/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mcquay.point;

import com.tridium.basicdriver.point.BBasicProxyExt;
import com.tridium.basicdriver.util.BIBasicPollable;
import com.tridium.mcquay.BMcQuayDevice;
import com.tridium.mcquay.BMcQuayNetwork;
import com.tridium.mcquay.messages.McQuayMessageConst;
import com.tridium.mcquay.messages.McQuayReadRequest;
import com.tridium.mcquay.messages.McQuayReadResponse;
import com.tridium.mcquay.point.BMcQuayEnumProxyExt;
import com.tridium.mcquay.point.BMcQuayPointDeviceExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.log.Log;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

public class BMcQuayProxyExt
extends BBasicProxyExt
implements BIBasicPollable,
McQuayMessageConst {
    public static final Property pollFrequency = BMcQuayProxyExt.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property registerHex = BMcQuayProxyExt.newProperty((int)0, (String)"-", null);
    public static final Property dataLenRegisters = BMcQuayProxyExt.newProperty((int)0, (int)1, null);
    public static final Type TYPE = Sys.loadType(BMcQuayProxyExt.class);
    Log mcQuayReadLog = Log.getLog((String)"McQuayReadLog");
    Log mcQuayWriteLog = Log.getLog((String)"McQuayWriteLog");
    BMcQuayNetwork network;
    BMcQuayDevice objDevice;
    McQuayReadRequest req = null;
    McQuayReadResponse rsp = null;
    McQuayReadResponse comboRsp;

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    public String getRegisterHex() {
        return this.getString(registerHex);
    }

    public void setRegisterHex(String v) {
        this.setString(registerHex, v, null);
    }

    public int getDataLenRegisters() {
        return this.getInt(dataLenRegisters);
    }

    public void setDataLenRegisters(int v) {
        this.setInt(dataLenRegisters, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        BStatusValue outVal = this.getParentPoint().getOutStatusValue();
        return super.post(action, (BValue)outVal, cx);
    }

    public void started() throws Exception {
        super.started();
        this.getMcQuayNetwork().getPollScheduler().subscribe((BIPollable)this);
    }

    public void stopped() throws Exception {
        super.stopped();
        this.getMcQuayNetwork().getPollScheduler().unsubscribe((BIPollable)this);
    }

    public final BMcQuayNetwork getMcQuayNetwork() {
        return (BMcQuayNetwork)this.getNetwork();
    }

    public final BMcQuayDevice getMcQuayDevice() {
        return (BMcQuayDevice)this.getDevice();
    }

    public final BMcQuayPointDeviceExt getMcQuayPointDeviceExt() {
        return (BMcQuayPointDeviceExt)this.getDeviceExt();
    }

    public Type getDeviceExtType() {
        return BMcQuayPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
    }

    public String getRegister() {
        String rString = this.getRegisterHex();
        if (rString.startsWith("-")) {
            return rString;
        }
        try {
            Integer n = Integer.valueOf(rString, 16);
        }
        catch (Exception e) {
            return "-1";
        }
        rString = "0000" + rString;
        return rString.substring(rString.length() - 4);
    }

    public void poll() {
        try {
            BMcQuayDevice device = this.getMcQuayDevice();
            BMcQuayNetwork network = device.getMcQuayNetwork();
            if (this.isUnoperational() || !network.getPollScheduler().getPollEnabled()) {
                return;
            }
            this.pollForData();
        }
        catch (Exception e) {
            this.mcQuayReadLog.error("Exception in McQuayProxyExt-->poll()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollForData() {
        try {
            this.network = (BMcQuayNetwork)this.getNetwork();
            if (this instanceof BMcQuayEnumProxyExt) {
                int ordinal = ((BMcQuayEnumProxyExt)this).getEnumType().getOrdinal();
                switch (ordinal) {
                    case 0: {
                        this.setRegisterHex("0801");
                        break;
                    }
                    case 1: {
                        this.setRegisterHex("043D");
                        break;
                    }
                    case 2: {
                        this.setRegisterHex("081C");
                        break;
                    }
                    case 3: {
                        this.setRegisterHex("081D");
                        break;
                    }
                    case 4: {
                        this.setRegisterHex("081E");
                        break;
                    }
                    case 5: {
                        this.setRegisterHex("081F");
                        break;
                    }
                }
            }
            this.objDevice = this.getMcQuayDevice();
            int l2Addr = this.objDevice.getMasterNodeL2Addr();
            int l3Addr = this.objDevice.getSlaveNodeL3Addr();
            String strRegister = this.getRegister();
            if (strRegister.startsWith("-")) {
                return;
            }
            String password = this.objDevice.getMcQuayNetwork().getPassword();
            this.comboRsp = new McQuayReadResponse();
            for (int i = 0; i < this.getDataLenRegisters(); ++i) {
                String nextReg = Integer.toHexString(Integer.parseInt(strRegister, 16) + i);
                while (nextReg.length() < 4) {
                    nextReg = "0" + nextReg;
                }
                this.req = new McQuayReadRequest(1, l2Addr, l3Addr, nextReg, password);
                this.rsp = (McQuayReadResponse)this.network.sendSync(this.req);
                if (this.rsp == null || this.rsp.isError()) {
                    this.rsp = new McQuayReadResponse();
                    this.rsp.exceptionCode = 9;
                    this.readFail("DEVICE TIMEOUT");
                    return;
                }
                if (this.rsp.exceptionCode == 2) {
                    this.mcQuayReadLog.error("Poll Request Received Negative Acknowledgement");
                    return;
                }
                if (i == 0) {
                    this.comboRsp = this.rsp;
                    continue;
                }
                this.comboRsp.setValue(this.comboRsp.getValue() * 256 + this.rsp.getValue());
            }
        }
        catch (Exception e) {
            this.mcQuayReadLog.error("Exception in McQuayProxyExt-->pollForData()");
        }
        finally {
            this.network = null;
        }
        this.setOutValue(this.comboRsp);
    }

    public void doWrite(BStatusValue value) {
        if (this.isUnoperational()) {
            return;
        }
    }

    public void setOutValue(McQuayReadResponse response) {
    }

    protected boolean isBoolean() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusBoolean;
    }

    protected boolean isNumeric() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusNumeric;
    }

    protected boolean isString() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusString;
    }

    protected boolean isEnum() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusEnum;
    }

    public void readSubscribed(Context cx) throws Exception {
        super.readSubscribed(cx);
    }

    public void readUnsubscribed(Context cx) throws Exception {
        super.readUnsubscribed(cx);
    }
}

