/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mcquay.point;

import com.tridium.mcquay.BMcQuayDevice;
import com.tridium.mcquay.BMcQuayNetwork;
import com.tridium.mcquay.messages.McQuayReadResponse;
import com.tridium.mcquay.messages.McQuayWriteRequest;
import com.tridium.mcquay.point.BMcQuayProxyExt;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BMcQuayBooleanProxyExt
extends BMcQuayProxyExt {
    public static final Type TYPE = Sys.loadType(BMcQuayBooleanProxyExt.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (!this.isRunning()) {
            System.out.println("The control point is not running - return");
            return;
        }
    }

    @Override
    public void doWrite(BStatusValue out) {
        super.doWrite(out);
        try {
            int value;
            String password;
            McQuayWriteRequest req;
            McQuayReadResponse resp;
            BMcQuayDevice device = this.getMcQuayDevice();
            BMcQuayNetwork network = this.getMcQuayNetwork();
            if (network.isDisabled() || device.isDown()) {
                return;
            }
            boolean bValue = ((BStatusBoolean)out).getBoolean();
            int l2Addr = device.getMasterNodeL2Addr();
            int l3Addr = device.getSlaveNodeL3Addr();
            String register = this.getRegister();
            boolean writeOk = true;
            if (register.startsWith("-")) {
                return;
            }
            if (!device.isDown()) {
                this.mcQuayWriteLog.message("***** McQuay writing " + bValue + " to:  *******");
            }
            if ((resp = (McQuayReadResponse)network.sendSync(req = new McQuayWriteRequest(l2Addr, l3Addr, register, password = network.getPassword(), value = this.getWriteValue(bValue)))) == null) {
                resp = new McQuayReadResponse();
                resp.exceptionCode = 9;
                writeOk = false;
            }
            if (resp.exceptionCode == 2) {
                this.mcQuayWriteLog.error("Write Request Received Negative Acknowledgement");
                writeOk = false;
                return;
            }
            if (resp.isError()) {
                writeOk = false;
                return;
            }
            writeOk = true;
            if (writeOk) {
                this.writeOk((BStatusValue)new BStatusBoolean(bValue));
            }
        }
        catch (Exception e) {
            this.mcQuayWriteLog.error("Exception in McQuayBooleanProxyExt-->doWrite()");
        }
    }

    public int getWriteValue(boolean bValue) {
        int activeValue = 1;
        int inactiveValue = 0;
        if (bValue) {
            if (activeValue > 0) {
                return activeValue;
            }
            if (inactiveValue < 0) {
                return 1;
            }
            return inactiveValue + 1;
        }
        if (inactiveValue > 0) {
            return inactiveValue;
        }
        if (activeValue < 0) {
            return 0;
        }
        return activeValue - 1;
    }

    @Override
    public void setOutValue(McQuayReadResponse response) {
        try {
            if (!response.isError()) {
                boolean binaryValue = false;
                int value = response.getValue();
                int activeValue = 1;
                int inactiveValue = 0;
                binaryValue = activeValue > 0 ? value == activeValue : (inactiveValue > 0 ? value != inactiveValue : value != 0);
                BStatusBoolean val = new BStatusBoolean();
                val.setValue(binaryValue);
                val.setStatusFault(false);
                this.readOk((BStatusValue)val);
            }
        }
        catch (Exception e) {
            this.mcQuayReadLog.error("Exception in McQuayBooleanProxyExt-->setOutValue()");
        }
    }
}

