/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mcquay.point;

import com.tridium.mcquay.BMcQuayDevice;
import com.tridium.mcquay.BMcQuayNetwork;
import com.tridium.mcquay.messages.McQuayReadResponse;
import com.tridium.mcquay.messages.McQuayWriteRequest;
import com.tridium.mcquay.point.BMcQuayProxyExt;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BMcQuayAnalogProxyExt
extends BMcQuayProxyExt {
    public static final Type TYPE = Sys.loadType(BMcQuayAnalogProxyExt.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (!this.isRunning()) {
            System.out.println("The control point is not running - return");
            return;
        }
    }

    @Override
    public void setOutValue(McQuayReadResponse response) {
        if (!response.isError()) {
            try {
                int regValue = response.getValue();
                BStatusNumeric val = new BStatusNumeric();
                val.setValue((double)regValue);
                val.setStatusFault(false);
                val.setStatusDown(false);
                this.readOk((BStatusValue)val);
            }
            catch (Exception e) {
                this.mcQuayReadLog.error("Exception in McQuayAnalogProxyExt-->setOutValue()");
            }
        }
    }

    @Override
    public void doWrite(BStatusValue value) {
        super.doWrite(value);
        try {
            McQuayWriteRequest req;
            BMcQuayDevice device = this.getMcQuayDevice();
            BMcQuayNetwork network = this.getMcQuayNetwork();
            if (network.isDisabled() || device.isDown()) {
                return;
            }
            double outValue = ((BStatusNumeric)value).getNumeric();
            int l2Addr = device.getMasterNodeL2Addr();
            int l3Addr = device.getSlaveNodeL3Addr();
            String register = this.getRegister();
            McQuayReadResponse resp = null;
            boolean writeOk = true;
            if (register.startsWith("-")) {
                return;
            }
            String password = network.getPassword();
            if (!device.isDown()) {
                this.mcQuayWriteLog.trace("***** McQuay writing " + outValue + " *******");
            }
            if (this.getDataLenRegisters() == 1) {
                req = new McQuayWriteRequest(l2Addr, l3Addr, register, password, (int)outValue);
                resp = (McQuayReadResponse)network.sendSync(req);
            }
            if (this.getDataLenRegisters() == 2) {
                req = new McQuayWriteRequest(l2Addr, l3Addr, register, password, (int)outValue / 256);
                resp = (McQuayReadResponse)network.sendSync(req);
                String regPlusOne = Integer.toHexString(Integer.parseInt(register, 16) + 1);
                while (regPlusOne.length() < 4) {
                    regPlusOne = "0" + regPlusOne;
                }
                req = new McQuayWriteRequest(l2Addr, l3Addr, regPlusOne, password, (int)outValue & 0xFF);
                resp = (McQuayReadResponse)network.sendSync(req);
            }
            if (resp == null) {
                resp = new McQuayReadResponse();
                resp.exceptionCode = 9;
                writeOk = false;
                return;
            }
            if (resp.exceptionCode == 2) {
                this.mcQuayWriteLog.error("Write Request Received Negative Acknowledgement");
                writeOk = false;
                return;
            }
            if (resp.isError()) {
                writeOk = false;
                return;
            }
            writeOk = true;
            if (writeOk) {
                this.writeOk((BStatusValue)new BStatusNumeric(outValue));
            }
        }
        catch (Exception e) {
            this.mcQuayWriteLog.error("Exception in McQuayAnalogProxyExt-->doWrite()");
        }
    }
}

