/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mcquay.messages;

import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.mcquay.messages.McQuayMessage;
import com.tridium.mcquay.messages.McQuayMessageConst;
import javax.baja.log.Log;

public class McQuayReadResponse
extends ReceivedMessage
implements McQuayMessageConst {
    McQuayMessage request;
    public int exceptionCode = 0;
    public int data = 0;
    public String strData = "-";
    Log mcQuayReadLog = Log.getLog((String)"McQuayReadLog");
    Log mcQuayWriteLog = Log.getLog((String)"McQuayWriteLog");

    public McQuayReadResponse() {
    }

    public McQuayReadResponse(McQuayMessage request) {
        this.request = request;
    }

    public void readResponse(byte[] dataBytes, int dataLen, boolean isFromrite) {
        if (isFromrite) {
            this.mcQuayWriteLog.trace("Write Response Received::" + new String(dataBytes));
        } else {
            this.mcQuayReadLog.trace("Read Response Received::" + new String(dataBytes));
        }
        if (dataBytes[0] == 32 && (dataBytes[1] == 49 || dataBytes[1] == 66)) {
            this.exceptionCode = 0;
            if (dataBytes[1] == 66) {
                byte[] byteData = new byte[16];
                this.data = 0;
                for (int i = 0; i < 2 * dataLen; i += 2) {
                    byteData[i / 2] = (byte)(Character.digit((char)dataBytes[2 + i], 16) * 16 + Character.digit((char)dataBytes[2 + i + 1], 16));
                    this.data = this.data * 256 + (0xFF & byteData[i / 2]);
                }
                this.strData = new String(byteData, 0, dataLen);
            }
        } else {
            this.exceptionCode = dataBytes[1] == 56 ? 2 : 1;
        }
    }

    public boolean isError() {
        return this.exceptionCode == 1;
    }

    public int getValue() {
        return this.data;
    }

    public void setValue(int data) {
        this.data = data;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        return sb.toString();
    }

    public String toDebugString() {
        StringBuffer sb = new StringBuffer();
        return sb.toString();
    }
}

