/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mcquay;

import com.tridium.basicdriver.BBasicDevice;
import com.tridium.mcquay.BMcQuayDeviceFolder;
import com.tridium.mcquay.BMcQuayNetwork;
import com.tridium.mcquay.messages.McQuayReadRequest;
import com.tridium.mcquay.messages.McQuayReadResponse;
import com.tridium.mcquay.point.BMcQuayPointDeviceExt;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

public class BMcQuayDevice
extends BBasicDevice {
    public static final Property masterNodeL2Addr = BMcQuayDevice.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)255));
    public static final Property slaveNodeL3Addr = BMcQuayDevice.newProperty((int)0, (int)255, (BFacets)BFacets.makeInt((int)0, (int)255));
    public static final Property pingRegisterHex = BMcQuayDevice.newProperty((int)4, (String)"-", null);
    public static final Property softwareIdent = BMcQuayDevice.newProperty((int)1, (String)"-", null);
    public static final Property deviceStatus = BMcQuayDevice.newProperty((int)1, (String)"Off-Line", null);
    public static final Property points = BMcQuayDevice.newProperty((int)0, (BValue)new BMcQuayPointDeviceExt(), (BFacets)BFacets.makeInt((int)1, (int)255));
    public static final Action upload = BMcQuayDevice.newAction((int)20, (BValue)new BUploadParameters(), null);
    public static final Action download = BMcQuayDevice.newAction((int)20, (BValue)new BDownloadParameters(), null);
    public static final Type TYPE = Sys.loadType(BMcQuayDevice.class);

    public int getMasterNodeL2Addr() {
        return this.getInt(masterNodeL2Addr);
    }

    public void setMasterNodeL2Addr(int v) {
        this.setInt(masterNodeL2Addr, v, null);
    }

    public int getSlaveNodeL3Addr() {
        return this.getInt(slaveNodeL3Addr);
    }

    public void setSlaveNodeL3Addr(int v) {
        this.setInt(slaveNodeL3Addr, v, null);
    }

    public String getPingRegisterHex() {
        return this.getString(pingRegisterHex);
    }

    public void setPingRegisterHex(String v) {
        this.setString(pingRegisterHex, v, null);
    }

    public String getSoftwareIdent() {
        return this.getString(softwareIdent);
    }

    public void setSoftwareIdent(String v) {
        this.setString(softwareIdent, v, null);
    }

    public String getDeviceStatus() {
        return this.getString(deviceStatus);
    }

    public void setDeviceStatus(String v) {
        this.setString(deviceStatus, v, null);
    }

    public BMcQuayPointDeviceExt getPoints() {
        return (BMcQuayPointDeviceExt)this.get(points);
    }

    public void setPoints(BMcQuayPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    public void upload(BUploadParameters parameters) {
        this.invoke(upload, (BValue)parameters, null);
    }

    public void download(BDownloadParameters parameters) {
        this.invoke(download, (BValue)parameters, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BMcQuayNetwork getMcQuayNetwork() {
        return (BMcQuayNetwork)this.getNetwork();
    }

    public Type getNetworkType() {
        return BMcQuayNetwork.TYPE;
    }

    public void started() throws Exception {
        super.started();
    }

    public void stopped() throws Exception {
        super.stopped();
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BMcQuayNetwork || parent instanceof BMcQuayDeviceFolder;
    }

    public void changed(Property changedProperty, Context cx) {
        if (cx == Context.decoding) {
            return;
        }
    }

    public boolean isChildLegal(BComponent component) throws LocalizableRuntimeException {
        if (component instanceof BMcQuayDevice) {
            throw new LocalizableRuntimeException("mcquay", "McQuayDevice cannot be child of McQuayDevice");
        }
        return true;
    }

    public IFuture postPing() {
        this.doPing();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPing() {
        BMcQuayNetwork network = (BMcQuayNetwork)this.getNetwork();
        if (network.isDisabled() || !network.isCommActive()) {
            this.pingFail("Ping failed");
            this.setDeviceStatus("Off-Line");
            return;
        }
        if (this.isDisabled()) {
            return;
        }
        McQuayReadRequest req = null;
        McQuayReadResponse resp = null;
        String softId = "";
        try {
            for (int i = 0; i < 8; ++i) {
                String nextReg = Integer.toHexString(Integer.parseInt("0A08", 16) + i);
                while (nextReg.length() < 4) {
                    nextReg = "0" + nextReg;
                }
                req = new McQuayReadRequest(1, this.getMasterNodeL2Addr(), this.getSlaveNodeL3Addr(), nextReg, network.getPassword());
                req.isPing = true;
                resp = (McQuayReadResponse)network.sendSync(req);
                if (resp == null || resp.isError()) {
                    this.pingFail("Ping Failed");
                    this.setDeviceStatus("Off-Line");
                    return;
                }
                if (resp.exceptionCode == 2) {
                    this.pingFail("Ping Failed");
                    this.setDeviceStatus("Off-Line");
                    return;
                }
                this.pingOk();
                softId = softId + resp.strData;
                this.setDeviceStatus("On-Line");
            }
            this.setSoftwareIdent(softId);
        }
        catch (Exception e) {
            this.pingFail("caught exception");
        }
        finally {
            network = null;
        }
    }
}

