/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.util;

import com.tridium.bql.util.BDynamicTimeRangeType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BTime;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

public final class BDynamicTimeRange
extends BSimple {
    public static final BDynamicTimeRange DEFAULT = BDynamicTimeRange.make(BAbsTime.NULL, BAbsTime.NULL);
    public static final BDynamicTimeRange TODAY = new BDynamicTimeRange(BDynamicTimeRangeType.today);
    public static final BDynamicTimeRange LAST_24_HOURS = new BDynamicTimeRange(BDynamicTimeRangeType.last24Hours);
    public static final BDynamicTimeRange YESTERDAY = new BDynamicTimeRange(BDynamicTimeRangeType.yesterday);
    public static final BDynamicTimeRange WEEK_TO_DATE = new BDynamicTimeRange(BDynamicTimeRangeType.weekToDate);
    public static final BDynamicTimeRange LAST_WEEK = new BDynamicTimeRange(BDynamicTimeRangeType.lastWeek);
    public static final BDynamicTimeRange LAST_7_DAYS = new BDynamicTimeRange(BDynamicTimeRangeType.last7Days);
    public static final BDynamicTimeRange MONTH_TO_DATE = new BDynamicTimeRange(BDynamicTimeRangeType.monthToDate);
    public static final BDynamicTimeRange LAST_MONTH = new BDynamicTimeRange(BDynamicTimeRangeType.lastMonth);
    public static final BDynamicTimeRange YEAR_TO_DATE = new BDynamicTimeRange(BDynamicTimeRangeType.yearToDate);
    public static final BDynamicTimeRange LAST_YEAR = new BDynamicTimeRange(BDynamicTimeRangeType.lastYear);
    private static final HashMap<String, BDynamicTimeRange> byId = new HashMap();
    private static final BTime LAST_INSTANT;
    public static final Type TYPE;
    private BDynamicTimeRangeType rangeType;
    private BAbsTime startTime;
    private BAbsTime endTime;

    private BDynamicTimeRange() {
        this(BDynamicTimeRangeType.today);
    }

    private BDynamicTimeRange(BDynamicTimeRangeType rangeType) {
        this.rangeType = rangeType;
        this.startTime = this.endTime = BAbsTime.NULL;
    }

    public static BDynamicTimeRange make(BDynamicTimeRangeType rangeType) {
        if (rangeType == BDynamicTimeRangeType.today) {
            return TODAY;
        }
        if (rangeType == BDynamicTimeRangeType.last24Hours) {
            return LAST_24_HOURS;
        }
        if (rangeType == BDynamicTimeRangeType.yesterday) {
            return YESTERDAY;
        }
        if (rangeType == BDynamicTimeRangeType.weekToDate) {
            return WEEK_TO_DATE;
        }
        if (rangeType == BDynamicTimeRangeType.lastWeek) {
            return LAST_WEEK;
        }
        if (rangeType == BDynamicTimeRangeType.last7Days) {
            return LAST_7_DAYS;
        }
        if (rangeType == BDynamicTimeRangeType.monthToDate) {
            return MONTH_TO_DATE;
        }
        if (rangeType == BDynamicTimeRangeType.lastMonth) {
            return LAST_MONTH;
        }
        if (rangeType == BDynamicTimeRangeType.yearToDate) {
            return YEAR_TO_DATE;
        }
        if (rangeType == BDynamicTimeRangeType.lastYear) {
            return LAST_YEAR;
        }
        if (rangeType == BDynamicTimeRangeType.timeRange) {
            throw new IllegalArgumentException("Must provide time bounds with timeRange.");
        }
        throw new IllegalArgumentException();
    }

    public static BDynamicTimeRange make(String periodId) {
        BDynamicTimeRange result = null;
        String key = periodId.toLowerCase();
        result = byId.get(key);
        if (result == null) {
            throw new IllegalArgumentException("Invalid period id: " + periodId);
        }
        return result;
    }

    public static BDynamicTimeRange make(BAbsTime startTime, BAbsTime endTime) {
        BDynamicTimeRange result = new BDynamicTimeRange();
        result.rangeType = BDynamicTimeRangeType.timeRange;
        if (!startTime.isNull() && !endTime.isNull() && startTime.isAfter(endTime)) {
            throw new IllegalArgumentException("Start time is after endTime time.");
        }
        result.startTime = startTime;
        result.endTime = endTime;
        return result;
    }

    public static BDynamicTimeRange fromOrdParams(String ordParams) {
        String rangeTag = ordParams.substring("period=".length());
        if (!rangeTag.startsWith(BDynamicTimeRangeType.timeRange.getTag())) {
            return BDynamicTimeRange.make(BDynamicTimeRangeType.make(rangeTag));
        }
        BAbsTime start = BAbsTime.NULL;
        BAbsTime end = BAbsTime.NULL;
        String[] params = TextUtil.splitAndTrim((String)rangeTag, (char)';');
        for (int i = 0; i < params.length; ++i) {
            try {
                if (params[i].startsWith("start=")) {
                    start = BAbsTime.make((String)params[i].substring("start=".length()));
                    continue;
                }
                if (!params[i].startsWith("end=")) continue;
                end = BAbsTime.make((String)params[i].substring("end=".length()));
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return BDynamicTimeRange.make(start, end);
    }

    public BDynamicTimeRangeType getRangeType() {
        return this.rangeType;
    }

    public BAbsTime getFixedStartTime() {
        return this.startTime;
    }

    public BAbsTime getFixedEndTime() {
        return this.endTime;
    }

    public BAbsTime getStartTime(BAbsTime currentTime) {
        return this.getStartTime(currentTime, null);
    }

    public BAbsTime getStartTime(BAbsTime currentTime, BTimeZone selectedTimeZone) {
        BTimeZone timeZone;
        BTimeZone bTimeZone = timeZone = selectedTimeZone == null ? currentTime.getTimeZone() : selectedTimeZone;
        if (this.rangeType == BDynamicTimeRangeType.timeRange) {
            return this.startTime;
        }
        if (this.rangeType == BDynamicTimeRangeType.today) {
            return BAbsTime.make((BAbsTime)currentTime, (BTime)BTime.MIDNIGHT);
        }
        if (this.rangeType == BDynamicTimeRangeType.last24Hours) {
            return BAbsTime.make((int)currentTime.getYear(), (BMonth)currentTime.getMonth(), (int)(currentTime.getDay() - 1), (int)currentTime.getHour(), (int)0, (int)0, (int)0, (BTimeZone)timeZone);
        }
        if (this.rangeType == BDynamicTimeRangeType.yesterday) {
            return BAbsTime.make((BAbsTime)currentTime.prevDay(), (BTime)BTime.MIDNIGHT);
        }
        if (this.rangeType == BDynamicTimeRangeType.weekToDate) {
            BAbsTime day = currentTime;
            BWeekday firstDayOfTheWeek = BWeekday.getFirstDayOfWeek(null);
            while (day.getWeekday() != firstDayOfTheWeek) {
                day = day.prevDay();
            }
            return BAbsTime.make((BAbsTime)day, (BTime)BTime.MIDNIGHT);
        }
        if (this.rangeType == BDynamicTimeRangeType.lastWeek) {
            BAbsTime day = currentTime;
            BWeekday firstDayOfTheWeek = BWeekday.getFirstDayOfWeek(null);
            while (day.getWeekday() != firstDayOfTheWeek) {
                day = day.prevDay();
            }
            day = day.prevDay();
            while (day.getWeekday() != firstDayOfTheWeek) {
                day = day.prevDay();
            }
            return BAbsTime.make((BAbsTime)day, (BTime)BTime.MIDNIGHT);
        }
        if (this.rangeType == BDynamicTimeRangeType.last7Days) {
            return BAbsTime.make((int)currentTime.getYear(), (BMonth)currentTime.getMonth(), (int)(currentTime.getDay() - 7), (int)0, (int)0, (int)0, (int)0, (BTimeZone)timeZone);
        }
        if (this.rangeType == BDynamicTimeRangeType.monthToDate) {
            return BAbsTime.make((int)currentTime.getYear(), (BMonth)currentTime.getMonth(), (int)1, (int)0, (int)0, (int)0, (int)0, (BTimeZone)timeZone);
        }
        if (this.rangeType == BDynamicTimeRangeType.lastMonth) {
            BAbsTime lastMonth = currentTime.prevMonth();
            return BAbsTime.make((int)lastMonth.getYear(), (BMonth)lastMonth.getMonth(), (int)1, (int)0, (int)0, (int)0, (int)0, (BTimeZone)timeZone);
        }
        if (this.rangeType == BDynamicTimeRangeType.yearToDate) {
            return BAbsTime.make((int)currentTime.getYear(), (BMonth)BMonth.january, (int)1, (int)0, (int)0, (int)0, (int)0, (BTimeZone)timeZone);
        }
        if (this.rangeType == BDynamicTimeRangeType.lastYear) {
            return BAbsTime.make((int)(currentTime.getYear() - 1), (BMonth)BMonth.january, (int)1, (int)0, (int)0, (int)0, (int)0, (BTimeZone)timeZone);
        }
        throw new IllegalStateException("Unsupported range type: " + (Object)((Object)this.rangeType));
    }

    public BAbsTime getEndTime(BAbsTime currentTime) {
        return this.getEndTime(currentTime, null);
    }

    public BAbsTime getEndTime(BAbsTime currentTime, BTimeZone selectedTimeZone) {
        BTimeZone timeZone;
        BTimeZone bTimeZone = timeZone = selectedTimeZone == null ? currentTime.getTimeZone() : selectedTimeZone;
        if (this.rangeType == BDynamicTimeRangeType.timeRange) {
            return this.endTime;
        }
        if (this.rangeType == BDynamicTimeRangeType.today) {
            return BAbsTime.make((BAbsTime)currentTime, (BTime)LAST_INSTANT);
        }
        if (this.rangeType == BDynamicTimeRangeType.last24Hours) {
            return currentTime;
        }
        if (this.rangeType == BDynamicTimeRangeType.yesterday) {
            return BAbsTime.make((BAbsTime)currentTime.prevDay(), (BTime)LAST_INSTANT);
        }
        if (this.rangeType == BDynamicTimeRangeType.weekToDate) {
            return currentTime;
        }
        if (this.rangeType == BDynamicTimeRangeType.lastWeek) {
            BAbsTime day = currentTime;
            BWeekday firstDayOfTheWeek = BWeekday.getFirstDayOfWeek(null);
            while (day.getWeekday() != firstDayOfTheWeek) {
                day = day.prevDay();
            }
            day = day.prevDay();
            return BAbsTime.make((BAbsTime)day, (BTime)LAST_INSTANT);
        }
        if (this.rangeType == BDynamicTimeRangeType.last7Days) {
            return currentTime;
        }
        if (this.rangeType == BDynamicTimeRangeType.monthToDate) {
            return currentTime;
        }
        if (this.rangeType == BDynamicTimeRangeType.lastMonth) {
            BAbsTime lastMonth = currentTime.prevMonth();
            return BAbsTime.make((int)lastMonth.getYear(), (BMonth)lastMonth.getMonth(), (int)BAbsTime.getDaysInMonth((int)lastMonth.getYear(), (BMonth)lastMonth.getMonth()), (int)LAST_INSTANT.getHour(), (int)LAST_INSTANT.getMinute(), (int)LAST_INSTANT.getSecond(), (int)LAST_INSTANT.getMillisecond(), (BTimeZone)timeZone);
        }
        if (this.rangeType == BDynamicTimeRangeType.yearToDate) {
            return currentTime;
        }
        if (this.rangeType == BDynamicTimeRangeType.lastYear) {
            return BAbsTime.make((int)(currentTime.getYear() - 1), (BMonth)BMonth.december, (int)BAbsTime.getDaysInMonth((int)(currentTime.getYear() - 1), (BMonth)BMonth.december), (int)LAST_INSTANT.getHour(), (int)LAST_INSTANT.getMinute(), (int)LAST_INSTANT.getSecond(), (int)LAST_INSTANT.getMillisecond(), (BTimeZone)timeZone);
        }
        throw new IllegalStateException("Unsupported range type: " + (Object)((Object)this.rangeType));
    }

    public String toOrdParams() {
        BAbsTime end;
        if (this.rangeType != BDynamicTimeRangeType.timeRange) {
            return "period=" + this.rangeType.getTag();
        }
        StringBuffer s = new StringBuffer(32);
        s.append("period=").append(this.rangeType.getTag());
        BAbsTime start = this.getFixedStartTime();
        if (start != null && !start.isNull()) {
            s.append(';').append("start=").append(start.encodeToString());
        }
        if ((end = this.getFixedEndTime()) != null && !end.isNull()) {
            s.append(';').append("end=").append(end.encodeToString());
        }
        return s.toString();
    }

    public int hashCode() {
        int hash = 23 + this.rangeType.hashCode();
        hash = hash * 37 + this.startTime.hashCode();
        return hash * 37 + this.endTime.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof BDynamicTimeRange) {
            BDynamicTimeRange other = (BDynamicTimeRange)((Object)o);
            return this.rangeType == other.rangeType && this.startTime.equals((Object)other.startTime) && this.endTime.equals((Object)other.endTime);
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        this.rangeType.encode(out);
        this.startTime.encode(out);
        this.endTime.encode(out);
    }

    public BObject decode(DataInput in) throws IOException {
        BDynamicTimeRange result = new BDynamicTimeRange();
        result.rangeType = (BDynamicTimeRangeType)BDynamicTimeRangeType.timeRange.decode(in);
        result.startTime = (BAbsTime)BAbsTime.DEFAULT.decode(in);
        result.endTime = (BAbsTime)BAbsTime.DEFAULT.decode(in);
        return result;
    }

    public String encodeToString() throws IOException {
        if (this.rangeType != BDynamicTimeRangeType.timeRange) {
            return this.rangeType.encodeToString();
        }
        return this.rangeType.encodeToString() + ":startTime=" + this.startTime.encodeToString() + ";endTime=" + this.endTime.encodeToString();
    }

    public BObject decodeFromString(String s) throws IOException {
        int colon = s.indexOf(58);
        if (colon == -1) {
            return BDynamicTimeRange.make(s);
        }
        int semi = s.indexOf(59);
        BDynamicTimeRange result = new BDynamicTimeRange();
        String typeString = s.substring(0, colon);
        if (!typeString.equals(BDynamicTimeRangeType.timeRange.getTag())) {
            throw new IOException("Invalid string encoding: " + s);
        }
        result.rangeType = BDynamicTimeRangeType.timeRange;
        String startParam = s.substring(colon + 1, semi);
        int eq = startParam.indexOf(61);
        if (eq == -1) {
            throw new IOException("Invalid string encoding: " + s);
        }
        if (!startParam.substring(0, eq).equals("startTime")) {
            throw new IOException("Invalid string encoding: " + s);
        }
        result.startTime = (BAbsTime)BAbsTime.DEFAULT.decodeFromString(startParam.substring(eq + 1));
        String endParam = s.substring(semi + 1);
        eq = endParam.indexOf(61);
        if (eq == -1) {
            throw new IOException("Invalid string encoding: " + s);
        }
        if (!endParam.substring(0, eq).equals("endTime")) {
            throw new IOException("Invalid string encoding: " + s);
        }
        result.endTime = (BAbsTime)BAbsTime.DEFAULT.decodeFromString(endParam.substring(eq + 1));
        return result;
    }

    public Type getType() {
        return TYPE;
    }

    static {
        byId.put(BDynamicTimeRangeType.today.getTag().toLowerCase(), TODAY);
        byId.put(BDynamicTimeRangeType.last24Hours.getTag().toLowerCase(), LAST_24_HOURS);
        byId.put(BDynamicTimeRangeType.yesterday.getTag().toLowerCase(), YESTERDAY);
        byId.put(BDynamicTimeRangeType.weekToDate.getTag().toLowerCase(), WEEK_TO_DATE);
        byId.put(BDynamicTimeRangeType.lastWeek.getTag().toLowerCase(), LAST_WEEK);
        byId.put(BDynamicTimeRangeType.last7Days.getTag().toLowerCase(), LAST_7_DAYS);
        byId.put(BDynamicTimeRangeType.monthToDate.getTag().toLowerCase(), MONTH_TO_DATE);
        byId.put(BDynamicTimeRangeType.lastMonth.getTag().toLowerCase(), LAST_MONTH);
        byId.put(BDynamicTimeRangeType.yearToDate.getTag().toLowerCase(), YEAR_TO_DATE);
        byId.put(BDynamicTimeRangeType.lastYear.getTag().toLowerCase(), LAST_YEAR);
        LAST_INSTANT = BTime.make((int)23, (int)59, (int)59, (int)999);
        TYPE = Sys.loadType(BDynamicTimeRange.class);
    }
}

