/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.query;

import com.tridium.bql.query.BqlVisitor;
import com.tridium.query.BICompiledQuery;
import com.tridium.query.BQueryEngine;
import java.util.logging.Logger;
import javax.baja.collection.BITable;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.query.BQuery;
import javax.baja.query.QueryRuntimeException;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBqlEngine
extends BQueryEngine
implements BICompiledQuery {
    public static final Type TYPE = Sys.loadType(BBqlEngine.class);
    protected static final Logger log = Logger.getLogger(BBqlEngine.class.getName());
    protected BOrd queryOrd;

    public Type getType() {
        return TYPE;
    }

    public BBqlEngine() {
        this.queryOrd = BOrd.NULL;
    }

    public BBqlEngine(BOrd baseOrd) {
        super(baseOrd);
    }

    protected BBqlEngine(BOrd queryOrd, String queryString) {
        this.queryOrd = BOrd.make((BOrd)queryOrd, (String)queryString);
    }

    public BICompiledQuery doCompile(BQuery query) {
        try {
            BqlVisitor visitor = new BqlVisitor();
            visitor.visit(query);
            log.fine("BQL Engine Generated:\n" + visitor.getQueryString() + '\n');
            return new BBqlEngine(this.baseOrd, "bql:" + visitor.getQueryString());
        }
        catch (QueryRuntimeException qce) {
            throw qce;
        }
        catch (Exception e) {
            throw new QueryRuntimeException("Failed query compilation.", (Throwable)e);
        }
    }

    public BITable<? extends BIObject> execute() {
        return this.execute(null);
    }

    public BITable<? extends BIObject> execute(Context cx) {
        return (BITable)this.queryOrd.get((BObject)BLocalHost.INSTANCE, cx);
    }
}

