/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.filter;

import java.util.StringTokenizer;
import java.util.Vector;
import javax.baja.bql.BIBqlFilter;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BExpression;
import javax.baja.query.BIQueryFilter;
import javax.baja.query.util.Funcs;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BStringFilter
extends BComponent
implements BIBqlFilter,
BIQueryFilter {
    public static final Property pattern = BStringFilter.newProperty((int)0, (String)"%", null);
    public static final Property exact = BStringFilter.newProperty((int)0, (boolean)false, null);
    public static final Property include = BStringFilter.newProperty((int)0, (boolean)true, null);
    public static final Property matchCase = BStringFilter.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BStringFilter.class);
    private static final char ONE_CHAR = '\u0000';

    public String getPattern() {
        return this.getString(pattern);
    }

    public void setPattern(String v) {
        this.setString(pattern, v, null);
    }

    public boolean getExact() {
        return this.getBoolean(exact);
    }

    public void setExact(boolean v) {
        this.setBoolean(exact, v, null);
    }

    public boolean getInclude() {
        return this.getBoolean(include);
    }

    public void setInclude(boolean v) {
        this.setBoolean(include, v, null);
    }

    public boolean getMatchCase() {
        return this.getBoolean(matchCase);
    }

    public void setMatchCase(boolean v) {
        this.setBoolean(matchCase, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BStringFilter() {
    }

    public BStringFilter(String pattern, boolean exact, boolean include) {
        this.setPattern(pattern);
        this.setExact(exact);
        this.setInclude(include);
    }

    @Override
    public void init(BObject o) {
    }

    public String getResolvedPattern() {
        if (this.getMatchCase()) {
            return this.getPattern();
        }
        return TextUtil.toLowerCase((String)this.getPattern());
    }

    @Override
    public String getPredicate(String columnName) {
        StringBuffer s = new StringBuffer(64);
        boolean inc = this.getInclude();
        if (!inc) {
            s.append("not (");
        }
        s.append(columnName);
        if (!this.getMatchCase()) {
            s.append(".toString.toLowerCase");
        }
        s.append(this.getExact() ? " = " : " like ");
        s.append('\'').append(BStringFilter.escapeQuotes(this.getResolvedPattern())).append('\'');
        if (!inc) {
            s.append(')');
        }
        return s.toString();
    }

    public BExpression getExpression(BExpression columnExpression) {
        if (!this.getMatchCase()) {
            columnExpression = Funcs.lower((BExpression)columnExpression);
        }
        BExpression e = this.getExact() ? Predicates.eq((BExpression)columnExpression, (BSimple)BString.make((String)this.getResolvedPattern())) : Predicates.like((BExpression)columnExpression, (BString)BString.make((String)this.getResolvedPattern()));
        if (!this.getInclude()) {
            e = Predicates.not((BExpression)e);
        }
        return e;
    }

    @Override
    public boolean accept(BObject o) {
        String val = o.toString();
        if (!this.getMatchCase()) {
            val = val.toLowerCase();
        }
        boolean accepted = this.getExact() ? (this.getMatchCase() ? val.equals(this.getResolvedPattern()) : val.equalsIgnoreCase(this.getResolvedPattern())) : this.evaluate(val, this.getResolvedPattern());
        return this.getInclude() == accepted;
    }

    protected boolean evaluate(String left, String right) {
        String test = left.toString();
        Pattern p = new Pattern(right, this.getMatchCase());
        return p.isMatch(test);
    }

    private static String escapeQuotes(String s) {
        if (s.indexOf(39) == -1) {
            return s;
        }
        StringBuffer result = new StringBuffer(s.length() + 2);
        StringTokenizer tokens = new StringTokenizer(s, "'", true);
        while (tokens.hasMoreTokens()) {
            String t = tokens.nextToken();
            if (t.equals("'")) {
                result.append("\\'");
                continue;
            }
            result.append(t);
        }
        return result.toString();
    }

    public static class Pattern {
        private char[][] pattern;
        private boolean matchAll;
        private boolean matchCase;

        public Pattern(String patternString, boolean matchCase) {
            this.init(patternString.toCharArray(), matchCase);
        }

        private void init(char[] patternStr, boolean matchCase) {
            this.matchCase = matchCase;
            if (patternStr.length == 0) {
                this.pattern = new char[0][];
                return;
            }
            this.matchAll = true;
            for (int i = 0; i < patternStr.length; ++i) {
                if (patternStr[i] == '*' || patternStr[i] == '%') continue;
                this.matchAll = false;
                break;
            }
            if (this.matchAll) {
                return;
            }
            Vector<String> v = new Vector<String>();
            int i = 0;
            StringBuffer buf = new StringBuffer(16);
            while (true) {
                if (i == patternStr.length) {
                    if (buf.length() <= 0) break;
                    v.addElement(buf.toString());
                    break;
                }
                if (patternStr[i] == '\\') {
                    if (buf.length() == 0) {
                        buf.append(' ');
                    }
                    if (i < patternStr.length - 1) {
                        char next = patternStr[i + 1];
                        if (next == '%' || next == '*' || next == '_' || next == '\\') {
                            buf.append(next);
                        } else if (next == 'n') {
                            buf.append('\n');
                        } else if (next == 'r') {
                            buf.append('\r');
                        } else if (next == 't') {
                            buf.append('\t');
                        } else {
                            throw new IllegalArgumentException("Invalid escape sequence: \\" + next);
                        }
                        i += 2;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid escape sequence: \\");
                }
                if (patternStr[i] == '%' || patternStr[i] == '*' || patternStr[i] == '_') {
                    if (patternStr[i] == '_') {
                        if (buf.length() == 0) {
                            buf.append(' ');
                        }
                        buf.append('\u0000');
                        ++i;
                        continue;
                    }
                    if (buf.length() > 0) {
                        v.addElement(buf.toString());
                    }
                    v.addElement("*");
                    while (i < patternStr.length && (patternStr[i] == '%' || patternStr[i] == '*')) {
                        ++i;
                    }
                    buf.setLength(0);
                    continue;
                }
                if (buf.length() == 0) {
                    buf.append(' ');
                }
                buf.append(patternStr[i++]);
            }
            this.pattern = new char[v.size()][];
            for (int j = 0; j < v.size(); ++j) {
                this.pattern[j] = ((String)v.elementAt(j)).toCharArray();
            }
        }

        public boolean isMatch(String testStr) {
            if (this.matchAll) {
                return true;
            }
            if (!this.matchCase) {
                testStr = TextUtil.toLowerCase((String)testStr);
            }
            char[] test = testStr.toCharArray();
            int ti = 0;
            boolean lastStart = false;
            int len = test.length;
            boolean afterWildcard = false;
            if (len == 0) {
                return this.pattern.length == 0;
            }
            block0: for (int pi = 0; pi < this.pattern.length; ++pi) {
                if (this.pattern[pi][0] == '*') {
                    if (pi == this.pattern.length - 1) {
                        return true;
                    }
                    afterWildcard = true;
                    continue;
                }
                while (ti < len) {
                    int ei;
                    int start = ti;
                    for (ei = 1; ti < len && ei < this.pattern[pi].length && (this.pattern[pi][ei] == '\u0000' || this.pattern[pi][ei] == test[ti]); ++ti, ++ei) {
                    }
                    if (ei == this.pattern[pi].length) {
                        if (pi == this.pattern.length - 1) {
                            if (ti == len) {
                                return true;
                            }
                            if (afterWildcard) {
                                ti = len - (this.pattern[pi].length - 1);
                                continue;
                            }
                            return false;
                        }
                        afterWildcard = false;
                        continue block0;
                    }
                    if (ti == len) {
                        return false;
                    }
                    if (!afterWildcard) {
                        return false;
                    }
                    ti = start + 1;
                    if (ti != len) continue;
                    return false;
                }
            }
            return false;
        }
    }
}

