/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.compiler;

import com.tridium.bql.BBqlExtent;
import com.tridium.bql.BSelect;
import com.tridium.bql.BTop;
import com.tridium.bql.compiler.BqlTokenizer;
import com.tridium.bql.compiler.Constants;
import com.tridium.bql.compiler.ExprParser;
import com.tridium.bql.compiler.ExprUtil;
import com.tridium.bql.compiler.RuntimeCompilerException;
import com.tridium.bql.compiler.Token;
import com.tridium.bql.compiler.UnexpectedSymbolException;
import com.tridium.bql.compiler.UnexpectedTokenTypeException;
import com.tridium.bql.expression.BPath;
import javax.baja.query.BExpression;
import javax.baja.query.BOrderByColumn;
import javax.baja.query.BOrdering;
import javax.baja.query.BProjection;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.util.Columns;
import javax.baja.util.Lexicon;

public class SelectParser
implements Constants {
    private static Lexicon lex = Lexicon.make((String)"bql");
    private BqlTokenizer tokens;
    private Token current;
    private BSelect query;
    private ExprParser exprParser;
    private boolean isAll = false;
    private BProjection projection;

    public SelectParser(BqlTokenizer tokens) {
        this.tokens = tokens;
        this.query = new BSelect();
        this.projection = null;
        this.isAll = false;
    }

    public static BSelect parse(BqlTokenizer tokens) {
        SelectParser parser = new SelectParser(tokens);
        return parser.parse();
    }

    public BSelect parse() {
        this.next();
        this.match(13);
        this.top();
        this.quantifier();
        this.projection();
        this.extent();
        this.predicate();
        this.having();
        this.ordering();
        this.tokens.push(this.current);
        return this.query;
    }

    protected void top() {
        if (this.current.type != 42) {
            return;
        }
        this.match(42);
        this.query.top(new BTop(Long.parseLong(this.match((int)3).lex)));
    }

    protected void quantifier() {
        switch (this.current.type) {
            case 19: {
                this.projection = Columns.distinctProjection();
                this.match(19);
                break;
            }
            case 20: {
                this.projection = Columns.projection();
                this.match(20);
                break;
            }
            default: {
                this.projection = Columns.projection();
            }
        }
    }

    protected void projection() {
        switch (this.current.type) {
            case 6: {
                if (this.current.opType != 2) break;
            }
            case 12: {
                this.next();
                this.isAll = true;
                this.projection.add(Columns.make((BExpression)new BPath("*")));
            }
        }
        if (!this.isAll) {
            boolean first = true;
            while (this.current.type != 16 && this.current.type != 15 && this.current.type != 17 && this.current.type != 18 && this.current.type != 41 && this.current.type != 37 && this.current.type != 8 && this.current.type != 2) {
                if (this.isAll) {
                    throw new RuntimeCompilerException(this.current.index, this.lexText("projection.tooManyColumns"));
                }
                if (!first) {
                    this.match(11);
                }
                first = false;
                this.tokens.push(this.current);
                this.projection.add(Columns.make((BExpression)this.expression()).as(this.as()));
            }
        }
        int len = this.projection.getProjectionColumns().length;
        if (this.projection.isDistinct() && (len == 0 || this.isAll)) {
            throw new RuntimeCompilerException(this.current.index, this.lexText("projection.distinct.noColumns"));
        }
        if (len != 0) {
            this.query.select(this.projection);
        }
    }

    protected String as() {
        if (this.current.type == 14) {
            this.match(14);
            return this.match((int)5).lex;
        }
        return null;
    }

    protected void extent() {
        StringBuffer extentText = new StringBuffer();
        boolean hasDepth = false;
        int depth = Integer.MAX_VALUE;
        boolean hasStop = false;
        if (this.current.type == 16) {
            this.match(16);
            boolean finished = false;
            this.tokens.setShowWhite(true);
            block7: while (!finished) {
                switch (this.current.type) {
                    case 2: 
                    case 8: 
                    case 15: 
                    case 17: 
                    case 18: 
                    case 37: 
                    case 41: {
                        finished = true;
                        continue block7;
                    }
                }
                extentText.append(this.current.lex);
                this.next();
            }
            this.tokens.setShowWhite(false);
            if (this.current.type == 0) {
                this.next();
            }
        }
        while (this.current.type == 17 || this.current.type == 18) {
            switch (this.current.type) {
                case 17: {
                    if (hasDepth) {
                        throw new RuntimeCompilerException(this.current.index, this.lexText("duplicate.depth"));
                    }
                    hasDepth = true;
                    depth = this.depth();
                    break;
                }
                case 18: {
                    if (hasStop) {
                        throw new RuntimeCompilerException(this.current.index, this.lexText("duplicate.stop"));
                    }
                    this.match(18);
                    hasStop = true;
                }
            }
        }
        this.query.from(new BBqlExtent(extentText.toString().trim(), depth, hasStop));
    }

    protected int depth() {
        this.match(17);
        int depth = Integer.MAX_VALUE;
        Token opToken = this.match(6);
        if (opToken.opType != 5) {
            throw new UnexpectedSymbolException(opToken.index, "=", OPTYPE_STRINGS[opToken.opType]);
        }
        if (this.current.type == 6 && this.current.opType == 2) {
            this.next();
        } else {
            depth = Integer.parseInt(this.match((int)3).lex);
        }
        return depth;
    }

    protected void predicate() {
        int start = this.current.index;
        if (this.current.type == 15) {
            BExpression predicate = this.expression();
            if (!ExprUtil.isBoolean(predicate)) {
                throw new RuntimeCompilerException(start, this.lexText("qualifier.required.boolean"), "<predicate>");
            }
            if (ExprUtil.isAggregateExpr(predicate)) {
                throw new RuntimeCompilerException(start, this.lexText("predicate.noAggregates"), "<predicate>");
            }
            this.query.where(predicate);
        }
    }

    protected void having() {
        if (this.current.type != 41) {
            return;
        }
        int start = this.current.index;
        BExpression having = this.expression();
        if (!ExprUtil.isBoolean(having)) {
            throw new RuntimeCompilerException(start, this.lexText("having.required.boolean"), "<having>");
        }
        if (!ExprUtil.isAggregateExpr(having)) {
            throw new RuntimeCompilerException(start, this.lexText("having.required.aggrExpr"), "<having>");
        }
        if (this.isAll) {
            throw new RuntimeCompilerException(start, this.lexText("having.noStar"), "<having>");
        }
        this.query.having(having);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void ordering() {
        if (this.current.type != 37) {
            return;
        }
        this.match(37);
        this.match(38);
        BOrdering ordering = new BOrdering();
        BProjectionColumn[] columns = this.query.hasProjection() ? this.query.getProjection().getProjectionColumns() : new BProjectionColumn[]{};
        boolean first = true;
        do {
            BOrderByColumn orderCol = null;
            if (!first) {
                this.match(11);
            }
            first = false;
            if (this.current.type == 3) {
                int col = Integer.parseInt(this.match((int)3).lex);
                if (columns.length <= 0 || col > columns.length) throw new RuntimeCompilerException(this.current.index, this.lexText("orderby.unresolved.columnNum"), Integer.toString(col));
                orderCol = Columns.orderBy((int)col);
            } else if (this.current.type == 5) {
                String alias = this.match((int)5).lex;
                for (int i = 0; i < columns.length && orderCol == null; ++i) {
                    if (!columns[i].hasAlias() || !columns[i].getAlias().equals(alias)) continue;
                    orderCol = Columns.orderBy((int)(i + 1));
                }
                if (orderCol == null) {
                    throw new RuntimeCompilerException(this.current.index, this.lexText("orderby.unresolved.alias"), alias);
                }
            } else {
                this.tokens.push(this.current);
                BExpression expr = this.expression();
                if (ExprUtil.isAggregateExpr(expr) && this.isAll) {
                    throw new RuntimeCompilerException(this.current.index, this.lexText("orderby.noAggrWithStar"), "<order by>");
                }
                orderCol = Columns.orderBy((BExpression)expr);
            }
            switch (this.current.type) {
                case 40: {
                    this.match(40);
                    orderCol.desc();
                    break;
                }
                case 39: {
                    this.match(39);
                }
            }
            ordering.add(orderCol);
        } while (this.current.type != 2);
        this.query.orderBy(ordering);
    }

    private BExpression expression() {
        if (this.exprParser == null) {
            this.exprParser = new ExprParser();
        }
        BExpression expr = this.exprParser.parse(this.tokens);
        this.next();
        return expr;
    }

    private void next() {
        this.current = this.tokens.next();
    }

    private Token match(int matchType) {
        Token result = this.current;
        if (this.current.type != matchType) {
            throw new UnexpectedTokenTypeException(this.current.index, matchType, this.current.type);
        }
        this.next();
        return result;
    }

    private String lexText(String key) {
        return lex.get(key, key);
    }
}

