/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.compiler;

public class RuntimeCompilerException
extends RuntimeException {
    private int column;
    private String[] args;

    public RuntimeCompilerException(int column, String key) {
        this(column, key, null);
    }

    public RuntimeCompilerException(int column, String key, String arg) {
        super(key);
        this.column = column;
        this.args = new String[]{arg};
    }

    public RuntimeCompilerException(int column, String key, String arg1, String arg2) {
        super(key);
        this.column = column;
        this.args = new String[]{arg1, arg2};
    }

    public int getColumn() {
        return this.column;
    }

    public String getKey() {
        return this.getMessage();
    }

    public String getArg() {
        return this.args == null ? null : this.args[0];
    }

    public String[] getArgs() {
        return this.args;
    }

    public String toDisplay() {
        StringBuffer err = new StringBuffer(64);
        err.append('(').append(this.column + 1).append("): ");
        err.append(this.getKey());
        if (this.args != null) {
            err.append(" {");
            for (int i = 0; i < this.args.length; ++i) {
                err.append(this.args[i]);
                if (i == this.args.length - 1) continue;
                err.append(',');
            }
            err.append('}');
        }
        return err.toString();
    }
}

