/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.compiler;

import com.tridium.bql.compiler.Constants;
import com.tridium.bql.expression.BAggregateFunction;
import com.tridium.bql.expression.BBqlFunction;
import com.tridium.bql.expression.BPath;
import com.tridium.bql.query.BqlVisitor;
import javax.baja.query.BExpression;
import javax.baja.query.expression.BBinaryExpression;
import javax.baja.query.expression.BFieldExpression;
import javax.baja.query.expression.BSimpleExpression;
import javax.baja.query.expression.BUnaryExpression;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;

public abstract class ExprUtil
implements Constants {
    private static final int BOOL_EXPR = 1;
    private static final int COMP_EXPR = 2;
    private static final int CONST_EXPR = 4;
    private static final int AGG_EXPR = 8;
    private static final String EXPR_FLAGS = "exprFlags";
    private static final String OP_ID = "opId";

    public static String toExprStr(BExpression expr) {
        BqlVisitor v = new BqlVisitor();
        v.visit(expr);
        return v.getQueryString();
    }

    public static boolean isUnary(BExpression expr) {
        return expr instanceof BUnaryExpression;
    }

    public static boolean isBinary(BExpression expr) {
        return expr instanceof BBinaryExpression;
    }

    public static boolean isSimple(BExpression expr) {
        return expr instanceof BSimpleExpression;
    }

    public static boolean isAggregateFunction(BExpression expr) {
        return expr instanceof BAggregateFunction;
    }

    public static boolean isField(BExpression expr) {
        return expr instanceof BFieldExpression;
    }

    public static BExpression tag(BExpression expr) {
        int flags = 0;
        int opId = -1;
        if (expr instanceof BPath || expr instanceof BBqlFunction) {
            flags |= 3;
            if (expr instanceof BAggregateFunction) {
                flags |= 8;
            }
        } else if (ExprUtil.isSimple(expr)) {
            BSimple s = ((BSimpleExpression)expr).getSimpleValue();
            flags |= 4;
            if (s instanceof BString) {
                flags |= 3;
            } else if (s instanceof BNumber) {
                flags |= 2;
            } else if (s instanceof BBoolean) {
                flags |= 1;
            } else {
                if (s instanceof Comparable) {
                    flags |= 2;
                }
                if (s.getType() == BBoolean.DEFAULT.getType()) {
                    flags |= 1;
                }
            }
        } else if (ExprUtil.isBinary(expr)) {
            BBinaryExpression binary = (BBinaryExpression)expr;
            String op = binary.op();
            if (ExprUtil.isConstant(binary.lhs()) && ExprUtil.isConstant(binary.rhs())) {
                flags |= 4;
            }
            if (ExprUtil.isAggregateExpr(binary.lhs()) || ExprUtil.isAggregateExpr(binary.rhs())) {
                flags |= 8;
            }
            if (boolOps.contains((Object)op)) {
                flags |= 1;
                opId = ExprUtil.toOpId(op);
            } else if (numericOps.contains((Object)op)) {
                flags |= 2;
                opId = ExprUtil.toOpId(op);
            }
        } else if (ExprUtil.isUnary(expr)) {
            BUnaryExpression unary = (BUnaryExpression)expr;
            String op = unary.op();
            if (ExprUtil.isConstant(unary.operand())) {
                flags |= 4;
            }
            if (ExprUtil.isAggregateExpr(unary.operand())) {
                flags |= 8;
            }
            if (boolOps.contains((Object)op)) {
                flags |= 1;
                opId = ExprUtil.toOpId(op);
            } else if (numericOps.contains((Object)op)) {
                flags |= 2;
                opId = ExprUtil.toOpId(op);
            }
        }
        expr.add(EXPR_FLAGS, (BValue)BInteger.make((int)flags));
        if (opId != -1) {
            expr.add(OP_ID, (BValue)BInteger.make((int)opId));
        }
        return expr;
    }

    public static final boolean isBoolean(BExpression expr) {
        Property tag = expr.getProperty(EXPR_FLAGS);
        return tag != null && (expr.getInt(tag) & 1) != 0;
    }

    public static final boolean isComparable(BExpression expr) {
        Property tag = expr.getProperty(EXPR_FLAGS);
        return tag != null && (expr.getInt(tag) & 2) != 0;
    }

    public static final boolean isConstant(BExpression expr) {
        Property tag = expr.getProperty(EXPR_FLAGS);
        return tag != null && (expr.getInt(tag) & 4) != 0;
    }

    public static final boolean isAggregateExpr(BExpression expr) {
        Property tag = expr.getProperty(EXPR_FLAGS);
        return tag != null && (expr.getInt(tag) & 8) != 0;
    }

    public static final int getOpId(BExpression expr) {
        Property op = expr.getProperty(OP_ID);
        if (op == null) {
            int opId = -1;
            if (expr instanceof BUnaryExpression) {
                opId = ExprUtil.toOpId(((BUnaryExpression)expr).op());
            } else if (expr instanceof BBinaryExpression) {
                opId = ExprUtil.toOpId(((BBinaryExpression)expr).op());
            }
            if (expr.get(OP_ID) != null) {
                expr.set(OP_ID, (BValue)BInteger.make((int)opId));
            } else {
                expr.add(OP_ID, (BValue)BInteger.make((int)opId));
            }
            op = expr.getProperty(OP_ID);
        }
        return expr.getInt(op);
    }

    private static int toOpId(String op) {
        for (int i = 0; i < OPTYPE_STRINGS.length; ++i) {
            if (!OPTYPE_STRINGS[i].equalsIgnoreCase(op)) continue;
            return i;
        }
        return -1;
    }
}

