/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.compiler;

import com.tridium.bql.BBqlLibrary;
import com.tridium.bql.BBqlTime;
import com.tridium.bql.compiler.BooleanRequiredException;
import com.tridium.bql.compiler.BqlTokenizer;
import com.tridium.bql.compiler.BqlTypeSpec;
import com.tridium.bql.compiler.ComparableRequiredException;
import com.tridium.bql.compiler.Constants;
import com.tridium.bql.compiler.ExprUtil;
import com.tridium.bql.compiler.InvalidNumberException;
import com.tridium.bql.compiler.LiteralParseException;
import com.tridium.bql.compiler.NumericRequiredException;
import com.tridium.bql.compiler.RuntimeCompilerException;
import com.tridium.bql.compiler.SimpleTypeRequiredException;
import com.tridium.bql.compiler.Token;
import com.tridium.bql.compiler.UnexpectedSymbolException;
import com.tridium.bql.compiler.UnexpectedTokenTypeException;
import com.tridium.bql.compiler.UnrecognizedModuleException;
import com.tridium.bql.compiler.UnrecognizedTypeException;
import com.tridium.bql.expression.BBqlFunction;
import com.tridium.bql.expression.BPath;
import com.tridium.bql.expression.BScalarFunction;
import java.io.IOException;
import javax.baja.nre.util.Array;
import javax.baja.query.BExpression;
import javax.baja.query.BNull;
import javax.baja.query.expression.BListExpression;
import javax.baja.query.expression.BSimpleExpression;
import javax.baja.query.util.Exprs;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

public class ExprParser
implements Constants {
    public static final BTypeSpec TIME_LIB = BBqlTime.TYPE.getTypeSpec();
    private static final BTypeSpec STD_LIB = BBqlLibrary.TYPE.getTypeSpec();
    private static final Lexicon lex = Lexicon.make((String)"bql");
    private static final BExpression[] NO_PARAMS = new BExpression[0];
    private BqlTokenizer tokens;
    private Token current;

    public BExpression parse(BqlTokenizer tokens) {
        this.tokens = tokens;
        this.next();
        BExpression result = this.or();
        tokens.push(this.current);
        return result;
    }

    protected BExpression or() {
        BExpression result = this.or(null);
        while (this.current.type == 6) {
            BExpression new_result = this.or(result);
            if (result.equals((Object)new_result)) {
                throw new RuntimeCompilerException(this.current.index, "unexpected.operator", this.current.lex);
            }
            result = new_result;
        }
        return result;
    }

    protected BExpression or(BExpression left) {
        int leftStart = this.current.index;
        int rightStart = this.current.index;
        if (left == null) {
            left = this.and();
        }
        while (this.current.type == 6 && this.current.opType == 14) {
            leftStart = rightStart;
            Token opToken = this.current;
            this.next();
            rightStart = this.current.index;
            BExpression right = this.and();
            this.verifyBoolean(left, leftStart);
            this.verifyBoolean(right, rightStart);
            left = ExprUtil.tag((BExpression)Exprs.binary((BExpression)left, (String)opToken.lex, (BExpression)right));
        }
        return left;
    }

    protected BExpression and() {
        int leftStart = this.current.index;
        int rightStart = this.current.index;
        BExpression left = this.comparison();
        while (this.current.type == 6 && this.current.opType == 13) {
            leftStart = rightStart;
            Token opToken = this.current;
            this.next();
            rightStart = this.current.index;
            BExpression right = this.comparison();
            this.verifyBoolean(left, leftStart);
            this.verifyBoolean(right, rightStart);
            left = ExprUtil.tag((BExpression)Exprs.binary((BExpression)left, (String)opToken.lex, (BExpression)right));
        }
        return left;
    }

    private void verifyBoolean(BExpression expr, int index) {
        if (!ExprUtil.isBoolean(expr)) {
            throw new BooleanRequiredException(index);
        }
    }

    protected BExpression comparison() {
        int leftStart = this.current.index;
        int rightStart = this.current.index;
        BExpression left = this.addition();
        while (this.isComparisonOperator()) {
            leftStart = rightStart;
            Token opToken = this.current;
            this.next();
            rightStart = this.current.index;
            BExpression right = this.addition();
            switch (opToken.opType) {
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    if (!ExprUtil.isComparable(left)) {
                        throw new ComparableRequiredException(leftStart);
                    }
                    if (ExprUtil.isComparable(right)) break;
                    throw new ComparableRequiredException(rightStart);
                }
                case 5: 
                case 6: {
                    break;
                }
                case 11: {
                    if (ExprUtil.isConstant(right) && right instanceof BSimpleExpression && ((BSimpleExpression)right).getSimpleValue().getType().is(BString.TYPE)) break;
                    throw new SimpleTypeRequiredException(rightStart, BString.TYPE);
                }
                case 15: {
                    this.validateIN_Right(right, rightStart);
                    break;
                }
                default: {
                    throw new RuntimeCompilerException(opToken.index, "invalid.opType.comparison", opToken.lex);
                }
            }
            left = ExprUtil.tag((BExpression)Exprs.binary((BExpression)left, (String)opToken.lex, (BExpression)right));
        }
        return left;
    }

    private boolean isComparisonOperator() {
        return this.current.type == 6 && (this.current.opType == 5 || this.current.opType == 6 || this.current.opType == 7 || this.current.opType == 8 || this.current.opType == 9 || this.current.opType == 10 || this.current.opType == 11 || this.current.opType == 15);
    }

    private void validateIN_Right(BExpression right, int rightStart) throws RuntimeCompilerException {
        if (right instanceof BListExpression) {
            return;
        }
        if (right instanceof BScalarFunction) {
            return;
        }
        throw new RuntimeCompilerException(rightStart, this.lexText("in.invalidRHS"));
    }

    protected BExpression addition() {
        int leftStart = this.current.index;
        int rightStart = this.current.index;
        BExpression left = this.multiplication();
        while (this.current.type == 6 && (this.current.opType == 0 || this.current.opType == 1)) {
            leftStart = rightStart;
            Token opToken = this.current;
            this.next();
            rightStart = this.current.index;
            BExpression right = this.multiplication();
            if (!ExprUtil.isComparable(left)) {
                throw new NumericRequiredException(leftStart);
            }
            if (!ExprUtil.isComparable(right)) {
                throw new NumericRequiredException(rightStart);
            }
            left = ExprUtil.tag((BExpression)Exprs.binary((BExpression)left, (String)opToken.lex, (BExpression)right));
        }
        return left;
    }

    protected BExpression multiplication() {
        int leftStart = this.current.index;
        int rightStart = this.current.index;
        BExpression left = this.unary();
        while (this.current.type == 6 && (this.current.opType == 2 || this.current.opType == 3 || this.current.opType == 4)) {
            leftStart = rightStart;
            Token opToken = this.current;
            this.next();
            rightStart = this.current.index;
            BExpression right = this.unary();
            if (!ExprUtil.isComparable(left)) {
                throw new NumericRequiredException(leftStart);
            }
            if (!ExprUtil.isComparable(right)) {
                throw new NumericRequiredException(rightStart);
            }
            left = ExprUtil.tag((BExpression)Exprs.binary((BExpression)left, (String)opToken.lex, (BExpression)right));
        }
        return left;
    }

    protected BExpression unary() {
        Token opToken = null;
        if (this.current.type == 6) {
            opToken = this.current;
            switch (opToken.opType) {
                case 0: 
                case 1: {
                    this.next();
                    break;
                }
                case 12: {
                    return this.not();
                }
                default: {
                    throw new RuntimeCompilerException(this.current.index, "unexpected.operator", opToken.lex);
                }
            }
        }
        int exprStart = this.current.index;
        BExpression expr = this.term();
        if (opToken != null) {
            switch (opToken.opType) {
                case 0: {
                    if (!ExprUtil.isComparable(expr)) {
                        throw new NumericRequiredException(exprStart);
                    }
                    return ExprUtil.tag((BExpression)Exprs.unary((String)opToken.lex, (BExpression)expr));
                }
                case 1: {
                    if (!ExprUtil.isComparable(expr)) {
                        throw new NumericRequiredException(exprStart);
                    }
                    return ExprUtil.tag((BExpression)Exprs.unary((String)opToken.lex, (BExpression)expr));
                }
            }
            throw new IllegalStateException();
        }
        return expr;
    }

    protected BExpression not() {
        Token opToken = null;
        int numNot = 0;
        while (this.current.type == 6 && this.current.opType == 12) {
            opToken = this.current;
            this.next();
            ++numNot;
        }
        if (opToken == null) {
            throw new IllegalStateException("Should have NOT");
        }
        int exprStart = this.current.index;
        BExpression expr = this.term();
        this.verifyBoolean(expr, exprStart);
        for (int i = 0; i < numNot; ++i) {
            expr = ExprUtil.tag((BExpression)Exprs.unary((String)opToken.lex, (BExpression)expr));
        }
        return expr;
    }

    protected BExpression term() {
        Token termToken = this.current;
        int opId = termToken.type;
        switch (opId) {
            case 1: {
                return ExprUtil.tag(this.id());
            }
            case 3: 
            case 12: {
                return ExprUtil.tag(this.number());
            }
            case 5: {
                this.next();
                return ExprUtil.tag((BExpression)Exprs.simple((BSimple)BString.make((String)termToken.lex)));
            }
            case 4: {
                this.next();
                return ExprUtil.tag((BExpression)Exprs.simple((BSimple)BBoolean.make((boolean)termToken.booleanValue)));
            }
            case 23: {
                return ExprUtil.tag(this.typeSpec());
            }
            case 7: {
                this.match(7);
                BExpression expr = this.or();
                this.match(8);
                return expr;
            }
            case 35: {
                this.tokens.push(this.current);
                return this.makeList(this.parameters(35, 36));
            }
            case 29: {
                return ExprUtil.tag((BExpression)BBqlFunction.make(TIME_LIB, this.match((int)29).lex, this.makeList(NO_PARAMS)));
            }
            case 30: {
                return ExprUtil.tag((BExpression)BBqlFunction.make(TIME_LIB, this.match((int)30).lex, this.makeList(NO_PARAMS)));
            }
            case 31: {
                return ExprUtil.tag((BExpression)BBqlFunction.make(TIME_LIB, this.match((int)31).lex, this.makeList(NO_PARAMS)));
            }
            case 33: {
                return ExprUtil.tag(this.bqltime());
            }
            case 26: {
                this.next();
                return ExprUtil.tag((BExpression)Exprs.simple((BSimple)BNull.NULL));
            }
            case 25: {
                throw new IllegalStateException();
            }
        }
        throw new UnexpectedSymbolException(termToken.index, "identifier or literal", termToken.toDisplay());
    }

    protected BExpression id() {
        Token pathStart = this.match(1);
        if (this.current.type == 7) {
            this.tokens.push(this.current);
            return this.function(STD_LIB, pathStart.lex);
        }
        Array parts = new Array(String.class);
        parts.add((Object)pathStart.lex);
        while (this.current.type == 12) {
            this.match(12);
            parts.add((Object)this.matchWord().lex);
        }
        return new BPath((String[])parts.trim());
    }

    protected BExpression typeSpec() {
        int start = this.current.index;
        Token typeToken = this.match(23);
        if (this.current.type == 5) {
            Token string = this.match(5);
            BqlTypeSpec typeSpec = new BqlTypeSpec(typeToken.lex);
            try {
                return Exprs.simple((BSimple)((BSimple)typeSpec.parse(string.lex)));
            }
            catch (ModuleException e) {
                throw new UnrecognizedModuleException(start, typeToken.lex);
            }
            catch (TypeException e) {
                throw new UnrecognizedTypeException(start, typeToken.lex);
            }
            catch (LiteralParseException | IOException e) {
                throw new LiteralParseException(start, typeToken.lex, string.lex);
            }
        }
        if (this.current.type == 12) {
            this.match(12);
            return this.enumOrFunctionExpr(typeToken);
        }
        return Exprs.simple((BSimple)BTypeSpec.make((String)typeToken.lex));
    }

    protected BExpression enumOrFunctionExpr(Token typeToken) {
        if (this.current.type != 1) {
            throw new UnexpectedTokenTypeException(this.current.index, 1, this.current.type);
        }
        Token idToken = this.match(1);
        if (this.current.type == 7) {
            this.tokens.push(this.current);
            return this.function(BTypeSpec.make((String)typeToken.lex), idToken.lex);
        }
        Type enumType = BTypeSpec.make((String)typeToken.lex).getResolvedType();
        BObject instance = enumType.getInstance();
        if (!(instance instanceof BFrozenEnum)) {
            throw new RuntimeCompilerException(typeToken.index, "invalid.enum.tag", typeToken.lex);
        }
        BFrozenEnum frozen = (BFrozenEnum)instance;
        BFrozenEnum value = (BFrozenEnum)frozen.getRange().get(idToken.lex);
        if (value == null) {
            throw new RuntimeCompilerException(idToken.index, "invalid.enum.tag", idToken.lex);
        }
        return Exprs.simple((BSimple)value);
    }

    protected BExpression number() {
        Token numberToken;
        this.tokens.setShowWhite(true);
        if (this.current.type != 12) {
            numberToken = this.current;
            this.next();
        } else {
            numberToken = Token.number(this.current.index, "0");
        }
        if (this.current.type == 12) {
            this.match(12);
            Token fracToken = this.current;
            if (fracToken.type != 3) {
                throw new InvalidNumberException(numberToken.index, numberToken.lex + "." + fracToken.lex);
            }
            this.match(3);
            this.tokens.setShowWhite(false);
            if (this.current.type == 0) {
                this.next();
            }
            return Exprs.simple((BSimple)BDouble.make((double)Double.parseDouble(numberToken.lex + "." + fracToken.lex)));
        }
        this.tokens.setShowWhite(false);
        if (this.current.type == 0) {
            this.next();
        }
        return Exprs.simple((BSimple)BLong.make((long)Long.parseLong(numberToken.lex)));
    }

    protected BExpression[] parameters(int leftBound, int rightBound) {
        if (this.tokens.peek().type != leftBound) {
            this.next();
            return NO_PARAMS;
        }
        this.next();
        if (this.tokens.peek().type == rightBound) {
            this.next();
            this.next();
            return NO_PARAMS;
        }
        Array temp = new Array(BExpression.class);
        while (this.current.type != rightBound) {
            ExprParser subParser = new ExprParser();
            BExpression sub = subParser.parse(this.tokens);
            temp.add((Object)sub);
            this.next();
        }
        this.next();
        return (BExpression[])temp.trim();
    }

    protected BExpression function(BTypeSpec typeSpec, String name) {
        boolean isDistinct = false;
        if (this.tokens.peek().type != 7) {
            this.next();
            return BBqlFunction.make(typeSpec, name, this.makeList(NO_PARAMS));
        }
        this.next();
        if (this.tokens.peek().type == 8) {
            this.next();
            this.next();
            return BBqlFunction.make(typeSpec, name, this.makeList(NO_PARAMS));
        }
        if (this.tokens.peek().type == 19) {
            this.next();
            isDistinct = true;
        }
        BBqlFunction function = null;
        if (this.tokens.peek().type == 6 && this.tokens.peek().opType == 2) {
            if (isDistinct) {
                throw new RuntimeCompilerException(this.current.index, this.lexText("function.distinctStar"));
            }
            this.next();
            if (this.tokens.peek().type != 8) {
                throw new RuntimeCompilerException(this.current.index, this.lexText("function.starAndArgs"));
            }
            this.next();
            this.next();
            function = BBqlFunction.make(typeSpec, name, this.makeList(new BExpression[]{new BPath("toString")}));
        } else {
            int lbound = this.current.type;
            this.tokens.push(this.current);
            function = BBqlFunction.make(typeSpec, name, this.makeList(this.parameters(lbound, 8)));
        }
        function.setDistinct(isDistinct);
        return function;
    }

    private BListExpression makeList(BExpression[] elems) {
        BListExpression list = new BListExpression();
        for (int i = 0; i < elems.length; ++i) {
            list.add(elems[i]);
        }
        return list;
    }

    protected BExpression bqltime() {
        this.next();
        this.match(12);
        Token timeToken = this.current;
        if (this.current.type != 1) {
            throw new UnexpectedTokenTypeException(timeToken.index, 1, timeToken.type);
        }
        String name = this.current.lex;
        return BBqlFunction.make(TIME_LIB, name, this.makeList(this.parameters(7, 8)));
    }

    private void next() {
        Token result = this.current;
        this.current = this.tokens.next();
    }

    private Token match(int matchType) {
        Token result = this.current;
        if (this.current.type != matchType) {
            throw new UnexpectedTokenTypeException(this.current.index, matchType, this.current.type);
        }
        this.next();
        return result;
    }

    private Token matchWord() {
        Token result = this.current;
        if (!this.current.isWord) {
            throw new UnexpectedTokenTypeException(this.current.index, 1, this.current.type);
        }
        this.next();
        return result;
    }

    private String lexText(String key) {
        return lex.get(key, key);
    }
}

