/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.compiler;

import com.tridium.bql.BBqlInterval;
import com.tridium.bql.compiler.LiteralParseException;
import com.tridium.bql.compiler.SimpleTypeRequiredException;
import com.tridium.bql.compiler.TimeUtil;
import java.io.IOException;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.util.BTypeSpec;

public class BqlTypeSpec {
    private static final int DATE = 0;
    private static final int TIME = 1;
    private static final int TIMESTAMP = 2;
    private static final int INTERVAL = 3;
    private String moduleName;
    private String typeName;
    private String bajaTypeName;
    private BTypeSpec bts;
    private int specialType = -1;

    public BqlTypeSpec(String spec) {
        int colon = spec.indexOf(58);
        if (colon == -1) {
            this.typeName = spec;
            this.setBajaType(this.typeName);
        } else {
            this.moduleName = spec.substring(0, colon);
            this.typeName = spec.substring(colon + 1);
            this.specialType = -1;
            this.bajaTypeName = this.typeName;
        }
    }

    public BTypeSpec getTypeSpec() {
        if (this.bts == null) {
            this.bts = BTypeSpec.make((String)this.moduleName, (String)this.typeName);
        }
        return this.bts;
    }

    public BObject parse(String s) throws ModuleException, TypeException, IOException, LiteralParseException {
        if (this.specialType == -1) {
            BTypeSpec typeSpec = this.getTypeSpec();
            Type type = typeSpec.getResolvedType();
            BObject def = type.getInstance();
            if (!def.isSimple()) {
                throw new SimpleTypeRequiredException(0, type);
            }
            try {
                return ((BSimple)def).decodeFromString(s);
            }
            catch (IOException e) {
                throw new LiteralParseException(0, typeSpec.toString(), s);
            }
        }
        if (this.specialType == 0) {
            return TimeUtil.parseDate(s);
        }
        if (this.specialType == 1) {
            return TimeUtil.parseTime(s);
        }
        if (this.specialType == 2) {
            return TimeUtil.parseTimestamp(s);
        }
        if (this.specialType == 3) {
            return BBqlInterval.make(s);
        }
        throw new LiteralParseException(0, this.getTypeSpec().toString(), s);
    }

    private void setBajaType(String typeName) {
        this.moduleName = "baja";
        typeName = typeName.toLowerCase();
        char first = typeName.charAt(0);
        switch (first) {
            case 'd': {
                if (typeName.equals("date")) {
                    this.specialType = 0;
                    this.moduleName = "baja";
                    this.bajaTypeName = "AbsTime";
                    break;
                }
                if (!typeName.equals("datetime")) break;
                this.specialType = 2;
                this.moduleName = "baja";
                this.bajaTypeName = "AbsTime";
                break;
            }
            case 't': {
                if (typeName.equals("time")) {
                    this.specialType = 1;
                    this.moduleName = "baja";
                    this.bajaTypeName = "Time";
                    break;
                }
                if (!typeName.equals("timestamp")) break;
                this.specialType = 2;
                this.moduleName = "baja";
                this.bajaTypeName = "AbsTime";
                break;
            }
            case 'i': {
                if (!typeName.equals("interval")) break;
                this.specialType = 3;
                this.moduleName = "bql";
                this.bajaTypeName = "BqlInterval";
                break;
            }
            default: {
                this.specialType = -1;
                this.bajaTypeName = typeName;
            }
        }
    }
}

