/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.collection;

import com.tridium.bql.BSelect;
import com.tridium.bql.collection.BqlColumn;
import com.tridium.bql.collection.BqlColumnList;
import com.tridium.bql.collection.BqlRow;
import com.tridium.bql.collection.TypeColumnList;
import com.tridium.bql.compiler.ExprUtil;
import com.tridium.bql.expression.BAggregateFunction;
import com.tridium.bql.expression.ExprEngine;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.collection.AbstractTableCursor;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Row;
import javax.baja.collection.TableCursor;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.query.BExpression;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.expression.BBinaryExpression;
import javax.baja.query.expression.BUnaryExpression;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BAggregateTable
extends BObject
implements BIRandomAccessTable<BIObject> {
    public static final Type TYPE = Sys.loadType(BAggregateTable.class);
    private BqlColumnList columns;
    private Context context;
    private ArrayList<Row<? extends BIObject>> list;
    private Type baseType;
    private BExpression[] groupby;
    private BExpression[] aggregates;
    private BSelect query;
    private ExprEngine engine;

    public BAggregateTable(BITable<? extends BIObject> inner, BSelect query, Context cx) {
        this.context = cx;
        this.query = query;
        this.engine = query.getExprEngine();
        this.load(inner);
    }

    public BITable<? extends BIObject> filter(IFilter filter) {
        ArrayList<Row<? extends BIObject>> filtered = new ArrayList<Row<? extends BIObject>>(this.list.size());
        for (int i = 0; i < this.list.size(); ++i) {
            if (!filter.accept(this.list.get(i))) continue;
            filtered.add(this.list.get(i));
        }
        this.list = filtered;
        return this;
    }

    public TableCursor<BIObject> cursor() {
        return new AggregateTableCursor(this, this.context);
    }

    public Row<BIObject> get(int row) {
        return new BqlRow<BIObject>((BITable<BIObject>)this, this.list.get(row).rowObject());
    }

    public int size() {
        return this.list.size();
    }

    public ColumnList getColumns() {
        if (this.columns == null) {
            if (this.groupby.length > 0) {
                TypeColumnList typeColumns = new TypeColumnList(this.baseType, null);
                this.columns = new BqlColumnList(typeColumns.list());
            } else {
                this.columns = new BqlColumnList();
            }
        }
        return this.columns;
    }

    public int getFlags(int row, Column column) {
        BObject o = (BObject)this.list.get(row);
        return ((BqlColumn)column).getFlags(o);
    }

    public BFacets getFacets(int row, Column column) {
        BObject o = (BObject)this.list.get(row);
        return ((BqlColumn)column).getFacets(o);
    }

    public BFacets getTableFacets() {
        return BFacets.NULL;
    }

    private void load(BITable<? extends BIObject> inner) {
        this.flatten();
        boolean isOnlyAggregates = this.groupby.length == 0;
        this.list = new ArrayList(16);
        this.baseType = null;
        BObject prototype = null;
        TableCursor c = inner.cursor();
        HashMap groupByMap = new HashMap();
        while (c.next()) {
            Row row = c.row().safeCopy();
            BObject o = (BObject)row.rowObject();
            if (isOnlyAggregates) {
                if (this.list.isEmpty()) {
                    prototype = o;
                    this.list.add((Row<? extends BIObject>)row);
                }
            } else {
                prototype = this.findPrototype(o, groupByMap);
                if (prototype == o) {
                    this.updateType(o.getType());
                    this.list.add((Row<? extends BIObject>)row);
                }
            }
            this.doAggregation(prototype, o);
        }
        if (this.query.hasHaving()) {
            BExpression havingExpr = this.query.getHaving().getHavingExpr();
            ArrayList<Row<? extends BIObject>> filtered = new ArrayList<Row<? extends BIObject>>(this.list.size() / 2);
            int size = this.list.size();
            for (int i = 0; i < size; ++i) {
                BObject o = (BObject)this.list.get(i).rowObject();
                BObject result = this.engine.evaluate(havingExpr, o, this.context);
                if (result.isNull() || !BBoolean.TRUE.equals((Object)result)) continue;
                filtered.add(this.list.get(i));
            }
            this.list = filtered;
        }
        if (this.baseType == null) {
            this.baseType = BObject.TYPE;
        }
    }

    private void flatten() {
        int i;
        BProjectionColumn[] cols;
        Array groupby = new Array(BExpression.class);
        Array aggs = new Array(BExpression.class);
        if (this.query.hasProjection()) {
            cols = this.query.getProjection().getProjectionColumns();
            for (i = 0; i < cols.length; ++i) {
                this.flatten(cols[i].getColumnExpression(), (Array<BExpression>)groupby, (Array<BExpression>)aggs, true);
            }
        }
        if (this.query.hasHaving()) {
            this.flatten(this.query.getHaving().getHavingExpr(), (Array<BExpression>)groupby, (Array<BExpression>)aggs, true);
        }
        if (this.query.hasOrdering()) {
            cols = this.query.getOrdering().getOrderByColumns();
            for (i = 0; i < cols.length; ++i) {
                if (ExprUtil.isSimple(cols[i].getColumnExpression())) continue;
                this.flatten(cols[i].getColumnExpression(), (Array<BExpression>)groupby, (Array<BExpression>)aggs, true);
            }
        }
        this.groupby = (BExpression[])groupby.trim();
        this.aggregates = (BExpression[])aggs.trim();
    }

    private void flatten(BExpression expr, Array<BExpression> groupby, Array<BExpression> aggs, boolean root) {
        if (ExprUtil.isConstant(expr)) {
            return;
        }
        if (root && !ExprUtil.isAggregateExpr(expr)) {
            this.addIfUnique(expr, groupby);
            return;
        }
        if (ExprUtil.isAggregateFunction(expr)) {
            aggs.add((Object)expr);
        } else if (ExprUtil.isUnary(expr)) {
            this.flatten(((BUnaryExpression)expr).operand(), groupby, aggs, false);
        } else if (ExprUtil.isBinary(expr)) {
            BBinaryExpression b = (BBinaryExpression)expr;
            this.flatten(b.lhs(), groupby, aggs, false);
            this.flatten(b.rhs(), groupby, aggs, false);
        } else if (ExprUtil.isField(expr)) {
            this.addIfUnique(expr, groupby);
        }
    }

    private void addIfUnique(BExpression e, Array<BExpression> arr) {
        String eStr = ExprUtil.toExprStr(e);
        int size = arr.size();
        for (int i = 0; i < size; ++i) {
            if (!eStr.equals(ExprUtil.toExprStr((BExpression)arr.get(i)))) continue;
            return;
        }
        arr.add((Object)e);
    }

    private BObject findPrototype(BObject o, HashMap groupByMap) {
        HashMap currentMap = groupByMap;
        boolean isDistinct = false;
        for (int i = 0; i < this.groupby.length; ++i) {
            BObject result = this.engine.evaluate(this.groupby[i], o, this.context);
            if (!currentMap.containsKey(result)) {
                currentMap.put(result, new HashMap());
                isDistinct = true;
            }
            currentMap = (HashMap)currentMap.get(result);
        }
        if (isDistinct) {
            currentMap.put("prototype", o);
        }
        return (BObject)currentMap.get("prototype");
    }

    private void doAggregation(BObject prototype, BObject actual) {
        for (int f = 0; f < this.aggregates.length; ++f) {
            ((BAggregateFunction)this.aggregates[f]).accumulate(prototype, actual, this.engine, this.context);
        }
    }

    private void updateType(Type newType) {
        if (this.baseType == null) {
            this.baseType = newType;
            return;
        }
        if (this.baseType == newType) {
            return;
        }
        while (this.baseType != BObject.TYPE && !newType.is(this.baseType)) {
            this.baseType = this.baseType.getSuperType();
        }
    }

    public Type getType() {
        return TYPE;
    }

    private class AggregateTableCursor
    extends AbstractTableCursor<BIObject> {
        final Context cx;
        final int size;
        int currentRow;

        public AggregateTableCursor(BAggregateTable table, Context cx) {
            super((BITable)table);
            this.currentRow = -1;
            this.cx = cx;
            this.size = table.size();
        }

        public Context getContext() {
            return this.cx;
        }

        public boolean advanceCursor() {
            if (this.currentRow < this.size) {
                ++this.currentRow;
            }
            return this.currentRow < this.size;
        }

        public Row<BIObject> row() {
            return ((BAggregateTable)this.getTable()).get(this.currentRow);
        }
    }
}

