/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql;

import com.tridium.bql.FunctionSpec;
import com.tridium.bql.FunctionUtil;
import com.tridium.util.FormatDenylist;
import java.lang.reflect.Method;
import javax.baja.bql.BqlQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BObject;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class FunctionQuery
extends BqlQuery {
    public FunctionSpec spec;

    public FunctionQuery(FunctionSpec spec) {
        this.spec = spec;
    }

    @Override
    public OrdTarget resolve(OrdTarget base) {
        Method method;
        Object[] resolvedParams;
        block9: {
            BTypeSpec typeSpec = BTypeSpec.make((String)this.spec.getTypeSpecString());
            Type type = typeSpec.getResolvedType();
            Class methodClass = type.getTypeClass();
            BqlQuery[] params = this.spec.getParameters();
            resolvedParams = new Object[params.length + 1];
            Class[] paramTypes = new Class[params.length + 1];
            resolvedParams[0] = base;
            paramTypes[0] = resolvedParams[0].getClass();
            int index = 1;
            for (BqlQuery param : params) {
                resolvedParams[index] = param.resolve(base).get();
                if (resolvedParams[index] != null) {
                    paramTypes[index] = resolvedParams[index].getClass();
                }
                ++index;
            }
            try {
                if (FormatDenylist.isDenied((Class)methodClass, (String)this.spec.getMethodName(), (Class[])paramTypes)) {
                    throw new UnresolvedException("Denied method: " + typeSpec.toString() + "." + this.spec.getMethodName());
                }
                method = methodClass.getMethod(this.spec.getMethodName(), paramTypes);
                if (method.getReturnType().equals(Void.TYPE)) {
                    throw new UnresolvedException(typeSpec.toString() + "." + this.spec.getMethodName());
                }
            }
            catch (NoSuchMethodException e) {
                method = FunctionUtil.getFunction(methodClass, this.spec.getMethodName(), paramTypes, true);
                if (method != null) break block9;
                throw new UnresolvedException(typeSpec.toString() + "." + this.spec.getMethodName());
            }
        }
        try {
            return new OrdTarget(base, (BObject)method.invoke(null, resolvedParams));
        }
        catch (UnresolvedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new UnresolvedException("Unresolvable function query.", (Throwable)ex);
        }
    }
}

