/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql;

import com.tridium.bql.compiler.RuntimeCompilerException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

public final class BBqlInterval
extends BSimple
implements BIComparable {
    public static final BBqlInterval DEFAULT = BBqlInterval.make("0ms");
    private String format;
    private static final int MILLIS = 1;
    private static final int SECONDS = 2;
    private static final int MINUTES = 4;
    private static final int HOURS = 8;
    private static final int DAYS = 16;
    private static final int WEEKS = 32;
    private static final int MONTHS = 64;
    private static final int YEARS = 128;
    private int fields = 0;
    private long ms;
    private int seconds;
    private int minutes;
    private int hours;
    private int days;
    private int weeks;
    private int months;
    private int years;
    private long allMilliCache = -1L;
    private BRelTime milliCache;
    public static final Type TYPE = Sys.loadType(BBqlInterval.class);

    private BBqlInterval(String format) {
        this.format = format;
        this.parse();
    }

    public static BBqlInterval make(String format) {
        return new BBqlInterval(format);
    }

    public BAbsTime addTo(BAbsTime t) {
        if (this.useMilliMath()) {
            return t.add(this.getRelTime());
        }
        int year = t.getYear();
        BMonth month = t.getMonth();
        int day = t.getDay();
        if ((this.fields & 0x80) != 0) {
            year += this.years;
        }
        if ((this.fields & 0x40) != 0) {
            for (int i = 0; i < this.months; ++i) {
                month = month.next();
            }
        }
        if ((this.fields & 0xC0) != 0) {
            t = BAbsTime.make((int)year, (BMonth)month, (int)day, (int)t.getHour(), (int)t.getMinute(), (int)t.getSecond(), (int)t.getMillisecond(), (BTimeZone)t.getTimeZone());
        }
        if ((this.fields & 0x20) != 0) {
            t = BBqlInterval.addDays(t, this.weeks * 7);
        }
        if ((this.fields & 0x10) != 0) {
            t = BBqlInterval.addDays(t, this.days);
        }
        if ((this.fields & 0xF) != 0) {
            t = t.add(this.getRelTime());
        }
        return t;
    }

    public static BAbsTime addDays(BAbsTime t, int days) {
        int year = t.getYear();
        int dayOfYear = t.getDayOfYear();
        int daysInYear = BAbsTime.getDaysInYear((int)year);
        dayOfYear += days;
        while (dayOfYear > daysInYear) {
            dayOfYear -= daysInYear;
            daysInYear = BAbsTime.getDaysInYear((int)(++year));
        }
        return BAbsTime.makeDayOfYear((int)year, (int)dayOfYear, (int)t.getHour(), (int)t.getMinute(), (int)t.getSecond(), (int)t.getMillisecond(), (BTimeZone)t.getTimeZone());
    }

    public BAbsTime subtractFrom(BAbsTime t) {
        if (this.useMilliMath()) {
            return t.subtract(this.getRelTime());
        }
        int year = t.getYear();
        BMonth month = t.getMonth();
        int day = t.getDay();
        if ((this.fields & 0x80) != 0) {
            year -= this.years;
        }
        if ((this.fields & 0x40) != 0) {
            for (int i = 0; i < this.months; ++i) {
                month = month.previous();
            }
        }
        if ((this.fields & 0xC0) != 0) {
            t = BAbsTime.make((int)year, (BMonth)month, (int)day, (int)t.getHour(), (int)t.getMinute(), (int)t.getSecond(), (int)t.getMillisecond(), (BTimeZone)t.getTimeZone());
        }
        if ((this.fields & 0x20) != 0) {
            t = BBqlInterval.subtractDays(t, this.weeks * 7);
        }
        if ((this.fields & 0x10) != 0) {
            t = BBqlInterval.subtractDays(t, this.days);
        }
        if ((this.fields & 0xF) != 0) {
            t = t.subtract(this.getRelTime());
        }
        return t;
    }

    public static BAbsTime subtractDays(BAbsTime t, int days) {
        int year = t.getYear();
        int dayOfYear = t.getDayOfYear();
        int daysInYear = BAbsTime.getDaysInYear((int)year);
        dayOfYear -= days;
        while (dayOfYear < 1) {
            daysInYear = BAbsTime.getDaysInYear((int)(--year));
            dayOfYear += daysInYear;
        }
        return BAbsTime.makeDayOfYear((int)year, (int)dayOfYear, (int)t.getHour(), (int)t.getMinute(), (int)t.getSecond(), (int)t.getMillisecond(), (BTimeZone)t.getTimeZone());
    }

    private boolean useMilliMath() {
        return (this.fields & 0xF0) == 0;
    }

    private BRelTime getRelTime() {
        if (this.milliCache != null) {
            return this.milliCache;
        }
        long millis = 0L;
        if ((this.fields & 1) != 0) {
            millis = this.ms;
        }
        if ((this.fields & 2) != 0) {
            millis += (long)this.seconds * 1000L;
        }
        if ((this.fields & 4) != 0) {
            millis += (long)this.minutes * 60000L;
        }
        if ((this.fields & 8) != 0) {
            millis += (long)this.hours * 3600000L;
        }
        this.milliCache = BRelTime.make((long)millis);
        return this.milliCache;
    }

    private long getAllMillis() {
        if (this.allMilliCache == -1L) {
            this.allMilliCache = 0L;
            if ((this.fields & 1) != 0) {
                this.allMilliCache = this.ms;
            }
            if ((this.fields & 2) != 0) {
                this.allMilliCache += (long)this.seconds * 1000L;
            }
            if ((this.fields & 4) != 0) {
                this.allMilliCache += (long)this.minutes * 60000L;
            }
            if ((this.fields & 8) != 0) {
                this.allMilliCache += (long)this.hours * 3600000L;
            }
            if ((this.fields & 0x10) != 0) {
                this.allMilliCache += (long)this.days * 86400000L;
            }
            if ((this.fields & 0x20) != 0) {
                this.allMilliCache += (long)this.weeks * 604800000L;
            }
            if ((this.fields & 0x40) != 0) {
                this.allMilliCache += (long)this.months * 2592000000L;
            }
            if ((this.fields & 0x80) != 0) {
                this.allMilliCache += (long)this.years * 31536000000L;
            }
        }
        return this.allMilliCache;
    }

    public int compareTo(Object o) {
        long otherMillis;
        BBqlInterval i = (BBqlInterval)((Object)o);
        long myMillis = this.getAllMillis();
        if (myMillis < (otherMillis = i.getAllMillis())) {
            return -1;
        }
        if (myMillis == otherMillis) {
            return 0;
        }
        return 1;
    }

    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public BObject decodeFromString(String s) throws IOException {
        try {
            return BBqlInterval.make(s);
        }
        catch (Exception e) {
            throw new IOException("Invalid BqlInterval: " + s);
        }
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.format);
    }

    public String encodeToString() throws IOException {
        return this.format;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.days;
        result = 31 * result + this.fields;
        result = 31 * result + this.hours;
        result = 31 * result + this.minutes;
        result = 31 * result + this.months;
        result = 31 * result + (int)(this.ms ^ this.ms >>> 32);
        result = 31 * result + this.seconds;
        result = 31 * result + this.weeks;
        result = 31 * result + this.years;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        BBqlInterval other = (BBqlInterval)((Object)obj);
        if (this.days != other.days) {
            return false;
        }
        if (this.fields != other.fields) {
            return false;
        }
        if (this.hours != other.hours) {
            return false;
        }
        if (this.minutes != other.minutes) {
            return false;
        }
        if (this.months != other.months) {
            return false;
        }
        if (this.ms != other.ms) {
            return false;
        }
        if (this.seconds != other.seconds) {
            return false;
        }
        if (this.weeks != other.weeks) {
            return false;
        }
        return this.years == other.years;
    }

    public BBqlInterval setMillis(long millis) {
        this.ms = millis;
        this.milliCache = null;
        this.fields |= 1;
        return this;
    }

    public BBqlInterval setSeconds(int seconds) {
        this.seconds = seconds;
        this.milliCache = null;
        this.fields |= 2;
        return this;
    }

    public BBqlInterval setMinutes(int minutes) {
        this.minutes = minutes;
        this.milliCache = null;
        this.fields |= 4;
        return this;
    }

    public BBqlInterval setHours(int hours) {
        this.hours = hours;
        this.milliCache = null;
        this.fields |= 8;
        return this;
    }

    public BBqlInterval setDays(int days) {
        this.days = days;
        this.fields |= 0x10;
        return this;
    }

    public BBqlInterval setWeeks(int weeks) {
        this.weeks = weeks;
        this.fields |= 0x20;
        return this;
    }

    public BBqlInterval setMonths(int months) {
        this.months = months;
        this.fields |= 0x40;
        return this;
    }

    public BBqlInterval setYears(int years) {
        this.years = years;
        this.fields |= 0x80;
        return this;
    }

    private void parse() {
        char[] AFTER_UNIT = new char[]{',', ' '};
        CharBuf cb = new CharBuf(this.format.toCharArray(), 0, this.format.length());
        cb.checkNotDone("invalid.format.interval");
        int count = 0;
        while (!cb.done()) {
            int number = cb.readNumber();
            if (count == 0) {
                cb.checkNotDone("invalid.format.interval");
                if (cb.buf[cb.index] == ':') {
                    cb.advance();
                    this.parseAbsoluteInterval(number, cb);
                    return;
                }
            }
            cb.skip(' ');
            cb.checkNotDone("invalid.format.interval");
            String unit = cb.readString(AFTER_UNIT);
            switch (unit.charAt(0)) {
                case 'd': {
                    if (unit.equals("day") || unit.length() == 1) {
                        this.setDays(number);
                        break;
                    }
                    throw new RuntimeCompilerException(0, "invalid.unit", unit);
                }
                case 'h': {
                    if (unit.equals("hour") || unit.length() == 1) {
                        this.setHours(number);
                        break;
                    }
                    throw new RuntimeCompilerException(0, "invalid.unit", unit);
                }
                case 'm': {
                    if (unit.startsWith("min") || unit.length() == 1) {
                        this.setMinutes(number);
                        break;
                    }
                    if (unit.equals("month")) {
                        this.setMonths(number);
                        break;
                    }
                    if (unit.equals("ms") || unit.startsWith("milli")) {
                        this.setMillis(number);
                        break;
                    }
                    throw new RuntimeCompilerException(0, "invalid.unit", unit);
                }
                case 's': {
                    if (unit.startsWith("sec") || unit.length() == 1) {
                        this.setSeconds(number);
                        break;
                    }
                    throw new RuntimeCompilerException(0, "invalid.unit", unit);
                }
                case 'w': {
                    if (unit.equals("week") || unit.length() == 1) {
                        this.setWeeks(number);
                        break;
                    }
                    throw new RuntimeCompilerException(0, "invalid.unit", unit);
                }
                case 'y': {
                    if (unit.equals("year") || unit.length() == 1) {
                        this.setYears(number);
                        break;
                    }
                    throw new RuntimeCompilerException(0, "invalid.unit", unit);
                }
                default: {
                    throw new RuntimeCompilerException(0, "invalid.unit", unit);
                }
            }
            cb.skip(AFTER_UNIT);
            ++count;
        }
    }

    private void parseAbsoluteInterval(int housrs, CharBuf cb) {
        this.setHours(this.hours);
        this.setMinutes(cb.readNumber());
        if (cb.done()) {
            return;
        }
        cb.checkCurrent(':', "invalid.format.interval");
        cb.advance();
        this.setSeconds(cb.readNumber());
        if (cb.done()) {
            return;
        }
        cb.checkCurrent('.', "invalid.format.interval");
        cb.advance();
        this.setMillis(cb.readNumber());
        if (cb.done()) {
            return;
        }
        throw new RuntimeCompilerException(0, "invalid.format.interval", cb.toString());
    }

    public Type getType() {
        return TYPE;
    }

    private static class CharBuf {
        public char[] buf;
        public int offset;
        public int len;
        public int end;
        public int index;

        public CharBuf(char[] buf, int offset, int len) {
            this.buf = buf;
            this.offset = offset;
            this.len = len;
            this.end = offset + len;
            this.index = offset;
        }

        public final boolean done() {
            return this.index == this.end;
        }

        public final void advance() {
            if (this.index != this.end) {
                ++this.index;
            }
        }

        public final void skip(char delim) {
            while (this.index != this.end && this.buf[this.index] == delim) {
                ++this.index;
            }
        }

        public final void skip(char[] delim) {
            while (this.index != this.end && this.in(this.buf[this.index], delim)) {
                ++this.index;
            }
        }

        public final void checkDone(String errKey) {
            if (this.index != this.end) {
                throw new RuntimeCompilerException(0, errKey, this.toString());
            }
        }

        public final void checkNotDone(String errKey) {
            if (this.index == this.end) {
                throw new RuntimeCompilerException(0, errKey, this.toString());
            }
        }

        public final void checkCurrent(char c, String errKey) {
            if (this.index == this.end || this.buf[this.index] != c) {
                throw new RuntimeCompilerException(0, errKey, this.toString());
            }
        }

        public final int readNumber() {
            int start = this.index;
            if (!Character.isDigit(this.buf[start])) {
                System.out.println("not digit: '" + this.buf[start] + "'");
                throw new RuntimeCompilerException(0, "invalid.format.interval", new String(this.buf, this.offset, this.len));
            }
            while (this.index < this.end && Character.isDigit(this.buf[this.index])) {
                ++this.index;
            }
            return this.stringToInt(this.buf, start, this.index - start);
        }

        public final String readString(char[] delim) {
            int strStart = this.index;
            while (this.index < this.end && !this.in(this.buf[this.index], delim)) {
                ++this.index;
            }
            int strEnd = this.index;
            int last = strEnd - 1;
            if (this.buf[last] == 's' && last != strStart) {
                --strEnd;
            }
            return new String(this.buf, strStart, strEnd - strStart);
        }

        public final String toString() {
            return new String(this.buf, this.offset, this.len);
        }

        private boolean in(char c, char[] delim) {
            int len = delim.length;
            for (int i = 0; i < len; ++i) {
                if (delim[i] != c) continue;
                return true;
            }
            return false;
        }

        private int stringToInt(char[] c, int offset, int len) {
            int result = 0;
            int factor = 1;
            if (len == 0) {
                throw new NumberFormatException(new String(c, offset, len));
            }
            for (int i = offset + len - 1; i >= offset; --i) {
                if (c[i] >= '0' && c[i] <= '9') {
                    result += (c[i] - 48) * factor;
                } else {
                    throw new NumberFormatException(new String(c, offset, len));
                }
                factor *= 10;
            }
            return result;
        }
    }
}

