/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.intrusionSmartKey.menu;

import com.tridiumx.accessDriver.enums.activity.BIntrusionStatusEnum;
import com.tridiumx.entsec.intrusion.BIntrusionZone;
import com.tridiumx.entsec.intrusion.IntrusionUtil;
import com.tridiumx.intrusionSmartKey.menu.BIntrusionArmingPage;
import com.tridiumx.intrusionSmartKey.menu.BIntrusionPage;
import com.tridiumx.intrusionSmartKey.menu.BIntrusionPinPage;
import javax.baja.nre.util.Array;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BIntrusionZonePage
extends BIntrusionPage {
    public static final Property cursorLine = BIntrusionZonePage.newProperty((int)0, (int)2, null);
    public static final Type TYPE = Sys.loadType(BIntrusionZonePage.class);
    private boolean arming = false;
    private int option = 0;
    private String[] armOptions = new String[]{BIntrusionArmingPage.NORMAL_ARM, BIntrusionArmingPage.ARMING_TEST, BIntrusionArmingPage.FORCE_ARM, BIntrusionArmingPage.FORCE_ARM_TD};
    private Array links = new Array(BIntrusionPage.class);
    private BIntrusionZone zone;

    @Override
    public int getCursorLine() {
        return this.getInt(cursorLine);
    }

    @Override
    public void setCursorLine(int v) {
        this.setInt(cursorLine, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BIntrusionZonePage() {
    }

    public BIntrusionZonePage(BIntrusionZone zone) {
        this.zone = zone;
    }

    @Override
    public void doExecute() {
        this.links.clear();
        this.data.clear();
        this.data.add((Object)this.zone.getDisplayName(null));
        this.data.add((Object)this.zone.getZoneStatus().getDisplayTag(null));
        this.links.add(null);
        this.links.add(null);
        if (this.zone.getZoneStatus() == BIntrusionStatusEnum.disarmed || this.zone.getZoneStatus() == BIntrusionStatusEnum.unableToArm) {
            this.arming = true;
            String display = this.armOptions[this.option];
            if (display.equals(BIntrusionArmingPage.NORMAL_ARM)) {
                display = display + " " + IntrusionUtil.text((String)"zone");
            }
            this.data.add((Object)display);
            if (this.getDisplay().getArmingPinRequired()) {
                this.links.add((Object)new BIntrusionPinPage(this.zone, (BIntrusionPage)new BIntrusionArmingPage(this.armOptions[this.option])));
            } else {
                this.links.add((Object)new BIntrusionArmingPage(this.zone, this.armOptions[this.option]));
            }
        } else {
            this.arming = false;
            this.data.add((Object)(BIntrusionArmingPage.DISARM + " " + IntrusionUtil.text((String)"zone")));
            this.links.add((Object)new BIntrusionPinPage(this.zone, (BIntrusionPage)new BIntrusionArmingPage(BIntrusionArmingPage.DISARM)));
        }
    }

    @Override
    public void doUp() {
        if (this.option > 0 && this.arming) {
            --this.option;
            this.getDisplay().doUpdateDisplay();
        }
    }

    @Override
    public boolean hasUp() {
        if (!this.arming) {
            return false;
        }
        return this.option > 0;
    }

    @Override
    public boolean hasDown() {
        if (!this.arming) {
            return false;
        }
        return this.option < this.armOptions.length - 1;
    }

    @Override
    public boolean hasBack() {
        return true;
    }

    @Override
    public void doDown() {
        if (this.option < this.armOptions.length - 1 && this.arming) {
            ++this.option;
            this.getDisplay().doUpdateDisplay();
        }
    }

    @Override
    public BIntrusionPage doIn() {
        BIntrusionPage page = (BIntrusionPage)((Object)this.links.get(this.getDataPosition()));
        if (page instanceof BIntrusionArmingPage) {
            ((BIntrusionArmingPage)page).executed = false;
        }
        return page;
    }
}

