/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.intrusionSmartKey.menu;

import com.tridiumx.accessDriver.enums.activity.BIntrusionStatusEnum;
import com.tridiumx.entsec.intrusion.BIntrusionService;
import com.tridiumx.entsec.intrusion.BIntrusionZone;
import com.tridiumx.entsec.intrusion.IntrusionUtil;
import com.tridiumx.intrusionSmartKey.menu.BIntrusionArmingPage;
import com.tridiumx.intrusionSmartKey.menu.BIntrusionListingPage;
import com.tridiumx.intrusionSmartKey.menu.BIntrusionPage;
import com.tridiumx.intrusionSmartKey.menu.BIntrusionPinPage;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BIntrusionSummaryPage
extends BIntrusionPage {
    public static final Action countDown = BIntrusionSummaryPage.newAction((int)0, (BValue)new BIntrusionZone(), null);
    public static final Type TYPE = Sys.loadType(BIntrusionSummaryPage.class);
    public static Lexicon lex = Lexicon.make(BIntrusionService.class);
    private boolean arming = false;
    private int option = 0;
    private BIntrusionZone armingZone;
    private BIntrusionZone[] authenticatedZones;
    private Clock.Ticket countDownTicket;
    private String[] armOptions = new String[]{BIntrusionArmingPage.NORMAL_ARM, BIntrusionArmingPage.ARMING_TEST, BIntrusionArmingPage.FORCE_ARM, BIntrusionArmingPage.FORCE_ARM_TD};
    private String[] disarmOptions = new String[]{BIntrusionArmingPage.DISARM, BIntrusionArmingPage.NORMAL_ARM, BIntrusionArmingPage.FORCE_ARM, BIntrusionArmingPage.FORCE_ARM_TD};
    private Array links;

    public void countDown(BIntrusionZone arg) {
        this.invoke(countDown, (BValue)arg, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void setZones(BIntrusionZone[] authenticatedZones) {
        this.authenticatedZones = authenticatedZones;
    }

    public BIntrusionZone[] getZones() {
        if (this.authenticatedZones == null) {
            return this.getDisplay().getIntrusionZones();
        }
        return this.authenticatedZones;
    }

    @Override
    public void initPosition() {
        this.option = 0;
        this.offset = 0;
        this.setCursorLine(0);
        this.cancelTimer(this.displayTicket);
        this.cancelTimer(this.scrollTicket);
        this.cancelTimer(this.countDownTicket);
        this.armingZone = null;
        this.doExecute2();
        while (this.getDataPosition() + 1 < this.data.size()) {
            this.doDown();
        }
    }

    @Override
    public void doExecute() {
    }

    public void doExecute2() {
        String display;
        int i;
        int armedCount = 0;
        int disarmedCount = 0;
        this.links = new Array(BIntrusionPage.class);
        BIntrusionZone[] zones = this.getZones();
        BEnumRange range = BIntrusionStatusEnum.arming.getRange();
        int[] counts = new int[]{0, 0, 0, 0, 0};
        for (i = 0; i < zones.length; ++i) {
            int n = zones[i].getZoneStatus().getOrdinal();
            counts[n] = counts[n] + 1;
            if (zones[i].getZoneStatus() != BIntrusionStatusEnum.disarmed && zones[i].getZoneStatus() != BIntrusionStatusEnum.unableToArm) {
                ++armedCount;
            } else if (zones[i].getZoneStatus() == BIntrusionStatusEnum.disarmed || zones[i].getZoneStatus() == BIntrusionStatusEnum.unableToArm) {
                ++disarmedCount;
            }
            if (zones[i].getZoneStatus() != BIntrusionStatusEnum.arming && zones[i].getZoneStatus() != BIntrusionStatusEnum.allowingTimeForDisarm || this.armingZone != null) continue;
            this.armingZone = zones[i];
        }
        if (zones.length == 0) {
            this.data.add((Object)lex.getText("noZones"));
            return;
        }
        if (zones.length == 1 && zones[0].getZoneStatus() != BIntrusionStatusEnum.arming && zones[0].getZoneStatus() != BIntrusionStatusEnum.allowingTimeForDisarm) {
            this.data.clear();
            this.links.clear();
            this.data.add((Object)zones[0].getDisplayName(null));
            this.links.add(null);
            this.data.add((Object)zones[0].getZoneStatus().getDisplayTag(null));
            this.links.add(null);
        } else {
            int j;
            StringBuffer b;
            this.data.clear();
            this.links.clear();
            for (i = 0; i < counts.length; ++i) {
                if (counts[i] <= 0 || range.get(i) == BIntrusionStatusEnum.arming || range.get(i) == BIntrusionStatusEnum.allowingTimeForDisarm) continue;
                b = new StringBuffer();
                b.append(range.getDisplayTag(i, null));
                b.append(":");
                for (j = b.length(); j < 14; ++j) {
                    b.append(" ");
                }
                b.append(counts[i]);
                this.data.add((Object)b.toString());
                this.links.add((Object)new BIntrusionListingPage((BIntrusionStatusEnum)range.get(i)));
            }
            for (i = 0; i < counts.length; ++i) {
                if (counts[i] <= 0 || range.get(i) != BIntrusionStatusEnum.arming && range.get(i) != BIntrusionStatusEnum.allowingTimeForDisarm) continue;
                b = new StringBuffer();
                b.append(range.getDisplayTag(i, null));
                b.append(":");
                for (j = b.length(); j < 14; ++j) {
                    b.append(" ");
                }
                b.append(counts[i]);
                this.data.add((Object)b.toString());
                this.links.add((Object)new BIntrusionListingPage((BIntrusionStatusEnum)range.get(i)));
                this.scheduleCountDown();
                this.data.add((Object)("" + this.armingZone.getCountDown().toString((Context)BFacets.make((String)"showMilliseconds", (boolean)false))));
                this.links.add(null);
            }
        }
        if (disarmedCount == zones.length) {
            this.arming = true;
            display = this.armOptions[this.option];
            if (display.equals(BIntrusionArmingPage.NORMAL_ARM)) {
                display = zones.length > 1 ? display + " " + IntrusionUtil.text((String)"system") : display + " " + IntrusionUtil.text((String)"zone");
            }
            this.data.add((Object)display);
            if (this.getDisplay().getArmingPinRequired()) {
                this.links.add((Object)new BIntrusionPinPage(zones, (BIntrusionPage)new BIntrusionArmingPage(zones, this.armOptions[this.option])));
            } else {
                this.links.add((Object)new BIntrusionArmingPage(zones, this.armOptions[this.option]));
            }
        } else if (armedCount > 0) {
            this.arming = true;
            display = this.disarmOptions[this.option];
            if (display.equals(BIntrusionArmingPage.DISARM) || this.getDisplay().getArmingPinRequired()) {
                this.links.add((Object)new BIntrusionPinPage(zones, (BIntrusionPage)new BIntrusionArmingPage(zones, this.disarmOptions[this.option])));
            } else {
                this.links.add((Object)new BIntrusionArmingPage(zones, this.disarmOptions[this.option]));
            }
            if (display.equals(BIntrusionArmingPage.NORMAL_ARM) || display.equals(BIntrusionArmingPage.DISARM)) {
                display = zones.length > 1 ? display + " " + IntrusionUtil.text((String)"system") : display + " " + IntrusionUtil.text((String)"zone");
            }
            this.data.add((Object)display);
        } else {
            this.arming = false;
            this.option = 0;
            display = BIntrusionArmingPage.DISARM;
            display = zones.length > 1 ? display + " " + IntrusionUtil.text((String)"system") : display + " " + IntrusionUtil.text((String)"zone");
            this.data.add((Object)display);
            this.links.add((Object)new BIntrusionPinPage(zones, (BIntrusionPage)new BIntrusionArmingPage(zones, BIntrusionArmingPage.DISARM)));
        }
        while (this.getDataPosition() >= this.data.size()) {
            this.doUp();
        }
    }

    @Override
    public void doUp() {
        if (this.option > 0 && this.arming) {
            --this.option;
            this.doExecute2();
            this.doUpdate();
        } else {
            super.doUp();
        }
    }

    @Override
    public boolean hasUp() {
        if (!this.arming || this.getDataPosition() != this.data.size() - 1) {
            return super.hasUp();
        }
        return true;
    }

    @Override
    public boolean hasDown() {
        if (!this.arming || this.getDataPosition() != this.data.size() - 1) {
            return super.hasDown();
        }
        return this.option < this.armOptions.length - 1;
    }

    @Override
    public void doDown() {
        int pos = this.getDataPosition();
        super.doDown();
        if (this.getDataPosition() == pos && this.option + 1 < this.armOptions.length && this.arming) {
            ++this.option;
            this.doExecute2();
            this.doUpdate();
        }
    }

    @Override
    public BIntrusionPage doIn() {
        if (this.getDataPosition() >= this.links.size()) {
            return null;
        }
        BIntrusionPage page = (BIntrusionPage)((Object)this.links.get(this.getDataPosition()));
        if (page instanceof BIntrusionArmingPage) {
            ((BIntrusionArmingPage)page).executed = false;
        }
        return page;
    }

    public void scheduleCountDown() {
        this.countDownTicket = Clock.schedulePeriodically((BComponent)this, (BAbsTime)BAbsTime.now().add(BRelTime.make((long)500L)), (BRelTime)BRelTime.makeSeconds((int)1), (Action)countDown, (BValue)this.armingZone);
    }

    public void doCountDown(BIntrusionZone zone) {
        if (this.armingZone != null) {
            int countDownLine = 0;
            for (int i = 0; i < this.data.size(); ++i) {
                if (this.data.get(i).toString().indexOf(BIntrusionStatusEnum.arming.getDisplayTag(null) + ":") != 0 && this.data.get(i).toString().indexOf(BIntrusionStatusEnum.allowingTimeForDisarm.getDisplayTag(null) + ":") != 0) continue;
                countDownLine = i + 1;
            }
            if (!zone.getCountDown().equals((Object)BRelTime.DEFAULT)) {
                this.data.set(countDownLine, (Object)("" + zone.getCountDown().toString((Context)BFacets.make((String)"showMilliseconds", (boolean)false))));
            } else {
                this.data.set(countDownLine, (Object)"");
            }
            BRelTime warning = zone.getWarningTime();
            if (this.getDisplay().getStatusBeep() && (zone.getCountDown().compareTo((Object)warning) > 0 && zone.getCountDown().getSeconds() % 5 == 0 || zone.getCountDown().compareTo((Object)warning) < 0)) {
                this.getDisplay().fireBeep(BInteger.make((int)1));
            }
        }
        this.doUpdateDisplay();
    }

    public boolean hasArmingZone() {
        return this.armingZone != null;
    }
}

