/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.intrusionSmartKey.menu;

import com.tridiumx.accessDriver.enums.activity.BIntrusionStatusEnum;
import com.tridiumx.entsec.intrusion.BIntrusionRecord;
import com.tridiumx.entsec.intrusion.BIntrusionZone;
import com.tridiumx.intrusionSmartKey.BIntrusionDisplay;
import com.tridiumx.intrusionSmartKey.enums.BPointDisplayEnum;
import com.tridiumx.intrusionSmartKey.menu.BIntrusionPage;
import com.tridiumx.intrusionSmartKey.menu.BIntrusionPointPage;
import java.util.HashMap;
import javax.baja.alarm.BAlarmService;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

public class BIntrusionStatusPage
extends BIntrusionPage {
    public static final Property cursorLine = BIntrusionStatusPage.newProperty((int)0, (int)2, null);
    public static final Property statusFormat = BIntrusionStatusPage.newProperty((int)0, (BValue)BFormat.make((String)"%intrusionZone%\n%status%\n%details%"), (BFacets)BIntrusionDisplay.facets);
    public static final Action countDown = BIntrusionStatusPage.newAction((int)0, (BValue)new BIntrusionZone(), null);
    public static final Type TYPE = Sys.loadType(BIntrusionStatusPage.class);
    private Clock.Ticket countDownTicket;
    private HashMap records = new HashMap();

    @Override
    public int getCursorLine() {
        return this.getInt(cursorLine);
    }

    @Override
    public void setCursorLine(int v) {
        this.setInt(cursorLine, v, null);
    }

    public BFormat getStatusFormat() {
        return (BFormat)this.get(statusFormat);
    }

    public void setStatusFormat(BFormat v) {
        this.set(statusFormat, (BValue)v, null);
    }

    public void countDown(BIntrusionZone arg) {
        this.invoke(countDown, (BValue)arg, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BIntrusionStatusPage() {
    }

    public BIntrusionStatusPage(BIntrusionRecord record) {
        String name = record.getIntrusionZone();
        this.records.put(name, record);
    }

    public void scheduleCountDown(BIntrusionRecord record) {
        if (record.getStatus() == BIntrusionStatusEnum.arming || record.getStatus() == BIntrusionStatusEnum.allowingTimeForDisarm) {
            String name = record.getIntrusionZone();
            BAlarmService service = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            BIntrusionZone[] zones = (BIntrusionZone[])service.getChildren(BIntrusionZone.class);
            for (int i = 0; i < zones.length; ++i) {
                if (!zones[i].getDisplayName(null).equals(name)) continue;
                this.countDownTicket = Clock.schedulePeriodically((BComponent)this, (BAbsTime)BAbsTime.now().add(BRelTime.make((long)500L)), (BRelTime)BRelTime.makeSeconds((int)1), (Action)countDown, (BValue)zones[i]);
            }
        }
    }

    public void doCountDown(BIntrusionZone zone) {
        if (this.data.size() > 2) {
            int countDownLine = 2;
            if (!zone.getCountDown().equals((Object)BRelTime.DEFAULT)) {
                this.data.set(countDownLine, (Object)("" + zone.getCountDown().toString((Context)BFacets.make((String)"showMilliseconds", (boolean)false))));
            } else {
                this.data.set(countDownLine, (Object)"");
            }
            BRelTime warning = zone.getWarningTime();
            if (this.getDisplay().getStatusBeep() && (zone.getCountDown().compareTo((Object)warning) > 0 && zone.getCountDown().getSeconds() % 5 == 0 || zone.getCountDown().compareTo((Object)warning) < 0)) {
                this.getDisplay().fireBeep(BInteger.make((int)1));
            }
        }
        this.doUpdateDisplay();
    }

    public void addStatus(BIntrusionRecord record) {
        BIntrusionRecord r;
        String name = record.getIntrusionZone();
        if (record.getStatus() == BIntrusionStatusEnum.disarmed && (r = (BIntrusionRecord)this.records.get(name)) != null && r.getStatus() == BIntrusionStatusEnum.unableToArm) {
            return;
        }
        this.records.put(name, record);
    }

    @Override
    public void doExecute() {
        this.data.clear();
        BPointDisplayEnum pointDisplay = this.getDisplay().getPointDisplay();
        Object[] a = this.records.values().toArray();
        for (int i = 0; i < a.length; ++i) {
            BIntrusionRecord record = (BIntrusionRecord)a[i];
            this.scheduleCountDown(record);
            String format = this.getStatusFormat().format((Object)record);
            String[] lines = TextUtil.split((String)format, (char)'\n');
            for (int j = 0; j < lines.length; ++j) {
                if (j % 3 == 2) {
                    lines[j] = BIntrusionStatusPage.getPointToDisplay(lines[j], pointDisplay);
                }
                this.data.add((Object)lines[j]);
            }
        }
    }

    @Override
    public boolean hasUp() {
        return this.getDataPosition() > 2;
    }

    @Override
    public boolean hasDown() {
        return this.getDataPosition() + 1 < this.data.size() - 1;
    }

    @Override
    public void doUp() {
        super.doUp();
        super.doUp();
        super.doUp();
        super.doUp();
        super.doUp();
        super.doDown();
        super.doDown();
    }

    @Override
    public void doDown() {
        super.doDown();
        super.doDown();
        super.doDown();
    }

    @Override
    public boolean hasIn() {
        Object[] a = this.records.values().toArray();
        BIntrusionRecord record = (BIntrusionRecord)a[this.getDataPosition() / 3];
        return record.getDetails().length() > 0;
    }

    @Override
    public BIntrusionPage doIn() {
        if (this.data.get(this.getDataPosition()).toString().length() > 0) {
            return new BIntrusionPointPage(this.data.get(this.getDataPosition()).toString());
        }
        return null;
    }
}

