/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.intrusionSmartKey.menu;

import com.tridiumx.intrusionSmartKey.BIntrusionDisplay;
import com.tridiumx.intrusionSmartKey.enums.BPointDisplayEnum;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.status.BStatusString;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BIntrusionPage
extends BComponent {
    public static final Property cursorLine = BIntrusionPage.newProperty((int)3, (int)0, null);
    public static final Property hasIn = BIntrusionPage.newProperty((int)3, (boolean)false, null);
    public static final Property hasUp = BIntrusionPage.newProperty((int)3, (boolean)false, null);
    public static final Property hasDown = BIntrusionPage.newProperty((int)3, (boolean)false, null);
    public static final Property hasBack = BIntrusionPage.newProperty((int)3, (boolean)false, null);
    public static final Action execute = BIntrusionPage.newAction((int)0, null);
    public static final Action update = BIntrusionPage.newAction((int)0, null);
    public static final Action up = BIntrusionPage.newAction((int)0, null);
    public static final Action down = BIntrusionPage.newAction((int)0, null);
    public static final Action input = BIntrusionPage.newAction((int)0, (BValue)BString.make((String)""), null);
    public static final Action in = BIntrusionPage.newAction((int)0, null);
    public static final Action scrollDisplay = BIntrusionPage.newAction((int)4, null);
    public static final Action updateDisplay = BIntrusionPage.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BIntrusionPage.class);
    protected int offset = 0;
    protected Array data = new Array(String.class);
    protected Clock.Ticket displayTicket;
    protected Clock.Ticket scrollTicket;
    private String scroll;
    private String extra;

    public int getCursorLine() {
        return this.getInt(cursorLine);
    }

    public void setCursorLine(int v) {
        this.setInt(cursorLine, v, null);
    }

    public boolean getHasIn() {
        return this.getBoolean(hasIn);
    }

    public void setHasIn(boolean v) {
        this.setBoolean(hasIn, v, null);
    }

    public boolean getHasUp() {
        return this.getBoolean(hasUp);
    }

    public void setHasUp(boolean v) {
        this.setBoolean(hasUp, v, null);
    }

    public boolean getHasDown() {
        return this.getBoolean(hasDown);
    }

    public void setHasDown(boolean v) {
        this.setBoolean(hasDown, v, null);
    }

    public boolean getHasBack() {
        return this.getBoolean(hasBack);
    }

    public void setHasBack(boolean v) {
        this.setBoolean(hasBack, v, null);
    }

    public void execute() {
        this.invoke(execute, null, null);
    }

    public void update() {
        this.invoke(update, null, null);
    }

    public void up() {
        this.invoke(up, null, null);
    }

    public void down() {
        this.invoke(down, null, null);
    }

    public void input(BString arg) {
        this.invoke(input, (BValue)arg, null);
    }

    public BIntrusionPage in() {
        return (BIntrusionPage)this.invoke(in, null, null);
    }

    public void scrollDisplay() {
        this.invoke(scrollDisplay, null, null);
    }

    public void updateDisplay() {
        this.invoke(updateDisplay, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public abstract void doExecute();

    public abstract BIntrusionPage doIn() throws Exception;

    public boolean hasNav() {
        return true;
    }

    public void doUpdate() {
        this.doExecute();
        this.doUpdateDisplay();
    }

    public void doInput(BString c) throws Exception {
    }

    public BIntrusionDisplay getDisplay() {
        return (BIntrusionDisplay)this.getParent();
    }

    public void doDown() {
        if (this.data.size() == 1) {
            return;
        }
        if (this.data.size() == 2) {
            if (this.getCursorLine() < 1) {
                this.setCursorLine(this.getCursorLine() + 1);
                this.doUpdate();
            }
            return;
        }
        if (this.getCursorLine() < 2) {
            this.setCursorLine(this.getCursorLine() + 1);
        } else if (this.offset < this.data.size() - 3) {
            ++this.offset;
        } else {
            return;
        }
        this.doUpdate();
    }

    public void doUp() {
        if (this.data.size() == 1) {
            return;
        }
        if (this.getCursorLine() > 0) {
            this.setCursorLine(this.getCursorLine() - 1);
        } else if (this.offset > 0) {
            --this.offset;
        } else {
            return;
        }
        this.doUpdate();
    }

    public static String getPointToDisplay(String line, BPointDisplayEnum pointDisplay) {
        if (pointDisplay == BPointDisplayEnum.reversePath && line.indexOf(".") > -1) {
            String[] split = TextUtil.split((String)line, (char)';');
            for (int k = 0; k < split.length; ++k) {
                String point = split[k];
                if (k > 0) {
                    point = point.substring(1);
                }
                Object[] split2 = TextUtil.split((String)point, (char)'.');
                Array ar = new Array(split2);
                ar = ar.reverse();
                split[k] = TextUtil.join((String[])((String[])ar.trim()), (char)'.');
            }
            line = TextUtil.join((String[])split, (char)';');
        } else if (pointDisplay == BPointDisplayEnum.noPath && line.indexOf(".") > -1) {
            String[] split = TextUtil.split((String)line, (char)';');
            for (int k = 0; k < split.length; ++k) {
                String point = split[k];
                if (k > 0) {
                    point = point.substring(1);
                }
                String[] split2 = TextUtil.split((String)point, (char)'.');
                split[k] = split2[split2.length - 1];
            }
            line = TextUtil.join((String[])split, (char)';');
        }
        return line;
    }

    public int getDataPosition() {
        return this.getCursorLine() + this.offset;
    }

    public void doUpdateDisplay() {
        if (this.getDisplay() == null) {
            return;
        }
        this.setCommands();
        this.cancelTimer(this.scrollTicket);
        this.cancelTimer(this.displayTicket);
        String[] lines = (String[])this.data.trim();
        if (!this.hasNav()) {
            this.getDisplay().setLines(lines);
            return;
        }
        boolean needsScrolling = false;
        this.scroll = "";
        String[] values = new String[4];
        int scrollAmount = 0;
        int line = 0;
        for (int i = this.offset; i < lines.length && i < this.offset + 3; ++i) {
            if (this.getCursorLine() == line) {
                values[line] = lines[i];
                if (values[line].length() > this.getDisplay().getColumns()) {
                    int diff;
                    scrollAmount = diff = lines[i].length() - this.getDisplay().getColumns();
                    needsScrolling = true;
                    this.scroll = lines[i].substring(this.getDisplay().getColumns());
                    this.extra = lines[i].substring(0, this.getDisplay().getColumns());
                }
            } else {
                values[line] = lines[i];
            }
            ++line;
        }
        while (line < 3) {
            values[line] = "";
            ++line;
        }
        values[3] = this.getNavLine();
        this.getDisplay().setLines(values);
        if (needsScrolling) {
            BRelTime displayDone = BRelTime.make((long)(this.getDisplay().getScrollStartDelay().getMillis() * 2L + (long)scrollAmount * this.getDisplay().getScrollColumnDelay().getMillis()));
            this.scrollTicket = Clock.schedulePeriodically((BComponent)this, (BAbsTime)BAbsTime.now().add(this.getDisplay().getScrollStartDelay()), (BRelTime)this.getDisplay().getScrollColumnDelay(), (Action)scrollDisplay, null);
            if (displayDone.compareTo((Object)this.getDisplay().getChangeDelay()) < 0) {
                displayDone = this.getDisplay().getChangeDelay();
            }
            this.displayTicket = this.setTimer(displayDone, updateDisplay, null);
        } else {
            this.displayTicket = this.setTimer(this.getDisplay().getChangeDelay(), updateDisplay, null);
        }
    }

    public void setCommands() {
        if (this.hasUp() != this.getHasUp()) {
            this.setHasUp(this.hasUp());
        }
        if (this.hasDown() != this.getHasDown()) {
            this.setHasDown(this.hasDown());
        }
        if (this.hasIn() != this.getHasIn()) {
            this.setHasIn(this.hasIn());
        }
        if (this.hasBack() != this.getHasBack()) {
            this.setHasBack(this.hasBack());
        }
    }

    public void doScrollDisplay() {
        boolean needsScrolling = false;
        String value = "";
        if (this.scroll.length() > 0) {
            this.extra = this.extra.substring(1) + this.scroll.charAt(0);
            value = this.hasIn() || this.hasUp() || this.hasDown() ? this.extra : this.extra;
            if (this.scroll.length() > 0) {
                needsScrolling = true;
                this.scroll = this.scroll.substring(1);
            } else {
                this.scroll = "";
            }
        } else {
            value = this.extra;
        }
        ((BStatusString)this.getDisplay().get("line" + (this.getCursorLine() + 1))).setValue(value);
        if (!needsScrolling) {
            this.cancelTimer(this.scrollTicket);
        }
    }

    protected Clock.Ticket setTimer(BRelTime time, Action action, BValue arg) {
        return Clock.schedule((BComponent)this, (BRelTime)time, (Action)action, (BValue)arg);
    }

    protected void cancelTimer(Clock.Ticket ticket) {
        if (ticket != null) {
            ticket.cancel();
            ticket = null;
        }
    }

    public String getNavLine() {
        StringBuffer b = new StringBuffer();
        char up = '\u0137';
        char down = '\u0138';
        char select = '\u013b';
        char back = '\u013c';
        if (this.hasIn()) {
            b.append(" " + select + "  ");
        } else {
            b.append("     ");
        }
        if (this.hasUp()) {
            b.append(up + "  ");
        } else {
            b.append("    ");
        }
        if (this.hasDown()) {
            b.append(down + "  ");
        } else {
            b.append("    ");
        }
        if (this.hasBack()) {
            b.append(" " + back);
        } else {
            b.append("    ");
        }
        return b.toString();
    }

    public boolean hasUp() {
        return this.getDataPosition() > 0;
    }

    public boolean hasDown() {
        return this.getDataPosition() < this.data.size() - 1;
    }

    public boolean hasIn() {
        return true;
    }

    public boolean hasBack() {
        return true;
    }

    public void initPosition() {
    }
}

