/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.intrusionSmartKey;

import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.LicenseChecker;
import com.tridiumx.entsec.securityUtil.BActivityRecord;
import com.tridiumx.entsec.securityUtil.BIActivityService;
import com.tridiumx.intrusionSmartKey.query.BConsolidatedIntrusionDisplays;
import com.tridiumx.intrusionSmartKey.query.BIntrusionDisplays;
import com.tridiumx.smartKey.BSmartKeyNetwork;
import java.util.logging.Logger;
import javax.baja.license.Feature;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BIntrusionSmartKeyService
extends BAbstractService
implements BIService,
BIActivityService {
    public static final Property intrusionDisplays = BIntrusionSmartKeyService.newProperty((int)8, (BValue)new BIntrusionDisplays(), null);
    public static final Property consolidatedIntrusionDisplays = BIntrusionSmartKeyService.newProperty((int)0, (BValue)new BConsolidatedIntrusionDisplays(), null);
    public static final Topic newActivity = BIntrusionSmartKeyService.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BIntrusionSmartKeyService.class);
    private static Type[] serviceTypes = new Type[]{TYPE};
    public static final BIcon ICON = BIcon.make((String)"module://icons/x16/lcd.png");
    public static final Logger LOG = Logger.getLogger("intrusionSmartKey");
    public static final Lexicon lex = Lexicon.make((String)"intrusionSmartKey");
    private static final String VENDOR = "tridium";
    private static final String SMARTKEY_FEATURE = "smartKey";
    private static final String INTRUSION_FEATURE = "intrusion";

    public BIntrusionDisplays getIntrusionDisplays() {
        return (BIntrusionDisplays)this.get(intrusionDisplays);
    }

    public void setIntrusionDisplays(BIntrusionDisplays v) {
        this.set(intrusionDisplays, (BValue)v, null);
    }

    public BConsolidatedIntrusionDisplays getConsolidatedIntrusionDisplays() {
        return (BConsolidatedIntrusionDisplays)this.get(consolidatedIntrusionDisplays);
    }

    public void setConsolidatedIntrusionDisplays(BConsolidatedIntrusionDisplays v) {
        this.set(consolidatedIntrusionDisplays, (BValue)v, null);
    }

    public void fireNewActivity(BActivityRecord event) {
        this.fire(newActivity, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public void started() throws Exception {
        if (!BEnterpriseSecurityService.isWorkstation()) {
            LicenseChecker licenseChecker = LicenseChecker.getChecker();
            licenseChecker.register(this.getParent(), (Slot)this.getPropertyInParent(), VENDOR, SMARTKEY_FEATURE, true);
            licenseChecker.register(this.getParent(), (Slot)this.getPropertyInParent(), VENDOR, INTRUSION_FEATURE, true);
            try {
                BComponent smartKeyNetwork = Sys.getService((Type)BSmartKeyNetwork.TYPE);
                if (smartKeyNetwork != null) {
                    licenseChecker.register(smartKeyNetwork.getParent(), (Slot)smartKeyNetwork.getPropertyInParent(), VENDOR, SMARTKEY_FEATURE, true);
                    licenseChecker.register(smartKeyNetwork.getParent(), (Slot)smartKeyNetwork.getPropertyInParent(), VENDOR, INTRUSION_FEATURE, true);
                }
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                // empty catch block
            }
        }
        super.started();
    }

    public void stopped() throws Exception {
        if (!BEnterpriseSecurityService.isWorkstation()) {
            LicenseChecker checker = LicenseChecker.getChecker();
            checker.deregister(this.getParent());
            try {
                BComponent smartKeyNetwork = Sys.getService((Type)BSmartKeyNetwork.TYPE);
                if (smartKeyNetwork != null) {
                    checker.deregister(smartKeyNetwork.getParent());
                }
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                // empty catch block
            }
        }
        super.stopped();
    }

    public Feature getLicenseFeature() {
        if (!BEnterpriseSecurityService.isWorkstation()) {
            return Sys.getLicenseManager().getFeature(VENDOR, SMARTKEY_FEATURE);
        }
        return null;
    }

    public BIcon getIcon() {
        return ICON;
    }
}

