/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.intrusionSmartKey;

import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.kitControl.BAlarmCountToRelay;
import com.tridium.kitControl.enums.BAlarmCountEnum;
import com.tridium.kitControl.logic.BAnd;
import com.tridiumx.accessDriver.BActivityAlertExt;
import com.tridiumx.accessDriver.enums.activity.BActivity;
import com.tridiumx.accessDriver.enums.activity.BBadgeActivity;
import com.tridiumx.accessDriver.enums.activity.BIntrusionStatusEnum;
import com.tridiumx.entsec.intrusion.BIntrusionRecord;
import com.tridiumx.entsec.intrusion.BIntrusionZone;
import com.tridiumx.entsec.intrusion.BPinActivity;
import com.tridiumx.entsec.intrusion.IntrusionUtil;
import com.tridiumx.intrusionSmartKey.BOrPoint;
import com.tridiumx.intrusionSmartKey.enums.BDefaultPageEnum;
import com.tridiumx.intrusionSmartKey.enums.BPointDisplayEnum;
import com.tridiumx.intrusionSmartKey.menu.BIntrusionArmingPage;
import com.tridiumx.intrusionSmartKey.menu.BIntrusionPage;
import com.tridiumx.intrusionSmartKey.menu.BIntrusionPinPage;
import com.tridiumx.intrusionSmartKey.menu.BIntrusionPointPage;
import com.tridiumx.intrusionSmartKey.menu.BIntrusionStatusPage;
import com.tridiumx.intrusionSmartKey.menu.BIntrusionSummaryPage;
import com.tridiumx.intrusionSmartKey.menu.BIntrusionTimePage;
import com.tridiumx.smartKey.BSmartKeyDevice;
import com.tridiumx.smartKey.BSmartKeyNetwork;
import com.tridiumx.smartKey.BSmartKeyPointDeviceExt;
import com.tridiumx.smartKey.discover.BSmartKeyPointDiscoveryLeaf;
import com.tridiumx.smartKey.discover.BSmartKeyPreDiscoveredPoints;
import com.tridiumx.smartKey.point.BSmartKeyBeeperPoint;
import com.tridiumx.smartKey.point.BSmartKeyProxyExt;
import java.util.Stack;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BStringPoint;
import javax.baja.control.BStringWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusString;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

public class BIntrusionDisplay
extends BComponent {
    public static final BFacets facets = BFacets.make((String[])new String[]{"rows", "fieldWidth", "multiLine"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)4), BInteger.make((int)16), BBoolean.TRUE});
    public static final Property defaultMessage = BIntrusionDisplay.newProperty((int)8, (String)"Intrusion Keypad", null);
    public static final Property smartKeyDevice = BIntrusionDisplay.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"intrusionSmartKey:SmartKeyFE")));
    public static final Property scrollStartDelay = BIntrusionDisplay.newProperty((int)0, (BValue)BRelTime.make((long)1250L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (boolean)true), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.DEFAULT)));
    public static final Property scrollColumnDelay = BIntrusionDisplay.newProperty((int)0, (BValue)BRelTime.make((long)150L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (boolean)true), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.DEFAULT)));
    public static final Property changeDelay = BIntrusionDisplay.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)3), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (boolean)true), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.DEFAULT)));
    public static final Property inactivityTime = BIntrusionDisplay.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)60), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.DEFAULT));
    public static final Property statusBeep = BIntrusionDisplay.newProperty((int)0, (boolean)true, null);
    public static final Property armingPinRequired = BIntrusionDisplay.newProperty((int)0, (boolean)false, null);
    public static final Property statusPinRequired = BIntrusionDisplay.newProperty((int)0, (boolean)false, null);
    public static final Property pointDisplay = BIntrusionDisplay.newProperty((int)0, (BValue)BPointDisplayEnum.normalPath, null);
    public static final Property backlight = BIntrusionDisplay.newProperty((int)6, (BValue)new BStatusBoolean(false), null);
    public static final Property dataEntered = BIntrusionDisplay.newProperty((int)6, (BValue)new BStatusString(), null);
    public static final Property currentPage = BIntrusionDisplay.newProperty((int)6, (BValue)new BIntrusionSummaryPage(), null);
    public static final Property line1 = BIntrusionDisplay.newProperty((int)0x10000006, (BValue)new BStatusString(), null);
    public static final Property line2 = BIntrusionDisplay.newProperty((int)0x10000006, (BValue)new BStatusString(), null);
    public static final Property line3 = BIntrusionDisplay.newProperty((int)0x10000006, (BValue)new BStatusString(), null);
    public static final Property line4 = BIntrusionDisplay.newProperty((int)0x10000006, (BValue)new BStatusString(), null);
    public static final Property invertLine1 = BIntrusionDisplay.newProperty((int)0x10000006, (BValue)new BStatusBoolean(false), null);
    public static final Property invertLine2 = BIntrusionDisplay.newProperty((int)0x10000006, (BValue)new BStatusBoolean(false), null);
    public static final Property invertLine3 = BIntrusionDisplay.newProperty((int)0x10000006, (BValue)new BStatusBoolean(false), null);
    public static final Property invertLine4 = BIntrusionDisplay.newProperty((int)0x10000006, (BValue)new BStatusBoolean(false), null);
    public static final Property rows = BIntrusionDisplay.newProperty((int)5, (int)4, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    public static final Property columns = BIntrusionDisplay.newProperty((int)5, (int)16, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    public static final Property authorization = BIntrusionDisplay.newProperty((int)7, (String)"", null);
    public static final Property invalidPinNumberAlert = BIntrusionDisplay.newProperty((int)0, (BValue)new BActivityAlertExt((BActivity)BPinActivity.invalidPinNumber, false), null);
    public static final Property noActiveScheduleAlert = BIntrusionDisplay.newProperty((int)0, (BValue)new BActivityAlertExt((BActivity)BPinActivity.noActiveSchedule, false), null);
    public static final Property defaultPage = BIntrusionDisplay.newProperty((int)0, (BValue)BDefaultPageEnum.time, null);
    public static final Property inAlarmBeep = BIntrusionDisplay.newProperty((int)0, (boolean)false, null);
    public static final Property inAlarmMaxBeep = BIntrusionDisplay.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)30), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.DEFAULT));
    public static final Property inAlarmPoint = BIntrusionDisplay.newProperty((int)4, (BValue)new BOrPoint(), null);
    public static final Action updateRecord = BIntrusionDisplay.newAction((int)0, (BValue)new BIntrusionRecord(), null);
    public static final Action updateDisplay = BIntrusionDisplay.newAction((int)4, null);
    public static final Action activity = BIntrusionDisplay.newAction((int)4, null);
    public static final Action inactivity = BIntrusionDisplay.newAction((int)4, null);
    public static final Action keyPressed = BIntrusionDisplay.newAction((int)2052, (BValue)BString.make((String)""), null);
    public static final Action buzzerCheck = BIntrusionDisplay.newAction((int)4, null);
    public static final Topic beep = BIntrusionDisplay.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BIntrusionDisplay.class);
    public static final BIcon ICON = BIcon.make((BIcon)BIcon.std((String)"lcd.png"), (BIcon)BIcon.make((String)"module://entsec/rc/securityUtil/card.png"));
    private BSmartKeyDevice oldSmartKeyDevice = null;
    private Clock.Ticket inactivityTicket;
    private Stack lastPage = new Stack();
    private BIntrusionPinPage lastPinPage;
    private boolean buzzing = false;

    public String getDefaultMessage() {
        return this.getString(defaultMessage);
    }

    public void setDefaultMessage(String v) {
        this.setString(defaultMessage, v, null);
    }

    public String getSmartKeyDevice() {
        return this.getString(smartKeyDevice);
    }

    public void setSmartKeyDevice(String v) {
        this.setString(smartKeyDevice, v, null);
    }

    public BRelTime getScrollStartDelay() {
        return (BRelTime)this.get(scrollStartDelay);
    }

    public void setScrollStartDelay(BRelTime v) {
        this.set(scrollStartDelay, (BValue)v, null);
    }

    public BRelTime getScrollColumnDelay() {
        return (BRelTime)this.get(scrollColumnDelay);
    }

    public void setScrollColumnDelay(BRelTime v) {
        this.set(scrollColumnDelay, (BValue)v, null);
    }

    public BRelTime getChangeDelay() {
        return (BRelTime)this.get(changeDelay);
    }

    public void setChangeDelay(BRelTime v) {
        this.set(changeDelay, (BValue)v, null);
    }

    public BRelTime getInactivityTime() {
        return (BRelTime)this.get(inactivityTime);
    }

    public void setInactivityTime(BRelTime v) {
        this.set(inactivityTime, (BValue)v, null);
    }

    public boolean getStatusBeep() {
        return this.getBoolean(statusBeep);
    }

    public void setStatusBeep(boolean v) {
        this.setBoolean(statusBeep, v, null);
    }

    public boolean getArmingPinRequired() {
        return this.getBoolean(armingPinRequired);
    }

    public void setArmingPinRequired(boolean v) {
        this.setBoolean(armingPinRequired, v, null);
    }

    public boolean getStatusPinRequired() {
        return this.getBoolean(statusPinRequired);
    }

    public void setStatusPinRequired(boolean v) {
        this.setBoolean(statusPinRequired, v, null);
    }

    public BPointDisplayEnum getPointDisplay() {
        return (BPointDisplayEnum)this.get(pointDisplay);
    }

    public void setPointDisplay(BPointDisplayEnum v) {
        this.set(pointDisplay, (BValue)v, null);
    }

    public BStatusBoolean getBacklight() {
        return (BStatusBoolean)this.get(backlight);
    }

    public void setBacklight(BStatusBoolean v) {
        this.set(backlight, (BValue)v, null);
    }

    public BStatusString getDataEntered() {
        return (BStatusString)this.get(dataEntered);
    }

    public void setDataEntered(BStatusString v) {
        this.set(dataEntered, (BValue)v, null);
    }

    public BIntrusionPage getCurrentPage() {
        return (BIntrusionPage)this.get(currentPage);
    }

    public void setCurrentPage(BIntrusionPage v) {
        this.set(currentPage, (BValue)v, null);
    }

    public BStatusString getLine1() {
        return (BStatusString)this.get(line1);
    }

    public void setLine1(BStatusString v) {
        this.set(line1, (BValue)v, null);
    }

    public BStatusString getLine2() {
        return (BStatusString)this.get(line2);
    }

    public void setLine2(BStatusString v) {
        this.set(line2, (BValue)v, null);
    }

    public BStatusString getLine3() {
        return (BStatusString)this.get(line3);
    }

    public void setLine3(BStatusString v) {
        this.set(line3, (BValue)v, null);
    }

    public BStatusString getLine4() {
        return (BStatusString)this.get(line4);
    }

    public void setLine4(BStatusString v) {
        this.set(line4, (BValue)v, null);
    }

    public BStatusBoolean getInvertLine1() {
        return (BStatusBoolean)this.get(invertLine1);
    }

    public void setInvertLine1(BStatusBoolean v) {
        this.set(invertLine1, (BValue)v, null);
    }

    public BStatusBoolean getInvertLine2() {
        return (BStatusBoolean)this.get(invertLine2);
    }

    public void setInvertLine2(BStatusBoolean v) {
        this.set(invertLine2, (BValue)v, null);
    }

    public BStatusBoolean getInvertLine3() {
        return (BStatusBoolean)this.get(invertLine3);
    }

    public void setInvertLine3(BStatusBoolean v) {
        this.set(invertLine3, (BValue)v, null);
    }

    public BStatusBoolean getInvertLine4() {
        return (BStatusBoolean)this.get(invertLine4);
    }

    public void setInvertLine4(BStatusBoolean v) {
        this.set(invertLine4, (BValue)v, null);
    }

    public int getRows() {
        return this.getInt(rows);
    }

    public void setRows(int v) {
        this.setInt(rows, v, null);
    }

    public int getColumns() {
        return this.getInt(columns);
    }

    public void setColumns(int v) {
        this.setInt(columns, v, null);
    }

    public String getAuthorization() {
        return this.getString(authorization);
    }

    public void setAuthorization(String v) {
        this.setString(authorization, v, null);
    }

    public BActivityAlertExt getInvalidPinNumberAlert() {
        return (BActivityAlertExt)this.get(invalidPinNumberAlert);
    }

    public void setInvalidPinNumberAlert(BActivityAlertExt v) {
        this.set(invalidPinNumberAlert, (BValue)v, null);
    }

    public BActivityAlertExt getNoActiveScheduleAlert() {
        return (BActivityAlertExt)this.get(noActiveScheduleAlert);
    }

    public void setNoActiveScheduleAlert(BActivityAlertExt v) {
        this.set(noActiveScheduleAlert, (BValue)v, null);
    }

    public BDefaultPageEnum getDefaultPage() {
        return (BDefaultPageEnum)this.get(defaultPage);
    }

    public void setDefaultPage(BDefaultPageEnum v) {
        this.set(defaultPage, (BValue)v, null);
    }

    public boolean getInAlarmBeep() {
        return this.getBoolean(inAlarmBeep);
    }

    public void setInAlarmBeep(boolean v) {
        this.setBoolean(inAlarmBeep, v, null);
    }

    public BRelTime getInAlarmMaxBeep() {
        return (BRelTime)this.get(inAlarmMaxBeep);
    }

    public void setInAlarmMaxBeep(BRelTime v) {
        this.set(inAlarmMaxBeep, (BValue)v, null);
    }

    public BOrPoint getInAlarmPoint() {
        return (BOrPoint)this.get(inAlarmPoint);
    }

    public void setInAlarmPoint(BOrPoint v) {
        this.set(inAlarmPoint, (BValue)v, null);
    }

    public void updateRecord(BIntrusionRecord event) {
        this.invoke(updateRecord, (BValue)event, null);
    }

    public void updateDisplay() {
        this.invoke(updateDisplay, null, null);
    }

    public void activity() {
        this.invoke(activity, null, null);
    }

    public void inactivity() {
        this.invoke(inactivity, null, null);
    }

    public void keyPressed(BString event) {
        this.invoke(keyPressed, (BValue)event, null);
    }

    public void buzzerCheck() {
        this.invoke(buzzerCheck, null, null);
    }

    public void fireBeep(BInteger event) {
        this.fire(beep, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.setDefaultPage();
        if (this.getInAlarmBeep()) {
            this.createBeepingOutputs();
        } else {
            this.removeBeepingOutputs();
        }
        BActivityAlertExt[] b = (BActivityAlertExt[])this.getChildren(BActivityAlertExt.class);
        for (int i = 0; i < b.length; ++i) {
            b[i].getAlarmInfo().setSourceName(BFormat.make((String)"%parent.parent.parent.displayName%.%parent.parent.displayName%"));
        }
        this.checkSmartKeyLinks();
    }

    public void setDefaultPage() {
        this.lastPage = new Stack();
        this.lastPinPage = null;
        if (this.getDefaultPage() == BDefaultPageEnum.summary) {
            this.setCurrentPage(new BIntrusionSummaryPage());
        } else if (this.getDefaultPage() == BDefaultPageEnum.time) {
            this.setCurrentPage(new BIntrusionTimePage());
        }
        this.getCurrentPage().initPosition();
        this.doUpdateDisplay();
    }

    public void doUpdateDisplay() {
        this.getCurrentPage().invoke(BIntrusionPage.update, null);
    }

    public void updateCursor() {
        int cursorLine = this.getCurrentPage().getCursorLine();
        BStatusBoolean[] inverts = new BStatusBoolean[]{this.getInvertLine1(), this.getInvertLine2(), this.getInvertLine3(), this.getInvertLine4()};
        for (int i = 0; i < inverts.length; ++i) {
            if (cursorLine == i) {
                inverts[i].setValue(true);
                continue;
            }
            inverts[i].setValue(false);
        }
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        this.doUpdateDisplay();
        this.doActivity();
    }

    public void added(Property prop, Context cx) {
        BLink link;
        super.added(prop, cx);
        if (!this.isRunning()) {
            return;
        }
        if (prop.getType().is(BLink.TYPE) && (link = (BLink)this.get(prop)).getTargetSlot().equals((Object)updateRecord) && this.getInAlarmBeep()) {
            this.removeBeepingOutputs();
            this.createBeepingOutputs();
        }
    }

    public void removed(Property prop, BValue value, Context cx) {
        BLink link;
        super.removed(prop, value, cx);
        if (!this.isRunning()) {
            return;
        }
        if (prop.getType().is(BLink.TYPE) && (link = (BLink)value).getTargetSlotName().equals("updateRecord") && this.getInAlarmBeep()) {
            this.removeBeepingOutputs();
            if (this.getLinks((Slot)updateRecord).length > 0) {
                this.createBeepingOutputs();
            }
        }
    }

    public void changed(Property prop, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(smartKeyDevice)) {
            this.checkSmartKeyLinks();
        } else if (prop.equals(defaultPage)) {
            this.setDefaultPage();
        } else if (prop.equals(defaultMessage)) {
            this.doUpdateDisplay();
            this.doActivity();
        } else if (prop.equals(dataEntered)) {
            this.doActivity();
            String value = this.getDataEntered().getValue();
            this.doKeyPressed(BString.make((String)value));
        } else if (prop.equals(currentPage)) {
            BIntrusionSummaryPage summary;
            if (this.getCurrentPage() instanceof BIntrusionPinPage) {
                this.lastPinPage = (BIntrusionPinPage)this.getCurrentPage();
            } else if (this.getCurrentPage() instanceof BIntrusionSummaryPage && (summary = (BIntrusionSummaryPage)this.getCurrentPage()).hasArmingZone()) {
                summary.scheduleCountDown();
            }
        } else if (prop.equals(inAlarmBeep)) {
            if (this.getInAlarmBeep()) {
                this.createBeepingOutputs();
            } else {
                this.removeBeepingOutputs();
            }
        } else if (prop.equals(inAlarmMaxBeep)) {
            BAlarmCountToRelay[] alarmCountToRelays = (BAlarmCountToRelay[])this.getChildren(BAlarmCountToRelay.class);
            for (int i = 0; i < alarmCountToRelays.length; ++i) {
                alarmCountToRelays[i].setTimer(this.getInAlarmMaxBeep());
            }
        } else {
            super.changed(prop, cx);
        }
    }

    public void checkSmartKeyLinks() {
        String newName = this.getSmartKeyDevice();
        BSmartKeyNetwork network = (BSmartKeyNetwork)Sys.getService((Type)BSmartKeyNetwork.TYPE);
        BSmartKeyDevice device = null;
        BDevice[] devices = network.getDevices();
        for (int i = 0; i < devices.length; ++i) {
            if (!devices[i].getName().equals(newName)) continue;
            device = (BSmartKeyDevice)devices[i];
        }
        if (this.oldSmartKeyDevice != null && this.oldSmartKeyDevice.getName() != null && !this.oldSmartKeyDevice.getName().equals(newName)) {
            this.removeLinks(this.oldSmartKeyDevice);
        }
        if (device != null) {
            this.addLinks(device);
        }
        this.oldSmartKeyDevice = device;
    }

    public void doBuzzerCheck() {
        if (this.getInAlarmPoint().getOut().getStatus().isValid() && this.getInAlarmPoint().getOut().getValue()) {
            this.fireBeep(BInteger.make((int)255));
            this.buzzing = true;
        } else {
            if (this.buzzing) {
                this.fireBeep(BInteger.make((int)1));
            }
            this.buzzing = false;
        }
    }

    public void removeBeepingOutputs() {
        BAlarmCountToRelay[] alarmCountToRelays = (BAlarmCountToRelay[])this.getChildren(BAlarmCountToRelay.class);
        for (int i = 0; i < alarmCountToRelays.length; ++i) {
            this.remove(alarmCountToRelays[i].getPropertyInParent());
        }
        BAnd[] ands = (BAnd[])this.getChildren(BAnd.class);
        for (int i = 0; i < ands.length; ++i) {
            this.remove(ands[i].getPropertyInParent());
        }
        this.getInAlarmPoint().removeChildrenSafely();
    }

    public void createBeepingOutputs() {
        this.removeBeepingOutputs();
        BIntrusionZone[] intrusionZones = this.getIntrusionZones();
        for (int i = 0; i < intrusionZones.length; ++i) {
            BAlarmCountToRelay alarmCountToRelay = new BAlarmCountToRelay();
            alarmCountToRelay.setAlarmCountType(BAlarmCountEnum.unackedAlarmCount);
            alarmCountToRelay.setTimer(this.getInAlarmMaxBeep());
            this.add(null, (BValue)alarmCountToRelay, 4);
            BLink bLink = alarmCountToRelay.makeLink((BComponent)intrusionZones[i], (Slot)BIntrusionZone.unackedAlarmCount, (Slot)BAlarmCountToRelay.alarmCount, null);
            alarmCountToRelay.add(null, (BValue)bLink);
            BLink fLink = alarmCountToRelay.makeLink((BComponent)intrusionZones[i], (Slot)BIntrusionZone.zoneDisarmed, (Slot)BAlarmCountToRelay.relayOutStop, null);
            alarmCountToRelay.add(null, (BValue)fLink);
            BAnd and = new BAnd();
            BStatusBoolean andLink = new BStatusBoolean(false);
            this.add(null, (BValue)and, 4);
            BLink cLink = and.makeLink((BComponent)intrusionZones[i], (Slot)BIntrusionZone.zoneEnabled, (Slot)BAnd.inA, null);
            BLink dLink = and.makeLink((BComponent)alarmCountToRelay, (Slot)BAlarmCountToRelay.relayOut, (Slot)BAnd.inB, null);
            and.add(null, (BValue)dLink);
            and.add(null, (BValue)cLink);
            Property p = this.getInAlarmPoint().add("in?", (BValue)new BStatusBoolean(false));
            BLink eLink = this.getInAlarmPoint().makeLink((BComponent)and, (Slot)BAnd.out, (Slot)p, null);
            this.getInAlarmPoint().add(null, (BValue)eLink);
        }
        LinkCheck check = this.checkLink((BComponent)this.getInAlarmPoint(), (Slot)BOrPoint.out, (Slot)buzzerCheck, null);
        if (check.isValid()) {
            BLink bLink = this.makeLink((BComponent)this.getInAlarmPoint(), (Slot)BOrPoint.out, (Slot)buzzerCheck, null);
            this.add(null, (BValue)bLink);
        }
    }

    public void doKeyPressed(BString v) {
        String value = v.toString();
        if (this.getCurrentPage() instanceof BIntrusionTimePage && (value.equals("<F1>") || value.equals("<F2>") || value.equals("<F3>"))) {
            BIntrusionPage next = (BIntrusionPage)this.getCurrentPage().invoke(BIntrusionPage.in, null);
            if (next != null) {
                this.setCurrentPage(next);
                this.getCurrentPage().initPosition();
                this.doUpdateDisplay();
            }
        } else if (value.equals("<F1>") && !(this.getCurrentPage() instanceof BIntrusionPinPage)) {
            BIntrusionPage next = (BIntrusionPage)this.getCurrentPage().invoke(BIntrusionPage.in, null);
            if (next != null) {
                this.lastPage.push(this.getCurrentPage());
                this.setCurrentPage(next);
                this.getCurrentPage().initPosition();
                this.doUpdateDisplay();
            }
        } else if (value.equals("<F2>")) {
            this.getCurrentPage().invoke(BIntrusionPage.up, null);
        } else if (value.equals("<F3>")) {
            this.getCurrentPage().invoke(BIntrusionPage.down, null);
        } else if (value.equals("<F4>")) {
            this.goBack();
        } else {
            this.getCurrentPage().input(BString.make((String)value));
        }
    }

    public void goBack() {
        if (!this.lastPage.empty()) {
            this.setCurrentPage((BIntrusionPage)((Object)this.lastPage.pop()));
            this.doUpdateDisplay();
        } else {
            this.setDefaultPage();
        }
    }

    public void fireBeepOnStatus(BIntrusionStatusEnum status) {
        if (!this.getStatusBeep()) {
            return;
        }
        int beeps = 1;
        if (status == BIntrusionStatusEnum.unableToArm || status == BIntrusionStatusEnum.allowingTimeForDisarm) {
            beeps = 4;
        } else if (status == BIntrusionStatusEnum.armed) {
            beeps = 1;
        } else if (status == BIntrusionStatusEnum.disarmed) {
            beeps = 2;
        } else if (status == BIntrusionStatusEnum.arming) {
            beeps = 1;
        }
        this.fireBeep(BInteger.make((int)beeps));
    }

    public void doUpdateRecord(BIntrusionRecord record) {
        this.fireBeepOnStatus(record.getStatus());
        if (this.getCurrentPage() instanceof BIntrusionSummaryPage && record.getStatus() != BIntrusionStatusEnum.unableToArm) {
            this.getCurrentPage().initPosition();
            this.doUpdateDisplay();
            this.updateCursor();
        } else if (record.getStatus() != BIntrusionStatusEnum.unableToArm) {
            if (this.getCurrentPage() instanceof BIntrusionStatusPage && record.getStatus() == BIntrusionStatusEnum.disarmed) {
                return;
            }
            if (this.getDefaultPage() == BDefaultPageEnum.time) {
                this.lastPage = new Stack();
                this.lastPage.push(new BIntrusionTimePage());
            }
            BIntrusionSummaryPage newSummary = new BIntrusionSummaryPage();
            if (this.getStatusPinRequired() && this.lastPinPage != null && this.lastPinPage.getLastZones() != null) {
                newSummary.setZones(this.lastPinPage.getLastZones());
            }
            this.setCurrentPage(newSummary);
            this.getCurrentPage().initPosition();
            this.doUpdateDisplay();
        } else if (this.getCurrentPage() instanceof BIntrusionStatusPage) {
            ((BIntrusionStatusPage)this.getCurrentPage()).addStatus(record);
            this.doUpdateDisplay();
        } else if (this.getCurrentPage() instanceof BIntrusionPointPage && !this.lastPage.isEmpty() && this.lastPage.peek() instanceof BIntrusionStatusPage) {
            ((BIntrusionStatusPage)((Object)this.lastPage.peek())).addStatus(record);
        } else {
            if (!(this.getCurrentPage() instanceof BIntrusionArmingPage)) {
                this.lastPage.push(this.getCurrentPage());
            }
            this.setCurrentPage(new BIntrusionStatusPage(record));
            this.doUpdateDisplay();
        }
        this.doActivity();
    }

    public void setLines(String[] lines) {
        this.updateCursor();
        BStatusString[] sLines = new BStatusString[]{this.getLine1(), this.getLine2(), this.getLine3(), this.getLine4()};
        for (int i = 0; i < lines.length && i < sLines.length; ++i) {
            sLines[i].setValue(lines[i]);
        }
    }

    public String getLines() {
        BStatusString[] sLines = new BStatusString[]{this.getLine1(), this.getLine2(), this.getLine3(), this.getLine4()};
        String[] lines = new String[sLines.length];
        for (int i = 0; i < sLines.length; ++i) {
            lines[i] = sLines[i].getValue();
        }
        return TextUtil.join((String[])lines, (char)'\n');
    }

    public BIntrusionZone[] getIntrusionZones() {
        BLink[] links = this.getLinks((Slot)updateRecord);
        Array a = new Array(BIntrusionZone.class);
        for (int i = 0; i < links.length; ++i) {
            BComponent c;
            if (!links[i].getEnabled() || !((c = links[i].getSourceComponent()) instanceof BIntrusionZone)) continue;
            a.add((Object)c);
        }
        return (BIntrusionZone[])a.trim();
    }

    public void addPoints(BSmartKeyDevice smartKeyDevice) {
        BSmartKeyPointDeviceExt pointsExt = smartKeyDevice.getPoints();
        BSmartKeyPreDiscoveredPoints points = new BSmartKeyPreDiscoveredPoints();
        BSmartKeyPointDiscoveryLeaf[] leafs = (BSmartKeyPointDiscoveryLeaf[])points.getChildren(BSmartKeyPointDiscoveryLeaf.class);
        for (int i = 0; i < leafs.length; ++i) {
            String description = leafs[i].getDescription();
            if (description.equals("Number Entered")) continue;
            BValue child = pointsExt.get(SlotPath.escape((String)description));
            if (child == null) {
                TypeInfo info = leafs[i].getValidDatabaseTypes()[0];
                BControlPoint point = (BControlPoint)info.getInstance();
                BSmartKeyProxyExt ext = new BSmartKeyProxyExt();
                ext.setPointId((BDdfIdParams)leafs[i].getPointId().newCopy());
                ext.setTuningPolicyName(leafs[i].getDiscoveryTuningPolicyName());
                ext.setReadParameters((BDdfIdParams)leafs[i].getReadParameters().newCopy());
                ext.setWriteParameters((BDdfIdParams)leafs[i].getWriteParameters().newCopy());
                point.setProxyExt((BAbstractProxyExt)ext);
                pointsExt.add(SlotPath.escape((String)description), (BValue)point);
                continue;
            }
            BSmartKeyProxyExt bSmartKeyProxyExt = (BSmartKeyProxyExt)((BControlPoint)child).getProxyExt();
        }
    }

    public void addLinks(BSmartKeyDevice smartKeyDevice) {
        BSmartKeyBeeperPoint beeper;
        BLink link;
        LinkCheck check;
        this.addPoints(smartKeyDevice);
        BSmartKeyPointDeviceExt points = smartKeyDevice.getPoints();
        BStringWritable[] wLines = (BStringWritable[])points.getChildren(BStringWritable.class);
        BStatusString[] sLines = new BStatusString[]{this.getLine1(), this.getLine2(), this.getLine3(), this.getLine4()};
        for (int i = 0; i < wLines.length && i < sLines.length; ++i) {
            check = wLines[i].checkLink((BComponent)this, (Slot)sLines[i].getPropertyInParent(), (Slot)BStringWritable.in15, null);
            if (!check.isValid()) continue;
            link = wLines[i].makeLink((BComponent)this, (Slot)sLines[i].getPropertyInParent(), (Slot)BStringWritable.in15, null);
            wLines[i].add(null, (BValue)link);
        }
        BStringPoint data = (BStringPoint)points.get(SlotPath.escape((String)"Key Pressed"));
        check = this.checkLink((BComponent)data, (Slot)BStringPoint.out, (Slot)dataEntered, null);
        if (check.isValid()) {
            link = this.makeLink((BComponent)data, (Slot)BStringPoint.out, (Slot)dataEntered, null);
            this.add(null, (BValue)link);
        }
        if ((check = (beeper = (BSmartKeyBeeperPoint)points.get(SlotPath.escape((String)"Buzzer"))).checkLink((BComponent)this, (Slot)beep, (Slot)BSmartKeyBeeperPoint.beepX, null)).isValid()) {
            BLink link2 = beeper.makeLink((BComponent)this, (Slot)beep, (Slot)BSmartKeyBeeperPoint.beepX, null);
            beeper.add(null, (BValue)link2);
        }
        BBooleanWritable[] wLights = (BBooleanWritable[])smartKeyDevice.getPoints().getChildren(BBooleanWritable.class);
        int invertCount = 0;
        Property[] props = new Property[]{invertLine1, invertLine2, invertLine3, invertLine4};
        for (int i = 0; i < wLights.length; ++i) {
            BLink link3;
            if (wLights[i].getName().indexOf("Invert") == -1) {
                check = wLights[i].checkLink((BComponent)this, (Slot)backlight, (Slot)BBooleanWritable.in15, null);
                if (!check.isValid()) continue;
                link3 = wLights[i].makeLink((BComponent)this, (Slot)backlight, (Slot)BBooleanWritable.in15, null);
                wLights[i].add(null, (BValue)link3);
                continue;
            }
            check = wLights[i].checkLink((BComponent)this, (Slot)props[invertCount], (Slot)BBooleanWritable.in15, null);
            if (check.isValid()) {
                link3 = wLights[i].makeLink((BComponent)this, (Slot)props[invertCount], (Slot)BBooleanWritable.in15, null);
                wLights[i].add(null, (BValue)link3);
            }
            ++invertCount;
        }
    }

    public void removeLinks(BSmartKeyDevice smartKeyDevice) {
        BControlPoint[] controlPoints = (BControlPoint[])smartKeyDevice.getPoints().getChildren(BControlPoint.class);
        for (int i = 0; i < controlPoints.length; ++i) {
            BLink[] links = controlPoints[i].getLinks();
            for (int j = 0; j < links.length; ++j) {
                if (links[j].getSourceComponent() != this) continue;
                controlPoints[i].remove(links[j].getPropertyInParent());
            }
        }
        BLink[] links = this.getLinks();
        for (int j = 0; j < links.length; ++j) {
            if (links[j].getSourceComponent().getParent() != smartKeyDevice.getPoints()) continue;
            this.remove(links[j].getPropertyInParent());
        }
    }

    public void doActivity() {
        this.getBacklight().setValue(true);
        this.cancelTimer(this.inactivityTicket);
        this.inactivityTicket = this.setTimer(this.getInactivityTime(), inactivity, null);
    }

    public void doInactivity() {
        this.setAuthorization("");
        this.getBacklight().setValue(false);
        this.setDefaultPage();
    }

    protected Clock.Ticket setTimer(BRelTime time, Action action, BValue arg) {
        return Clock.schedule((BComponent)this, (BRelTime)time, (Action)action, (BValue)arg);
    }

    protected void cancelTimer(Clock.Ticket ticket) {
        if (ticket != null) {
            ticket.cancel();
            ticket = null;
        }
    }

    public boolean makeAlarm(BActivity activity, String pinInfo) {
        try {
            BActivityAlertExt[] alerts = (BActivityAlertExt[])this.getChildren(BActivityAlertExt.class);
            for (int i = 0; i < alerts.length; ++i) {
                if (!alerts[i].getActivityType().equals((Object)activity)) continue;
                return alerts[i].generateAlert(pinInfo, "", IntrusionUtil.text((String)"intrusionPin"), null);
            }
        }
        catch (Exception alarmEx) {
            alarmEx.printStackTrace();
        }
        return false;
    }

    public boolean enableLogging(BBadgeActivity activity) {
        try {
            BActivityAlertExt[] alerts = (BActivityAlertExt[])this.getChildren(BActivityAlertExt.class);
            for (int i = 0; i < alerts.length; ++i) {
                if (!alerts[i].getActivityType().equals((Object)activity)) continue;
                return alerts[i].getEnableLogging();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public BIcon getIcon() {
        return ICON;
    }
}

