/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.ui.module;

import com.tridium.program.BProgram;
import com.tridium.program.ui.module.BuildException;
import com.tridium.program.ui.module.BuildHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BAction;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BLong;
import javax.baja.sys.BString;
import javax.baja.sys.BTopic;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.util.BWsAnnotation;

public class ComponentWriter
extends PrintWriter {
    private String[] predefinedImports = new String[]{"java.util.*;", "javax.baja.sys.*;", "javax.baja.status.*;", "javax.baja.util.*;", "javax.baja.security.*;"};
    private static final int tabWidth = 2;
    private BProgram program;
    private Class<?> programClass;
    private String packageName;
    private String compName;

    public ComponentWriter(Writer out, BProgram program, String packageName) {
        super(out);
        this.init(program, packageName);
    }

    private void init(BProgram program, String packageName) {
        this.program = program;
        try {
            this.programClass = program.getCode().newInstance().getClass();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BajaRuntimeException((Throwable)e);
        }
        this.packageName = packageName;
        this.compName = BuildHelper.toComponentName(program);
    }

    public void generate() {
        this.writeHeader();
        this.writeImports();
        this.writeClass();
        this.flush();
        this.close();
    }

    protected void writeHeader() {
        this.wl("/* Auto-generated by the Program Module-Builder. */");
        this.w("package ").w(this.packageName).wl(";");
        this.nl();
    }

    protected void writeImports() {
        String[] allImports;
        String[] prefixedImports;
        HashSet<String> imports = new HashSet<String>();
        Collections.addAll(imports, this.predefinedImports);
        String userImports = this.program.getCode().getUserDefinedImports();
        for (String prefixedImport : prefixedImports = TextUtil.split((String)userImports, (char)';')) {
            imports.add(TextUtil.split((String)prefixedImport, (char)':')[1] + ".*;");
        }
        SlotCursor c = this.program.getProperties();
        while (c.next()) {
            if (!c.property().isDynamic()) continue;
            Class<?> cls = c.get().getClass();
            imports.add(TextUtil.getPackageName(cls) + ".*;");
        }
        for (String allImport : allImports = imports.toArray(new String[imports.size()])) {
            this.w("import ").wl(allImport);
        }
        this.nl();
    }

    protected void writeClass() {
        this.w("public class ").wl(this.compName);
        this.tab().wl("extends BComponent implements Runnable");
        this.wl("{");
        this.writeProperties();
        this.writeActions();
        this.writeBComponentOverrides();
        this.writeRunnable();
        this.writeAccess();
        this.writeUtils();
        this.writeStubs();
        this.writeCode();
        this.writeType();
        this.wl("}");
    }

    protected void writeType() {
        this.section("Type");
        this.tab().wl("public Type getType() { return TYPE; }");
        this.tab().w("public static final Type TYPE = Sys.loadType(").w(this.compName).w(".class);");
        this.nl().nl();
    }

    protected void writeProperties() {
        SlotCursor c = this.program.getProperties();
        while (c.next()) {
            BValue v;
            Property prop = c.property();
            if (prop.isFrozen() || (v = c.get().asValue()) instanceof BWsAnnotation || v instanceof BLink || v instanceof BAction || v instanceof BTopic) continue;
            if (v instanceof BDouble || v instanceof BLong) {
                throw new BuildException("Property slot type not supported: " + v.getType());
            }
            this.section("Property \"" + prop.getName() + "\"");
            this.writeNewProperty(prop, v.isSimple());
            this.writeGetSet(prop);
        }
    }

    protected final void writeNewProperty(Property p, boolean isSimple) {
        String btype = "B" + p.getType().getTypeName();
        String def = isSimple ? "(BValue)" + btype + ".TYPE.getInstance()" : "new " + btype + "()";
        this.tab().w("public static final Property ").w(p.getName()).w(" = newProperty(").w(this.flags((Slot)p)).w(", ").w(def).w(", ").w(this.facets((Slot)p)).w(");").nl().nl();
    }

    protected final void writeGetSet(Property p) {
        CompProperty cp = new CompProperty(p);
        this.tab().w("public ").w(cp.type).w(" ").w(cp.getter()).w("() ").w("{ return ").w(cp.cast).w("get" + cp.postfix).w("(" + cp.name() + "); }").nl().nl();
        this.tab().w("public void ").w(cp.setter()).w("(" + cp.type + " v)").w(" { set" + cp.postfix + "(" + cp.name() + ", v, null); }").nl().nl();
    }

    protected void writeActions() {
        SlotCursor c = this.program.getActions();
        while (c.next()) {
            Action action = c.action();
            CompAction ca = new CompAction(c.action());
            if (action.isFrozen() && !ca.name().equals("execute")) continue;
            this.section("Action \"" + ca.name() + "\"");
            this.tab().w("public static final Action ").w(ca.name()).w(" = newAction(").w(this.flags((Slot)action)).w(", ").w(ca.paramDefault()).w(", ").w(this.facets((Slot)action)).w(");").nl().nl();
            this.writeActionInvoke(action);
            this.writeActionDelegate(action);
        }
    }

    protected void writeActionInvoke(Action action) {
        CompAction ca = new CompAction(action);
        StringBuffer sb = new StringBuffer().append("public ").append(ca.returnType()).append(" ").append(ca.name()).append("(").append(ca.parameter()).append(")").append("{ ").append(ca.returnStmt()).append("invoke(").append(ca.name()).append(", ").append(ca.invokeParam()).append(", null); }");
        this.tab().wl(sb.toString()).nl();
    }

    protected void writeActionDelegate(Action action) {
        CompAction ca = new CompAction(action);
        this.tab().wl("/** Autogenerated delegate for \"" + ca.getOn() + "\" */");
        this.tab().w("public ").w(ca.returnType()).w(" " + ca.getDo()).w("(" + ca.parameter() + ") throws Exception").nl().tab().wl("{").tab(2).w("try { ").w(ca.returnStmt()).w(ca.getOn()).w("(" + ca.actualParam() + "); }").nl().tab(2).w("catch (Throwable t) { throw new Exception(t); }").nl().tab().wl("}").nl();
    }

    protected void writeBComponentOverrides() {
        this.section("BComponent Overrides");
        this.tab().wl("public void started() throws Exception { try { onStart(); } catch(Throwable t) { throw new Exception(t); } }").nl();
        this.tab().wl("public void stopped() throws Exception { try { onStop(); } catch(Throwable t) { throw new Exception(t); } }").nl();
        this.writeChanged();
    }

    protected void writeChanged() {
        this.tab(1).wl("public void changed(Property prop, Context cx)").tab(1).wl("{").tab(2).wl("super.changed(prop, cx);").tab(2).wl("if (!isRunning()) return;").tab(2).wl("if (Flags.isExecuteOnChange(this, prop)) execute();").tab(1).wl("}").nl();
    }

    protected final void writeRunnable() {
        if (!this.programDeclares("run", null)) {
            this.section("Runnable");
            this.tab().wl("public void run() { System.out.println(\"Source BProgram did not override run(). Exiting thread.\"); }").nl();
        }
    }

    protected final void writeAccess() {
        this.section("Access");
        this.tab().wl("public final BComponent getComponent() { return this; }").nl();
        this.tab().wl("public final BComponent getProgram() { return this; }").nl();
    }

    protected final void writeUtils() {
        this.section("Utils");
        if (!this.programDeclares("print", new Class[]{String.class})) {
            this.tab().wl("/** Print a string to standard out without a trailing new-line. */");
            this.tab().wl("public void print(String s) { System.out.print(s); System.out.flush(); }").nl();
        } else {
            this.tab().wl("// print(String s) is overridden by program source.").nl();
        }
        if (!this.programDeclares("println", new Class[]{String.class})) {
            this.tab().wl("/** Print a string to standard out with a trailing new-line. */");
            this.tab().wl("public void println(String s) { System.out.println(s); }").nl();
        } else {
            this.tab().wl("// println(String s) is overridden by program souce.").nl();
        }
    }

    protected final void writeStubs() {
        this.section("ProgramBase Stubs");
        if (!this.programDeclares("onStart", null)) {
            this.tab().wl("public void onStart() throws Throwable {}").nl();
        }
        if (!this.programDeclares("onStop", null)) {
            this.tab().wl("public void onStop() throws Throwable {}").nl();
        }
        if (!this.programDeclares("onExecute", null)) {
            this.tab().wl("public void onExecute() throws Throwable {}").nl();
        }
    }

    protected void writeCode() {
        String sourceCode = this.program.getCode().getSource();
        sourceCode = sourceCode.replace("BProgram.", this.compName + '.');
        this.section("BProgram Source Code");
        this.writeSourceLines(sourceCode);
    }

    protected boolean programDeclares(String name, Class<?>[] paramTypes) {
        try {
            this.programClass.getDeclaredMethod(name, paramTypes);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    protected final void writeSourceLines(String source) {
        try {
            String line;
            BufferedReader r = new BufferedReader(new StringReader(source));
            while ((line = r.readLine()) != null) {
                this.tab().wl(line);
            }
            this.nl();
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }

    protected void section(String s) {
        this.nl();
        this.wl("////////////////////////////////////////////////////////////////");
        this.wl("// " + s);
        this.wl("////////////////////////////////////////////////////////////////");
        this.nl();
    }

    protected final String flags(Slot slot) {
        StringBuilder sb = new StringBuilder("0");
        if (Flags.isAsync((BComplex)this.program, (Slot)slot)) {
            sb.append("|Flags.ASYNC");
        }
        if (Flags.isComposite((BComplex)this.program, (Slot)slot)) {
            sb.append("|Flags.COMPOSITE");
        }
        if (Flags.isConfirmRequired((BComplex)this.program, (Slot)slot)) {
            sb.append("|Flags.CONFIRM_REQUIRED");
        }
        if (Flags.isDefaultOnClone((BComplex)this.program, (Slot)slot)) {
            sb.append("|Flags.DEFAULT_ON_CLONE");
        }
        if (Flags.isExecuteOnChange((BComplex)this.program, (Slot)slot)) {
            sb.append("|Flags.EXECUTE_ON_CHANGE");
        }
        if (Flags.isFanIn((BComplex)this.program, (Slot)slot)) {
            sb.append("|Flags.FAN_IN");
        }
        if (Flags.isHidden((BComplex)this.program, (Slot)slot)) {
            sb.append("|Flags.HIDDEN");
        }
        if (Flags.isNoAudit((BComplex)this.program, (Slot)slot)) {
            sb.append("|Flags.NO_AUDIT");
        }
        if (Flags.isNoRun((BComplex)this.program, (Slot)slot)) {
            sb.append("|Flags.NO_RUN");
        }
        if (Flags.isOperator((BComplex)this.program, (Slot)slot)) {
            sb.append("|Flags.OPERATOR");
        }
        if (Flags.isReadonly((BComplex)this.program, (Slot)slot)) {
            sb.append("|Flags.READONLY");
        }
        if (Flags.isSummary((BComplex)this.program, (Slot)slot)) {
            sb.append("|Flags.SUMMARY");
        }
        if (Flags.isTransient((BComplex)this.program, (Slot)slot)) {
            sb.append("|Flags.TRANSIENT");
        }
        if (Flags.isUserDefined1((BComplex)this.program, (Slot)slot)) {
            sb.append("|Flags.USER_DEFINED_1");
        }
        if (Flags.isUserDefined2((BComplex)this.program, (Slot)slot)) {
            sb.append("|Flags.USER_DEFINED_2");
        }
        if (Flags.isUserDefined3((BComplex)this.program, (Slot)slot)) {
            sb.append("|Flags.USER_DEFINED_3");
        }
        if (Flags.isUserDefined4((BComplex)this.program, (Slot)slot)) {
            sb.append("|Flags.USER_DEFINED_4");
        }
        return sb.toString();
    }

    protected final String facets(Slot slot) {
        try {
            return slot.getFacets().isNull() ? "null" : "BFacets.tryMake(\"" + slot.getFacets().encodeToString() + "\")";
        }
        catch (Exception e) {
            throw new BuildException("Failed to create facets. ", e);
        }
    }

    protected ComponentWriter w(String s) {
        this.print(s);
        return this;
    }

    protected ComponentWriter wl(String s) {
        this.print(s);
        this.print('\n');
        return this;
    }

    protected ComponentWriter nl() {
        this.print('\n');
        return this;
    }

    protected ComponentWriter tab() {
        return this.tab(1);
    }

    protected ComponentWriter tab(int numTabs) {
        return this.w(TextUtil.getSpaces((int)(numTabs * 2)));
    }

    protected ComponentWriter sp(int spaces) {
        return this.w(TextUtil.getSpaces((int)spaces));
    }

    public static class CompAction {
        public Action action;
        public static final String ACTUAL_PARAM_VAR = "v";

        public CompAction(Action action) {
            this.action = action;
        }

        public String name() {
            return this.action.getName();
        }

        public String returnType() {
            return this.action.getReturnType() == null ? "void" : "B" + this.action.getReturnType().getTypeName();
        }

        public String parameter() {
            return this.action.getParameterDefault() == null ? "" : this.paramType() + " " + ACTUAL_PARAM_VAR;
        }

        public String paramType() {
            return this.action.getParameterType() == null ? null : "B" + this.action.getParameterType().getTypeName();
        }

        public Class<?>[] paramTypeArray() {
            if (this.action.getParameterType() == null) {
                return null;
            }
            return new Class[]{this.action.getParameterType().getInstance().getClass()};
        }

        public String paramDefault() {
            BValue param = this.action.getParameterDefault();
            if (param == null) {
                return "null";
            }
            String btypeParam = this.paramType();
            if (param.isSimple()) {
                return "(BValue)" + btypeParam + ".TYPE.getInstance()";
            }
            return "new " + btypeParam + "()";
        }

        public String returnStmt() {
            return this.action.getReturnType() == null ? "" : "return (" + this.returnType() + ")";
        }

        public String invokeParam() {
            return this.paramType() == null ? "null" : ACTUAL_PARAM_VAR;
        }

        public String actualParam() {
            return this.action.getParameterType() == null ? "" : ACTUAL_PARAM_VAR;
        }

        public String getDo() {
            return "do" + TextUtil.capitalize((String)this.name());
        }

        public String getOn() {
            return "on" + TextUtil.capitalize((String)this.name());
        }
    }

    public static class CompProperty {
        public Property prop;
        String cast = "";
        String postfix = "";
        String type;
        String bname;
        Class<?>[] setParams;

        public CompProperty(Property prop) {
            this.prop = prop;
            BValue v = prop.getDefaultValue();
            this.type = this.bname = "B" + v.getType().getTypeName();
            if (v.isSimple()) {
                if (v instanceof BString) {
                    this.postfix = "String";
                    this.type = "String";
                    this.setParams = new Class[]{String.class};
                } else if (v instanceof BBoolean) {
                    this.type = "boolean";
                    this.postfix = "Boolean";
                    this.setParams = new Class[]{Boolean.TYPE};
                } else if (v instanceof BInteger) {
                    this.type = "int";
                    this.postfix = "Int";
                    this.setParams = new Class[]{Integer.TYPE};
                } else if (v instanceof BFloat) {
                    this.type = "float";
                    this.postfix = "Float";
                    this.setParams = new Class[]{Float.TYPE};
                } else {
                    this.cast = "(" + this.type + ")";
                    this.setParams = new Class[]{v.getClass()};
                }
            } else if (v.isValue()) {
                this.cast = "(" + this.type + ")";
                this.setParams = new Class[]{v.getClass()};
            } else {
                throw new IllegalStateException(this.bname + ", " + v.getType());
            }
        }

        public String name() {
            return this.prop.getName();
        }

        public String getter() {
            return "get" + TextUtil.capitalize((String)this.name());
        }

        public String setter() {
            return "set" + TextUtil.capitalize((String)this.name());
        }

        public String cast() {
            return this.cast;
        }

        public String postfix() {
            return this.postfix;
        }

        public String type() {
            return this.type;
        }

        public String typeName() {
            return this.bname;
        }
    }
}

