/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.ui.batch;

import com.tridium.program.ui.batch.BBatchEditor;
import com.tridium.program.ui.batch.BatchCommands;
import com.tridium.script.PropertyField;
import com.tridium.script.ScriptField;
import com.tridium.script.ScriptUtil;
import com.tridium.workbench.user.BPermissionsMapFE;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.baja.gx.BImage;
import javax.baja.naming.SlotPath;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BBatchTable
extends BTable {
    public static final Type TYPE = Sys.loadType(BBatchTable.class);
    private Lexicon lex = Lexicon.make((String)"program");
    BBatchEditor editor;
    Model model;

    public Type getType() {
        return TYPE;
    }

    public BBatchTable(BBatchEditor editor) {
        this.editor = editor;
        this.model = new Model();
        this.setModel(this.model);
        this.setSelection(new Selection());
        this.setController(new Controller());
        this.setPasteEnabled(true);
    }

    public void refresh() {
        BatchCommands.lease(this.model.kids.toArray(new BComponent[this.model.kids.size()]));
        this.relayout();
    }

    public void setModel(TableModel m) {
        super.setModel(m);
        if (m instanceof Model) {
            this.model = (Model)m;
        }
    }

    public int dragOver(TransferContext cx) {
        BObject[] obj;
        Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
        for (BObject anObj : obj = mark.getValues()) {
            if (!(anObj instanceof BComponent)) continue;
            return 16;
        }
        return 0;
    }

    public CommandArtifact drop(TransferContext cx) throws Exception {
        Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
        BObject[] obj = mark.getValues();
        ArrayList<BComponent> toLease = new ArrayList<BComponent>();
        for (BObject anObj : obj) {
            if (!(anObj instanceof BComponent) || this.model.kids.contains(anObj)) continue;
            toLease.add((BComponent)anObj);
            this.model.kids.add((BComponent)anObj);
        }
        BatchCommands.lease(toLease.toArray(new BComponent[toLease.size()]));
        this.sizeColumnsToFit();
        this.relayout();
        this.editor.commands.updateCommands();
        return null;
    }

    public CommandArtifact insertTransferData(TransferContext cx) throws Exception {
        return this.drop(cx);
    }

    class Controller
    extends TableController {
        Controller() {
        }

        public void keyPressed(BKeyEvent event) {
            if (event.getKeyCode() == 127) {
                event.consume();
                BBatchTable.this.editor.commands.clear.invoke();
            } else {
                super.keyPressed(event);
            }
        }

        protected void cellPopup(BMouseEvent event, int row, int column) {
            BMenu menu = BBatchTable.this.editor.commands.buildMenu();
            menu.open((BWidget)this.getTable(), event.getX(), event.getY());
        }

        protected void backgroundPopup(BMouseEvent event) {
            BMenu menu = BBatchTable.this.editor.commands.buildMenu();
            menu.open((BWidget)this.getTable(), event.getX(), event.getY());
        }
    }

    class Selection
    extends TableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            BBatchTable.this.editor.commands.updateCommands();
        }
    }

    class Model
    extends TableModel {
        List<String> cols = new ArrayList<String>();
        List<BComponent> kids = new ArrayList<BComponent>();
        Map<BComponent, BImage> hash = new HashMap<BComponent, BImage>();

        private Model() {
            this.cols.add(BBatchTable.this.lex.getText("batchEditor.object"));
        }

        public int getColumnCount() {
            return this.cols.size();
        }

        public String getColumnName(int col) {
            return this.cols.get(col);
        }

        public int getRowCount() {
            return this.kids.size();
        }

        public Object getValueAt(int row, int col) {
            BComponent c = this.kids.get(row);
            if (col == 0) {
                return SlotPath.unescape((String)c.getSlotPath().getBody());
            }
            BValue obj = c.get(this.cols.get(col));
            return obj == null ? "n/a" : String.valueOf(obj);
        }

        public BImage getRowIcon(int row) {
            BImage icon = this.hash.get(this.kids.get(row));
            if (icon == null) {
                BComponent obj = this.kids.get(row);
                icon = BImage.make((BIcon)obj.getIcon());
                this.hash.put(obj, icon);
            }
            return icon;
        }

        public String[] getAllColumns() {
            return this.getAllColumns(true);
        }

        public String[] getAllColumns(boolean includeFrozen) {
            ArrayList<String> list = new ArrayList<String>();
            for (BComponent kid : this.kids) {
                ScriptField[] fields;
                for (ScriptField field : fields = ScriptUtil.scriptFields((Object)kid)) {
                    boolean frozen;
                    if (!field.isProperty() || list.contains(field.scriptName()) || (field.scriptFlags((Object)kid) & 1) != 0 || (field.scriptType().getModifiers() & 0x400) != 0) continue;
                    boolean bl = frozen = field.isProperty() && ((PropertyField)field).getProperty().isFrozen();
                    if (!includeFrozen && frozen) continue;
                    list.add(field.scriptName());
                }
            }
            Object[] array = list.toArray(new String[list.size()]);
            Arrays.sort(array);
            return array;
        }

        public Class<?> getColumnType(String name) {
            for (BComponent kid : this.kids) {
                ScriptField[] fields;
                for (ScriptField field : fields = ScriptUtil.scriptFields((Object)kid)) {
                    if (!name.equals(field.scriptName())) continue;
                    return field.scriptType();
                }
            }
            return null;
        }

        public BWbFieldEditor getColumnEditor(String name) {
            for (BComponent kid : this.kids) {
                ScriptField[] fields;
                for (ScriptField field : fields = ScriptUtil.scriptFields((Object)kid)) {
                    BWbFieldEditor fe;
                    Slot slot;
                    if (!name.equals(field.scriptName())) continue;
                    BFacets cx = null;
                    BObject defaultValue = null;
                    if (kid != null && (slot = kid.getSlot(field.scriptName())) != null && slot.isProperty()) {
                        cx = slot.asProperty().getFacets();
                        defaultValue = slot.asProperty().getDefaultValue();
                    }
                    if (defaultValue == null) {
                        defaultValue = Sys.getType((Class)field.scriptType()).getInstance();
                    }
                    if ((fe = BWbFieldEditor.makeFor(defaultValue, cx)) instanceof BPermissionsMapFE && (cx == null || cx.getFacets().isNull())) {
                        cx = BBatchTable.this.editor.getCurrentContext();
                    }
                    fe.loadValue(defaultValue, cx);
                    return fe;
                }
            }
            return null;
        }

        public Model makeCopy() {
            int i;
            ArrayList<BComponent> toLease = new ArrayList<BComponent>();
            Model m = new Model();
            for (i = 1; i < this.cols.size(); ++i) {
                m.cols.add(this.cols.get(i));
            }
            for (i = 0; i < this.kids.size(); ++i) {
                BComponent c = this.kids.get(i);
                if (!c.isMounted()) continue;
                toLease.add(c);
                m.kids.add(c);
            }
            BatchCommands.lease(toLease.toArray(new BComponent[toLease.size()]));
            return m;
        }
    }
}

