/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.ui;

import com.tridium.crypto.core.cert.SigningUtil;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.nsh.NShell;
import com.tridium.program.BCode;
import com.tridium.program.MacroProperties;
import com.tridium.program.ui.CompilerException;
import com.tridium.program.ui.signing.BCertificateNotSelectedDialog;
import com.tridium.program.ui.signing.BCodeSigningOptions;
import com.tridium.workbench.console.BConsole;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.baja.naming.SlotPath;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.registry.DependencyInfo;
import javax.baja.registry.ModuleInfo;
import javax.baja.sys.BBlob;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;

public class Compiler
implements BConsole.ExecCallback {
    BWidget owner;
    public String className;
    File temp;
    File java;
    File classFile;
    File[] innerClassFiles;
    BCode code;
    boolean reportErrors = false;
    boolean signingEnabled = true;
    static final Logger log = Logger.getLogger("sys.program");
    protected static Lexicon lex = Lexicon.make((String)"program");

    public Compiler(BWidget owner) {
        this.owner = owner;
    }

    public void compile(String className, BCode code, String source) throws Exception {
        this.className = className;
        this.temp = new File(Sys.getNiagaraUserHome(), "temp");
        this.java = new File(this.temp, className + ".java");
        this.classFile = new File(this.temp, className + ".class");
        this.innerClassFiles = null;
        this.code = code;
        File fTemp = this.temp;
        AccessController.doPrivileged(() -> {
            if (!fTemp.exists()) {
                fTemp.mkdirs();
            }
            return null;
        });
        try (FileWriter out = new FileWriter(this.java);){
            this.writeSource(out, source);
        }
        String sep = File.separator;
        String pathSep = File.pathSeparator;
        StringBuilder cp = new StringBuilder();
        File binDir = new File(Sys.getNiagaraHome(), "bin");
        File binExtDir = new File(binDir, "ext");
        String[] binJars = binExtDir.list(new JarFilenameFilter());
        String binMbase = Sys.getNiagaraHome() + sep + "bin" + sep + "ext" + sep;
        for (String binJar : binJars) {
            cp.append(binMbase).append(binJar).append(pathSep);
        }
        cp.append(Sys.getNiagaraHome()).append(sep).append("modules").append(sep).append("baja.jar").append(pathSep);
        String[] depends = this.parseDependencies(code);
        String mbase = Sys.getNiagaraHome() + sep + "modules" + sep;
        for (String depend : depends) {
            if (depend.equals("baja")) continue;
            cp.append(mbase).append(depend).append(".jar").append(pathSep);
        }
        String profile = Compiler.getCompactProfile(depends);
        try {
            String cmd = Compiler.getCompileJavaCommand(profile, cp.toString(), this.temp.toString(), this.java.toString());
            this.exec(cmd);
        }
        catch (Exception e) {
            if (this.reportErrors) {
                throw e;
            }
            System.out.println("Problem loading 'javac' command.");
            e.printStackTrace();
        }
    }

    protected String[] parseDependencies(BCode code) throws Exception {
        String[] deps;
        HashSet<String> result = new HashSet<String>();
        for (String dep : deps = code.parseDependencies()) {
            String modulePartName = null;
            try {
                ModuleInfo mInfo = Sys.getRegistry().moduleForDependency(dep);
                modulePartName = mInfo.getModulePartName();
            }
            catch (ModuleNotFoundException moduleNotFoundException) {
                // empty catch block
            }
            if (modulePartName == null) continue;
            this.accumDependencies(result, modulePartName);
        }
        return result.toArray(new String[result.size()]);
    }

    protected void accumDependencies(Set<String> acc, String modulePartName) throws Exception {
        DependencyInfo[] deps;
        if (acc.contains(modulePartName)) {
            return;
        }
        acc.add(modulePartName);
        for (DependencyInfo dep : deps = Sys.getRegistry().moduleForDependency(modulePartName).getDependencies()) {
            this.accumDependencies(acc, dep.getModulePartName());
        }
    }

    public void writeSource(FileWriter out, String source) throws Exception {
        out.write(source);
    }

    public void exec(String cmd) throws Exception {
        if (this.owner != null) {
            this.openConsole().exec(cmd, (BConsole.ExecCallback)this);
        } else if (this.reportErrors) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream out = new PrintStream(bos);
            NShell shell = new NShell(out);
            shell.exec(cmd);
            shell.execWaitUntilDone();
            String compileRes = bos.toString();
            if (compileRes.indexOf("error") > 0) {
                this.cleanup();
                throw new CompilerException(compileRes);
            }
            this.compileSuccess(null);
            this.cleanup();
        } else {
            NShell shell = new NShell(System.out);
            shell.exec(cmd);
            shell.execWaitUntilDone();
            this.compileSuccess(null);
            this.cleanup();
        }
    }

    public BConsole openConsole() {
        return this.owner.getShell() != null ? ((BNiagaraWbShell)this.owner.getShell()).openConsole() : null;
    }

    public void consoleExecDone(BConsole console, int exitCode) {
        try {
            if (exitCode == 0) {
                this.compileSuccess(console);
            } else {
                this.compileFailed(console);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.cleanup();
    }

    public void compileSuccess(BConsole console) throws Exception {
        BCode temp = new BCode();
        byte[] buf = new byte[(int)this.classFile.length()];
        DataInputStream in = AccessController.doPrivileged(() -> new DataInputStream(new BufferedInputStream(new FileInputStream(this.classFile))));
        in.readFully(buf);
        in.close();
        temp.setClassName(this.className);
        temp.setClassFile(BBlob.make((byte[])buf));
        File[] tempFiles = this.classFile.getParentFile().listFiles();
        ArrayList<File> innerArray = new ArrayList<File>();
        for (int i = 0; i < (tempFiles != null ? tempFiles.length : 0); ++i) {
            if (!tempFiles[i].getName().startsWith(this.className + '$')) continue;
            innerArray.add(tempFiles[i]);
            String innerClassName = tempFiles[i].getName();
            innerClassName = innerClassName.substring(0, innerClassName.length() - 6);
            buf = new byte[(int)tempFiles[i].length()];
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(tempFiles[i])));
            in.readFully(buf);
            in.close();
            temp.addInnerClassFile(innerClassName, BBlob.make((byte[])buf));
        }
        this.innerClassFiles = innerArray.toArray(new File[innerArray.size()]);
        try {
            if (this.signingEnabled) {
                Compiler.signCode(temp, (BWidget)console);
            }
        }
        catch (Exception e) {
            this.handleSigningFailed(e, console);
            throw e;
        }
        this.code.setClassName(temp.getClassName());
        this.code.setClassFile(temp.getClassFile());
        this.code.setSignature(temp.getSignature());
        this.code.clearInnerClassFiles();
        SlotCursor c = temp.getProperties();
        while (c.next(BBlob.class)) {
            if (!c.property().isDynamic()) continue;
            this.code.add(c.property().getName(), c.get(), 1);
        }
    }

    public static void signCode(BCode code, BWidget owner) throws Exception {
        BCodeSigningOptions options = BCodeSigningOptions.make();
        String alias = options.getSigningCert();
        if ((alias == null || alias.isEmpty()) && AccessController.doPrivileged(() -> Boolean.getBoolean("program.requireSigning")).booleanValue()) {
            CoreCryptoManager ccm = AccessController.doPrivileged(() -> {
                try {
                    return CoreCryptoManager.get((ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider());
                }
                catch (Exception e) {
                    return null;
                }
            });
            String newAlias = BCertificateNotSelectedDialog.show(owner);
            if (newAlias != null && !newAlias.isEmpty()) {
                options.setSigningCert(newAlias);
                alias = newAlias;
            }
        }
        char[] keyPassword = null;
        if (alias != null && !alias.isEmpty()) {
            try {
                keyPassword = AccessController.doPrivileged(() -> {
                    try {
                        return options.getKeyPassword(owner);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof Exception) {
                    throw (Exception)e.getCause();
                }
                throw e;
            }
        }
        String tsaUrl = options.getTsaUrl();
        Compiler.signCode(code, alias, keyPassword, tsaUrl);
    }

    public static void signCode(BCode code, String alias, char[] keyPassword, String tsaUrl) throws Exception {
        byte[] buf = code.getClassFile().copyBytes();
        if ((alias == null || alias.equals("")) && !AccessController.doPrivileged(() -> Boolean.getBoolean("program.requireSigning")).booleanValue()) {
            code.setSignature(BBlob.DEFAULT);
            code.clearInnerClassSignatures();
            log.warning(lex.getText("program.willNotSign"));
            return;
        }
        if (alias == null || alias.equals("")) {
            throw new Exception(lex.getText("program.certNotSelected"));
        }
        CoreCryptoManager ccm = AccessController.doPrivileged(() -> {
            try {
                return CoreCryptoManager.get((ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider());
            }
            catch (Exception e) {
                return null;
            }
        });
        BBlob signature = BBlob.make((byte[])SigningUtil.generateSignature((byte[])buf, (String)alias, (String)tsaUrl, (char[])((char[])keyPassword.clone()), (KeyStore)ccm.getKeyStore().getKeyStore()));
        code.setSignature(signature);
        SlotCursor c = code.getProperties();
        while (c.next(BBlob.class)) {
            if (!c.property().isDynamic() || SlotPath.unescape((String)c.property().getName()).endsWith("#sig")) continue;
            byte[] innerBytes = ((BBlob)c.get()).copyBytes();
            signature = BBlob.make((byte[])SigningUtil.generateSignature((byte[])innerBytes, (String)alias, (String)tsaUrl, (char[])((char[])keyPassword.clone()), (KeyStore)ccm.getKeyStore().getKeyStore()));
            code.addInnerClassSignature(SlotPath.unescape((String)c.property().getName()), signature);
        }
        if (tsaUrl == null || tsaUrl.isEmpty()) {
            log.warning(lex.getText("program.willNotTimestamp"));
        }
    }

    public static void checkSigningKey(String alias, char[] password) throws LocalizableException {
        CoreCryptoManager ccm = AccessController.doPrivileged(() -> {
            try {
                return CoreCryptoManager.get((ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider());
            }
            catch (Exception e) {
                return null;
            }
        });
        try {
            KeyStore keystore = ccm.getKeyStore().getKeyStore();
            SigningUtil.checkKey((KeyStore)keystore, (String)alias, (char[])((char[])password.clone()));
        }
        catch (Exception e) {
            throw new LocalizableException("program", "program.couldNotSign", new Object[]{e.getMessage()});
        }
    }

    public void handleSigningFailed(Exception e, BConsole console) {
        console.appendLine(lex.getText("program.couldNotSign", new Object[]{e}));
        console.showLast();
    }

    public void compileFailed(BConsole console) throws Exception {
        console.next();
    }

    public void cleanup() {
        File[] fInnerClassFiles;
        if (this.innerClassFiles != null) {
            fInnerClassFiles = new File[this.innerClassFiles.length];
            System.arraycopy(this.innerClassFiles, 0, fInnerClassFiles, 0, this.innerClassFiles.length);
        } else {
            fInnerClassFiles = new File[]{};
        }
        final File fClassFile = this.classFile;
        final File fJava = this.java;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                fClassFile.delete();
                for (File fInnerClassFile : fInnerClassFiles) {
                    fInnerClassFile.delete();
                }
                fJava.delete();
                return null;
            }
        });
    }

    public static String getCompactProfile(String[] depends) {
        RuntimeProfile moduleProfile = RuntimeProfile.rt;
        for (String name : depends) {
            try {
                ModuleInfo mInfo = Sys.getRegistry().moduleForDependency(name);
                RuntimeProfile runtime = mInfo.getRuntimeProfile();
                if (runtime.compareTo((Enum)moduleProfile) <= 0) continue;
                moduleProfile = runtime;
            }
            catch (ModuleNotFoundException moduleNotFoundException) {
                // empty catch block
            }
        }
        if (moduleProfile.compareTo((Enum)RuntimeProfile.ux) >= 0) {
            return "";
        }
        return "compact3";
    }

    public static String getCompileJavaCommand(String profile, String classPath, String destDir, String javaSrcFile) throws Exception {
        if (!javaSrcFile.startsWith("\"")) {
            javaSrcFile = "\"" + javaSrcFile;
        }
        if (!javaSrcFile.endsWith("\"")) {
            javaSrcFile = javaSrcFile + "\"";
        }
        String jdkHome = AccessController.doPrivileged(() -> System.getProperty("java.home"));
        String javacMacro = "\"" + jdkHome + File.separator + "bin" + File.separator + "javac\" -encoding UTF-8 %javac.profile% -Xlint:deprecation -classpath \"%javac.classpath%\" -d \"%javac.out%\" %javac.src%";
        MacroProperties javac = new MacroProperties();
        javac.put((Object)"javac.classpath", (Object)classPath);
        javac.put((Object)"javac.out", (Object)destDir);
        javac.put((Object)"javac.src", (Object)javaSrcFile);
        if (profile != null && !profile.equals("")) {
            javac.put((Object)"javac.profile", (Object)("-profile " + profile));
        } else {
            javac.put((Object)"javac.profile", (Object)"");
        }
        javac.put((Object)"javac.cmd", (Object)javacMacro);
        String cmd = javac.resolve("javac.cmd");
        if (!cmd.endsWith(javaSrcFile)) {
            int idx = cmd.lastIndexOf(javaSrcFile);
            cmd = idx > -1 ? cmd.substring(0, idx) : cmd + " ";
            cmd = cmd + javaSrcFile;
        }
        return cmd;
    }

    public void setReportErrors(boolean b) {
        this.reportErrors = b;
    }

    public void setSignignEnabled(boolean enabled) {
        this.signingEnabled = enabled;
    }

    public static class JarFilenameFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    }
}

