/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.raster.viewer;

import com.tridium.gx.GxEnv;
import com.tridium.gx.awt.AwtEnv;
import com.tridium.gx.awt.ImageManager;
import com.tridium.raster.codec.png.PNGImageDecoder;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.TextController;
import javax.imageio.ImageIO;

public class ImageUtil {
    public static final Type imageFileType = Sys.getType((String)"file:ImageFile");
    public static final Type gifFileType = Sys.getType((String)"file:GifFile");
    public static final Type jpegFileType = Sys.getType((String)"file:JpegFile");
    public static final Type pngFileType = Sys.getType((String)"file:PngFile");
    public static final Type pxFileType = Sys.getType((String)"file:PxFile");
    public static final RenderingHints highQuality = new RenderingHints(null);

    public static BufferedImage read(BIFile file) throws Exception {
        try (InputStream in = file.getInputStream();){
            if (file.getType().is(pngFileType)) {
                BufferedImage bufferedImage = new PNGImageDecoder(in).decode();
                return bufferedImage;
            }
            BufferedImage bufferedImage = ImageIO.read(in);
            return bufferedImage;
        }
        byte[] buf = file.read();
        Image img = Toolkit.getDefaultToolkit().createImage(buf);
        ImageManager.sync((Image)img);
        BufferedImage bimg = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D g = bimg.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        return bimg;
    }

    public static boolean canWrite(BIFile file) {
        return file.getType().is(jpegFileType) || file.getType().is(pngFileType);
    }

    public static void write(BIFile file, BufferedImage orig, BufferedImage img) throws Exception {
        if (file.getType().is(jpegFileType)) {
            OutputStream out = file.getOutputStream();
            ImageIO.write((RenderedImage)img, "jpg", out);
            out.close();
        } else if (file.getType().is(pngFileType)) {
            OutputStream out = file.getOutputStream();
            ImageIO.write((RenderedImage)img, "png", out);
            out.close();
        } else {
            throw new Exception("Cannot write file type: " + file.getType());
        }
    }

    public static BImage toBImage(Image img) {
        return ((AwtEnv)GxEnv.get()).makeImage(img, false);
    }

    public static void process(BWidget owner, BIFile[] files, Processor proc) {
        for (int i = 0; i < files.length; ++i) {
            BIFile f = files[i];
            if (ImageUtil.canWrite(f)) continue;
            BDialog.error((BWidget)owner, (Object)("No support for writing \"" + f.getMimeType() + "\" files (" + f.getFileName() + ")"));
            return;
        }
        BProgressDialog.open((BWidget)owner, (String)"Processing Files", (BProgressDialog.Worker)new Worker(files, proc), (BImage)BImage.make((String)"module://icons/x32/clock.png"));
    }

    static {
        highQuality.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        highQuality.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        highQuality.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
    }

    static class Worker
    extends BProgressDialog.Worker {
        BIFile[] files;
        Processor proc;
        boolean canceled;

        Worker(BIFile[] files, Processor proc) {
            this.files = files;
            this.proc = proc;
        }

        public void doCancel() {
            this.canceled = true;
        }

        public void doRun() {
            double curStep = 0.0;
            double totalSteps = this.files.length * 3;
            for (int i = 0; i < this.files.length && !this.canceled; ++i) {
                BIFile file = this.files[i];
                String name = file.getFileName();
                try {
                    double d = curStep;
                    curStep = d + 1.0;
                    this.updateProgress((int)(d / totalSteps * 100.0), "Reading " + name);
                    BufferedImage src = ImageUtil.read(file);
                    double d2 = curStep;
                    curStep = d2 + 1.0;
                    this.updateProgress((int)(d2 / totalSteps * 100.0), "Processing " + name);
                    BufferedImage dest = this.proc.process(src);
                    double d3 = curStep;
                    curStep = d3 + 1.0;
                    this.updateProgress((int)(d3 / totalSteps * 100.0), "Writing " + name);
                    ImageUtil.write(file, src, dest);
                    continue;
                }
                catch (Exception e) {
                    String msg = "Cannot process: " + name;
                    int r = BDialog.open((BWidget)this.getDialog(), (String)BDialog.TITLE_ERROR, (Object)msg, (int)3, (BImage)BDialog.ERROR_ICON, (Throwable)e);
                    if (r != 2) continue;
                    this.canceled = true;
                }
            }
        }
    }

    public static class ResizeInput {
        BWidget content;
        BTextField w = new BTextField("", 8);
        BTextField h = new BTextField("", 8);
        BCheckBox aspect = new BCheckBox("Maintain aspect ratio");
        double ratio;

        public ResizeInput(int curw, int curh) {
            this.ratio = (double)curw / (double)curh;
            this.aspect.setCommand((Command)new AspectToggle(), false, false);
            this.aspect.setSelected(true);
            this.w.setController((TextController)new Controller());
            this.h.setController((TextController)new Controller());
            this.setWidth(curw);
            this.setHeight(curh);
            BGridPane size = new BGridPane(2);
            size.add(null, (BValue)new BLabel("Width"));
            size.add(null, (BValue)this.w);
            size.add(null, (BValue)new BLabel("Height"));
            size.add(null, (BValue)this.h);
            BGridPane grid = new BGridPane(1);
            grid.add(null, (BValue)size);
            grid.add(null, (BValue)this.aspect);
            this.content = new BBorderPane((BWidget)grid);
        }

        public BWidget getContent() {
            return this.content;
        }

        public int getWidth() {
            return Integer.parseInt(this.w.getText());
        }

        public int getHeight() {
            return Integer.parseInt(this.h.getText());
        }

        void checkAspect(BTextField f) {
            try {
                if (!this.aspect.isSelected()) {
                    return;
                }
                if (f == this.w) {
                    this.setHeight((int)((double)this.getWidth() / this.ratio));
                } else {
                    this.setWidth((int)((double)this.getHeight() * this.ratio));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void setWidth(int w) {
            this.w.setText(String.valueOf(w));
        }

        void setHeight(int h) {
            this.h.setText(String.valueOf(h));
        }

        class Controller
        extends TextController {
            Controller() {
            }

            public void keyPressed(BKeyEvent e) {
                super.keyPressed(e);
                ResizeInput.this.checkAspect((BTextField)this.getEditor());
            }

            public void keyReleased(BKeyEvent e) {
                super.keyReleased(e);
                ResizeInput.this.checkAspect((BTextField)this.getEditor());
            }

            public void keyTyped(BKeyEvent e) {
                super.keyTyped(e);
                ResizeInput.this.checkAspect((BTextField)this.getEditor());
            }
        }

        class AspectToggle
        extends ToggleCommand {
            AspectToggle() {
                super((BWidget)ResizeInput.this.aspect, "aspect");
            }

            public void setSelected(boolean sel) {
                super.setSelected(sel);
                ResizeInput.this.checkAspect(ResizeInput.this.w);
            }
        }
    }

    public static class Resize
    extends Processor {
        int dw;
        int dh;

        public Resize(int w, int h) {
            this.dw = w;
            this.dh = h;
        }

        @Override
        public BufferedImage process(BufferedImage src) {
            BufferedImage dest = new BufferedImage(this.dw, this.dh, src.getType());
            Graphics2D g = (Graphics2D)dest.getGraphics();
            g.setRenderingHints(highQuality);
            g.drawImage(src, 0, 0, this.dw, this.dh, null);
            g.dispose();
            return dest;
        }
    }

    public static class Rotate
    extends Processor {
        int angle;

        public Rotate(int angle) {
            if (angle != 90 && angle != 270) {
                throw new IllegalArgumentException("" + angle);
            }
            this.angle = angle;
        }

        @Override
        public BufferedImage process(BufferedImage src) {
            int w = src.getWidth();
            int h = src.getHeight();
            int offset = (w - h) / 2;
            double x = 0.5 * (double)w;
            double y = 0.5 * (double)h;
            AffineTransform at = new AffineTransform();
            at.rotate(Math.toRadians(this.angle), x, y);
            if (this.angle == 90) {
                at.translate(offset, offset);
            } else if (this.angle == 270) {
                at.translate(-offset, -offset);
            }
            BufferedImage dest = new BufferedImage(h, w, src.getType());
            Graphics2D g = (Graphics2D)dest.getGraphics();
            g.setRenderingHints(highQuality);
            g.transform(at);
            g.drawImage((Image)src, 0, 0, null);
            g.dispose();
            return dest;
        }
    }

    public static abstract class Processor {
        public abstract BufferedImage process(BufferedImage var1);
    }
}

