/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc.ui;

import com.tridium.help.bajadoc.ClassDoc;
import com.tridium.help.bajadoc.ui.BBajadocOptions;
import com.tridium.help.bajadoc.ui.BBajadocViewer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;

public class BajadocCommands {
    static final BImage classIcon = BImage.make((String)"module://icons/x16/file.png");
    static final BImage moduleIcon = BImage.make((String)"module://icons/x16/module.png");
    public final BBajadocViewer viewer;
    public BajaOnlyToggle bajaOnly;
    public FlattenToggle flatten;
    public ExpandAll expandAll;
    public ExpandAll collapseAll;
    public Depends depends;

    public BajadocCommands(BBajadocViewer viewer) {
        this.viewer = viewer;
    }

    public void init() {
        this.bajaOnly = new BajaOnlyToggle();
        this.flatten = new FlattenToggle();
        this.expandAll = new ExpandAll(true);
        this.collapseAll = new ExpandAll(false);
        this.depends = new Depends();
    }

    public BMenu getViewMenu() {
        BMenu menu = UiLexicon.bajaui().buildMenu("menu.bajadoc.label");
        menu.add("bajaOnly", (Command)this.bajaOnly);
        menu.add("flatten", (Command)this.flatten);
        menu.add("expandAll", (Command)this.expandAll);
        menu.add("collapseAll", (Command)this.collapseAll);
        menu.add("sep0", (BValue)new BSeparator());
        menu.add("depends", (Command)this.depends);
        return menu;
    }

    public void updateToolBar(BToolBar bar) {
        bar.add("bajaOnly", (Command)this.bajaOnly);
        bar.add("flatten", (Command)this.flatten);
        bar.add("depends", (Command)this.depends);
    }

    void reflect(HashMap<Class<?>, Class<?>> map, Class<?> cls, boolean recurse) {
        if (cls == null) {
            return;
        }
        if (cls == Void.TYPE) {
            return;
        }
        while (cls.isArray()) {
            cls = cls.getComponentType();
        }
        if (cls.isPrimitive()) {
            return;
        }
        if (map.get(cls) != null) {
            return;
        }
        map.put(cls, cls);
        this.reflect(map, cls.getSuperclass(), true);
        Class<?>[] ifaces = cls.getInterfaces();
        for (int i = 0; i < ifaces.length; ++i) {
            this.reflect(map, ifaces[i], true);
        }
        if (!recurse) {
            return;
        }
        Constructor<?>[] ctors = cls.getDeclaredConstructors();
        for (int i = 0; i < ctors.length; ++i) {
            Constructor<?> c = ctors[i];
            int mods = c.getModifiers();
            if (!Modifier.isPublic(mods) && !Modifier.isProtected(mods)) continue;
            Class<?>[] params = c.getParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                this.reflect(map, params[j], false);
            }
        }
        Method[] methods = cls.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            int mods = m.getModifiers();
            if (!Modifier.isPublic(mods) && !Modifier.isProtected(mods)) continue;
            this.reflect(map, m.getReturnType(), false);
            Class<?>[] params = m.getParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                this.reflect(map, params[j], false);
            }
        }
        Field[] fields = cls.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            int mods = f.getModifiers();
            if (!Modifier.isPublic(mods) && !Modifier.isProtected(mods)) continue;
            this.reflect(map, f.getType(), false);
        }
    }

    static class NoSelectionRenderer
    extends TableCellRenderer {
        NoSelectionRenderer() {
        }

        public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
            return this.getForeground(cell);
        }

        public BBrush getSelectionBackground(TableCellRenderer.Cell cell) {
            return this.getBackground(cell);
        }
    }

    static class ModuleModel
    extends TableModel {
        BModule[] modules;

        ModuleModel(BModule[] modules) {
            this.modules = modules;
        }

        public int getRowCount() {
            return this.modules.length;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Description";
                }
            }
            return "?";
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.modules[row].getModuleName();
                }
                case 1: {
                    return this.modules[row].getDescription();
                }
            }
            return "?";
        }

        public BImage getRowIcon(int row) {
            return moduleIcon;
        }
    }

    static class ClassModel
    extends TableModel {
        Class<?>[] classes;

        ClassModel(Class<?>[] classes) {
            this.classes = classes;
        }

        public int getRowCount() {
            return this.classes.length;
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Name";
                }
            }
            return "?";
        }

        public Object getValueAt(int row, int col) {
            return this.classes[row].getName();
        }

        public BImage getRowIcon(int row) {
            return classIcon;
        }
    }

    public class Depends
    extends BajadocCommand {
        private boolean expand;

        public Depends() {
            super("commands.bajadoc.depends");
        }

        public CommandArtifact doInvoke() throws Exception {
            ClassDoc doc = (ClassDoc)BajadocCommands.this.viewer.getDoc();
            String module = doc.module();
            String qname = doc.qualifiedName();
            Class cls = module == null ? Class.forName(qname) : Sys.loadClass((String)module, (String)qname);
            HashMap classMap = new HashMap();
            BajadocCommands.this.reflect(classMap, cls, true);
            Object[] classes = classMap.values().toArray(new Class[classMap.size()]);
            SortUtil.sort((Object[])classes);
            HashMap<String, BModule> moduleMap = new HashMap<String, BModule>();
            for (int i = 0; i < classes.length; ++i) {
                BModule m = Sys.getModuleForClass((Class)classes[i]);
                if (m == null) continue;
                moduleMap.put(m.getModuleName(), m);
            }
            Object[] modules = moduleMap.values().toArray(new BModule[moduleMap.size()]);
            SortUtil.sort((Object[])modules);
            BTable moduleTable = new BTable((TableModel)new ModuleModel((BModule[])modules));
            moduleTable.setCellRenderer((TableCellRenderer)new NoSelectionRenderer());
            BTable classTable = new BTable((TableModel)new ClassModel((Class<?>[])classes));
            classTable.setCellRenderer((TableCellRenderer)new NoSelectionRenderer());
            BSplitPane split = new BSplitPane(BOrientation.vertical, 30.0);
            split.setWidget1((BWidget)BTitlePane.makePane((String)"Dependent Modules", (BTable)moduleTable));
            split.setWidget2((BWidget)BTitlePane.makePane((String)"Dependent Classes", (BTable)classTable));
            BConstrainedPane pane = new BConstrainedPane((BWidget)split);
            pane.setFixedSize(500.0, 500.0);
            BDialog.open((BWidget)this.getOwner(), (String)("Dependencies for " + module + ":" + qname), (Object)pane, (int)1);
            return null;
        }
    }

    public class ExpandAll
    extends BajadocCommand {
        private boolean expand;

        public ExpandAll(boolean expand) {
            super(expand ? "commands.bajadoc.expandAll" : "commands.bajadoc.collapseAll");
            this.expand = expand;
        }

        public CommandArtifact doInvoke() throws Exception {
            super.doInvoke();
            BajadocCommands.this.viewer.expandAll(this.expand);
            return null;
        }
    }

    public class FlattenToggle
    extends BajadocToggle {
        public FlattenToggle() {
            super("commands.bajadoc.flatten");
            this.setSelected(BBajadocOptions.make().getFlattenInheritance());
        }

        public CommandArtifact doInvoke() throws Exception {
            super.doInvoke();
            BBajadocOptions.make().setFlattenInheritance(this.isSelected());
            BajadocCommands.this.viewer.reloadViewer();
            return null;
        }
    }

    public class BajaOnlyToggle
    extends BajadocToggle {
        public BajaOnlyToggle() {
            super("commands.bajadoc.bajaOnly");
            this.setSelected(BBajadocOptions.make().getShowBajaOnly());
        }

        public CommandArtifact doInvoke() throws Exception {
            super.doInvoke();
            BBajadocOptions.make().setShowBajaOnly(this.isSelected());
            BajadocCommands.this.viewer.reloadViewer();
            return null;
        }
    }

    public class BajadocCommand
    extends Command {
        public BajadocCommand(String keyBase) {
            super((BWidget)BajadocCommands.this.viewer.getShell(), UiLexicon.bajaui().module, keyBase);
        }
    }

    public class BajadocToggle
    extends ToggleCommand {
        public BajadocToggle(String keyBase) {
            super((BWidget)BajadocCommands.this.viewer.getShell(), UiLexicon.bajaui().module, keyBase);
        }
    }
}

