/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc;

import com.tridium.help.bajadoc.Annotation;
import com.tridium.help.bajadoc.ClassSummary;
import com.tridium.help.bajadoc.DescriptionPart;
import com.tridium.help.bajadoc.Doc;
import com.tridium.help.bajadoc.Tag;
import java.util.Arrays;
import java.util.function.Predicate;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BIcon;

public class PackageDoc
extends Doc {
    public static final BIcon ICON = BIcon.std((String)"folder.png");
    protected String module;
    protected String profile;
    protected String name;
    protected String docModule;
    protected ClassSummary[] classes;
    protected ClassSummary[] classesSorted;
    private ClassSummary[] interfaces;
    private ClassSummary[] interfacesSorted;
    private ClassSummary[] normal;
    private ClassSummary[] normalSorted;
    private ClassSummary[] exceptions;
    private ClassSummary[] exceptionsSorted;
    private ClassSummary[] enums;
    private ClassSummary[] enumsSorted;
    private ClassSummary[] annotationTypes;
    private ClassSummary[] annotationTypesSorted;

    public PackageDoc(String module, String profile, String name, String docModule, ClassSummary[] classes, DescriptionPart[] description, Tag[] tags, Annotation[] annotations) {
        super(description, tags, annotations);
        this.module = module;
        this.profile = profile;
        this.name = name;
        this.docModule = docModule;
        this.classes = classes;
    }

    @Override
    public BIcon icon() {
        return ICON;
    }

    public String module() {
        return this.module;
    }

    public String profile() {
        return this.profile;
    }

    public String modulePart() {
        return this.module + '-' + this.profile;
    }

    public String docModule() {
        return this.docModule;
    }

    public String name() {
        return this.name;
    }

    public ClassSummary[] classes() {
        return this.classes;
    }

    public String toString() {
        return "package " + this.name;
    }

    public ClassSummary[] interfaces() {
        if (this.interfaces == null) {
            this.interfaces = this.filter(ClassSummary::isInterface);
        }
        return this.interfaces;
    }

    public ClassSummary[] normal() {
        if (this.normal == null) {
            this.normal = this.filter(ClassSummary::isNormal);
        }
        return this.normal;
    }

    public ClassSummary[] exceptions() {
        if (this.exceptions == null) {
            this.exceptions = this.filter(ClassSummary::isException);
        }
        return this.exceptions;
    }

    public ClassSummary[] enums() {
        if (this.enums == null) {
            this.enums = this.filter(ClassSummary::isEnum);
        }
        return this.enums;
    }

    public ClassSummary[] annotationTypes() {
        if (this.annotationTypes == null) {
            this.annotationTypes = this.filter(ClassSummary::isAnnotationType);
        }
        return this.annotationTypes;
    }

    private ClassSummary[] filter(Predicate<ClassSummary> p) {
        return (ClassSummary[])Arrays.stream(this.classes()).filter(p).toArray(ClassSummary[]::new);
    }

    public ClassSummary[] interfacesSorted() {
        if (this.interfacesSorted == null) {
            this.interfacesSorted = PackageDoc.sort(this.interfaces());
        }
        return this.interfacesSorted;
    }

    public ClassSummary[] normalSorted() {
        if (this.normalSorted == null) {
            this.normalSorted = PackageDoc.sort(this.normal());
        }
        return this.normalSorted;
    }

    public ClassSummary[] exceptionsSorted() {
        if (this.exceptionsSorted == null) {
            this.exceptionsSorted = PackageDoc.sort(this.exceptions());
        }
        return this.exceptionsSorted;
    }

    public ClassSummary[] classesSorted() {
        if (this.classesSorted == null) {
            this.classesSorted = PackageDoc.sort(this.classes());
        }
        return this.classesSorted;
    }

    public ClassSummary[] enumsSorted() {
        if (this.enumsSorted == null) {
            this.enumsSorted = PackageDoc.sort(this.enums());
        }
        return this.enumsSorted;
    }

    public ClassSummary[] annotationTypesSorted() {
        if (this.annotationTypesSorted == null) {
            this.annotationTypesSorted = PackageDoc.sort(this.annotationTypes());
        }
        return this.annotationTypesSorted;
    }

    private static ClassSummary[] sort(ClassSummary[] list) {
        int len = list.length;
        Object[] keys = new String[len];
        Object[] sorted = new ClassSummary[len];
        for (int i = 0; i < len; ++i) {
            keys[i] = list[i].name();
            sorted[i] = list[i];
        }
        SortUtil.sort((Object[])keys, (Object[])sorted);
        return sorted;
    }
}

