/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help;

import com.tridium.help.HelpSystem;
import com.tridium.help.SearchResult;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BajaRuntimeException;

public class Searcher {
    private static final String DELIM = "\t\n\r\f.,-?;:[](){}!'<>/#$|+=\\/*&\u00a9\u00ae`~@%^";
    public static final String WORDS = "words.dat";
    public static final String WORDDOCS = "worddocs.dat";
    public static final String POSTINGS = "postings.dat";
    public static final String DOCUMENTS = "documents.dat";
    public static final String VERSION = "3.0";
    public static final Set<String> STOP_WORDS = new HashSet<String>();
    private static Searcher instance;
    private Module[] modules;

    public static Searcher getInstance() throws IOException {
        if (instance == null) {
            instance = new Searcher();
        }
        return instance;
    }

    private Searcher() throws IOException {
        ArrayList list = new ArrayList();
        try {
            AccessController.doPrivileged(() -> {
                for (String child : HelpSystem.HELP.list()) {
                    Module m;
                    File file = new File(HelpSystem.HELP, child);
                    if (!file.exists() || !file.isDirectory() || (m = this.loadModule(file)) == null) continue;
                    list.add(m);
                }
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            pae.printStackTrace();
            if (pae.getException() instanceof IOException) {
                throw (IOException)pae.getException();
            }
            throw new BajaRuntimeException((Throwable)pae.getException());
        }
        this.modules = list.toArray(new Module[list.size()]);
    }

    private Module loadModule(File moduleDir) throws IOException {
        try {
            return AccessController.doPrivileged(() -> {
                ArrayList<ModulePartWordMap> partMaps = new ArrayList<ModulePartWordMap>();
                for (String part : moduleDir.list()) {
                    HashMap<String, Integer> wordMap = new HashMap<String, Integer>();
                    String name = part + '/' + WORDS;
                    File file = new File(moduleDir, name);
                    if (!file.exists()) continue;
                    RandomAccessFile wordKeys = this.openFile(moduleDir, name);
                    long len = wordKeys.length();
                    while (wordKeys.getFilePointer() < len) {
                        wordMap.put(wordKeys.readUTF(), wordKeys.readInt());
                    }
                    wordKeys.close();
                    partMaps.add(new ModulePartWordMap(part, wordMap));
                }
                if (!partMaps.isEmpty()) {
                    return new Module(moduleDir.getName(), partMaps);
                }
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            pae.printStackTrace();
            if (pae.getException() instanceof IOException) {
                throw (IOException)pae.getException();
            }
            throw new BajaRuntimeException((Throwable)pae.getException());
        }
    }

    private RandomAccessFile openFile(File dir, String name) throws IOException {
        File file = new File(dir, name);
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        raf.readUTF();
        return raf;
    }

    public SearchResult[] search(String searchStr) throws IOException {
        HashMap<BOrd, int[]> ordMap = new HashMap<BOrd, int[]>();
        String[][] words = this.tokenize(searchStr);
        for (int w = 0; w < words.length; ++w) {
            WordResult[] results;
            for (WordResult result : results = words[w].length == 1 ? this.searchWord(words[w][0]) : this.searchPhrase(words[w])) {
                int[] scores = (int[])ordMap.get(result.ord);
                if (scores == null) {
                    scores = new int[words.length];
                    ordMap.put(result.ord, scores);
                }
                scores[w] = result.len;
            }
        }
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        block2: for (BOrd ord : ordMap.keySet()) {
            int[] scores;
            for (int score : scores = (int[])ordMap.get(ord)) {
                if (score == 0) continue block2;
            }
            results.add(new SearchResult(ord, scores));
        }
        Object[] arr = results.toArray(new SearchResult[results.size()]);
        Arrays.sort(arr);
        return arr;
    }

    private String[][] tokenize(String str) {
        StringBuilder sb = new StringBuilder(TextUtil.toLowerCase((String)str));
        for (int i = 0; i < sb.length(); ++i) {
            if (DELIM.indexOf(sb.charAt(i)) == -1) continue;
            sb.setCharAt(i, ' ');
        }
        int n = 1;
        while (n < sb.length()) {
            if (sb.charAt(n - 1) == ' ') {
                if (sb.charAt(n) == ' ') {
                    sb.deleteCharAt(n);
                    continue;
                }
                ++n;
                continue;
            }
            ++n;
        }
        boolean quotes = false;
        for (int i = 0; i < sb.length(); ++i) {
            if (quotes) {
                if (sb.charAt(i) == '\"') {
                    quotes = false;
                    continue;
                }
                if (sb.charAt(i) != ' ') continue;
                sb.setCharAt(i, '_');
                continue;
            }
            if (sb.charAt(i) != '\"') continue;
            quotes = true;
        }
        n = sb.indexOf("\"");
        while (n != -1) {
            sb.deleteCharAt(n);
            n = sb.indexOf("\"");
        }
        String[] tok1 = TextUtil.split((String)sb.toString().trim(), (char)' ');
        String[][] tok2 = new String[tok1.length][];
        for (int i = 0; i < tok1.length; ++i) {
            tok2[i] = TextUtil.split((String)tok1[i], (char)'_');
            ArrayList list = new ArrayList();
            for (int j = 0; j < tok2[i].length; ++j) {
                if (STOP_WORDS.contains(tok2[i][j])) continue;
                list.add(tok2[i][j]);
            }
            tok2[i] = list.toArray(new String[list.size()]);
        }
        int len = 0;
        for (String[] aTok2 : tok2) {
            if (aTok2.length <= 0) continue;
            ++len;
        }
        String[][] res = new String[len][];
        n = 0;
        for (String[] aTok2 : tok2) {
            if (aTok2.length <= 0) continue;
            res[n++] = aTok2;
        }
        return res;
    }

    private WordResult[] searchWord(String word) throws IOException {
        ArrayList list = new ArrayList();
        word = TextUtil.toLowerCase((String)word);
        for (Module module : this.modules) {
            Collections.addAll(list, this.searchModuleForWord(module, word, false));
        }
        return list.toArray(new WordResult[list.size()]);
    }

    private WordResult[] searchPhrase(String[] phrase) throws IOException {
        ArrayList<WordResult> list = new ArrayList<WordResult>();
        HashMap<BOrd, int[][]> ordMap = new HashMap<BOrd, int[][]>();
        for (int i = 0; i < phrase.length; ++i) {
            String word = TextUtil.toLowerCase((String)phrase[i]);
            for (Module module : this.modules) {
                for (WordResult res : this.searchModuleForWord(module, word, true)) {
                    Object ordWnum = (int[][])ordMap.get(res.ord);
                    if (ordWnum == null) {
                        ordWnum = new int[phrase.length][];
                        ordMap.put(res.ord, (int[][])ordWnum);
                    }
                    ordWnum[i] = res.wnum;
                }
            }
        }
        block3: for (BOrd ord : ordMap.keySet()) {
            int score = 0;
            int[][] wnum = (int[][])ordMap.get(ord);
            for (int i = 0; i < phrase.length; ++i) {
                if (wnum[i] == null) continue block3;
            }
            for (int k = 0; k < wnum[0].length; ++k) {
                int n = wnum[0][k];
                int count = 0;
                for (int i = 1; i < phrase.length; ++i) {
                    for (int j = 0; j < wnum[i].length; ++j) {
                        if (wnum[i][j] != n + i) continue;
                        ++count;
                    }
                }
                if (count != phrase.length - 1) continue;
                ++score;
            }
            if (score <= 0) continue;
            list.add(new WordResult(ord, score, null));
        }
        return list.toArray(new WordResult[list.size()]);
    }

    private WordResult[] searchModuleForWord(Module module, String word, boolean doPostings) throws IOException {
        try {
            return AccessController.doPrivileged(() -> {
                ArrayList<WordResult> list = new ArrayList<WordResult>();
                File moduleDir = new File(HelpSystem.HELP, module.name);
                for (ModulePartWordMap partMap : module.modulePartWordMaps) {
                    String modulePart = partMap.modulePart;
                    Map wordMap = partMap.wordMap;
                    Integer offset = (Integer)wordMap.get(word);
                    if (offset == null) continue;
                    RandomAccessFile wordDocs = this.openFile(moduleDir, modulePart + "/" + WORDDOCS);
                    RandomAccessFile postings = doPostings ? this.openFile(moduleDir, modulePart + "/" + POSTINGS) : null;
                    RandomAccessFile documents = this.openFile(moduleDir, modulePart + "/" + DOCUMENTS);
                    wordDocs.seek(offset.intValue());
                    int size = wordDocs.readShort();
                    for (int j = 0; j < size; ++j) {
                        int docId = wordDocs.readInt();
                        int postId = wordDocs.readInt();
                        int len = wordDocs.readShort();
                        documents.seek(docId);
                        String docName = documents.readUTF();
                        int[] wnum = null;
                        if (doPostings) {
                            postings.seek(postId);
                            wnum = new int[len];
                            for (int i = 0; i < len; ++i) {
                                wnum[i] = postings.readShort();
                            }
                        }
                        list.add(new WordResult(BOrd.make((String)("module://" + module.name + '/' + docName)), len, wnum));
                    }
                    wordDocs.close();
                    if (doPostings) {
                        postings.close();
                    }
                    documents.close();
                }
                return list.toArray(new WordResult[list.size()]);
            });
        }
        catch (PrivilegedActionException e) {
            e.printStackTrace();
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            throw new BajaRuntimeException((Throwable)e.getException());
        }
    }

    static {
        Collections.addAll(STOP_WORDS, "the", "of", "a", "is", "to", "this", "and", "in", "for", "if", "be", "see", "an", "that", "or", "not", "by", "with", "are", "as", "name", "from", "will", "it", "which", "on", "since");
        instance = null;
    }

    private class WordResult {
        private BOrd ord;
        private int len;
        private int[] wnum;

        private WordResult(BOrd ord, int len, int[] wnum) {
            this.ord = ord;
            this.len = len;
            this.wnum = wnum;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(TextUtil.padLeft((String)Integer.toString(this.len), (int)6));
            sb.append("  ").append(this.ord.toString());
            if (this.wnum != null) {
                sb.append("\n        [");
                for (int i = 0; i < this.wnum.length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(this.wnum[i]);
                }
                sb.append("]");
            }
            return sb.toString();
        }
    }

    private static class ModulePartWordMap {
        private final String modulePart;
        private final Map<String, Integer> wordMap;

        private ModulePartWordMap(String modulePart, Map<String, Integer> wordMap) {
            this.modulePart = modulePart;
            this.wordMap = wordMap;
        }
    }

    private static class Module {
        private final String name;
        private final Collection<ModulePartWordMap> modulePartWordMaps;

        private Module(String name, Collection<ModulePartWordMap> modulePartWordMaps) {
            this.name = name;
            this.modulePartWordMaps = modulePartWordMaps;
        }
    }
}

