/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help;

import com.tridium.help.Searcher;
import com.tridium.html.util.HtmlTokenizer;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.baja.nre.util.TextUtil;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class SearchBuilder {
    private static final String DELIM = " \"\t\n\r\f.,-?;:[](){}!'<>/#$|+=\\/*&\u00a9\u00ae`~@%^";
    private Map<String, Map<Integer, List<Integer>>> words = new HashMap<String, Map<Integer, List<Integer>>>();
    private Integer docId;
    private int wnum;
    private HtmlParser htmlParser = new HtmlParser();

    public void build(File base, ZipFile zip) throws Exception {
        this.makeIndex(base, zip);
        this.persist(base);
    }

    private void persist(File base) throws Exception {
        RandomAccessFile dat = this.createRandomAccessFile(base, "words.dat");
        RandomAccessFile wordDocsDat = this.createRandomAccessFile(base, "worddocs.dat");
        RandomAccessFile postingsDat = this.createRandomAccessFile(base, "postings.dat");
        for (String word : this.words.keySet()) {
            Map<Integer, List<Integer>> wordDocs = this.words.get(word);
            dat.writeUTF(word);
            dat.writeInt((int)wordDocsDat.length());
            wordDocsDat.writeShort(wordDocs.size());
            for (Integer docId : wordDocs.keySet()) {
                List<Integer> postings = wordDocs.get(docId);
                wordDocsDat.writeInt(docId);
                wordDocsDat.writeInt((int)postingsDat.length());
                wordDocsDat.writeShort(postings.size());
                for (int i = 0; i < postings.size(); ++i) {
                    postingsDat.writeShort(postings.get(i));
                }
            }
        }
        dat.close();
        wordDocsDat.close();
        postingsDat.close();
        this.words = null;
        System.gc();
    }

    private RandomAccessFile createRandomAccessFile(File base, String name) throws Exception {
        File file = new File(base, name);
        if (file.exists()) {
            file.delete();
        }
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        raf.writeUTF("3.0");
        return raf;
    }

    private void loadWord(String word) {
        if (Searcher.STOP_WORDS.contains(word)) {
            return;
        }
        Map<Integer, List<Integer>> wordDocs = this.words.get(word);
        if (wordDocs == null) {
            wordDocs = new HashMap<Integer, List<Integer>>();
            this.words.put(word, wordDocs);
            ArrayList<Integer> postings = new ArrayList<Integer>();
            wordDocs.put(this.docId, postings);
            postings.add(new Integer(this.wnum++));
        } else {
            List<Integer> postings = wordDocs.get(this.docId);
            if (postings == null) {
                postings = new ArrayList<Integer>();
                wordDocs.put(this.docId, postings);
            }
            postings.add(new Integer(this.wnum++));
        }
    }

    private void loadBajadocElement(XElem parentElm) throws Exception {
        String text = parentElm.string();
        if (text != null) {
            this.htmlParser.parse(text);
        }
        for (int i = 0; i < parentElm.attrSize(); ++i) {
            String name = parentElm.attrName(i);
            if (!name.equals("name") && !name.equals("class") && !name.equals("qualifiedName")) continue;
            this.htmlParser.parse(parentElm.attrValue(i));
        }
        XElem[] kidElms = parentElm.elems();
        for (int i = 0; i < kidElms.length; ++i) {
            this.loadBajadocElement(kidElms[i]);
        }
    }

    private void loadBajadoc(InputStream in) throws Exception {
        XElem rootElem = XParser.make((InputStream)in).parse(false);
        XElem[] kidElms = rootElem.elems();
        for (int i = 0; i < kidElms.length; ++i) {
            this.loadBajadocElement(kidElms[i]);
        }
    }

    private void loadText(InputStream stream) throws Exception {
        String str;
        BufferedReader in = new BufferedReader(new InputStreamReader(stream));
        while ((str = in.readLine()) != null) {
            StringTokenizer parser = new StringTokenizer(TextUtil.toLowerCase((String)HtmlTokenizer.replaceLiterals((String)str)), DELIM);
            while (parser.hasMoreTokens()) {
                this.loadWord(parser.nextToken());
            }
        }
    }

    private void makeIndex(File base, ZipFile zip) throws Exception {
        RandomAccessFile documents = this.createRandomAccessFile(base, "documents.dat");
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!SearchBuilder.isFileTypeForIndexing(name)) continue;
            this.startNextDocument(documents, name);
            BufferedInputStream bin = new BufferedInputStream(zip.getInputStream(entry));
            Throwable throwable = null;
            try {
                this.indexFile(name, bin);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (bin == null) continue;
                if (throwable != null) {
                    try {
                        bin.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                bin.close();
            }
        }
        documents.close();
    }

    private void startNextDocument(RandomAccessFile documents, String name) throws Exception {
        this.docId = this.storeDocument(documents, name);
        this.wnum = 0;
    }

    private static boolean isFileTypeForIndexing(String name) {
        return name.endsWith(".html") || name.endsWith(".bajadoc") || name.endsWith(".java") || name.endsWith(".txt");
    }

    private void indexFile(String name, BufferedInputStream in) throws Exception {
        if (name.endsWith(".html")) {
            this.htmlParser.parse(in, false);
        } else if (name.endsWith(".bajadoc")) {
            this.loadBajadoc(in);
        } else if (name.endsWith(".java") || name.endsWith(".txt")) {
            this.loadText(in);
        }
    }

    private Integer storeDocument(RandomAccessFile documents, String name) throws Exception {
        Integer ofs = new Integer((int)documents.length());
        documents.writeUTF(name);
        return ofs;
    }

    public static void indexSourceDirectory(File src, File dst) {
        if (!src.exists() || !src.isDirectory()) {
            return;
        }
        try {
            SearchBuilder.doIndexSourceDir(src.toPath(), dst.toPath());
        }
        catch (Exception e) {
            System.out.println("index [ERROR: could not index - " + e.getMessage() + ']');
            e.printStackTrace();
        }
    }

    private static void doIndexSourceDir(final Path src, Path dst) throws Exception {
        if (!Files.exists(dst, new LinkOption[0])) {
            Files.createDirectories(dst, new FileAttribute[0]);
        }
        final SearchBuilder builder = new SearchBuilder();
        final RandomAccessFile documents = builder.createRandomAccessFile(dst.toFile(), "documents.dat");
        Files.walkFileTree(src, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                String path = src.relativize(file).toString().replace('\\', '/');
                if (SearchBuilder.isFileTypeForIndexing(path)) {
                    try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(file, StandardOpenOption.READ));){
                        builder.startNextDocument(documents, path);
                        builder.indexFile(path, in);
                    }
                    catch (Exception e) {
                        System.out.println("index [ERROR: failed to index document " + path + ": " + e.getMessage() + ']');
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        builder.persist(dst.toFile());
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            SearchBuilder.usage();
            return;
        }
        try {
            Path dst;
            Path src;
            try {
                src = Paths.get(args[0], new String[0]);
            }
            catch (InvalidPathException e) {
                System.out.print(args[0] + " is not a valid path.");
                return;
            }
            if (!Files.exists(src, new LinkOption[0])) {
                System.out.println(String.format("Source path %s not found.", src.toAbsolutePath()));
                return;
            }
            if (!Files.isDirectory(src, new LinkOption[0])) {
                System.out.println(String.format("Source path %s is not a directory.", src.toAbsolutePath()));
                return;
            }
            try {
                dst = Paths.get(args[1], new String[0]);
            }
            catch (InvalidPathException e) {
                System.out.print(args[1] + " is not a valid path.");
                return;
            }
            SearchBuilder.doIndexSourceDir(src, dst);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("usage: java com.tridium.help.SearchBuilder <srcdir> <destdir>");
        System.out.println("parameters:");
        System.out.println("srcdir         source directory containing files to index");
        System.out.println("destdir        destination directory for index data files");
    }

    private class HtmlParser
    extends HtmlTokenizer {
        private HtmlParser() {
        }

        public void handleText(String str) {
            StringTokenizer parser = new StringTokenizer(TextUtil.toLowerCase((String)HtmlParser.replaceLiterals((String)str)), SearchBuilder.DELIM);
            while (parser.hasMoreTokens()) {
                SearchBuilder.this.loadWord(parser.nextToken());
            }
        }

        public void handleComment(String str) {
        }

        public void handleStartTag(int row, String str, Map<String, String> attribs) {
        }

        public void handleEndTag(int row, String str) {
        }
    }
}

