/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help;

import com.tridium.help.SearchLoader;
import com.tridium.sys.Nre;
import com.tridium.sys.module.NModule;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.registry.ModuleInfo;
import javax.baja.sys.BModule;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Sys;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.util.UiLexicon;

public abstract class HelpSystem {
    static final File HELP = new File(Sys.getNiagaraUserHome(), "help");
    private static final File REGISTRY_CHK = new File(Sys.getNiagaraUserHome(), "registry/registry.chk");
    private static final boolean SEARCH_ALL_MODULE_PARTS = AccessController.doPrivileged(() -> Boolean.getBoolean("help.searchAllModuleParts"));

    public static void load(BWidget owner, Consumer<Boolean> onComplete) {
        SearchLoader loader = new SearchLoader();
        loader.setOnComplete(onComplete);
        BProgressDialog.open((BWidget)owner, (String)UiLexicon.bajaui().getText("help.load.title"), (BProgressDialog.Worker)loader, (BImage)BImage.make((String)"module://icons/x32/question.png"));
    }

    public static boolean exists() {
        return AccessController.doPrivileged(HELP::exists);
    }

    public static boolean upToDate() {
        return AccessController.doPrivileged(() -> {
            if (!REGISTRY_CHK.exists()) {
                return false;
            }
            return REGISTRY_CHK.lastModified() < HELP.lastModified();
        });
    }

    public static String[] getModulesHavingFile(String filePathBody) {
        return (String[])HelpSystem.getModulesForHelp().filter(m -> m.getZipFile().getEntry(filePathBody) != null).map(m -> m.getModuleName()).sorted().toArray(String[]::new);
    }

    public static BufferedInputStream getJarEntryInputStream(String moduleName, String entryName) {
        try {
            BModule module = Sys.loadModule((String)moduleName);
            BIFileStore entry = module.findStore(new FilePath(entryName));
            if (entry != null) {
                return new BufferedInputStream(entry.getInputStream());
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    static Stream<NModule> getModulesForHelp() {
        return Arrays.stream(Sys.getRegistry().getModules()).filter(m -> RuntimeProfile.doc == m.getRuntimeProfile() || SEARCH_ALL_MODULE_PARTS).map(m -> HelpSystem.loadModulePart(m)).filter(m -> m != null);
    }

    private static NModule loadModulePart(ModuleInfo info) {
        try {
            return AccessController.doPrivileged(() -> Nre.getModuleManager()).loadDependency(info.getModulePartName());
        }
        catch (ModuleException moduleException) {
            return null;
        }
    }
}

