/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256.ui;

import com.tridium.andoverAC256.BAndoverDevice;
import com.tridium.andoverAC256.datatypes.BAndoverPointDiscoveryConfig;
import com.tridium.andoverAC256.datatypes.BPrintStatusReadings;
import com.tridium.andoverAC256.job.BAndoverDiscoveryPoint;
import com.tridium.andoverAC256.point.BAndoverBooleanProxyExt;
import com.tridium.andoverAC256.point.BAndoverEnumProxyExt;
import com.tridium.andoverAC256.point.BAndoverNumericProxyExt;
import com.tridium.andoverAC256.point.BAndoverPointDeviceExt;
import com.tridium.andoverAC256.point.BAndoverProxyExt;
import com.tridium.andoverAC256.point.BAndoverStringProxyExt;
import java.util.Vector;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringPoint;
import javax.baja.control.BStringWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BAndoverPointManager
extends BPointManager {
    public static final Type TYPE = Sys.loadType(BAndoverPointManager.class);
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type(3);
    MgrColumn colValue = new MgrColumn.ToString(lexicon.getText("point.columnTitle.value"), 0);
    MgrColumn colFacets = new MgrColumn.Prop(BControlPoint.facets, 3);
    MgrColumn colFaultCause = new MgrColumn.PropPath(lexicon.getText("point.columnTitle.faultCause"), new Property[]{BControlPoint.proxyExt, BAndoverProxyExt.faultCause}, 4);
    MgrColumn colEnabled = new MgrColumn.PropPath(lexicon.getText("point.columnTitle.enabled"), new Property[]{BControlPoint.proxyExt, BAndoverProxyExt.enabled}, 6);
    MgrColumn colReadValue = new MgrColumn.PropPath(lexicon.getText("point.columnTitle.readValue"), new Property[]{BControlPoint.proxyExt, BAndoverProxyExt.readValue}, 6);
    MgrColumn colWriteValue = new MgrColumn.PropPath(lexicon.getText("point.columnTitle.writeValue"), new Property[]{BControlPoint.proxyExt, BAndoverProxyExt.writeValue}, 6);
    MgrColumn colAssignedName = new MgrColumn.PropPath(lexicon.getText("point.columnTitle.assignedName"), new Property[]{BControlPoint.proxyExt, BAndoverProxyExt.assignedName}, 1);
    MgrColumn colRawValue = new MgrColumn.PropPath(lexicon.getText("point.columnTitle.rawValue"), new Property[]{BControlPoint.proxyExt, BAndoverProxyExt.rawValue}, 1);
    MgrColumn colOrigin = new MgrColumn.PropPath(lexicon.getText("point.columnTitle.origin"), new Property[]{BControlPoint.proxyExt, BAndoverProxyExt.pointOrigin}, 1);
    MgrColumn colPointNotes = new MgrColumn.PropPath(lexicon.getText("point.columnTitle.pointNotes"), new Property[]{BControlPoint.proxyExt, BAndoverProxyExt.pointNotes}, 1);
    MgrColumn[] cols = new MgrColumn[]{this.colPath, this.colName, this.colType, this.colValue, this.colFacets, this.colFaultCause, this.colEnabled, this.colReadValue, this.colWriteValue, this.colAssignedName, this.colRawValue, this.colOrigin, this.colPointNotes};
    static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BAndoverPointManager.class);
    private BAndoverPointDeviceExt deviceExt;

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new AndoverPointModel();
    }

    protected MgrLearn makeLearn() {
        return new AndoverPointLearn();
    }

    protected MgrController makeController() {
        return new AndoverPointController();
    }

    public BAndoverPointDeviceExt getDeviceExt() {
        if (this.deviceExt == null) {
            this.deviceExt = (BAndoverPointDeviceExt)((BIPointFolder)this.getCurrentValue()).getDeviceExt();
        }
        return this.deviceExt;
    }

    public BAndoverDevice getDevice() {
        return (BAndoverDevice)this.getDeviceExt().getDevice();
    }

    private void updateDiscoveryRows(BJob discoveryJob) {
        Object[] discoveredRows = (BAndoverDiscoveryPoint[])discoveryJob.getChildren(BAndoverDiscoveryPoint.class);
        if (discoveredRows != null) {
            for (int i = 0; i < discoveredRows.length; ++i) {
                discoveredRows[i] = (BAndoverDiscoveryPoint)discoveredRows[i].newCopy();
            }
            this.getLearn().updateRoots(discoveredRows);
        }
    }

    public void doLoadValue(BObject obj, Context cx) {
        super.doLoadValue(obj, cx);
    }

    class AndoverPointController
    extends PointController {
        public AndoverPointController() {
            super((BPointManager)BAndoverPointManager.this);
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            super.doDiscover(cx);
            BPrintStatusReadings readings = BAndoverPointManager.this.getDevice().getPrintStatusReadings();
            readings.lease();
            int ious = readings.getNumberAttachedIOUs();
            int lcus = readings.getNumberLCUs();
            BAndoverPointDiscoveryConfig config = new BAndoverPointDiscoveryConfig();
            if (ious > 0) {
                config.getIou().setStartAddress(1);
            }
            config.getIou().setStopAddress(ious);
            if (lcus > 0) {
                config.getLcu().setStartAddress(1);
            }
            config.getLcu().setStopAddress(lcus);
            BAndoverPointDiscoveryConfig params = (BAndoverPointDiscoveryConfig)BWbFieldEditor.dialog((BWidget)this.getManager(), (String)lexicon.get("point.discover.configDialog"), (BObject)config);
            if (params == null) {
                return null;
            }
            BOrd ordToDiscoveryJob = BAndoverPointManager.this.getDevice().submitDiscoverPointsJob(params);
            BAndoverPointManager.this.getLearn().setJob(ordToDiscoveryJob);
            return null;
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            MgrController.IMgrCommand[] ancestor = super.makeCommands();
            Vector<MgrController.IMgrCommand> vret = new Vector<MgrController.IMgrCommand>(ancestor.length - 1);
            for (int i = 0; i < ancestor.length; ++i) {
                if (ancestor[i] == this.match || ancestor[i] == this.quickMatch) continue;
                vret.addElement(ancestor[i]);
            }
            Object[] ret = new MgrController.IMgrCommand[vret.size()];
            vret.copyInto(ret);
            return ret;
        }
    }

    class AndoverPointLearn
    extends MgrLearn {
        AndoverPointLearn() {
            super((BAbstractManager)BAndoverPointManager.this);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn("assignedName"){

                public Object get(Object row) {
                    return ((BAndoverDiscoveryPoint)row).getAssignedName();
                }
            }, new MgrColumn("rawValue"){

                public Object get(Object row) {
                    return ((BAndoverDiscoveryPoint)row).getValueString();
                }
            }, new MgrColumn("origin"){

                public Object get(Object row) {
                    return ((BAndoverDiscoveryPoint)row).getOrigin();
                }
            }, new MgrColumn("notes"){

                public Object get(Object row) {
                    return ((BAndoverDiscoveryPoint)row).getPointNotes();
                }
            }};
        }

        public MgrTypeInfo[] toTypes(Object discovery) {
            BAndoverDiscoveryPoint dp = (BAndoverDiscoveryPoint)discovery;
            if (dp.getValueString().trim().equalsIgnoreCase("-ON")) {
                return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BEnumPoint.TYPE), MgrTypeInfo.make((Type)BEnumWritable.TYPE), MgrTypeInfo.make((Type)BNumericPoint.TYPE), MgrTypeInfo.make((Type)BNumericWritable.TYPE), MgrTypeInfo.make((Type)BBooleanPoint.TYPE), MgrTypeInfo.make((Type)BBooleanWritable.TYPE), MgrTypeInfo.make((Type)BStringPoint.TYPE), MgrTypeInfo.make((Type)BStringWritable.TYPE)};
            }
            if (dp.getValueString().trim().equalsIgnoreCase("ON") || dp.getValueString().trim().equalsIgnoreCase("OFF")) {
                return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BBooleanPoint.TYPE), MgrTypeInfo.make((Type)BBooleanWritable.TYPE), MgrTypeInfo.make((Type)BNumericPoint.TYPE), MgrTypeInfo.make((Type)BNumericWritable.TYPE), MgrTypeInfo.make((Type)BEnumPoint.TYPE), MgrTypeInfo.make((Type)BEnumWritable.TYPE), MgrTypeInfo.make((Type)BStringPoint.TYPE), MgrTypeInfo.make((Type)BStringWritable.TYPE)};
            }
            try {
                String dps = dp.getValueString().trim();
                if (dps.startsWith("-")) {
                    dps = dps.substring(1).trim();
                }
                Double.parseDouble(dps);
                return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BNumericPoint.TYPE), MgrTypeInfo.make((Type)BNumericWritable.TYPE), MgrTypeInfo.make((Type)BEnumPoint.TYPE), MgrTypeInfo.make((Type)BEnumWritable.TYPE), MgrTypeInfo.make((Type)BBooleanPoint.TYPE), MgrTypeInfo.make((Type)BBooleanWritable.TYPE), MgrTypeInfo.make((Type)BStringPoint.TYPE), MgrTypeInfo.make((Type)BStringWritable.TYPE)};
            }
            catch (NumberFormatException numberFormatException) {
                return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BStringPoint.TYPE), MgrTypeInfo.make((Type)BStringWritable.TYPE), MgrTypeInfo.make((Type)BEnumPoint.TYPE), MgrTypeInfo.make((Type)BEnumWritable.TYPE), MgrTypeInfo.make((Type)BBooleanPoint.TYPE), MgrTypeInfo.make((Type)BBooleanWritable.TYPE), MgrTypeInfo.make((Type)BNumericPoint.TYPE), MgrTypeInfo.make((Type)BNumericWritable.TYPE)};
            }
        }

        public void toRow(Object discovered, MgrEditRow row) {
            BAndoverDiscoveryPoint discPt = (BAndoverDiscoveryPoint)discovered;
            row.setDefaultName(SlotPath.escape((String)discPt.getAssignedName()));
            row.setCell(BAndoverPointManager.this.colAssignedName, (BValue)BString.make((String)discPt.getAssignedName()));
            row.setCell(BAndoverPointManager.this.colRawValue, (BValue)BString.make((String)discPt.getValueString()));
            row.setCell(BAndoverPointManager.this.colOrigin, (BValue)BString.make((String)discPt.getOrigin()));
            row.setCell(BAndoverPointManager.this.colPointNotes, (BValue)BString.make((String)discPt.getPointNotes()));
        }

        public boolean isMatchable(Object discovery, BComponent database) {
            return false;
        }

        public boolean isExisting(Object dis, BComponent comp) {
            if (comp instanceof BControlPoint) {
                BAndoverDiscoveryPoint dp = (BAndoverDiscoveryPoint)dis;
                BControlPoint cp = (BControlPoint)comp;
                BAbstractProxyExt p = cp.getProxyExt();
                if (p instanceof BAndoverProxyExt) {
                    BAndoverProxyExt ape = (BAndoverProxyExt)p;
                    return ape.getAssignedName() == dp.getAssignedName();
                }
            }
            return false;
        }

        public void jobComplete(BJob job) {
            super.jobComplete(job);
            BAndoverPointManager.this.updateDiscoveryRows(job);
        }
    }

    class AndoverPointModel
    extends PointModel {
        AndoverPointModel() {
            super((BPointManager)BAndoverPointManager.this);
        }

        protected MgrColumn[] makeColumns() {
            return BAndoverPointManager.this.cols;
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BControlPoint pt = (BControlPoint)type.newInstance();
            BNullProxyExt ext = new BNullProxyExt();
            if (pt instanceof BBooleanPoint) {
                ext = new BAndoverBooleanProxyExt("");
            } else if (pt instanceof BNumericPoint) {
                ext = new BAndoverNumericProxyExt("");
            } else if (pt instanceof BEnumPoint) {
                ext = new BAndoverEnumProxyExt("");
            } else if (pt instanceof BStringPoint) {
                ext = new BAndoverStringProxyExt("");
            }
            if (ext instanceof BProxyExt) {
                BFacets deviceFacets = (BFacets)pt.getFacets().newCopy();
                ((BProxyExt)ext).setDeviceFacets(deviceFacets);
            }
            pt.setProxyExt((BAbstractProxyExt)ext);
            return pt;
        }
    }
}

