/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nss.dashboard;

import com.tridium.json.JSONObject;
import com.tridium.nss.dashboard.BIStationSecurityDashboard;
import com.tridium.nss.dashboard.BISystemSecurityDashboard;
import com.tridium.nss.dashboard.DashboardException;
import com.tridium.nss.dashboard.InvalidDashboardOrdException;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.util.LexiconModule;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class SecurityDashboardServlet
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger("securityDashboard");
    private static final LexiconModule LEX = LexiconModule.make(SecurityDashboardServlet.class);
    private static final String NO_HTTP_KEY = "servlet.noHTTP";
    private static final String NO_ORD_KEY = "servlet.noOrd";
    private static final String ORD_PARAM = "ord";
    private static final String TIMESTAMP_PARAM = "lastDataTimestamp";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        SecurityDashboardServlet.handleRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        SecurityDashboardServlet.handleRequest(req, resp);
    }

    private static void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Context cx = (Context)req.getAttribute("niagara.context");
        try {
            if (!req.isSecure()) {
                resp.sendError(403, LEX.get(NO_HTTP_KEY, cx));
                return;
            }
            String ord = req.getParameter(ORD_PARAM);
            if (ord == null) {
                resp.sendError(400, LEX.get(NO_ORD_KEY, cx));
                return;
            }
            OrdTarget target = BOrd.make((String)ord).resolve((BObject)Sys.getStation(), cx);
            if (!target.canRead()) {
                resp.sendError(404);
                return;
            }
            String referer = req.getHeader("Referer");
            cx = referer != null && !referer.isEmpty() && referer.toLowerCase(Locale.ENGLISH).contains("bajaux") ? new BasicContext(cx, BFacets.make((String)"workbenchBrowser", (boolean)true)) : new BasicContext(cx, BFacets.make((String)"workbenchBrowser", (boolean)false));
            resp.setContentType("application/json");
            boolean handled = false;
            if (req.getMethod().equalsIgnoreCase("GET")) {
                handled = SecurityDashboardServlet.handleGetRequest(req, resp, cx);
            } else if (req.getMethod().equalsIgnoreCase("POST")) {
                handled = SecurityDashboardServlet.handlePostRequest(req, resp, cx);
            }
            if (!handled) {
                resp.sendError(404);
            }
        }
        catch (InvalidDashboardOrdException e) {
            resp.sendError(400, e.getGenericErrorMessage(cx));
            e.log(cx);
        }
        catch (DashboardException e) {
            resp.sendError(404);
            e.log(cx);
        }
        catch (Exception e) {
            resp.sendError(404);
            LOGGER.log(Level.FINE, "Could not handle dashboard servlet request. Cause is: " + e.getMessage(), e);
        }
    }

    private static boolean handleGetRequest(HttpServletRequest req, HttpServletResponse resp, Context cx) throws IOException, DashboardException {
        String requestURI = req.getRequestURI().toLowerCase(Locale.ENGLISH);
        if (requestURI.equals("/nss/dashboardstatus")) {
            JSONObject jsonObject = SecurityDashboardServlet.getDashboardStatus(req, cx);
            jsonObject.write((Writer)resp.getWriter());
            resp.getWriter().flush();
            return true;
        }
        if (requestURI.equals("/nss/station/data")) {
            JSONObject jsonObject = SecurityDashboardServlet.getStationDashboardData(req, cx);
            jsonObject.write((Writer)resp.getWriter());
            resp.getWriter().flush();
            return true;
        }
        if (requestURI.equals("/nss/system/data")) {
            resp.setHeader("transfer-encoding", "chunked");
            JSONObject jsonObject = SecurityDashboardServlet.getSystemDataAll(req, cx);
            jsonObject.write((Writer)resp.getWriter());
            resp.getWriter().flush();
            return true;
        }
        if (requestURI.startsWith("/nss/system/data/station")) {
            JSONObject jsonObject = SecurityDashboardServlet.getSystemDataSingle(req, cx);
            jsonObject.write((Writer)resp.getWriter());
            resp.getWriter().flush();
            return true;
        }
        return false;
    }

    private static String getStationName(String uri) {
        int lastSlash = uri.lastIndexOf(47);
        return uri.substring(lastSlash + 1);
    }

    private static JSONObject getDashboardStatus(HttpServletRequest req, Context cx) throws DashboardException {
        String ord = req.getParameter(ORD_PARAM);
        OrdTarget target = BOrd.make((String)ord).resolve((BObject)Sys.getStation(), cx);
        BComponent component = target.getComponent();
        return SecurityDashboardServlet.getDashboardStatusForComponent(component, cx).orElseThrow(() -> new InvalidDashboardOrdException(target.toString() + " must be a BIStationSecurityDashboard or BISystemSecurityDashboard.", false));
    }

    private static Optional<JSONObject> getDashboardStatusForComponent(BComponent component, Context cx) {
        if (!(component instanceof BISystemSecurityDashboard) && !(component instanceof BIStationSecurityDashboard)) {
            return Optional.empty();
        }
        JSONObject status = new JSONObject();
        status.put("version", 1);
        status.put("stationDashboardStatus", (Object)(component instanceof BIStationSecurityDashboard ? SecurityDashboardServlet.convertToStatus(((BIStationSecurityDashboard)component).isStationDashboardEnabled()) : "notSupported"));
        status.put("systemDashboardStatus", (Object)(component instanceof BISystemSecurityDashboard ? SecurityDashboardServlet.convertToStatus(((BISystemSecurityDashboard)component).isSystemDashboardEnabled()) : "notSupported"));
        return Optional.of(status);
    }

    private static String convertToStatus(boolean enabled) {
        return enabled ? "enabled" : "disabled";
    }

    private static JSONObject getStationDashboardData(HttpServletRequest req, Context cx) throws DashboardException {
        String ord = req.getParameter(ORD_PARAM);
        OrdTarget target = BOrd.make((String)ord).resolve((BObject)Sys.getStation(), cx);
        BComponent component = target.getComponent();
        if (component instanceof BIStationSecurityDashboard) {
            BIStationSecurityDashboard dashboard = (BIStationSecurityDashboard)component;
            return dashboard.getStationDashboardData(cx);
        }
        throw new InvalidDashboardOrdException(target.toString() + " must be a BIStationSecurityDashboard.", false);
    }

    private static JSONObject getSystemDataAll(HttpServletRequest req, Context cx) throws DashboardException {
        String ord = req.getParameter(ORD_PARAM);
        OrdTarget target = BOrd.make((String)ord).resolve((BObject)Sys.getStation(), cx);
        BComponent component = target.getComponent();
        if (component instanceof BISystemSecurityDashboard) {
            BISystemSecurityDashboard systemDashboard = (BISystemSecurityDashboard)component;
            return systemDashboard.getSystemDashboardData(cx);
        }
        throw new InvalidDashboardOrdException(target.toString() + " must be a BISystemSecurityDashboard.", true);
    }

    private static JSONObject getSystemDataSingle(HttpServletRequest req, Context cx) throws DashboardException {
        String ord = req.getParameter(ORD_PARAM);
        OrdTarget target = BOrd.make((String)ord).resolve((BObject)Sys.getStation(), cx);
        BComponent component = target.getComponent();
        if (component instanceof BISystemSecurityDashboard) {
            BISystemSecurityDashboard systemDashboard = (BISystemSecurityDashboard)component;
            String stationName = SecurityDashboardServlet.getStationName(req.getRequestURI());
            String timestamp = req.getParameter(TIMESTAMP_PARAM);
            return systemDashboard.getSystemDashboardDataForStation(stationName, timestamp, cx);
        }
        throw new InvalidDashboardOrdException(target.toString() + " must be a BISystemSecurityDashboard.", true);
    }

    private static boolean handlePostRequest(HttpServletRequest req, HttpServletResponse resp, Context cx) throws IOException, DashboardException {
        String requestURI = req.getRequestURI().toLowerCase(Locale.ENGLISH);
        if (requestURI.startsWith("/nss/system/refresh/station")) {
            JSONObject jsonObject = SecurityDashboardServlet.refreshSystemDataForStation(req, cx);
            jsonObject.write((Writer)resp.getWriter());
            return true;
        }
        return false;
    }

    private static JSONObject refreshSystemDataForStation(HttpServletRequest req, Context cx) throws DashboardException {
        String ord = req.getParameter(ORD_PARAM);
        OrdTarget target = BOrd.make((String)ord).resolve((BObject)Sys.getStation(), cx);
        BComponent component = target.getComponent();
        if (component instanceof BISystemSecurityDashboard) {
            BISystemSecurityDashboard dashboard = (BISystemSecurityDashboard)component;
            String stationName = SecurityDashboardServlet.getStationName(req.getRequestURI());
            return dashboard.refreshSystemDashboardDataForStation(stationName, cx);
        }
        throw new InvalidDashboardOrdException(target.toString() + " must be a BISystemSecurityDashboard.", true);
    }
}

