/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nss.dashboard;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.json.JSONObject;
import com.tridium.nre.security.Aes256PasswordManager;
import com.tridium.nre.security.ISecretBytesSupplier;
import com.tridium.nre.security.SecretBytes;
import com.tridium.nss.BSecurityService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.SecureRandom;
import java.util.Optional;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PasswordEncodingContext;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public class BFoxSecurityDashboardChannel
extends BFoxChannel {
    public static final Type TYPE = Sys.loadType(BFoxSecurityDashboardChannel.class);
    private static final String STATUS = "status";
    private static final String STATUS_SUCCESS = "success";
    private static final String STATUS_FAILED = "failed";
    private static final String FAILURE_CAUSE = "failureCause";
    private static final String IV = "iv";

    public Type getType() {
        return TYPE;
    }

    public BFoxSecurityDashboardChannel() {
        super("securityDashboard");
    }

    public FoxResponse process(FoxRequest req) throws Throwable {
        throw new InvalidCommandException(req.command);
    }

    public void circuitOpened(FoxCircuit circuit) throws Throwable {
        if (!"getStationDashboardInfo".equals(circuit.command)) {
            throw new InvalidCommandException(circuit.command);
        }
        this.getStationDashboardInfo(circuit);
    }

    protected boolean useSharedKeyEncryption() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getStationDashboardInfo(FoxCircuit circuit) throws Exception {
        try {
            Context context = circuit.session().getSessionContext();
            Optional service = Sys.findService((Type)BSecurityService.TYPE);
            BSecurityService securityService = (BSecurityService)service.orElseThrow(() -> new IllegalStateException(Lexicon.make((String)"nss").get("foxDashboardChannel.noSecurityService")));
            if (!securityService.getEnabled()) {
                throw new IllegalStateException(Lexicon.make((String)"nss").get("foxDashboardChannel.noSecurityService"));
            }
            try {
                JSONObject stationSecurityDashboardData = securityService.getStationDashboardData(context);
                byte[] dashboardData = stationSecurityDashboardData.toString().getBytes(StandardCharsets.UTF_8);
                byte[] iv = new byte[16];
                new SecureRandom().nextBytes(iv);
                byte[] encryptedDashboardData = this.encryptData(dashboardData, iv);
                FoxMessage metadata = new FoxMessage();
                metadata.add(STATUS, STATUS_SUCCESS);
                metadata.add(IV, iv);
                circuit.writeMessage(metadata);
                circuit.getOutputStream().write(encryptedDashboardData);
            }
            catch (Exception e) {
                FoxMessage metadata = new FoxMessage();
                metadata.add(STATUS, STATUS_FAILED);
                metadata.add(FAILURE_CAUSE, e.getMessage());
                circuit.writeMessage(metadata);
            }
        }
        finally {
            circuit.close();
        }
    }

    protected JSONObject getStationDashboardInfo() throws Exception {
        FoxCircuit circuit = this.openCircuit("getStationDashboardInfo");
        FoxMessage response = circuit.readMessage();
        switch (response.getString(STATUS)) {
            case "success": {
                try {
                    byte[] iv = response.getBlob(IV);
                    byte[] encryptedDashData = this.readAllBytes(circuit.getInputStream());
                    byte[] dashboardData = this.decryptData(encryptedDashData, iv);
                    return new JSONObject(new String(dashboardData, StandardCharsets.UTF_8));
                }
                catch (Exception e) {
                    throw new Exception(Lexicon.make((String)"nss").getText("foxDashboardChannel.remoteSuccess.localFail", new Object[]{e.getMessage()}), e);
                }
            }
            case "failed": {
                String message = response.getString(FAILURE_CAUSE);
                throw new Exception(Lexicon.make((String)"nss").getText("foxDashboardChannel.getDashboardDataFailed", new Object[]{message}));
            }
        }
        throw new Exception(Lexicon.make((String)"nss").get("foxDashboardChannel.unknownResponse"));
    }

    private byte[] encryptData(byte[] data, byte[] iv) throws Exception {
        PasswordEncodingContext encodingContext = (PasswordEncodingContext)this.makeEncodingContext((Context)new BasicContext());
        Optional encryptionKeySupplier = AccessController.doPrivileged(() -> ((PasswordEncodingContext)encodingContext).getEncryptionKey());
        byte[] encryptionKey = ((SecretBytes)((ISecretBytesSupplier)encryptionKeySupplier.orElseThrow(() -> new SecurityException("Failed to acquire fox session shared encryption key"))).get()).get();
        return Aes256PasswordManager.encrypt((byte[])data, (byte[])iv, (byte[])encryptionKey, (String)this.getAesTransformation());
    }

    private byte[] decryptData(byte[] encryptedData, byte[] iv) throws Exception {
        PasswordEncodingContext encodingContext = (PasswordEncodingContext)this.makeEncodingContext((Context)new BasicContext());
        Optional encryptionKeySupplier = AccessController.doPrivileged(() -> ((PasswordEncodingContext)encodingContext).getEncryptionKey());
        byte[] encryptionKey = ((SecretBytes)((ISecretBytesSupplier)encryptionKeySupplier.orElseThrow(() -> new SecurityException("Failed to acquire fox session shared encryption key"))).get()).get();
        return Aes256PasswordManager.decrypt((byte[])encryptionKey, (byte[])encryptedData, (byte[])iv, (String)this.getAesTransformation());
    }

    private byte[] readAllBytes(InputStream inputStream) throws IOException {
        int numRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[8192];
        while ((numRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, numRead);
        }
        return buffer.toByteArray();
    }
}

