/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nss;

import com.tridium.nss.BCertificateInfo;
import java.security.cert.X509Certificate;
import javax.baja.control.BNumericPoint;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3)
public class BCertificateExpiryPoint
extends BNumericPoint {
    public static final Property faultCause = BCertificateExpiryPoint.newProperty((int)3, (String)"", null);
    public static final Type TYPE = Sys.loadType(BCertificateExpiryPoint.class);
    private static final Lexicon lex = Lexicon.make(BCertificateExpiryPoint.class);

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BCertificateInfo;
    }

    public BCertificateInfo getParentCertificate() {
        BComplex parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return (BCertificateInfo)parent.as(BCertificateInfo.class);
    }

    public void onExecute(BStatusValue out, Context cx) {
        BCertificateInfo parent = this.getParentCertificate();
        if (parent == null || parent.getAlias() == null || parent.getAlias().isEmpty()) {
            out.setStatus(BStatus.makeDisabled((BStatus)out.getStatus(), (boolean)true));
        } else {
            out.setStatus(BStatus.makeDisabled((BStatus)out.getStatus(), (boolean)false));
            try {
                X509Certificate certificate = parent.getCertificate();
                if (certificate == null) {
                    throw new IllegalArgumentException(lex.getText("certificateInfo.certNotFound", new Object[]{parent.getAlias()}));
                }
                BAbsTime notAfter = BAbsTime.make((long)certificate.getNotAfter().getTime(), (BTimeZone)BTimeZone.GMT);
                BRelTime delta = BAbsTime.now().delta(notAfter);
                ((BStatusNumeric)out).setValue((double)delta.getDays());
                if (notAfter.isBefore(BAbsTime.now())) {
                    out.setStatus(BStatus.makeDown((BStatus)out.getStatus(), (boolean)true));
                    this.setFaultCause(lex.get("certificateInfo.expired"));
                } else {
                    out.setStatus(BStatus.makeDown((BStatus)out.getStatus(), (boolean)false));
                    this.setFaultCause("");
                }
            }
            catch (Exception e) {
                out.setStatus(BStatus.makeFault((BStatus)out.getStatus(), (boolean)true));
                this.setFaultCause(lex.getText("certificateInfo.couldNotGetCert", new Object[]{parent.getAlias(), e.getMessage()}));
            }
        }
    }
}

