/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tunnel;

import com.tridium.tunnel.BTunnelConnection;
import com.tridium.tunnel.BTunnelService;
import java.io.IOException;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BTunnel
extends BComponent
implements BIStatus {
    public static final Property enabled = BTunnel.newProperty((int)0, (boolean)true, null);
    public static final Property connections = BTunnel.newProperty((int)67, (int)0, null);
    public static final Property status = BTunnel.newProperty((int)67, (BValue)BStatus.ok, null);
    public static final Action disconnectAll = BTunnel.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType(BTunnel.class);
    private boolean engaged = false;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public int getConnections() {
        return this.getInt(connections);
    }

    public void setConnections(int v) {
        this.setInt(connections, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public void disconnectAll() {
        this.invoke(disconnectAll, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context c) {
        if (c != Context.decoding && p == enabled) {
            this.update();
        }
        super.changed(p, c);
    }

    public void doDisconnectAll() {
        BTunnelConnection[] kids = (BTunnelConnection[])this.getChildren(BTunnelConnection.class);
        int i = kids.length;
        while (--i >= 0) {
            kids[i].disconnect();
        }
    }

    public BTunnelConnection[] getTunnelConnectionsArray() {
        BTunnelConnection[] kids = (BTunnelConnection[])this.getChildren(BTunnelConnection.class);
        return kids;
    }

    public BIcon getIcon() {
        return BTunnelService.icon;
    }

    public abstract String getIdentifier();

    public boolean isChildLegal(BComponent c) {
        return c instanceof BTunnelConnection;
    }

    public abstract void service(BTunnelConnection var1) throws IOException;

    public abstract void sessionClosed(BTunnelConnection var1);

    public void started() throws Exception {
        super.started();
        this.update();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.unregister();
    }

    public abstract boolean supportsConcurrentConnections();

    protected void update() {
        if (!this.getEnabled()) {
            this.setStatus(BStatus.disabled);
            this.unregister();
            this.disconnectAll();
        } else {
            this.setStatus(BStatus.ok);
            this.register();
        }
    }

    protected void register() {
        if (this.engaged) {
            return;
        }
        if (!this.getEnabled()) {
            return;
        }
        try {
            BTunnelService service = (BTunnelService)Sys.getService((Type)BTunnelService.TYPE);
            service.register(this);
            this.engaged = true;
        }
        catch (Exception x) {
            this.setStatus(BStatus.fault);
            Log.getLog((String)SlotPath.unescape((String)this.toPathString())).error(this.toPathString(), (Throwable)x);
        }
    }

    protected void unregister() {
        if (!this.engaged) {
            return;
        }
        try {
            BTunnelService service = (BTunnelService)Sys.getService((Type)BTunnelService.TYPE);
            service.unregister(this);
            this.engaged = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addConnection(BTunnelConnection session) {
        BTunnel bTunnel = this;
        synchronized (bTunnel) {
            this.setConnections(this.getConnections() + 1);
        }
        this.add(SlotPath.escape((String)(session.getRemoteHost() + "#1")) + "?", (BValue)session, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConnection(BTunnelConnection session) {
        BTunnel bTunnel = this;
        synchronized (bTunnel) {
            if (this.getConnections() > 0) {
                this.setConnections(this.getConnections() - 1);
            }
        }
        this.remove((BComplex)session);
    }
}

