/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tunnel;

import com.tridium.tunnel.BTunnel;
import com.tridium.tunnel.BTunnelConnection;
import com.tridium.tunnel.TunnelConst;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.baja.log.Log;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.serial.BISerialHelperParent;
import javax.baja.serial.BISerialPort;
import javax.baja.serial.BISerialService;
import javax.baja.serial.BSerialHelper;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSerialTunnel
extends BTunnel
implements TunnelConst,
BISerialHelperParent {
    public static final Property identifier = BSerialTunnel.newProperty((int)1, (String)"none", null);
    public static final Property serialPortConfig = BSerialTunnel.newProperty((int)0, (BValue)new BSerialHelper(), null);
    public static final Type TYPE = Sys.loadType(BSerialTunnel.class);
    boolean newDirection = IN_FROM_TUNNEL_OUT_TO_COMM;
    boolean oldDirection = IN_FROM_TUNNEL_OUT_TO_COMM;
    private static boolean IN_FROM_TUNNEL_OUT_TO_COMM = false;
    private static boolean IN_FROM_COMM_OUT_TO_TUNNEL = true;
    private Log log = null;
    private boolean connected = false;
    private BISerialPort comm;
    private InputStream comPortIn;
    private OutputStream comPortOut;
    private ReadDataFromComPortDriver rcvDriver;
    private Thread rcvThread;
    private SendDataToTunnelDriver tunSndDriver;
    private Thread tunSndThread;
    private PipedInputStream pipedInput;
    private PipedOutputStream pipedOutput;
    private BufferedInputStream bufferedPipeIn;

    @Override
    public String getIdentifier() {
        return this.getString(identifier);
    }

    public void setIdentifier(String v) {
        this.setString(identifier, v, null);
    }

    public BSerialHelper getSerialPortConfig() {
        return (BSerialHelper)this.get(serialPortConfig);
    }

    public void setSerialPortConfig(BSerialHelper v) {
        this.set(serialPortConfig, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        this.getSerialPortConfig().setSerialHelperParent((BISerialHelperParent)this);
        this.setIdentifier(this.getSerialPortConfig().getPortName());
        super.started();
    }

    @Override
    public void stopped() throws Exception {
        this.doDisconnectAll();
        super.stopped();
    }

    @Override
    public void changed(Property property, Context context) {
        if (context != Context.decoding) {
            if (property == BSerialHelper.portName) {
                this.setIdentifier(this.getSerialPortConfig().getPortName());
            } else if (property == identifier) {
                String oldName = "none";
                if (this.log != null) {
                    Log.deleteLog((String)this.log.getLogName());
                    this.log = null;
                    this.log().trace("changed name from " + oldName);
                }
            }
        }
        super.changed(property, context);
    }

    @Override
    public void service(BTunnelConnection cx) throws IOException {
        byte[] tunnelBuffer = new byte[1024];
        while (cx.isConnected()) {
            int bytesRead = cx.read(tunnelBuffer, 0, 1000);
            if (bytesRead <= 0) continue;
            this.newDirection = IN_FROM_TUNNEL_OUT_TO_COMM;
            try {
                if (this.log().isTraceOn()) {
                    this.log().trace("snd:" + this.debugBytes(ByteArrayUtil.toHexString((byte[])tunnelBuffer, (int)0, (int)bytesRead)));
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (this.comPortOut == null) {
                this.log().error("comPortOut is null");
                cx.disconnect();
                continue;
            }
            this.comPortOut.write(tunnelBuffer, 0, bytesRead);
        }
    }

    public String debugBytes(String bytes) {
        StringBuffer sb = new StringBuffer();
        if (this.newDirection == this.oldDirection) {
            sb.append(bytes);
        } else {
            if (this.newDirection == IN_FROM_COMM_OUT_TO_TUNNEL) {
                sb.append("\n<" + bytes);
            } else {
                sb.append("\n>" + bytes);
            }
            this.oldDirection = this.newDirection;
        }
        return sb.toString();
    }

    @Override
    public void sessionClosed(BTunnelConnection cx) {
        this.doDisconnectAll();
    }

    @Override
    public boolean supportsConcurrentConnections() {
        return false;
    }

    @Override
    protected void addConnection(BTunnelConnection session) {
        super.addConnection(session);
        this.startSerialTunnel();
    }

    @Override
    protected void removeConnection(BTunnelConnection session) {
        super.removeConnection(session);
        this.stopSerialTunnel();
    }

    public final void reopenPort() {
    }

    public Log log() {
        if (this.log == null) {
            this.log = Log.getLog((String)("Tunnel_" + this.getIdentifier().toLowerCase()));
        }
        return this.log;
    }

    public boolean startSerialTunnel() {
        if (!this.getEnabled()) {
            return true;
        }
        if ("none".equalsIgnoreCase(this.getSerialPortConfig().getPortName())) {
            return true;
        }
        this.log().trace("start()::thread=" + Thread.currentThread().getName());
        try {
            this.log().trace("opening com port...");
            this.comm = this.getSerialPortConfig().open("SerialTunnel");
            BISerialService platSvc = (BISerialService)Sys.getService((Type)BISerialService.TYPE);
            this.comm.enableReceiveTimeout(platSvc.getMinTimeout());
            this.comPortIn = this.comm.getInputStream();
            this.comPortOut = this.comm.getOutputStream();
            this.pipedInput = new PipedInputStream();
            this.pipedOutput = new PipedOutputStream(this.pipedInput);
            this.bufferedPipeIn = new BufferedInputStream(this.pipedInput, 8000);
            this.connected = true;
        }
        catch (Exception e) {
            this.log().trace("SerialTunnel exception: " + e);
            e.printStackTrace();
            this.connected = false;
            this.comPortIn = null;
            this.comPortOut = null;
            return false;
        }
        this.rcvDriver = new ReadDataFromComPortDriver();
        this.rcvThread = new Thread((Runnable)this.rcvDriver, "tunPtoB" + this.getIdentifier());
        this.log().trace("SerialTunnel > starting ReadDataFromComPortDriver");
        this.rcvThread.start();
        this.rcvThread.setPriority(5);
        this.tunSndDriver = new SendDataToTunnelDriver();
        this.tunSndThread = new Thread((Runnable)this.tunSndDriver, "tunBtoT" + this.getIdentifier());
        this.log().trace("SendDataToTunnelDriver.start()");
        this.tunSndThread.start();
        this.tunSndThread.setPriority(5);
        return true;
    }

    public void stopSerialTunnel() {
        if (!this.connected) {
            return;
        }
        this.log().trace("stop()::thread=" + Thread.currentThread().getName());
        this.connected = false;
        if (this.rcvDriver != null) {
            this.rcvThread.interrupt();
        }
        if (this.tunSndDriver != null) {
            this.tunSndThread.interrupt();
        }
        try {
            this.bufferedPipeIn.close();
            this.pipedOutput.close();
            this.pipedInput.close();
            this.comPortIn.close();
            this.comPortOut.close();
            this.comm.close();
            this.bufferedPipeIn = null;
            this.pipedInput = null;
            this.pipedOutput = null;
            this.comPortIn = null;
            this.comPortOut = null;
            this.comm = null;
        }
        catch (Exception e) {
            this.log().error("SerialTunnel exception: " + e);
            e.printStackTrace();
        }
        this.rcvDriver = null;
        this.tunSndDriver = null;
    }

    class SendDataToTunnelDriver
    implements Runnable {
        SendDataToTunnelDriver() {
        }

        @Override
        public void run() {
            byte[] data = new byte[1024];
            while (BSerialTunnel.this.connected) {
                int len;
                try {
                    len = BSerialTunnel.this.bufferedPipeIn.read(data);
                }
                catch (Exception e) {
                    if (!BSerialTunnel.this.connected) {
                        BSerialTunnel.this.log().trace("closing SerialTunnel SendDataToTunnelDriver...");
                        break;
                    }
                    BSerialTunnel.this.log().error("Exception in SerialTunnel SendDataToTunnelDriver in.read():" + e);
                    BSerialTunnel.this.connected = false;
                    break;
                }
                try {
                    if (len == -1) continue;
                    BTunnelConnection[] connections = BSerialTunnel.this.getTunnelConnectionsArray();
                    for (int i = 0; i < connections.length; ++i) {
                        if (!BSerialTunnel.this.connected) continue;
                        connections[i].write(data, 0, len);
                    }
                }
                catch (Exception e) {
                    BSerialTunnel.this.log().error("SendDataToTunnelDriver.run()while::thread=" + Thread.currentThread().getName() + " Exception:" + e);
                }
            }
            try {
                if (BSerialTunnel.this.bufferedPipeIn != null) {
                    BSerialTunnel.this.bufferedPipeIn.close();
                }
                if (BSerialTunnel.this.pipedInput != null) {
                    BSerialTunnel.this.pipedInput.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            BSerialTunnel.this.log().trace(Thread.currentThread().getName() + " is stopped!");
        }
    }

    class ReadDataFromComPortDriver
    implements Runnable {
        BufferedOutputStream bufferedPipeOut;

        ReadDataFromComPortDriver() {
            this.bufferedPipeOut = new BufferedOutputStream(BSerialTunnel.this.pipedOutput, 8000);
        }

        @Override
        public void run() {
            BSerialTunnel.this.log().trace("ReadDataFromComPortDriver.run()::thread=" + Thread.currentThread().getName());
            byte[] data = new byte[1024];
            while (BSerialTunnel.this.connected) {
                int len;
                try {
                    len = BSerialTunnel.this.comPortIn.read(data);
                }
                catch (Exception e) {
                    if (!BSerialTunnel.this.connected) {
                        BSerialTunnel.this.log().trace("exiting " + Thread.currentThread().getName() + "...");
                        break;
                    }
                    BSerialTunnel.this.log().error("ReadDataFromComPortDriver.run()::thread=" + Thread.currentThread().getName() + " Exception:" + e);
                    e.printStackTrace();
                    BSerialTunnel.this.connected = false;
                    break;
                }
                try {
                    if (len <= 0) continue;
                    BSerialTunnel.this.log().trace(Thread.currentThread().getName() + " comm input: " + len + " bytes");
                    BSerialTunnel.this.newDirection = IN_FROM_COMM_OUT_TO_TUNNEL;
                    try {
                        if (len > 0 && BSerialTunnel.this.log().isTraceOn()) {
                            BSerialTunnel.this.log().trace("rcv:" + BSerialTunnel.this.debugBytes(ByteArrayUtil.toHexString((byte[])data, (int)0, (int)len)));
                        }
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                    if (BSerialTunnel.this.connected) {
                        this.bufferedPipeOut.write(data, 0, len);
                    }
                    this.bufferedPipeOut.flush();
                }
                catch (Exception e) {
                    BSerialTunnel.this.log().error("ReadDataFromComPortDriver.run()::thread=" + Thread.currentThread().getName() + " Exception:" + e);
                    e.printStackTrace();
                }
            }
            try {
                this.bufferedPipeOut.close();
                BSerialTunnel.this.pipedOutput.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            BSerialTunnel.this.log().trace(Thread.currentThread().getName() + " is stopped!");
        }
    }
}

