/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui.installapp;

import com.tridium.backup.ui.BBackupManager;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.template.BTemplateConfig;
import com.tridium.template.BTemplateService;
import com.tridium.template.application.ApplicationTemplateUtil;
import com.tridium.template.application.BApplicationInstallSpecs;
import com.tridium.template.file.BNtplFile;
import com.tridium.template.job.BInstallApplicationTemplateJob;
import com.tridium.template.ui.ApplicationTemplateInstallUtil;
import com.tridium.template.ui.BulkDeployUtil;
import com.tridium.template.ui.file.BWbDeployableNtplFile;
import com.tridium.template.ui.installapp.BackupStepArtifact;
import com.tridium.template.ui.installapp.OptionalComponentsArtifact;
import com.tridium.template.ui.installapp.WizardUtil;
import com.tridium.ui.wizard.step.WizardStep;
import com.tridium.ui.wizard.step.util.ProgressTextPaneUiHandler;
import com.tridium.util.JobProgressMonitor;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Subscriber;
import javax.baja.ui.BWidget;

public class InstallingApplicationWorker
extends ProgressTextPaneUiHandler.WorkerRunnable {
    private final ApplicationTemplateInstallUtil installInfo;
    private static final List<String> APPLICATION_TEMPLATE_FLAG_HACK = Collections.singletonList(";");

    public static WizardStep makeWizardStep(ApplicationTemplateInstallUtil installInfo) {
        String description;
        String title;
        switch (installInfo.getSourceType()) {
            case 2: {
                title = "installApplication.installingApplicationExcelFile.title";
                description = "installApplication.installingApplicationExcelFile.description";
                break;
            }
            default: {
                title = "installApplication.installingApplicationTemplate.title";
                description = "installApplication.installingApplicationTemplate.description";
            }
        }
        return WizardUtil.makeStep(title, description, (WizardStep.IUiHandler)new ProgressTextPaneUiHandler((ProgressTextPaneUiHandler.WorkerRunnable)new InstallingApplicationWorker(installInfo)));
    }

    private InstallingApplicationWorker(ApplicationTemplateInstallUtil installInfo) {
        this.installInfo = installInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void workIt() {
        Context cx = this.getContext();
        Subscriber subscriber = Subscriber.make(event -> {});
        BFoxSession session = (BFoxSession)BOrd.toSession((BObject)this.installInfo.getStation());
        Object pauseToken = null;
        try {
            BOrd installApplicationTemplateJobOrd;
            pauseToken = session.pauseActivityMonitor();
            String stationName = this.installInfo.getStation().getStationDisplayName(null);
            BWbDeployableNtplFile sourceTemplateFile = this.installInfo.getApplicationTemplateFile();
            if (sourceTemplateFile == null) {
                throw new LocalizableRuntimeException("template", "installApplication.templateFileNotFound");
            }
            String sourceTemplateFileName = sourceTemplateFile.getFileName();
            if (BackupStepArtifact.canPerformBackup(this.getStepModel())) {
                this.message("installApplication.backingUpStation", stationName);
                BOrd backupJobOrd = this.startBackup();
                BJobState jobState = new JobProgressMonitor(backupJobOrd, (BComponent)this.installInfo.getStation(), JobProgressMonitor.makeJobLogItemMessageConsumer(x$0 -> this.message((String)x$0, new Object[0]), (Context)cx)).waitAndReadLog().getJobState();
                if (!BJobState.success.equals((Object)jobState)) {
                    this.message("installApplication.failedBackup", stationName);
                    return;
                }
            }
            BTemplateService templateService = this.resolveTemplateService();
            this.message("installApplication.copyingFile", sourceTemplateFileName, stationName);
            BIFile applicationTemplateFile = ApplicationTemplateUtil.copyApplicationTemplateToStation((BNtplFile)sourceTemplateFile, (BStation)this.installInfo.getStation());
            this.message("installApplication.finishedCopyingFile", applicationTemplateFile.getFileName());
            this.message("installApplication.startingApplicationTemplateInstallationJob", new Object[0]);
            if (this.installInfo.getSourceType() == 2 && this.installInfo.getWorkbook() == null) {
                this.message("installApplication.excelFileWorkbookNotFound", this.installInfo.getSourceFile().getFileName());
                return;
            }
            if (this.installInfo.isUpgradeMode() && !this.installInfo.doesStationSupportUpgradeAndOptionals()) {
                this.message("upgradeApplication.stationDoesntSupportUpgrade", this.installInfo.getSourceFile().getFileName());
                return;
            }
            BOrd applicationTemplateFileOrd = applicationTemplateFile.getOrdInSession();
            if (this.installInfo.doesStationSupportUpgradeAndOptionals()) {
                BApplicationInstallSpecs installSpecs = BApplicationInstallSpecs.make();
                installSpecs.setCheckModules(false);
                installSpecs.setUpgrade(this.installInfo.isUpgradeMode());
                installSpecs.setFileOrd(applicationTemplateFileOrd);
                BOrdList toBeRemoved = BOrdList.DEFAULT;
                if (!this.installInfo.isUpgradeMode()) {
                    if (this.installInfo.getSourceType() == 2) {
                        toBeRemoved = this.getSelectedOptionalsFromWorkbook((BIFile)sourceTemplateFile);
                    } else if (this.installInfo.doesTemplateHaveOptionals() && !OptionalComponentsArtifact.allOptionalsAreSelected(this.getStepModel())) {
                        toBeRemoved = OptionalComponentsArtifact.getOptionalComponentsToBeRemoved(this.getStepModel());
                    }
                }
                installSpecs.setToBeRemoved(toBeRemoved);
                installApplicationTemplateJobOrd = templateService.installApplication(installSpecs);
            } else {
                installApplicationTemplateJobOrd = templateService.installApplicationTemplate(applicationTemplateFileOrd);
            }
            JobProgressMonitor jobMonitor = new JobProgressMonitor(installApplicationTemplateJobOrd, (BComponent)this.installInfo.getStation(), JobProgressMonitor.makeJobLogItemMessageConsumer(x$0 -> this.message((String)x$0, new Object[0]), (Context)cx));
            BInstallApplicationTemplateJob job = (BInstallApplicationTemplateJob)jobMonitor.waitAndReadLog();
            if (BJobState.success.equals((Object)job.getJobState())) {
                if (this.installInfo.isUpgradeMode()) {
                    this.message("upgradeApplication.applicationTemplateInstalled", new Object[0]);
                } else {
                    this.message("installApplication.configuringApplicationTemplate", new Object[0]);
                    switch (this.installInfo.getSourceType()) {
                        case 2: {
                            this.applyTemplateConfigs(sourceTemplateFile);
                            break;
                        }
                        default: {
                            BWbDeployableNtplFile.doPostDeploy(sourceTemplateFile, (BWidget)this.getProgressTextBox().getShell(), (BComponent)this.installInfo.getStation(), APPLICATION_TEMPLATE_FLAG_HACK, arg_0 -> ((InstallingApplicationWorker)this).add(arg_0), cx);
                        }
                    }
                    this.message("installApplication.applicationTemplateInstalled", new Object[0]);
                }
            } else {
                this.message("installApplication.applicationTemplateFailedToInstall", new Object[0]);
            }
        }
        catch (Exception error) {
            this.error(error);
        }
        finally {
            subscriber.unsubscribeAll();
            session.resumeActivityMonitor(pauseToken);
        }
    }

    private BOrdList getSelectedOptionalsFromWorkbook(BIFile applicationTemplateFile) {
        if (!(applicationTemplateFile instanceof BWbDeployableNtplFile)) {
            return BOrdList.DEFAULT;
        }
        BWbDeployableNtplFile templateFile = (BWbDeployableNtplFile)applicationTemplateFile;
        BulkDeployUtil bulkDeployUtil = new BulkDeployUtil();
        BulkDeployUtil.DeployedWorksheet deployedWorksheet = this.installInfo.getDeployedWorksheet();
        BulkDeployUtil.DeployedRoot deployedRoot = this.installInfo.getDeployedRoot();
        return bulkDeployUtil.getSelectedOptionalsFromWorkbook(templateFile, deployedWorksheet, deployedRoot);
    }

    private void applyTemplateConfigs(BWbDeployableNtplFile sourceTemplateFile) {
        BTemplateConfig templateConfig = BTemplateConfig.getConfigForRoot((BComponent)this.installInfo.getStation());
        if (templateConfig == null) {
            this.message("bulkDeploy.excelImport.invalidTemplateError", sourceTemplateFile.getTitle());
            return;
        }
        templateConfig.lease();
        BulkDeployUtil bulkDeployUtil = new BulkDeployUtil();
        BulkDeployUtil.DeployedWorksheet deployedWorksheet = this.installInfo.getDeployedWorksheet();
        BulkDeployUtil.DeployedRoot deployedRoot = this.installInfo.getDeployedRoot();
        if (deployedRoot.getConfigs() != null) {
            this.message("installApplication.applyingConfigs", new Object[0]);
            bulkDeployUtil.setConfigsFromWorksheet(deployedWorksheet, deployedRoot, (BComponent)this.installInfo.getStation(), templateConfig, false);
        }
        if (deployedRoot.getOptionalConfigs() != null) {
            this.message("installApplication.applyingOptionalConfigs", new Object[0]);
            bulkDeployUtil.setOptionalConfigsFromWorksheet(deployedWorksheet, deployedRoot, (BComponent)this.installInfo.getStation(), templateConfig, false);
        }
        if (deployedRoot.getTags() != null) {
            this.message("installApplication.applyingTags", new Object[0]);
            bulkDeployUtil.setTagsFromWorksheet(deployedWorksheet, deployedRoot, (BComponent)this.installInfo.getStation());
        }
        if (deployedRoot.isEnableHistories()) {
            BHistoryExt[] unconfigurableHistories;
            this.message("installApplication.applyingHistories", new Object[0]);
            for (BHistoryExt historyExt : unconfigurableHistories = bulkDeployUtil.unconfigurableHistoryExtensions((BComponent)this.installInfo.getStation())) {
                historyExt.setEnabled(true);
            }
        }
    }

    private BTemplateService resolveTemplateService() {
        return (BTemplateService)BOrd.make((String)"service:template:TemplateService").get((BObject)this.installInfo.getStation());
    }

    private BOrd startBackup() throws IOException {
        BFileSystem.INSTANCE.makeDir(new FilePath("~backups"));
        BFoxSession session = (BFoxSession)BOrd.toSession((BObject)this.installInfo.getStation());
        String backupFilePath = "~backups/" + BBackupManager.makeDefaultBackupFileName((String)session.getStationName());
        return BBackupManager.submitBackupJob((String)backupFilePath, (BFoxSession)session);
    }

    private void message(String lexKey, Object ... args) {
        this.add(WizardUtil.LEX.getText(lexKey, args));
    }

    private void error(Throwable error) {
        this.add(error);
    }
}

