/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui.installapp;

import com.tridium.template.ui.ApplicationTemplateInstallUtil;
import com.tridium.template.ui.installapp.BackupUiHandler;
import com.tridium.template.ui.installapp.CompatibilityMessageUiHandler;
import com.tridium.template.ui.installapp.ConfirmInstallApplicationTemplateUiHandler;
import com.tridium.template.ui.installapp.InstallingApplicationWorker;
import com.tridium.template.ui.installapp.SelectApplicationTemplateUiHandler;
import com.tridium.template.ui.installapp.SelectOptionalComponentsUiHandler;
import com.tridium.template.ui.installapp.WizardUtil;
import com.tridium.ui.wizard.step.StepModel;
import com.tridium.ui.wizard.step.StepWizardModel;
import com.tridium.ui.wizard.step.WizardStep;
import javax.baja.sys.BStation;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;

public class InstallApplicationCommand
extends Command {
    private BStation station;

    public InstallApplicationCommand(BWidget owner, BStation station) {
        super(owner, (Lexicon)UiLexicon.bajaui(), "commands.installApplication");
        this.station = station;
    }

    public CommandArtifact doInvoke() {
        try {
            BWizard.open((BWidget)this.getOwner(), (WizardModel)InstallApplicationCommand.makeWizardModel(this.station));
        }
        catch (Exception err) {
            BDialog.error((BWidget)this.getOwner(), (String)this.getLabel(), (Object)WizardUtil.LEX.get("installApplication.cannotInstall"), (Throwable)err);
        }
        return null;
    }

    private static StepWizardModel makeWizardModel(BStation station) {
        ApplicationTemplateInstallUtil installInfo = new ApplicationTemplateInstallUtil(station);
        WizardStep selectApplicationTemplateStep = SelectApplicationTemplateUiHandler.makeWizardStep(installInfo);
        WizardStep compatibilityMessageStep = CompatibilityMessageUiHandler.makeWizardStep(installInfo);
        WizardStep optionalsStep = SelectOptionalComponentsUiHandler.makeWizardStep(installInfo);
        WizardStep backupStep = BackupUiHandler.makeWizardStep(installInfo);
        WizardStep confirmStep = ConfirmInstallApplicationTemplateUiHandler.makeWizardStep(installInfo);
        WizardStep installingStep = InstallingApplicationWorker.makeWizardStep(installInfo);
        selectApplicationTemplateStep.setNext(compatibilityMessageStep).setNext(optionalsStep).setNext(backupStep).setNext(confirmStep).setNext(installingStep);
        StepModel stepModel = StepModel.make((WizardStep)selectApplicationTemplateStep);
        return new StepWizardModel(stepModel, WizardUtil.LEX.get("installApplication.title"));
    }
}

