/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui;

import com.tridium.template.ui.BTemplateBogEditor;
import com.tridium.template.ui.BTemplateConfigEditor;
import com.tridium.template.ui.BTemplateIOEditor;
import com.tridium.template.ui.BTemplateManager;
import com.tridium.template.ui.BTemplateView;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;

public class TemplateViewState {
    private static Array<TemplateViewState> history = new Array(TemplateViewState.class);
    final String key;
    Type lastSelectedTab;
    BOrd bogSelOrd;
    int programSelIndex;
    int bogSelPane;

    static void save(BTemplateView view) {
        try {
            String key = TemplateViewState.toKey((BWbView)view);
            TemplateViewState state = new TemplateViewState(key);
            state.doSave(view);
            TemplateViewState.add(state);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void restore(BTemplateView view) {
        try {
            String key = TemplateViewState.toKey((BWbView)view);
            TemplateViewState state = TemplateViewState.get(key);
            if (state != null) {
                state.doRestore(view);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private TemplateViewState(String key) {
        this.key = key;
    }

    private static String toKey(BWbView view) {
        BWbShell shell = view.getWbShell();
        if (shell == null) {
            return null;
        }
        return "" + shell.getActiveOrdTarget().getOrdWithoutViewQuery();
    }

    private static TemplateViewState get(String key) {
        for (int i = history.size() - 1; i >= 0; --i) {
            TemplateViewState state = (TemplateViewState)history.get(i);
            if (state == null || state.key == null || !state.key.equals(key)) continue;
            return state;
        }
        return (TemplateViewState)history.last();
    }

    private static void add(TemplateViewState state) {
        TemplateViewState orig = TemplateViewState.get(state.key);
        if (orig != null && orig.key == state.key) {
            history.remove((Object)orig);
        }
        if (history.size() > 10) {
            history.remove(0);
        }
        history.add((Object)state);
    }

    private void doSave(BTemplateView view) {
        BWidget content = view.tp.getSelectedLabelPane().getContent();
        if (content instanceof BBorderPane) {
            content = ((BBorderPane)content).getContent();
        }
        this.lastSelectedTab = content.getType();
        this.bogSelPane = view.bogPane.selPane;
        if (content instanceof BTemplateBogEditor) {
            this.bogSelOrd = ((BTemplateBogEditor)content).bogSelOrd;
            this.programSelIndex = ((BTemplateBogEditor)content).programSelIndex;
        }
    }

    private void doRestore(BTemplateView view) {
        Object content = null;
        if (this.lastSelectedTab.is(BTemplateBogEditor.TYPE)) {
            content = view.bogPane;
        } else if (this.lastSelectedTab.is(BTemplateConfigEditor.TYPE)) {
            content = view.settingsPane;
        } else if (this.lastSelectedTab.is(BTemplateIOEditor.TYPE)) {
            content = view.ioPane;
        } else if (this.lastSelectedTab.is(BTemplateManager.TYPE)) {
            content = view.templateMgr;
        }
        if (content != null) {
            view.tp.selectPane(content.getParentWidget());
        }
        view.bogPane.selPane = this.bogSelPane;
        view.bogPane.bogSelOrd = this.bogSelOrd;
        view.bogPane.programSelIndex = this.programSelIndex;
    }
}

