/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui;

import com.tridium.excel.CTCol;
import com.tridium.excel.Cell;
import com.tridium.excel.CellRangeAddress;
import com.tridium.excel.CellStyle;
import com.tridium.excel.CellType;
import com.tridium.excel.ClientAnchor;
import com.tridium.excel.Color;
import com.tridium.excel.Comment;
import com.tridium.excel.CreationHelper;
import com.tridium.excel.DataFormatter;
import com.tridium.excel.Drawing;
import com.tridium.excel.EncryptionInfo;
import com.tridium.excel.Encryptor;
import com.tridium.excel.ExcelFileObject;
import com.tridium.excel.ExcelFileSystem;
import com.tridium.excel.ExcelUtils;
import com.tridium.excel.FillPatternType;
import com.tridium.excel.Font;
import com.tridium.excel.IndexedColors;
import com.tridium.excel.Name;
import com.tridium.excel.RichTextString;
import com.tridium.excel.Row;
import com.tridium.excel.Sheet;
import com.tridium.excel.Workbook;
import com.tridium.neql.component.ComponentTreeIterator;
import com.tridium.sys.tag.ComponentTags;
import com.tridium.sys.transfer.DeployToComp;
import com.tridium.template.BConfigBinding;
import com.tridium.template.BRelationInfo;
import com.tridium.template.BTemplateConfig;
import com.tridium.template.BTemplateService;
import com.tridium.template.api.NiagaraTemplate;
import com.tridium.template.api.OptionalComponent;
import com.tridium.template.api.TemplateElement;
import com.tridium.template.api.TemplateValue;
import com.tridium.template.file.BNtplFile;
import com.tridium.template.file.TemplateManager;
import com.tridium.template.manifest.TemplateManifest;
import com.tridium.template.ui.BulkDeployWorkbook;
import com.tridium.template.ui.TemplateDeployWorker;
import com.tridium.template.ui.UpdateUtil;
import com.tridium.template.ui.file.BWbDeployableNtplFile;
import com.tridium.template.ui.file.TmplUtil;
import com.tridium.util.CompUtil;
import com.tridium.util.ThrowableUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDriverContainer;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.history.BIArchiveFolder;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.search.BSearchService;
import javax.baja.security.BPassword;
import javax.baja.space.BComponentSpace;
import javax.baja.space.Mark;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BIService;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelation;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.Tag;
import javax.baja.tag.Tags;
import javax.baja.util.BFolder;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.util.BServiceContainer;
import javax.baja.util.BUuid;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

public class BulkDeployUtil {
    public static final Level IMPORT_LOG_LEVEL = Level.FINE;
    public static final Lexicon lex = Lexicon.make((String)"template");
    public static final Logger log = Logger.getLogger("template.bulkDeploy");
    protected static final String SLOT_NAME_SEPARATOR = ".";
    private static final String SLOT_NAME_SEPARATOR_REGEX = "\\.";
    public static final int EXCEL_HEADER_ROWS = 6;
    public static final int EXCEL_COLUMN_FREEZE = 2;
    public static final int EXCEL_APP_COLUMN_FREEZE = 2;
    private BTemplateService templateService;
    private BSearchService searchService;
    private StyleVault styleVault;
    public static final int DEVICE_INFO_COLUMN_COUNT = 5;
    public static final int COMPONENT_INFO_COLUMN_COUNT = 5;
    public static final int APP_INFO_COLUMN_COUNT = 2;
    public static final int CELL_COMMENT_OFFSET_COLUMN = 5;
    public static final int CELL_COMMENT_OFFSET_ROW = 5;
    public static final int CELL_COMMENT_MAX_STRING_LENGTH = 60;
    protected static final int PARENT_SLOTPATH = 0;
    protected static final int DEPLOYED_NAME = 1;
    protected static final int DISPLAY_NAME = 2;
    protected static final int WS_POSITION = 3;
    protected static final int UNIQUE_DEVICE = 4;
    protected static final int HISTORY_EXT = 5;
    protected static final int APP_UNIQUE_DEVICE = 1;
    protected static final int TEMPLATE_HEADER_LABEL_COLUMN = 0;
    protected static final int TEMPLATE_HEADER_TEXT_COLUMN = 1;
    protected static final int INPUT_DEFS_INDEX = 0;
    protected static final int OUTPUT_DEFS_INDEX = 1;
    protected static final int RELATION_DEFS_INDEX = 2;
    protected static final int CONFIG_DEFS_INDEX = 3;
    protected static final int OPTIONAL_DEFS_INDEX = 4;
    protected static final int OPTIONAL_CONFIG_DEFS_INDEX = 5;
    protected static final int TAG_DEFS_INDEX = 6;
    protected static final String TEMPLATE_EXPORT_VERSION = "1.2";
    protected static final String TEMPLATE_EXPORT_VERSION_NAME = "version";
    protected static final String TEMPLATE_VENDOR_NAME = "templateVendor";
    protected static final String TEMPLATE_FILE_NAME = "templateFile";
    protected static final String TEMPLATE_TITLE_NAME = "templateTitle";
    protected static final String TEMPLATE_VERSION_NAME = "templateVersion";
    protected static final String TEMPLATE_UID_NAME = "templateUID";
    protected static final String TEMPLATE_TYPE_NAME = "templateType";
    protected static final String TEMPLATE_SHEET_INFO_COLUMNS_NAME = "infoColumns";
    protected static final String TEMPLATE_INPUTS_COUNT_NAME = "inputsCount";
    protected static final String TEMPLATE_OUTPUTS_COUNT_NAME = "outputsCount";
    protected static final String TEMPLATE_RELATIONS_COUNT_NAME = "relationsCount";
    protected static final String TEMPLATE_CONFIGS_COUNT_NAME = "configsCount";
    protected static final String TEMPLATE_OPTIONALS_COUNT_NAME = "optionalsCount";
    protected static final String TEMPLATE_OPTIONAL_CONFIGS_COUNT_NAME = "optionalConfigsCount";
    protected static final String TEMPLATE_TAG_COUNT_NAME = "tagCount";
    protected static final String KEEP_PRIVATE_NAME = "keepPrivate";
    protected static final String DEFAULT_TARGET_SLOT = "in10";
    protected static final String DEFAULT_SOURCE_SLOT = "out";
    protected static final String SOURCE_SLOT_MIN_VERSION = "1.1";
    public static final String TEMPLATE_TYPE_COMPONENT = "Component";
    public static final String TEMPLATE_TYPE_DEVICE = "Device";
    public static final String TEMPLATE_TYPE_APPLICATION = "Application";
    public static final String TEMPLATE_TYPE_STATION = "Station";
    private static final BFacets TIMESTAMP_FORMAT = BFacets.make((String[])new String[]{"timeFormat", "showDate", "showTime", "showSeconds", "showMilliseconds"}, (BIDataValue[])new BIDataValue[]{BString.make((String)"YYYYMMDD_HHmmss"), BBoolean.TRUE, BBoolean.TRUE, BBoolean.TRUE, BBoolean.FALSE});

    public HashSet<Tag> getStringTagsInTemplate(BWbDeployableNtplFile ntplFile) {
        BComponent templateBase = ntplFile.getBaseComponent();
        HashSet<Tag> tags = new HashSet<Tag>();
        ComponentTreeIterator iterator = new ComponentTreeIterator(templateBase);
        while (iterator.hasNext()) {
            ComponentTags componentTags;
            Entity entity = iterator.next();
            if (!(entity.tags() instanceof ComponentTags) || (componentTags = (ComponentTags)entity.tags()).isEmpty()) continue;
            componentTags.forEach(tag -> {
                if (tag.getValue().getType().is(BString.TYPE)) {
                    tags.add((Tag)tag);
                }
            });
        }
        return tags;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File exportTemplateToExcel(BIFile exportPath, BPassword encryptPassword, BWbDeployableNtplFile[] ntplFiles, Map<BWbDeployableNtplFile, HashSet<Tag>> tagMap, StringBuilder replyMessage) {
        File exportBase = BFileSystem.INSTANCE.pathToLocalFile(exportPath.getFilePath());
        File exportFile = new File(exportBase.getParent(), exportBase.getName());
        boolean useOldExcelFormat = exportPath.getExtension().equalsIgnoreCase("xls");
        try (FileOutputStream excelExport = new FileOutputStream(exportFile);
             Workbook wb = ExcelUtils.createWorkbook((!useOldExcelFormat ? 1 : 0) != 0);){
            this.setTemplateExportVersion(wb);
            this.styleVault = new StyleVault(wb);
            for (BWbDeployableNtplFile ntplFile : ntplFiles) {
                BTemplateConfig templateConfig;
                BComponent templateBase;
                String templateFileName = ntplFile.getFileName();
                TemplateManifest manifest = ntplFile.getTemplateManifest();
                String templateName = manifest.vendor + '-' + templateFileName;
                Sheet templateSheet = wb.createSheet(templateName);
                this.setDefaultCellStyle(templateSheet);
                this.setTemplateFile(templateSheet, templateFileName);
                try {
                    templateBase = ntplFile.getBaseComponent();
                    templateConfig = BTemplateConfig.getConfigForRoot((BComponent)templateBase);
                    if (templateConfig == null) {
                        log.log(Level.WARNING, lex.getText("bulkDeploy.excelExport.templateConfigNotFound", new Object[]{templateFileName}));
                        File file = null;
                        return file;
                    }
                }
                catch (Exception e) {
                    String message = lex.getText("bulkDeploy.excelExport.exportFileError", new Object[]{exportFile.toString()});
                    if (this.isModuleNotFoundException(e)) {
                        message = lex.getText("bulkDeploy.excelExport.moduleNotFoundError", new Object[]{ntplFile.getTitle()});
                    }
                    log.log(Level.WARNING, message, e);
                    replyMessage.append(message);
                    File file = null;
                    return file;
                }
                try {
                    this.setTemplateVendor(templateSheet, manifest.vendor);
                    this.setTemplateTitle(templateSheet, manifest.title);
                    this.setTemplateVersion(templateSheet, manifest.version);
                    this.setTemplateUID(templateSheet, templateConfig.getUID().encodeToString());
                    this.setTemplateTypeName(templateSheet, this.buildTemplateTypeName(manifest));
                }
                catch (IOException e) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelExport.templateIdError", new Object[]{templateFileName}), e);
                    File file = null;
                    if (wb != null) {
                        if (var12_16 != null) {
                            try {
                                wb.close();
                            }
                            catch (Throwable throwable) {
                                var12_16.addSuppressed(throwable);
                            }
                        } else {
                            wb.close();
                        }
                    }
                    if (excelExport == null) return file;
                    if (var10_11 == null) {
                        excelExport.close();
                        return file;
                    }
                    try {
                        excelExport.close();
                        return file;
                    }
                    catch (Throwable throwable) {
                        var10_11.addSuppressed(throwable);
                        return file;
                    }
                }
                HashSet<Tag> tags = tagMap.get((Object)ntplFile);
                this.getTemplateConfigContents(templateBase, templateConfig, manifest, tags, templateSheet);
                if (ExcelUtils.isXmlFormat((ExcelFileObject)templateSheet)) {
                    templateSheet.lockSelectLockedCells(false);
                    templateSheet.lockSelectUnlockedCells(false);
                    templateSheet.lockFormatColumns(false);
                    templateSheet.lockFormatRows(false);
                    templateSheet.lockFormatCells(true);
                    templateSheet.lockInsertColumns(true);
                    templateSheet.lockInsertRows(true);
                    templateSheet.lockInsertHyperlinks(true);
                    templateSheet.lockDeleteColumns(true);
                    templateSheet.lockDeleteRows(true);
                    templateSheet.lockSort(true);
                    templateSheet.lockAutoFilter(true);
                    templateSheet.lockPivotTables(true);
                    templateSheet.lockObjects(true);
                    templateSheet.lockScenarios(true);
                    templateSheet.enableLocking();
                }
                ntplFile.closeIfOpen();
            }
            if (encryptPassword != null && !useOldExcelFormat || this.templatesHaveConfigPasswords(ntplFiles)) {
                this.setKeepPrivateFlag(wb);
                Row noteRow = wb.getSheetAt(wb.getActiveSheetIndex()).getRow(1);
                this.generateCell(noteRow, 0, lex.getText("templateSideBar.privacyNote"), this.styleVault.getInfoCellStyle());
                this.generateCell(noteRow, 1, lex.getText("templateSideBar.privacyMessage"), this.styleVault.getStringCellStyle());
            }
            if (encryptPassword == null) {
                wb.write((OutputStream)excelExport);
                return exportFile;
            }
            if (useOldExcelFormat) {
                ExcelUtils.setCurrentUserPassword((String)encryptPassword.getValue());
                wb.write((OutputStream)excelExport);
                ExcelUtils.setCurrentUserPassword(null);
                return exportFile;
            }
            ExcelFileSystem fs = ExcelUtils.makeFileSystem();
            EncryptionInfo info = ExcelUtils.makeEncryptionInfo();
            Encryptor enc = info.getEncryptor();
            enc.confirmPassword(encryptPassword.getValue());
            try (OutputStream os = enc.getDataStream(fs);){
                wb.write(os);
            }
            fs.writeFilesystem((OutputStream)excelExport);
            return exportFile;
        }
        catch (Exception e) {
            String message = lex.getText("bulkDeploy.excelExport.exportFileError", new Object[]{exportFile.toString()});
            log.log(Level.WARNING, message, e);
            replyMessage.append(message);
            return null;
        }
    }

    public File exportTemplateToExcel(BIFile exportPath, NiagaraTemplate template, StringBuilder replyMessage) {
        return this.exportTemplateToExcel(exportPath, null, template, replyMessage);
    }

    public File exportTemplateToExcel(BIFile exportPath, BPassword encryptPassword, NiagaraTemplate template, StringBuilder replyMessage) {
        NiagaraTemplate[] templates = new NiagaraTemplate[]{template};
        return this.exportTemplateToExcel(exportPath, encryptPassword, templates, replyMessage);
    }

    public File exportTemplateToExcel(BIFile exportPath, NiagaraTemplate[] templates, StringBuilder replyMessage) {
        return this.exportTemplateToExcel(exportPath, null, templates, replyMessage);
    }

    public File exportTemplateToExcel(BIFile exportPath, BPassword encryptPassword, NiagaraTemplate[] templates, StringBuilder replyMessage) {
        File exportBase = BFileSystem.INSTANCE.pathToLocalFile(exportPath.getFilePath());
        File exportFile = new File(exportBase.getParent(), exportBase.getName());
        boolean useOldExcelFormat = exportPath.getExtension().equalsIgnoreCase("xls");
        try (FileOutputStream excelExport = new FileOutputStream(exportFile);){
            this.exportTemplateToExcel((OutputStream)excelExport, encryptPassword, useOldExcelFormat, templates);
        }
        catch (Exception e) {
            String message = lex.getText("bulkDeploy.excelExport.exportFileError", new Object[]{exportFile.toString()});
            log.log(Level.WARNING, message, e);
            replyMessage.append(message);
            return null;
        }
        return exportFile;
    }

    public void exportTemplateToExcel(OutputStream exportStream, NiagaraTemplate template) throws IOException, GeneralSecurityException {
        this.exportTemplateToExcel(exportStream, null, false, template);
    }

    public void exportTemplateToExcel(OutputStream exportStream, BPassword encryptPassword, boolean useOldExcelFormat, NiagaraTemplate template) throws IOException, GeneralSecurityException {
        NiagaraTemplate[] templates = new NiagaraTemplate[]{template};
        this.exportTemplateToExcel(exportStream, encryptPassword, useOldExcelFormat, templates);
    }

    public void exportTemplateToExcel(OutputStream exportStream, NiagaraTemplate[] templates) throws IOException, GeneralSecurityException {
        this.exportTemplateToExcel(exportStream, null, false, templates);
    }

    public void exportTemplateToExcel(OutputStream exportStream, BPassword encryptPassword, boolean useOldExcelFormat, NiagaraTemplate[] templates) throws IOException, GeneralSecurityException {
        block30: {
            try (Workbook wb = ExcelUtils.createWorkbook((!useOldExcelFormat ? 1 : 0) != 0);){
                this.setTemplateExportVersion(wb);
                this.styleVault = new StyleVault(wb);
                boolean hasSensitiveDataConfig = false;
                for (NiagaraTemplate template : templates) {
                    String templateFileName = template.getFileName();
                    String vendor = template.getVendor();
                    String templateName = (vendor.isEmpty() ? "" : template.getVendor() + '-') + templateFileName;
                    Sheet templateSheet = wb.createSheet(templateName);
                    this.setDefaultCellStyle(templateSheet);
                    this.setTemplateFile(templateSheet, templateFileName);
                    this.setTemplateVendor(templateSheet, vendor);
                    this.setTemplateTitle(templateSheet, template.getTitle());
                    this.setTemplateVersion(templateSheet, template.getVersion());
                    this.setTemplateUID(templateSheet, template.getUid());
                    this.setTemplateTypeName(templateSheet, template.getTemplateType().friendlyName());
                    this.getTemplateConfigContents(template, templateSheet);
                    if (ExcelUtils.isXmlFormat((ExcelFileObject)templateSheet)) {
                        templateSheet.lockSelectLockedCells(false);
                        templateSheet.lockSelectUnlockedCells(false);
                        templateSheet.lockFormatColumns(false);
                        templateSheet.lockFormatRows(false);
                        templateSheet.lockFormatCells(true);
                        templateSheet.lockInsertColumns(true);
                        templateSheet.lockInsertRows(true);
                        templateSheet.lockInsertHyperlinks(true);
                        templateSheet.lockDeleteColumns(true);
                        templateSheet.lockDeleteRows(true);
                        templateSheet.lockSort(true);
                        templateSheet.lockAutoFilter(true);
                        templateSheet.lockPivotTables(true);
                        templateSheet.lockObjects(true);
                        templateSheet.lockScenarios(true);
                        templateSheet.enableLocking();
                    }
                    hasSensitiveDataConfig = hasSensitiveDataConfig || template.hasSensitiveDataConfig();
                }
                if (encryptPassword != null && !useOldExcelFormat || hasSensitiveDataConfig) {
                    this.setKeepPrivateFlag(wb);
                    Sheet firstSheet = wb.getNumberOfSheets() < 1 ? wb.createSheet() : wb.getSheetAt(0);
                    Row noteRow = firstSheet.getRow(1);
                    if (noteRow == null) {
                        noteRow = firstSheet.createRow(1);
                    }
                    this.generateCell(noteRow, 0, lex.getText("templateSideBar.privacyNote"), this.styleVault.getInfoCellStyle());
                    this.generateCell(noteRow, 1, lex.getText("templateSideBar.privacyMessage"), this.styleVault.getStringCellStyle());
                }
                if (encryptPassword == null) {
                    wb.write(exportStream);
                    break block30;
                }
                if (useOldExcelFormat) {
                    ExcelUtils.setCurrentUserPassword((String)encryptPassword.getValue());
                    wb.write(exportStream);
                    ExcelUtils.setCurrentUserPassword(null);
                    break block30;
                }
                ExcelFileSystem fs = ExcelUtils.makeFileSystem();
                EncryptionInfo info = ExcelUtils.makeEncryptionInfo();
                Encryptor enc = info.getEncryptor();
                enc.confirmPassword(encryptPassword.getValue());
                try (OutputStream os = enc.getDataStream(fs);){
                    wb.write(os);
                }
                fs.writeFilesystem(exportStream);
            }
        }
    }

    private void setDefaultCellStyle(Sheet sheet) {
        if (ExcelUtils.isXmlFormat((ExcelFileObject)sheet)) {
            CTCol cTCol = sheet.addCTCol();
            cTCol.setMin(1L);
            cTCol.setMax(16384L);
            cTCol.setStyle((long)this.styleVault.getEmptyCellStyle().getIndex());
        }
    }

    private boolean isModuleNotFoundException(Throwable e) {
        while (e != null) {
            if (e instanceof ModuleNotFoundException) {
                return true;
            }
            e = ThrowableUtil.getCause((Throwable)e);
        }
        return false;
    }

    private void getTemplateConfigContents(BComponent templateBase, BTemplateConfig templateConfig, TemplateManifest manifest, HashSet<Tag> tags, Sheet templateSheet) {
        BConfigBinding[] configBindings = templateConfig.getConfigBindings();
        Slot[] inputSlots = templateConfig.getInputSlots();
        Slot[] outputSlots = templateConfig.getOutputSlots();
        ArrayList relations = templateConfig.getRelationInfos();
        List optionalComponents = manifest.optional.list();
        Row firstRow = templateSheet.createRow(0);
        Row secondRow = templateSheet.createRow(1);
        Row thirdRow = templateSheet.createRow(2);
        Row fourthRow = templateSheet.createRow(3);
        Row fifthRow = templateSheet.createRow(4);
        Row sixthRow = templateSheet.createRow(5);
        int excelInstanceInfoColumns = 0;
        String description = manifest.description;
        String info = SlotPath.unescape((String)manifest.info);
        this.generateCell(firstRow, 0, lex.getText("templateSideBar.description"), this.styleVault.getInfoCellStyle());
        Cell labelCell = this.generateCell(firstRow, 1, description, this.styleVault.getStringCellStyle());
        if (info == null && !info.isEmpty()) {
            this.setCellComment(templateSheet, labelCell, info);
        }
        int uniqueDeviceColumn = 4;
        int columnFreezePane = 2;
        TemplateType templateType = manifest.isApplication ? TemplateType.APPLICATION : (templateBase instanceof BDevice ? TemplateType.DEVICE : TemplateType.COMPONENT);
        switch (templateType) {
            case APPLICATION: {
                excelInstanceInfoColumns = 2;
                break;
            }
            case DEVICE: {
                excelInstanceInfoColumns = 5;
                break;
            }
            default: {
                excelInstanceInfoColumns = 5;
            }
        }
        for (int i = 0; i < excelInstanceInfoColumns; ++i) {
            templateSheet.setDefaultColumnStyle(i, this.styleVault.getStringCellStyle());
        }
        if (templateType == TemplateType.APPLICATION) {
            excelInstanceInfoColumns = 2;
            labelCell = this.generateCell(sixthRow, 0, lex.getText("templateSideBar.rowName"), this.styleVault.getInstanceCellStyle());
            this.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.rowNameHelp"));
            uniqueDeviceColumn = 1;
            columnFreezePane = 2;
        } else {
            if (templateType == TemplateType.DEVICE) {
                excelInstanceInfoColumns = 5;
                labelCell = this.generateCell(sixthRow, 0, lex.getText("templateSideBar.network"), this.styleVault.getInstanceCellStyle());
                this.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.networkHelp"));
                labelCell = this.generateCell(sixthRow, 1, lex.getText("templateSideBar.device"), this.styleVault.getInstanceCellStyle());
                this.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.deviceHelp"));
            } else {
                excelInstanceInfoColumns = 5;
                labelCell = this.generateCell(sixthRow, 0, lex.getText("templateSideBar.rootOrd"), this.styleVault.getInstanceCellStyle());
                this.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.rootOrdHelp"));
                labelCell = this.generateCell(sixthRow, 1, lex.getText("templateSideBar.deployedName"), this.styleVault.getInstanceCellStyle());
                this.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.deployedNameHelp"));
            }
            labelCell = this.generateCell(sixthRow, 2, lex.getText("templateSideBar.display"), this.styleVault.getOptionalCellStyle());
            this.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.displayHelp"));
            labelCell = this.generateCell(sixthRow, 3, lex.getText("templateSideBar.position"), this.styleVault.getOptionalCellStyle());
            this.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.positionHelp"));
        }
        labelCell = this.generateCell(sixthRow, uniqueDeviceColumn, lex.getText("templateSideBar.uniqueDevice"), this.styleVault.getOptionalCellStyle());
        this.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.uniqueDeviceHelp"));
        this.setTemplateSheetInfoColumns(templateSheet, excelInstanceInfoColumns);
        int configColumnOffset = excelInstanceInfoColumns;
        try {
            Cell propertyCell;
            BString bindHints;
            BString userTip;
            boolean includeTags;
            int configsForOptionalComponent;
            int outputIndex;
            int i;
            if (inputSlots.length > 0) {
                this.generateCell(firstRow, configColumnOffset, "", this.styleVault.getInputCellStyle());
                this.generateCell(secondRow, configColumnOffset, lex.getText("templateSideBar.slotName"), this.styleVault.getInputCellStyle());
                this.generateCell(thirdRow, configColumnOffset, lex.getText("templateSideBar.label"), this.styleVault.getInputCellStyle());
                this.generateCell(fourthRow, configColumnOffset, lex.getText("templateSideBar.bindHints"), this.styleVault.getInputCellStyle());
                this.generateCell(fifthRow, configColumnOffset, lex.getText("templateSideBar.targetSlotHints"), this.styleVault.getInputCellStyle());
                labelCell = this.generateCell(sixthRow, configColumnOffset, lex.getText("templateSideBar.userDescriptions"), this.styleVault.getInputCellStyle());
                this.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.userDescriptionsHelp"));
                templateSheet.setDefaultColumnStyle(configColumnOffset, this.styleVault.getEmptyCellStyle());
                CellRangeAddress inputRange = ExcelUtils.makeCellRangeAddress((int)0, (int)0, (int)(++configColumnOffset), (int)(configColumnOffset + inputSlots.length * 2 - 1));
                int inputIndex = templateSheet.addMergedRegion(inputRange);
                this.generateCell(firstRow, configColumnOffset, lex.getText("templateSideBar.inputs"), this.styleVault.getInputCellStyle());
                for (i = 0; i < inputSlots.length * 2; ++i) {
                    templateSheet.setDefaultColumnStyle(configColumnOffset + i, this.styleVault.getStringCellStyle());
                }
                configColumnOffset += inputSlots.length * 2;
            }
            this.setInputsCount(templateSheet, inputSlots.length * 2);
            if (outputSlots.length > 0) {
                this.generateCell(firstRow, configColumnOffset, "", this.styleVault.getOutputCellStyle());
                this.generateCell(secondRow, configColumnOffset, lex.getText("templateSideBar.slotName"), this.styleVault.getOutputCellStyle());
                this.generateCell(thirdRow, configColumnOffset, lex.getText("templateSideBar.label"), this.styleVault.getOutputCellStyle());
                this.generateCell(fourthRow, configColumnOffset, lex.getText("templateSideBar.bindHints"), this.styleVault.getOutputCellStyle());
                this.generateCell(fifthRow, configColumnOffset, lex.getText("templateSideBar.targetSlotHints"), this.styleVault.getOutputCellStyle());
                labelCell = this.generateCell(sixthRow, configColumnOffset, lex.getText("templateSideBar.userDescriptions"), this.styleVault.getOutputCellStyle());
                this.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.userDescriptionsHelp"));
                templateSheet.setDefaultColumnStyle(configColumnOffset, this.styleVault.getEmptyCellStyle());
                CellRangeAddress outputRange = ExcelUtils.makeCellRangeAddress((int)0, (int)0, (int)(++configColumnOffset), (int)(configColumnOffset + outputSlots.length * 2 - 1));
                outputIndex = templateSheet.addMergedRegion(outputRange);
                this.generateCell(firstRow, configColumnOffset, lex.getText("templateSideBar.outputs"), this.styleVault.getOutputCellStyle());
                for (i = 0; i < outputSlots.length * 2; ++i) {
                    templateSheet.setDefaultColumnStyle(configColumnOffset + i, this.styleVault.getStringCellStyle());
                }
                configColumnOffset += outputSlots.length * 2;
            }
            this.setOutputsCount(templateSheet, outputSlots.length * 2);
            if (relations.size() > 0) {
                this.generateCell(firstRow, configColumnOffset, "", this.styleVault.getRelationCellStyle());
                this.generateCell(secondRow, configColumnOffset, lex.getText("templateSideBar.label"), this.styleVault.getRelationCellStyle());
                this.generateCell(thirdRow, configColumnOffset, lex.getText("templateSideBar.relationId"), this.styleVault.getRelationCellStyle());
                this.generateCell(fourthRow, configColumnOffset, lex.getText("templateSideBar.relateHints"), this.styleVault.getRelationCellStyle());
                this.generateCell(fifthRow, configColumnOffset, lex.getText("templateSideBar.direction"), this.styleVault.getRelationCellStyle());
                labelCell = this.generateCell(sixthRow, configColumnOffset, lex.getText("templateSideBar.userDescriptions"), this.styleVault.getRelationCellStyle());
                this.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.userDescriptionsHelp"));
                templateSheet.setDefaultColumnStyle(configColumnOffset, this.styleVault.getEmptyCellStyle());
                ++configColumnOffset;
                if (relations.size() > 1) {
                    CellRangeAddress relationRange = ExcelUtils.makeCellRangeAddress((int)0, (int)0, (int)configColumnOffset, (int)(configColumnOffset + relations.size() - 1));
                    outputIndex = templateSheet.addMergedRegion(relationRange);
                }
                this.generateCell(firstRow, configColumnOffset, lex.getText("templateSideBar.relations"), this.styleVault.getRelationCellStyle());
                for (int i2 = 0; i2 < relations.size(); ++i2) {
                    templateSheet.setDefaultColumnStyle(configColumnOffset + i2, this.styleVault.getStringCellStyle());
                }
                configColumnOffset += relations.size();
            }
            this.setRelationsCount(templateSheet, relations.size());
            ArrayList<BindingProperties> normalBindingList = new ArrayList<BindingProperties>();
            ArrayList<OptionalBindingProperties> optionalBindingList = new ArrayList<OptionalBindingProperties>();
            for (BConfigBinding configBinding : configBindings) {
                if (this.isOptionalConfiguration(configBinding, optionalComponents, templateBase)) {
                    OptionalBindingProperties optionalBindingProps = new OptionalBindingProperties(configBinding, optionalComponents, templateBase, templateConfig);
                    optionalBindingList.add(optionalBindingProps);
                    continue;
                }
                BindingProperties bindingProps = new BindingProperties(configBinding, templateConfig);
                normalBindingList.add(bindingProps);
            }
            int configBindingsColumnCount = this.getConfigPropertyCount(normalBindingList);
            if (configBindingsColumnCount > 0) {
                this.generateCell(firstRow, configColumnOffset, "", this.styleVault.getConfigCellStyle());
                this.generateCell(secondRow, configColumnOffset, lex.getText("templateSideBar.slotName"), this.styleVault.getConfigCellStyle());
                this.generateCell(thirdRow, configColumnOffset, lex.getText("templateSideBar.label"), this.styleVault.getConfigCellStyle());
                this.generateCell(fourthRow, configColumnOffset, lex.getText("templateSideBar.slotType"), this.styleVault.getConfigCellStyle());
                this.generateCell(fifthRow, configColumnOffset, lex.getText("templateSideBar.defaultValue"), this.styleVault.getConfigCellStyle());
                labelCell = this.generateCell(sixthRow, configColumnOffset, lex.getText("templateSideBar.userDescriptions"), this.styleVault.getConfigCellStyle());
                this.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.userDescriptionsHelp"));
                templateSheet.setDefaultColumnStyle(configColumnOffset, this.styleVault.getEmptyCellStyle());
                ++configColumnOffset;
                if (configBindingsColumnCount > 1) {
                    CellRangeAddress configRange = ExcelUtils.makeCellRangeAddress((int)0, (int)0, (int)configColumnOffset, (int)(configColumnOffset + configBindingsColumnCount - 1));
                    int n = templateSheet.addMergedRegion(configRange);
                }
                this.generateCell(firstRow, configColumnOffset, lex.getText("templateSideBar.configs"), this.styleVault.getConfigCellStyle());
                configColumnOffset += configBindingsColumnCount;
            }
            this.setConfigsCount(templateSheet, configBindingsColumnCount);
            int optionalColumnConfigCount = this.getConfigPropertyCount(optionalBindingList);
            if (!optionalComponents.isEmpty()) {
                this.generateCell(firstRow, configColumnOffset, "", this.styleVault.getOptionalConfigCellStyle());
                this.generateCell(secondRow, configColumnOffset, lex.getText("templateSideBar.optionalSlot"), this.styleVault.getOptionalConfigCellStyle());
                this.generateCell(thirdRow, configColumnOffset, lex.getText("templateSideBar.optionalSlotType"), this.styleVault.getOptionalConfigCellStyle());
                this.generateCell(fourthRow, configColumnOffset, "", this.styleVault.getOptionalConfigCellStyle());
                this.generateCell(fifthRow, configColumnOffset, lex.getText("templateSideBar.installOptional"), this.styleVault.getOptionalConfigCellStyle());
                labelCell = this.generateCell(sixthRow, configColumnOffset, lex.getText("templateSideBar.userDescriptions"), this.styleVault.getOptionalConfigCellStyle());
                this.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.userDescriptionsHelp"));
                templateSheet.setDefaultColumnStyle(configColumnOffset, this.styleVault.getEmptyCellStyle());
                ++configColumnOffset;
                if (optionalComponents.size() > 1) {
                    CellRangeAddress optionalRange = ExcelUtils.makeCellRangeAddress((int)0, (int)0, (int)configColumnOffset, (int)(configColumnOffset + optionalComponents.size() - 1));
                    int configBinding = templateSheet.addMergedRegion(optionalRange);
                }
                this.generateCell(firstRow, configColumnOffset, lex.getText("templateSideBar.optional"), this.styleVault.getOptionalConfigCellStyle());
                configColumnOffset += optionalComponents.size();
                if (optionalColumnConfigCount > 0) {
                    this.generateCell(firstRow, configColumnOffset, "", this.styleVault.getOptionalConfigCellStyle());
                    this.generateCell(secondRow, configColumnOffset, lex.getText("templateSideBar.slotName"), this.styleVault.getOptionalConfigCellStyle());
                    this.generateCell(thirdRow, configColumnOffset, lex.getText("templateSideBar.label"), this.styleVault.getOptionalConfigCellStyle());
                    this.generateCell(fourthRow, configColumnOffset, lex.getText("templateSideBar.slotType"), this.styleVault.getOptionalConfigCellStyle());
                    this.generateCell(fifthRow, configColumnOffset, lex.getText("templateSideBar.defaultValue"), this.styleVault.getOptionalConfigCellStyle());
                    labelCell = this.generateCell(sixthRow, configColumnOffset, lex.getText("templateSideBar.userDescriptions"), this.styleVault.getOptionalConfigCellStyle());
                    this.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.userDescriptionsHelp"));
                    templateSheet.setDefaultColumnStyle(configColumnOffset, this.styleVault.getEmptyCellStyle());
                    ++configColumnOffset;
                    for (BOrd optionalOrd : optionalComponents) {
                        String relativeSlotPath = "";
                        configsForOptionalComponent = 0;
                        BComponent optionalComponent = optionalOrd.resolve((BObject)templateBase).get().asComponent();
                        for (OptionalBindingProperties optionalBindingProp : optionalBindingList) {
                            Optional<BComponent> parentComponent = this.getComponentForOptionalConfig(optionalBindingProp.configBinding, optionalComponents, templateBase);
                            if (!parentComponent.isPresent() || parentComponent.get() != optionalComponent) continue;
                            relativeSlotPath = optionalBindingProp.relativeSlotPath;
                            configsForOptionalComponent += optionalBindingProp.properties.size();
                        }
                        if (configsForOptionalComponent == 0) continue;
                        if (configsForOptionalComponent > 1) {
                            CellRangeAddress optionalComponentRange = ExcelUtils.makeCellRangeAddress((int)0, (int)0, (int)configColumnOffset, (int)(configColumnOffset + configsForOptionalComponent - 1));
                            int optionalBindingProp = templateSheet.addMergedRegion(optionalComponentRange);
                        }
                        this.generateCell(firstRow, configColumnOffset, lex.getText("templateSideBar.optionalConfigs", new Object[]{relativeSlotPath}), this.styleVault.getOptionalConfigCellStyle());
                        configColumnOffset += configsForOptionalComponent;
                    }
                }
            }
            this.setOptionalCount(templateSheet, optionalComponents.size());
            this.setOptionalConfigurationCount(templateSheet, optionalColumnConfigCount);
            int tagColumnCount = 0;
            boolean bl = includeTags = tags != null && !tags.isEmpty();
            if (includeTags) {
                this.generateCell(firstRow, configColumnOffset, "", this.styleVault.getTagCellStyle());
                this.generateCell(secondRow, configColumnOffset, lex.getText("templateSideBar.tagId"), this.styleVault.getTagCellStyle());
                this.generateCell(thirdRow, configColumnOffset, "", this.styleVault.getTagCellStyle());
                this.generateCell(fourthRow, configColumnOffset, lex.getText("templateSideBar.slotType"), this.styleVault.getTagCellStyle());
                this.generateCell(fifthRow, configColumnOffset, lex.getText("templateSideBar.defaultValue"), this.styleVault.getTagCellStyle());
                labelCell = this.generateCell(sixthRow, configColumnOffset, lex.getText("templateSideBar.userDescriptions"), this.styleVault.getTagCellStyle());
                this.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.userDescriptionsHelp"));
                templateSheet.setDefaultColumnStyle(configColumnOffset, this.styleVault.getEmptyCellStyle());
                ++configColumnOffset;
                if (tags.size() > 1) {
                    CellRangeAddress tagRange = ExcelUtils.makeCellRangeAddress((int)0, (int)0, (int)configColumnOffset, (int)(configColumnOffset + tags.size() - 1));
                    configsForOptionalComponent = templateSheet.addMergedRegion(tagRange);
                }
                this.generateCell(firstRow, configColumnOffset, lex.getText("templateSideBar.tags"), this.styleVault.getTagCellStyle());
                for (int i3 = 0; i3 < tags.size(); ++i3) {
                    templateSheet.setDefaultColumnStyle(configColumnOffset + i3, this.styleVault.getStringCellStyle());
                }
                tagColumnCount += tags.size();
            }
            this.setTagCount(templateSheet, tagColumnCount);
            int propertyRowPosition = excelInstanceInfoColumns + (inputSlots.length > 0 ? 1 : 0);
            for (Slot input : inputSlots) {
                Property inputProperty = input.asProperty();
                Tags inputTags = templateConfig.getInputSlotTags(input);
                userTip = BString.make((String)input.getName());
                bindHints = BString.DEFAULT;
                BString sourceSlotHint = BString.DEFAULT;
                if (inputTags != null) {
                    userTip = inputTags.get(Id.newId((String)"n:userTip")).filter(biDataValue -> biDataValue.toString().length() != 0).orElse((BIDataValue)BString.make((String)input.getName()));
                    bindHints = (BIDataValue)inputTags.get(Id.newId((String)"n:bindHints")).orElse(BString.DEFAULT);
                    sourceSlotHint = (BIDataValue)inputTags.get(Id.newId((String)"n:targetSlotHint")).orElse(BString.make((String)DEFAULT_SOURCE_SLOT));
                }
                propertyCell = secondRow.createCell(propertyRowPosition);
                propertyCell.setCellValue(input.getName());
                propertyCell = thirdRow.createCell(propertyRowPosition);
                propertyCell.setCellValue(userTip.toString());
                propertyCell = fourthRow.createCell(propertyRowPosition);
                propertyCell.setCellValue(bindHints.toString());
                propertyCell = sixthRow.createCell(propertyRowPosition);
                propertyCell.setCellStyle(this.styleVault.stringCellStyle);
                propertyCell = fifthRow.createCell(++propertyRowPosition);
                propertyCell.setCellValue(sourceSlotHint.toString());
                propertyCell = sixthRow.createCell(propertyRowPosition);
                propertyCell.setCellStyle(this.styleVault.stringCellStyle);
                ++propertyRowPosition;
            }
            propertyRowPosition += outputSlots.length > 0 ? 1 : 0;
            for (Slot output : outputSlots) {
                Property outputProperty = output.asProperty();
                Tags outputTags = templateConfig.getOutputSlotTags(output);
                userTip = BString.make((String)output.getName());
                bindHints = BString.DEFAULT;
                BString targetSlotHint = BString.DEFAULT;
                if (outputTags != null) {
                    userTip = outputTags.get(Id.newId((String)"n:userTip")).filter(biDataValue -> biDataValue.toString().length() != 0).orElse((BIDataValue)BString.make((String)output.getName()));
                    bindHints = (BIDataValue)outputTags.get(Id.newId((String)"n:bindHints")).orElse(BString.DEFAULT);
                    targetSlotHint = (BIDataValue)outputTags.get(Id.newId((String)"n:targetSlotHint")).orElse(BString.make((String)DEFAULT_TARGET_SLOT));
                }
                propertyCell = secondRow.createCell(propertyRowPosition);
                propertyCell.setCellValue(output.getName());
                propertyCell = thirdRow.createCell(propertyRowPosition);
                propertyCell.setCellValue(userTip.toString());
                propertyCell = fourthRow.createCell(propertyRowPosition);
                propertyCell.setCellValue(bindHints.toString());
                propertyCell = sixthRow.createCell(propertyRowPosition);
                propertyCell.setCellStyle(this.styleVault.stringCellStyle);
                propertyCell = fifthRow.createCell(++propertyRowPosition);
                propertyCell.setCellValue(targetSlotHint.toString());
                propertyCell = sixthRow.createCell(propertyRowPosition);
                propertyCell.setCellStyle(this.styleVault.stringCellStyle);
                ++propertyRowPosition;
            }
            propertyRowPosition += relations.size() > 0 ? 1 : 0;
            for (BRelationInfo relation : relations) {
                Cell propertyCell2 = secondRow.createCell(propertyRowPosition);
                propertyCell2.setCellValue(relation.getUserTip());
                propertyCell2 = thirdRow.createCell(propertyRowPosition);
                propertyCell2.setCellValue(relation.getRelationId());
                propertyCell2 = fourthRow.createCell(propertyRowPosition);
                propertyCell2.setCellValue(relation.getRelateHints());
                propertyCell2 = fifthRow.createCell(propertyRowPosition);
                propertyCell2.setCellValue(relation.getInbound() ? lex.getText("templateRelationEditor.in") : lex.getText("templateRelationEditor.out"));
                propertyCell2 = sixthRow.createCell(propertyRowPosition);
                propertyCell2.setCellStyle(this.styleVault.stringCellStyle);
                ++propertyRowPosition;
            }
            if (configBindingsColumnCount > 0) {
                ++propertyRowPosition;
                for (BindingProperties normalBindingProps : normalBindingList) {
                    Row[] rows = new Row[]{secondRow, thirdRow, fourthRow, fifthRow, sixthRow};
                    propertyRowPosition += this.addConfigColumn(normalBindingProps, rows, propertyRowPosition);
                }
            }
            HashMap<String, Boolean> optionalHighlight = new HashMap<String, Boolean>();
            boolean lastHighlight = Boolean.TRUE;
            propertyRowPosition += !optionalComponents.isEmpty() ? 1 : 0;
            for (BOrd optionalOrd : optionalComponents) {
                String optionalSlot = this.getRelativeSlotPathForOptionalComponent(optionalOrd, templateBase);
                String optionalSlotType = optionalOrd.resolve((BObject)templateBase).get().getType().toString();
                lastHighlight = !lastHighlight;
                optionalHighlight.put(optionalSlot, lastHighlight);
                Cell propertyCell3 = secondRow.createCell(propertyRowPosition);
                propertyCell3.setCellValue(optionalSlot);
                this.setOptionalCellStyle(lastHighlight, propertyCell3);
                propertyCell3 = thirdRow.createCell(propertyRowPosition);
                propertyCell3.setCellValue(optionalSlotType);
                this.setOptionalCellStyle(lastHighlight, propertyCell3);
                propertyCell3 = fourthRow.createCell(propertyRowPosition);
                this.setOptionalCellStyle(lastHighlight, propertyCell3);
                propertyCell3 = fifthRow.createCell(propertyRowPosition);
                propertyCell3.setCellValue(lex.getText("templateSideBar.true"));
                this.setOptionalCellStyle(lastHighlight, propertyCell3);
                propertyCell3 = sixthRow.createCell(propertyRowPosition);
                propertyCell3.setCellStyle(this.styleVault.stringCellStyle);
                ++propertyRowPosition;
            }
            if (optionalColumnConfigCount > 0) {
                ++propertyRowPosition;
                for (OptionalBindingProperties optionalBindingProps : optionalBindingList) {
                    Row[] rows = new Row[]{secondRow, thirdRow, fourthRow, fifthRow, sixthRow};
                    int addedPositions = this.addConfigColumn(optionalBindingProps, rows, propertyRowPosition);
                    Optional<BComponent> parentComponent = this.getComponentForOptionalConfig(optionalBindingProps.configBinding, optionalComponents, templateBase);
                    if (parentComponent.isPresent()) {
                        boolean highlight = (Boolean)optionalHighlight.get(optionalBindingProps.relativeSlotPath);
                        for (int i4 = 0; i4 < addedPositions; ++i4) {
                            int thisRowPosition = propertyRowPosition + i4;
                            for (int n = 0; n < 4; ++n) {
                                Cell highlightCell = rows[n].getCell(thisRowPosition);
                                this.setOptionalCellStyle(highlight, highlightCell);
                            }
                            templateSheet.setDefaultColumnStyle(configColumnOffset + i4, this.styleVault.getEmptyCellStyle());
                        }
                    }
                    propertyRowPosition += addedPositions;
                }
            }
            if (includeTags) {
                AtomicInteger lambdaInt = new AtomicInteger(propertyRowPosition += tags.isEmpty() ? 0 : 1);
                tags.forEach(tag -> {
                    Cell propertyCell = secondRow.createCell(lambdaInt.get());
                    propertyCell.setCellValue(tag.getId().getQName());
                    propertyCell = fourthRow.createCell(lambdaInt.get());
                    propertyCell.setCellValue(tag.getValue().getType().toString());
                    this.setCellComment(templateSheet, propertyCell, lex.getText("templateSideBar.slotTypeStringHelp"));
                    propertyCell = fifthRow.createCell(lambdaInt.get());
                    propertyCell.setCellValue(tag.getValue().toString(null));
                    propertyCell = sixthRow.createCell(lambdaInt.get());
                    propertyCell.setCellStyle(this.styleVault.stringCellStyle);
                    lambdaInt.incrementAndGet();
                });
                propertyRowPosition = lambdaInt.get();
            }
            for (int i5 = 0; i5 < propertyRowPosition; ++i5) {
                templateSheet.autoSizeColumn(i5);
            }
            templateSheet.createFreezePane(columnFreezePane, 6);
        }
        catch (Exception e) {
            log.log(Level.WARNING, lex.getText("bulkDeploy.excelExport.columnError"), e);
            return;
        }
    }

    private void getTemplateConfigContents(NiagaraTemplate template, Sheet templateSheet) {
        Row firstRow = templateSheet.createRow(0);
        Row secondRow = templateSheet.createRow(1);
        Row thirdRow = templateSheet.createRow(2);
        Row fourthRow = templateSheet.createRow(3);
        Row fifthRow = templateSheet.createRow(4);
        Row sixthRow = templateSheet.createRow(5);
        Row seventhRow = templateSheet.createRow(6);
        int excelInstanceInfoColumns = 0;
        String description = template.getDescription();
        String info = template.getInfo();
        this.generateCell(firstRow, 0, lex.getText("templateSideBar.description"), this.styleVault.getInfoCellStyle());
        Cell labelCell = this.generateCell(firstRow, 1, description, this.styleVault.getStringCellStyle());
        if (!info.isEmpty()) {
            this.setCellComment(templateSheet, labelCell, info);
        }
        int uniqueDeviceColumn = 4;
        int columnFreezePane = 2;
        switch (template.getTemplateType()) {
            case APPLICATION: {
                excelInstanceInfoColumns = 2;
                break;
            }
            case DEVICE: {
                excelInstanceInfoColumns = 5;
                break;
            }
            default: {
                excelInstanceInfoColumns = 5;
            }
        }
        for (int i = 0; i < excelInstanceInfoColumns; ++i) {
            templateSheet.setDefaultColumnStyle(i, this.styleVault.getStringCellStyle());
        }
        if (template.getTemplateType() == com.tridium.template.api.TemplateType.APPLICATION) {
            labelCell = this.generateCell(sixthRow, 0, lex.getText("templateSideBar.rowName"), this.styleVault.getInstanceCellStyle());
            this.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.rowNameHelp"));
            uniqueDeviceColumn = 1;
            columnFreezePane = 2;
            Cell nameCell = seventhRow.createCell(0);
            nameCell.setCellValue(template.getTitle());
            nameCell.setCellStyle(this.styleVault.getStringCellStyle());
        }
        labelCell = this.generateCell(sixthRow, uniqueDeviceColumn, lex.getText("templateSideBar.uniqueDevice"), this.styleVault.getOptionalCellStyle());
        this.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.uniqueDeviceHelp"));
        this.setTemplateSheetInfoColumns(templateSheet, excelInstanceInfoColumns);
        int configColumnOffset = excelInstanceInfoColumns;
        this.setInputsCount(templateSheet, 0);
        this.setOutputsCount(templateSheet, 0);
        this.setRelationsCount(templateSheet, 0);
        int configBindingsColumnCount = template.requiredPropertyElements().size();
        if (configBindingsColumnCount > 0) {
            this.generateCell(firstRow, configColumnOffset, "", this.styleVault.getConfigCellStyle());
            this.generateCell(secondRow, configColumnOffset, lex.getText("templateSideBar.slotName"), this.styleVault.getConfigCellStyle());
            this.generateCell(thirdRow, configColumnOffset, lex.getText("templateSideBar.label"), this.styleVault.getConfigCellStyle());
            this.generateCell(fourthRow, configColumnOffset, lex.getText("templateSideBar.slotType"), this.styleVault.getConfigCellStyle());
            this.generateCell(fifthRow, configColumnOffset, lex.getText("templateSideBar.defaultValue"), this.styleVault.getConfigCellStyle());
            labelCell = this.generateCell(sixthRow, configColumnOffset, lex.getText("templateSideBar.userDescriptions"), this.styleVault.getConfigCellStyle());
            this.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.userDescriptionsHelp"));
            templateSheet.setDefaultColumnStyle(configColumnOffset, this.styleVault.getEmptyCellStyle());
            ++configColumnOffset;
            if (configBindingsColumnCount > 1) {
                CellRangeAddress configRange = ExcelUtils.makeCellRangeAddress((int)0, (int)0, (int)configColumnOffset, (int)(configColumnOffset + configBindingsColumnCount - 1));
                int n = templateSheet.addMergedRegion(configRange);
            }
            this.generateCell(firstRow, configColumnOffset, lex.getText("templateSideBar.configs"), this.styleVault.getConfigCellStyle());
            configColumnOffset += configBindingsColumnCount;
        }
        this.setConfigsCount(templateSheet, configBindingsColumnCount);
        int optionalColumnConfigCount = 0;
        List optionalComponents = template.optionalComponents();
        for (OptionalComponent optionalComponent : optionalComponents) {
            optionalColumnConfigCount += optionalComponent.propertyElements().size();
        }
        if (!optionalComponents.isEmpty()) {
            this.generateCell(firstRow, configColumnOffset, "", this.styleVault.getOptionalConfigCellStyle());
            this.generateCell(secondRow, configColumnOffset, lex.getText("templateSideBar.optionalSlot"), this.styleVault.getOptionalConfigCellStyle());
            this.generateCell(thirdRow, configColumnOffset, lex.getText("templateSideBar.optionalSlotType"), this.styleVault.getOptionalConfigCellStyle());
            this.generateCell(fourthRow, configColumnOffset, "", this.styleVault.getOptionalConfigCellStyle());
            this.generateCell(fifthRow, configColumnOffset, lex.getText("templateSideBar.installOptional"), this.styleVault.getOptionalConfigCellStyle());
            labelCell = this.generateCell(sixthRow, configColumnOffset, lex.getText("templateSideBar.userDescriptions"), this.styleVault.getOptionalConfigCellStyle());
            this.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.userDescriptionsHelp"));
            templateSheet.setDefaultColumnStyle(configColumnOffset, this.styleVault.getEmptyCellStyle());
            ++configColumnOffset;
            if (optionalComponents.size() > 1) {
                CellRangeAddress optionalRange = ExcelUtils.makeCellRangeAddress((int)0, (int)0, (int)configColumnOffset, (int)(configColumnOffset + optionalComponents.size() - 1));
                int optionalComponent = templateSheet.addMergedRegion(optionalRange);
            }
            this.generateCell(firstRow, configColumnOffset, lex.getText("templateSideBar.optional"), this.styleVault.getOptionalConfigCellStyle());
            configColumnOffset += optionalComponents.size();
            if (optionalColumnConfigCount > 0) {
                this.generateCell(firstRow, configColumnOffset, "", this.styleVault.getOptionalConfigCellStyle());
                this.generateCell(secondRow, configColumnOffset, lex.getText("templateSideBar.slotName"), this.styleVault.getOptionalConfigCellStyle());
                this.generateCell(thirdRow, configColumnOffset, lex.getText("templateSideBar.label"), this.styleVault.getOptionalConfigCellStyle());
                this.generateCell(fourthRow, configColumnOffset, lex.getText("templateSideBar.slotType"), this.styleVault.getOptionalConfigCellStyle());
                this.generateCell(fifthRow, configColumnOffset, lex.getText("templateSideBar.defaultValue"), this.styleVault.getOptionalConfigCellStyle());
                labelCell = this.generateCell(sixthRow, configColumnOffset, lex.getText("templateSideBar.userDescriptions"), this.styleVault.getOptionalConfigCellStyle());
                this.setCellComment(templateSheet, labelCell, lex.getText("templateSideBar.userDescriptionsHelp"));
                templateSheet.setDefaultColumnStyle(configColumnOffset, this.styleVault.getEmptyCellStyle());
                ++configColumnOffset;
                for (OptionalComponent optionalComponent : optionalComponents) {
                    if (optionalComponent.propertyElements().size() == 0) continue;
                    if (optionalComponent.propertyElements().size() > 1) {
                        CellRangeAddress optionalComponentRange = ExcelUtils.makeCellRangeAddress((int)0, (int)0, (int)configColumnOffset, (int)(configColumnOffset + optionalComponent.propertyElements().size() - 1));
                        int n = templateSheet.addMergedRegion(optionalComponentRange);
                    }
                    this.generateCell(firstRow, configColumnOffset, lex.getText("templateSideBar.optionalConfigs", new Object[]{this.getOptionalComponentSlot(optionalComponent.getPath())}), this.styleVault.getOptionalConfigCellStyle());
                    configColumnOffset += optionalComponent.propertyElements().size();
                }
            }
        }
        this.setOptionalCount(templateSheet, optionalComponents.size());
        this.setOptionalConfigurationCount(templateSheet, optionalColumnConfigCount);
        this.setTagCount(templateSheet, 0);
        int propertyRowPosition = excelInstanceInfoColumns;
        if (configBindingsColumnCount > 0) {
            ++propertyRowPosition;
            Row[] rows = new Row[]{secondRow, thirdRow, fourthRow, fifthRow, sixthRow, seventhRow};
            for (TemplateElement configElement : template.requiredPropertyElements()) {
                this.setCellValueAndFormatColumn(rows, configElement, propertyRowPosition++);
            }
        }
        HashMap<String, Boolean> optionalHighlight = new HashMap<String, Boolean>();
        boolean lastHighlight = true;
        propertyRowPosition += optionalComponents.isEmpty() ? 0 : 1;
        for (OptionalComponent optionalComponent : optionalComponents) {
            String optionalPath = optionalComponent.getPath();
            String optionalSlot = this.getOptionalComponentSlot(optionalPath);
            String optionalSlotType = optionalComponent.getNType();
            lastHighlight = !lastHighlight;
            optionalHighlight.put(optionalPath, lastHighlight);
            Cell propertyCell = secondRow.createCell(propertyRowPosition);
            propertyCell.setCellValue(optionalSlot);
            this.setOptionalCellStyle(lastHighlight, propertyCell);
            propertyCell = thirdRow.createCell(propertyRowPosition);
            propertyCell.setCellValue(optionalSlotType);
            this.setOptionalCellStyle(lastHighlight, propertyCell);
            propertyCell = fourthRow.createCell(propertyRowPosition);
            this.setOptionalCellStyle(lastHighlight, propertyCell);
            propertyCell = fifthRow.createCell(propertyRowPosition);
            propertyCell.setCellValue(lex.getText("templateSideBar.true"));
            this.setOptionalCellStyle(lastHighlight, propertyCell);
            propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
            propertyCell = sixthRow.createCell(propertyRowPosition);
            propertyCell.setCellStyle(this.styleVault.stringCellStyle);
            if (!optionalComponent.isInstalled()) {
                propertyCell = seventhRow.createCell(propertyRowPosition);
                propertyCell.setCellValue(lex.getText("templateSideBar.false"));
                propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
            }
            ++propertyRowPosition;
        }
        if (optionalColumnConfigCount > 0) {
            ++propertyRowPosition;
            for (OptionalComponent optionalComponent : optionalComponents) {
                boolean highlight = (Boolean)optionalHighlight.get(optionalComponent.getPath());
                for (TemplateElement element : optionalComponent.propertyElements()) {
                    Row[] rows = new Row[]{secondRow, thirdRow, fourthRow, fifthRow, sixthRow, seventhRow};
                    this.setCellValueAndFormatColumn(rows, element, propertyRowPosition);
                    for (int n = 0; n < 4; ++n) {
                        Cell highlightCell = rows[n].getCell(propertyRowPosition);
                        this.setOptionalCellStyle(highlight, highlightCell);
                    }
                    ++propertyRowPosition;
                }
            }
        }
        for (int i = 0; i < propertyRowPosition; ++i) {
            templateSheet.autoSizeColumn(i);
        }
        templateSheet.createFreezePane(columnFreezePane, 6);
    }

    private void setOptionalCellStyle(boolean isHighlighted, Cell cell) {
        CellStyle highlightCellStyle;
        if (isHighlighted && (highlightCellStyle = this.styleVault.getHighlightCellStyle()) != null && ExcelUtils.isXmlFormat((ExcelFileObject)cell)) {
            cell.setCellStyle(highlightCellStyle);
        }
    }

    private String getOptionalComponentSlot(String optionalComponentPath) {
        if (optionalComponentPath.startsWith("Drivers/")) {
            return optionalComponentPath.substring("Drivers/".length());
        }
        return optionalComponentPath;
    }

    private int addConfigColumn(BindingProperties configBindingProps, Row[] rows, int propertyRowPosition) throws IOException {
        String userTip = configBindingProps.configBinding.getUserTip();
        for (BindingProperty entry : configBindingProps.properties) {
            this.setCellValueAndFormatColumn(rows, entry.property, entry.value, propertyRowPosition, entry.name, userTip);
            ++propertyRowPosition;
        }
        return configBindingProps.properties.size();
    }

    private String getRelativeSlotPathForOptionalComponent(BOrd optionalOrd, BComponent templateBase) {
        BComponent optionalComponent = optionalOrd.resolve((BObject)templateBase).get().asComponent();
        return this.getRelativeSlotPathForOptionalComponent(optionalComponent, templateBase);
    }

    private String getRelativeSlotPathForOptionalComponent(BComponent optionalComponent, BComponent templateBase) {
        BDriverContainer[] containers = (BDriverContainer[])CompUtil.getDescendants((BComponent)templateBase, BDriverContainer.class);
        Optional relativeSlotPath = CompUtil.slotPathFromAncestor((BComplex)containers[0], (BComplex)optionalComponent);
        return relativeSlotPath.isPresent() ? ((SlotPath)relativeSlotPath.get()).toDisplayString() : optionalComponent.getSlotPathOrd().toString();
    }

    private Optional<BComponent> getComponentForOptionalConfig(BConfigBinding configBinding, List<BOrd> optionalComponents, BComponent templateBase) {
        BObject configTargetObject = configBinding.getTargetOrd().resolve((BObject)templateBase).get();
        for (BOrd optionalOrd : optionalComponents) {
            BComplex parentObject;
            Optional slotPath;
            Optional slotPath2;
            BComponent optionalComponent = optionalOrd.resolve((BObject)templateBase).get().asComponent();
            if (!(configTargetObject instanceof BComplex ? (slotPath2 = CompUtil.slotPathFromAncestor((BComplex)optionalComponent, (BComplex)((BComplex)configTargetObject))).isPresent() : (slotPath = CompUtil.slotPathFromAncestor((BComplex)optionalComponent, (BComplex)(parentObject = configBinding.getTargetOrd().resolve((BObject)templateBase).getParent()))).isPresent())) continue;
            return Optional.of(optionalComponent);
        }
        return Optional.empty();
    }

    private boolean isOptionalConfiguration(BConfigBinding configBinding, List<BOrd> optionalComponents, BComponent templateBase) {
        BObject configTargetObject = configBinding.getTargetOrd().resolve((BObject)templateBase).get();
        for (BOrd optionalOrd : optionalComponents) {
            BComplex parentObject;
            Optional slotPath;
            Optional slotPath2;
            BComponent optionalComponent = optionalOrd.resolve((BObject)templateBase).get().asComponent();
            if (!(configTargetObject instanceof BComplex ? (slotPath2 = CompUtil.slotPathFromAncestor((BComplex)optionalComponent, (BComplex)((BComplex)configTargetObject))).isPresent() : (slotPath = CompUtil.slotPathFromAncestor((BComplex)optionalComponent, (BComplex)(parentObject = configBinding.getTargetOrd().resolve((BObject)templateBase).getParent()))).isPresent())) continue;
            return true;
        }
        return false;
    }

    private int getConfigPropertyCount(List<? extends BindingProperties> bindingList) {
        int propertyCount = 0;
        for (BindingProperties bindingProperties : bindingList) {
            propertyCount += bindingProperties.properties.size();
        }
        return propertyCount;
    }

    private int unconfigurableHistoryExtCount(BComponent templateBase, BTemplateConfig templateConfig) {
        return this.unconfigurableHistoryExtensions(templateBase, templateConfig).length;
    }

    public BHistoryExt[] unconfigurableHistoryExtensions(BComponent templateBase) {
        BTemplateConfig templateConfig = BTemplateConfig.getConfigForRoot((BComponent)templateBase);
        return this.unconfigurableHistoryExtensions(templateBase, templateConfig);
    }

    private BHistoryExt[] unconfigurableHistoryExtensions(BComponent templateBase, BTemplateConfig templateConfig) {
        BConfigBinding[] configBindings;
        BHistoryExt[] allHistoryExtensions = (BHistoryExt[])CompUtil.getDescendants((BComponent)templateBase, BHistoryExt.class);
        HashSet<BHistoryExt> unconfigurableHistoryExtensions = null;
        for (BConfigBinding configBinding : configBindings = (BConfigBinding[])templateConfig.getChildren(BConfigBinding.class)) {
            BObject target;
            if (!Objects.equals(configBinding.getTargetSlot(), BHistoryExt.enabled.getName()) || !((target = configBinding.getTargetOrd().resolve((BObject)templateConfig).get()) instanceof BHistoryExt)) continue;
            BHistoryExt targetHistoryExt = (BHistoryExt)target;
            if (unconfigurableHistoryExtensions == null) {
                unconfigurableHistoryExtensions = new HashSet<BHistoryExt>();
                unconfigurableHistoryExtensions.addAll(Arrays.asList(allHistoryExtensions));
            }
            unconfigurableHistoryExtensions.remove(targetHistoryExt);
        }
        if (unconfigurableHistoryExtensions == null) {
            return allHistoryExtensions;
        }
        return unconfigurableHistoryExtensions.toArray(new BHistoryExt[unconfigurableHistoryExtensions.size()]);
    }

    private Cell generateCell(Row row, int column, String value, CellStyle style) {
        Cell newCell = row.createCell(column);
        if (value.isEmpty()) {
            newCell.setBlank();
        } else {
            newCell.setCellValue(value);
        }
        if (style != null) {
            newCell.setCellStyle(style);
        }
        return newCell;
    }

    private void setCellValueAndFormatColumn(Row[] rows, Property configProperty, BValue configPropertyValue, int propertyRowPosition, String slotName, String userTip) throws IOException {
        Sheet sheet = rows[0].getSheet();
        Cell propertyCell = rows[0].createCell(propertyRowPosition);
        String cellValue = SlotPath.unescape((String)slotName);
        propertyCell.setCellValue(cellValue);
        propertyCell = rows[1].createCell(propertyRowPosition);
        propertyCell.setCellValue(userTip);
        Cell slotTypeCell = rows[2].createCell(propertyRowPosition);
        slotTypeCell.setCellValue(configProperty.getType().toString());
        if (configProperty.getType().is(BStatusValue.TYPE)) {
            if (configProperty.getType().is(BStatusNumeric.TYPE)) {
                sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getDataCellStyle());
                propertyCell = rows[3].createCell(propertyRowPosition);
                propertyCell.setCellValue(((BStatusNumeric)configPropertyValue).getValue());
                propertyCell.setCellStyle(this.styleVault.getDataCellStyle());
                this.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeNumberHelp"));
            } else if (configProperty.getType().is(BStatusBoolean.TYPE)) {
                sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getStringCellStyle());
                propertyCell = rows[3].createCell(propertyRowPosition);
                propertyCell.setCellValue(((BStatusValue)configPropertyValue).valueToString(null));
                propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
                this.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeBooleanHelp"));
            } else if (configProperty.getType().is(BStatusEnum.TYPE)) {
                sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getStringCellStyle());
                propertyCell = rows[3].createCell(propertyRowPosition);
                propertyCell.setCellValue(((BStatusValue)configPropertyValue).valueToString(null));
                propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
                String commentText = this.getEnumCellComment(((BStatusEnum)configPropertyValue).getEnum());
                this.setCellComment(sheet, slotTypeCell, commentText);
            } else {
                sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getStringCellStyle());
                propertyCell = rows[3].createCell(propertyRowPosition);
                propertyCell.setCellValue(((BStatusValue)configPropertyValue).valueToString(null));
                propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
                this.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeStringHelp"));
            }
        } else if (configProperty.getType().is(BSimple.TYPE)) {
            if (configProperty.getType().is(BNumber.TYPE)) {
                sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getDataCellStyle());
                propertyCell = rows[3].createCell(propertyRowPosition);
                propertyCell.setCellValue(((BNumber)configPropertyValue).getDouble());
                propertyCell.setCellStyle(this.styleVault.getDataCellStyle());
                if (configProperty.getType().is(BInteger.TYPE) || configProperty.getType().is(BLong.TYPE)) {
                    this.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeIntHelp"));
                } else {
                    this.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeNumberHelp"));
                }
            } else if (configProperty.getType().is(BBoolean.TYPE)) {
                sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getStringCellStyle());
                propertyCell = rows[3].createCell(propertyRowPosition);
                propertyCell.setCellValue(((BSimple)configPropertyValue).encodeToString());
                propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
                this.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeBooleanHelp"));
            } else if (configProperty.getType().is(BEnum.TYPE)) {
                if (configProperty.getType().is(BDynamicEnum.TYPE)) {
                    sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getDataCellStyle());
                    propertyCell = rows[3].createCell(propertyRowPosition);
                    propertyCell.setCellValue(((BDynamicEnum)configPropertyValue).getTag());
                    propertyCell.setCellStyle(this.styleVault.getDataCellStyle());
                } else {
                    sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getStringCellStyle());
                    propertyCell = rows[3].createCell(propertyRowPosition);
                    propertyCell.setCellValue(((BSimple)configPropertyValue).encodeToString());
                    propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
                }
                String commentText = this.getEnumCellComment((BEnum)configPropertyValue);
                this.setCellComment(sheet, slotTypeCell, commentText);
            } else if (configProperty.getType().is(BPassword.TYPE)) {
                sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getPasswordCellStyle());
                propertyCell = rows[3].createCell(propertyRowPosition);
                propertyCell.setCellStyle(this.styleVault.getPasswordCellStyle());
                this.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeStringHelp"));
            } else {
                sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getStringCellStyle());
                propertyCell = rows[3].createCell(propertyRowPosition);
                propertyCell.setCellValue(((BSimple)configPropertyValue).encodeToString());
                propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
                this.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeStringHelp"));
            }
        } else {
            sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getStringCellStyle());
            propertyCell = rows[3].createCell(propertyRowPosition);
            propertyCell.setCellValue(configPropertyValue.toString());
            propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
            this.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeStringHelp"));
        }
        propertyCell = rows[4].createCell(propertyRowPosition);
        propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
    }

    private void setCellValueAndFormatColumn(Row[] rows, TemplateElement element, int propertyRowPosition) {
        Sheet sheet = rows[0].getSheet();
        Cell propertyCell = rows[0].createCell(propertyRowPosition);
        String cellValue = SlotPath.unescape((String)element.getFullName());
        propertyCell.setCellValue(cellValue);
        propertyCell = rows[1].createCell(propertyRowPosition);
        propertyCell.setCellValue(element.property().getUserTip());
        Cell slotTypeCell = rows[2].createCell(propertyRowPosition);
        TemplateValue presentValue = element.presentValue();
        TemplateValue localValue = element.localValue();
        TemplateValue defaultValue = element.defaultValue();
        slotTypeCell.setCellValue(presentValue.getNType());
        switch (presentValue.getType()) {
            case NUMERIC: {
                sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getDataCellStyle());
                propertyCell = rows[3].createCell(propertyRowPosition);
                if (!defaultValue.isMissing()) {
                    propertyCell.setCellValue(defaultValue.getNumericValue());
                }
                propertyCell.setCellStyle(this.styleVault.getDataCellStyle());
                this.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeNumberHelp"));
                if (localValue.isMissing()) break;
                propertyCell = rows[5].createCell(propertyRowPosition);
                propertyCell.setCellValue(localValue.getNumericValue());
                propertyCell.setCellStyle(this.styleVault.getDataCellStyle());
                break;
            }
            case INTEGER: {
                sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getDataCellStyle());
                propertyCell = rows[3].createCell(propertyRowPosition);
                if (!defaultValue.isMissing()) {
                    propertyCell.setCellValue(defaultValue.getNumericValue());
                }
                propertyCell.setCellStyle(this.styleVault.getDataCellStyle());
                this.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeIntHelp"));
                if (localValue.isMissing()) break;
                propertyCell = rows[5].createCell(propertyRowPosition);
                propertyCell.setCellValue(localValue.getNumericValue());
                propertyCell.setCellStyle(this.styleVault.getDataCellStyle());
                break;
            }
            case BOOLEAN: {
                sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getStringCellStyle());
                propertyCell = rows[3].createCell(propertyRowPosition);
                if (!defaultValue.isMissing()) {
                    propertyCell.setCellValue(BBoolean.toString((boolean)defaultValue.getBooleanValue(), null));
                }
                propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
                this.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeBooleanHelp"));
                if (localValue.isMissing()) break;
                propertyCell = rows[5].createCell(propertyRowPosition);
                propertyCell.setCellValue(BBoolean.toString((boolean)localValue.getBooleanValue(), null));
                propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
                break;
            }
            case ENUM: {
                Map enumValues = presentValue.getDefinedEnumValues();
                if (enumValues.isEmpty()) {
                    sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getDataCellStyle());
                } else {
                    sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getStringCellStyle());
                }
                propertyCell = rows[3].createCell(propertyRowPosition);
                if (!defaultValue.isMissing()) {
                    int enumValue = (int)defaultValue.getIntegerValue();
                    if (enumValues.containsKey(enumValue)) {
                        propertyCell.setCellValue((String)enumValues.get(enumValue));
                    } else {
                        propertyCell.setCellValue((double)enumValue);
                    }
                }
                if (enumValues.isEmpty()) {
                    propertyCell.setCellStyle(this.styleVault.getDataCellStyle());
                } else {
                    propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
                }
                String commentText = this.getEnumCellComment(enumValues);
                this.setCellComment(sheet, slotTypeCell, commentText);
                if (localValue.isMissing()) break;
                propertyCell = rows[5].createCell(propertyRowPosition);
                int enumValue = (int)localValue.getIntegerValue();
                if (enumValues.containsKey(enumValue)) {
                    propertyCell.setCellValue((String)enumValues.get(enumValue));
                } else {
                    propertyCell.setCellValue((double)enumValue);
                }
                if (enumValues.isEmpty()) {
                    propertyCell.setCellStyle(this.styleVault.getDataCellStyle());
                    break;
                }
                propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
                break;
            }
            case PASSWORD: {
                sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getPasswordCellStyle());
                propertyCell = rows[3].createCell(propertyRowPosition);
                propertyCell.setCellStyle(this.styleVault.getPasswordCellStyle());
                this.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeStringHelp"));
                break;
            }
            default: {
                sheet.setDefaultColumnStyle(propertyRowPosition, this.styleVault.getStringCellStyle());
                propertyCell = rows[3].createCell(propertyRowPosition);
                if (!defaultValue.isMissing()) {
                    propertyCell.setCellValue(defaultValue.getStringValue());
                }
                propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
                this.setCellComment(sheet, slotTypeCell, lex.getText("templateSideBar.slotTypeStringHelp"));
                if (localValue.isMissing()) break;
                propertyCell = rows[5].createCell(propertyRowPosition);
                propertyCell.setCellValue(localValue.getStringValue());
                propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
            }
        }
        propertyCell = rows[4].createCell(propertyRowPosition);
        propertyCell.setCellStyle(this.styleVault.getStringCellStyle());
    }

    private String getEnumCellComment(BEnum tags) {
        BEnumRange range = tags.getRange();
        if (range.isNull()) {
            return lex.getText("templateSideBar.slotTypeEnumEmptyHelp");
        }
        StringBuilder sb = new StringBuilder(lex.getText("templateSideBar.slotTypeEnumHelp")).append("\n");
        int currentLineLength = 0;
        boolean first = true;
        for (int i : range.getOrdinals()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            if (currentLineLength > 60) {
                sb.append("\n");
                currentLineLength = 0;
            }
            String tag = range.getTag(i);
            sb.append(tag);
            currentLineLength += tag.length() + 2;
        }
        return sb.toString();
    }

    private String getEnumCellComment(Map<Integer, String> enumValues) {
        if (enumValues.isEmpty()) {
            return lex.getText("templateSideBar.slotTypeEnumEmptyHelp");
        }
        StringBuilder sb = new StringBuilder(lex.getText("templateSideBar.slotTypeEnumHelp")).append("\n");
        int currentLineLength = 0;
        boolean first = true;
        for (String enumValue : enumValues.values()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            if (currentLineLength > 60) {
                sb.append("\n");
                currentLineLength = 0;
            }
            sb.append(enumValue);
            currentLineLength += enumValue.length() + 2;
        }
        return sb.toString();
    }

    private void setCellComment(Sheet sheet, Cell cell, String text) {
        CreationHelper factory = sheet.getWorkbook().getCreationHelper();
        ClientAnchor anchor = factory.createClientAnchor();
        anchor.setCol1(cell.getColumnIndex());
        anchor.setCol2(cell.getColumnIndex() + 5);
        anchor.setRow1(cell.getRow().getRowNum());
        anchor.setRow2(cell.getRow().getRowNum() + 5);
        Drawing drawing = sheet.createDrawingPatriarch();
        Comment comment = drawing.createCellComment(anchor);
        comment.setAuthor("Niagara Template Exporter");
        RichTextString rts = factory.createRichTextString(text);
        comment.setString(rts);
        cell.setCellComment(comment);
    }

    public Map<String, String> getTemplateTitlesFromExcel(BulkDeployWorkbook workbook) {
        List<DeployedWorksheet> deployedWorksheets = this.loadDeployedWorksheets(workbook);
        HashMap<String, String> templateTitles = new HashMap<String, String>();
        if (deployedWorksheets == null || deployedWorksheets.isEmpty()) {
            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.importFileError", new Object[]{workbook.getName()}));
        }
        for (DeployedWorksheet deployedWorksheet : deployedWorksheets) {
            for (DeployedRoot deployedRoot : deployedWorksheet.deployedRoots) {
                templateTitles.put(deployedWorksheet.title, deployedRoot.deployName);
            }
        }
        return templateTitles;
    }

    public void deployTemplatesFromExcel(BulkDeployWorkbook bulkDeployWorkbook, BComponent root, TemplateDeployWorker worker) {
        List<DeployedWorksheet> deployedWorksheets = this.loadDeployedWorksheets(bulkDeployWorkbook);
        if (deployedWorksheets == null || deployedWorksheets.isEmpty()) {
            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.importFileError", new Object[]{bulkDeployWorkbook.getName()}));
            return;
        }
        int templateInstanceCount = deployedWorksheets.stream().mapToInt(deployedWorksheet -> deployedWorksheet.deployedRoots.size()).sum();
        int processedInstances = 0;
        int totalProgress = 0;
        HashMap<BComponent, BNameMap> displayNames = new HashMap<BComponent, BNameMap>();
        for (DeployedWorksheet deployedWorksheet2 : deployedWorksheets) {
            for (DeployedRoot deployedRoot : deployedWorksheet2.deployedRoots) {
                int currentProgress;
                BComponent deployedRootComponent;
                log.log(IMPORT_LOG_LEVEL, "Copying type " + deployedWorksheet2.templateType + " template " + deployedWorksheet2.title + " version " + deployedWorksheet2.version + " parent component " + deployedRoot.parentComponentSlotPath + " to target component" + deployedRoot.deployName);
                switch (deployedWorksheet2.templateType) {
                    case "Application": {
                        deployedRootComponent = root;
                        break;
                    }
                    default: {
                        deployedRootComponent = this.resolveDeployComponent(deployedRoot, root);
                    }
                }
                if (deployedRootComponent == null) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.rootNotResolvedError", new Object[]{deployedRoot.deployName, deployedWorksheet2.title}));
                    continue;
                }
                deployedRootComponent.lease();
                BINavNode templateObject = deployedRootComponent.getNavChild(deployedRoot.deployName);
                if (templateObject != null) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.templateComponentExistsError", new Object[]{deployedRoot.deployName, deployedRootComponent.getNavName()}));
                    continue;
                }
                BNtplFile ntplFile = this.copyTemplateToStation(deployedWorksheet2, deployedRootComponent);
                if (ntplFile == null) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.templateFileCopyError", new Object[]{deployedWorksheet2.title}));
                    continue;
                }
                HashMap<String, BFormat> componentDisplayNames = new HashMap<String, BFormat>();
                BComponent deployedTemplateComponent = this.installTemplateToStation(deployedWorksheet2, deployedRoot, deployedRootComponent, ntplFile, componentDisplayNames);
                if (deployedTemplateComponent == null) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.templateNotResolvedError", new Object[]{deployedRoot.parentComponentSlotPath, deployedWorksheet2.title}));
                    continue;
                }
                deployedRoot.deployedTemplate = deployedTemplateComponent;
                if (!componentDisplayNames.isEmpty()) {
                    BNameMap nameMap = BNameMap.make(componentDisplayNames);
                    if (displayNames.containsKey(deployedRootComponent)) {
                        BNameMap mergedNameMap = BNameMap.make((BNameMap)((BNameMap)displayNames.get(deployedRootComponent)), (BNameMap)nameMap);
                        displayNames.put(deployedRootComponent, mergedNameMap);
                    } else {
                        displayNames.put(deployedRootComponent, nameMap);
                    }
                }
                if (worker == null) continue;
                if ((currentProgress = (int)((double)(++processedInstances) * 70.0 / (double)templateInstanceCount)) > totalProgress) {
                    totalProgress = currentProgress;
                    String progressMessage = lex.getText("bulkDeploy.progress.update.deploy", new Object[]{deployedWorksheet2.title, deployedRoot.deployName});
                    worker.updateProgress(totalProgress, progressMessage);
                }
                if (worker.isRunning()) continue;
                if (worker.isCanceled()) {
                    log.log(Level.INFO, lex.getText("bulkDeploy.progress.cancel", new Object[]{bulkDeployWorkbook.getName()}));
                } else {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.progress.cancelInternal", new Object[]{bulkDeployWorkbook.getName()}));
                }
                return;
            }
        }
        if (!displayNames.isEmpty()) {
            displayNames.forEach((key, value) -> {
                log.log(Level.FINER, String.format("Component: %s, Display name: %s", key.getName(), value.encodeToString()));
                this.updateTemplateDisplayNames((BComponent)key, (BNameMap)value);
            });
        }
        for (DeployedWorksheet deployedWorksheet2 : deployedWorksheets) {
            for (DeployedRoot deployedRoot : deployedWorksheet2.deployedRoots) {
                int currentProgress;
                this.applyConfigurations(deployedWorksheet2, deployedRoot);
                if (worker == null) continue;
                if ((currentProgress = (int)((double)(++processedInstances) * 30.0 / (double)templateInstanceCount) + 70) > totalProgress) {
                    totalProgress = currentProgress;
                    String progressMessage = lex.getText("bulkDeploy.progress.update.config", new Object[]{deployedWorksheet2.title, deployedRoot.deployName});
                    worker.updateProgress(totalProgress, progressMessage);
                }
                if (worker.isRunning()) continue;
                if (worker.isCanceled()) {
                    log.log(Level.INFO, lex.getText("bulkDeploy.progress.cancel", new Object[]{bulkDeployWorkbook.getName()}));
                } else {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.progress.cancelInternal", new Object[]{bulkDeployWorkbook.getName()}));
                }
                return;
            }
        }
    }

    public void updateTemplateDisplayNames(BComponent deployRootComponent, BNameMap templateDisplayNames) {
        BNameMap existingDisplayNames = (BNameMap)deployRootComponent.get("displayNames");
        if (existingDisplayNames == null) {
            deployRootComponent.add("displayNames", (BValue)templateDisplayNames);
        } else if (existingDisplayNames.isNull()) {
            deployRootComponent.remove("displayNames");
            deployRootComponent.add("displayNames", (BValue)templateDisplayNames);
        } else {
            BNameMap mergedNameMap = BNameMap.make((BNameMap)existingDisplayNames, (BNameMap)templateDisplayNames);
            deployRootComponent.remove("displayNames");
            deployRootComponent.add("displayNames", (BValue)mergedNameMap);
        }
    }

    private boolean supportInputSlot(DeployedWorksheet worksheet) {
        Version templateVersion = new Version(worksheet.templateExportVersion);
        Version inputSlotVersion = new Version(SOURCE_SLOT_MIN_VERSION);
        return templateVersion.compareTo(inputSlotVersion) >= 0;
    }

    public List<DeployedWorksheet> loadDeployedWorksheets(BulkDeployWorkbook bulkDeployWorkbook) {
        ArrayList<DeployedWorksheet> deployedWorksheets = new ArrayList<DeployedWorksheet>();
        if (bulkDeployWorkbook == null || !bulkDeployWorkbook.isValid()) {
            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.importFileUndefined"));
            return deployedWorksheets;
        }
        Workbook wb = bulkDeployWorkbook.getWorkbook();
        String templateExportVersion = this.getTemplateExportVersion(wb);
        if (templateExportVersion == null) {
            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.importFileInvalid"));
            return deployedWorksheets;
        }
        if (!TEMPLATE_EXPORT_VERSION.equals(templateExportVersion)) {
            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.importFileVersionMismatch"), new Object[]{templateExportVersion, TEMPLATE_EXPORT_VERSION});
        }
        Iterator sheetIterator = wb.sheetIterator();
        while (sheetIterator.hasNext()) {
            String valueType;
            int n;
            Sheet sheet = (Sheet)sheetIterator.next();
            int firstRowNum = sheet.getFirstRowNum();
            int lastRowNum = sheet.getLastRowNum();
            int rowCount = sheet.getPhysicalNumberOfRows();
            int realLastRow = lastRowNum + 1;
            if (realLastRow <= 6) continue;
            String templateFile = this.getTemplateFile(sheet);
            String vendor = this.getTemplateVendor(sheet);
            String title = this.getTemplateTitle(sheet);
            String version = this.getTemplateVersion(sheet);
            BUuid uid = BUuid.make((String)this.getTemplateUID(sheet));
            int excelInstanceInfoColumns = this.getTemplateSheetInfoColumns(sheet);
            String templateType = this.getTemplateTypeName(sheet);
            log.log(IMPORT_LOG_LEVEL, "Deploying template " + title + " version " + version);
            int[] configCounts = new int[]{0, 0, 0, 0, 0, 0, 0};
            this.loadConfigItemCounts(sheet, excelInstanceInfoColumns, configCounts);
            log.log(IMPORT_LOG_LEVEL, () -> String.format("Inputs = %d, Outputs = %d, Relations = %d, Configs = %d, Optionals = %d, OptionalConfigs = %d, Tags = %d", configCounts[0], configCounts[1], configCounts[2], configCounts[3], configCounts[4], configCounts[5], configCounts[6]));
            Row secondRow = sheet.getRow(1);
            Row thirdRow = sheet.getRow(2);
            Row fourthRow = sheet.getRow(3);
            Row fifthRow = sheet.getRow(4);
            DeployedWorksheet newWorksheet = new DeployedWorksheet();
            newWorksheet.title = title;
            newWorksheet.vendor = vendor;
            newWorksheet.version = version;
            newWorksheet.uid = uid;
            newWorksheet.templateType = templateType;
            newWorksheet.templateFile = templateFile;
            newWorksheet.templateExportVersion = templateExportVersion;
            int columnOffset = excelInstanceInfoColumns;
            if (configCounts[0] > 0) {
                ++columnOffset;
                for (n = 0; n < configCounts[0]; ++n) {
                    String[] inputs = new String[6];
                    inputs[0] = this.getCell(secondRow, columnOffset);
                    inputs[1] = this.getCell(thirdRow, columnOffset);
                    inputs[2] = this.getCell(fourthRow, columnOffset);
                    inputs[3] = this.getCell(fifthRow, columnOffset);
                    newWorksheet.inputDefs.add(inputs);
                    ++columnOffset;
                }
            }
            if (configCounts[1] > 0) {
                ++columnOffset;
                for (n = 0; n < configCounts[1]; ++n) {
                    String[] outputs = new String[6];
                    outputs[0] = this.getCell(secondRow, columnOffset);
                    outputs[1] = this.getCell(thirdRow, columnOffset);
                    outputs[2] = this.getCell(fourthRow, columnOffset);
                    outputs[3] = this.getCell(fifthRow, columnOffset);
                    newWorksheet.outputDefs.add(outputs);
                    ++columnOffset;
                }
            }
            if (configCounts[2] > 0) {
                ++columnOffset;
                for (n = 0; n < configCounts[2]; ++n) {
                    String[] relations = new String[]{this.getCell(secondRow, columnOffset), this.getCell(thirdRow, columnOffset), this.getCell(fourthRow, columnOffset), this.getCell(fifthRow, columnOffset)};
                    newWorksheet.relationDefs.add(relations);
                    ++columnOffset;
                }
            }
            if (configCounts[3] > 0) {
                ++columnOffset;
                for (n = 0; n < configCounts[3]; ++n) {
                    ArrayList<String> configs = new ArrayList<String>();
                    configs.add(this.getCell(secondRow, columnOffset));
                    configs.add(this.getCell(thirdRow, columnOffset));
                    valueType = this.getCell(fourthRow, columnOffset);
                    configs.add(valueType);
                    configs.add(this.getCellOrNull(fifthRow, columnOffset, BulkDeployUtil.isStringType(valueType)));
                    newWorksheet.configDefs.add(configs.toArray(new String[0]));
                    ++columnOffset;
                }
            }
            if (configCounts[4] > 0) {
                ++columnOffset;
                for (n = 0; n < configCounts[4]; ++n) {
                    ArrayList<String> optionals = new ArrayList<String>();
                    optionals.add(this.getCell(secondRow, columnOffset));
                    optionals.add(this.getCell(thirdRow, columnOffset));
                    optionals.add(this.getCell(fifthRow, columnOffset));
                    newWorksheet.optionalDefs.add(optionals.toArray(new String[0]));
                    ++columnOffset;
                }
            }
            if (configCounts[5] > 0) {
                ++columnOffset;
                for (n = 0; n < configCounts[5]; ++n) {
                    ArrayList<String> optionalConfigs = new ArrayList<String>();
                    optionalConfigs.add(this.getCell(secondRow, columnOffset));
                    optionalConfigs.add(this.getCell(thirdRow, columnOffset));
                    valueType = this.getCell(fourthRow, columnOffset);
                    optionalConfigs.add(valueType);
                    optionalConfigs.add(this.getCellOrNull(fifthRow, columnOffset, BulkDeployUtil.isStringType(valueType)));
                    newWorksheet.optionalConfigDefs.add(optionalConfigs.toArray(new String[0]));
                    ++columnOffset;
                }
            }
            if (configCounts[6] > 0) {
                ++columnOffset;
                for (n = 0; n < configCounts[6]; ++n) {
                    ArrayList<String> tags = new ArrayList<String>();
                    tags.add(this.getCell(secondRow, columnOffset));
                    tags.add(this.getCell(fourthRow, columnOffset));
                    tags.add(this.getCell(fifthRow, columnOffset));
                    newWorksheet.tagDefs.add(tags.toArray(new String[tags.size()]));
                    ++columnOffset;
                }
            }
            for (int i = 6; i < realLastRow; ++i) {
                String configValue;
                int n2;
                Row row = sheet.getRow(i);
                String rootComponentName = this.getCell(row, 0);
                String deployName = "";
                String displayName = "";
                String position = "";
                String deviceTarget = "";
                boolean enableHistories = false;
                if (TEMPLATE_TYPE_APPLICATION.contentEquals(templateType)) {
                    if (rootComponentName == null || rootComponentName.isEmpty()) {
                        log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.stationEmptyError", new Object[]{title}));
                        continue;
                    }
                    deployName = rootComponentName;
                    if (excelInstanceInfoColumns > 1) {
                        deviceTarget = this.getCell(row, 1);
                        log.log(IMPORT_LOG_LEVEL, "Device target = " + deviceTarget);
                    }
                } else {
                    deployName = this.getCell(row, 1);
                    if (deployName == null || deployName.isEmpty()) {
                        log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.deployEmptyError", new Object[]{title}));
                        continue;
                    }
                    if (excelInstanceInfoColumns > 2) {
                        displayName = this.getCell(row, 2);
                        log.log(IMPORT_LOG_LEVEL, "Display name = " + displayName);
                    }
                    if (excelInstanceInfoColumns > 3) {
                        position = this.getCell(row, 3);
                        log.log(IMPORT_LOG_LEVEL, "Position = " + position);
                    }
                    if (excelInstanceInfoColumns > 4) {
                        deviceTarget = this.getCell(row, 4);
                        log.log(IMPORT_LOG_LEVEL, "Device target = " + deviceTarget);
                    }
                    if (excelInstanceInfoColumns > 5) {
                        enableHistories = this.getCellAsBoolean(row, 5);
                    }
                }
                DeployedRoot newRoot = new DeployedRoot();
                newRoot.parentComponentSlotPath = rootComponentName == null ? "" : rootComponentName;
                newRoot.deployName = deployName;
                newRoot.displayName = displayName;
                newRoot.position = position;
                newRoot.deviceTarget = deviceTarget;
                newRoot.enableHistories = enableHistories;
                columnOffset = excelInstanceInfoColumns;
                if (configCounts[0] > 0) {
                    DeployedRoot.access$802(newRoot, new String[configCounts[0]]);
                    ++columnOffset;
                    for (n2 = 0; n2 < configCounts[0]; ++n2) {
                        String[] inputDef = newWorksheet.inputDefs.get(n2);
                        if (inputDef == null || inputDef.length == 0) {
                            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.inputDefinitionError", new Object[]{deployName}));
                            continue;
                        }
                        String inputName = this.getCell(row, columnOffset);
                        log.log(IMPORT_LOG_LEVEL, "Input name " + inputName);
                        ((DeployedRoot)newRoot).inputs[n2] = inputName;
                        if (this.supportInputSlot(newWorksheet)) {
                            ++columnOffset;
                            if ((inputDef = newWorksheet.inputDefs.get(++n2)) == null || inputDef.length == 0) {
                                log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.targetSlotHintsError", new Object[]{deployName}));
                                continue;
                            }
                            String inputSlotName = this.getCell(row, columnOffset);
                            if (inputSlotName == null || inputSlotName.length() == 0) {
                                inputSlotName = inputDef[3];
                            }
                            log.log(IMPORT_LOG_LEVEL, "Input name " + inputName + " slot " + inputSlotName);
                            ((DeployedRoot)newRoot).inputs[n2] = inputSlotName;
                        }
                        ++columnOffset;
                    }
                }
                if (configCounts[1] > 0) {
                    DeployedRoot.access$902(newRoot, new String[configCounts[1]]);
                    ++columnOffset;
                    for (n2 = 0; n2 < configCounts[1]; ++n2) {
                        String outputName;
                        String[] outputDef = newWorksheet.outputDefs.get(n2);
                        if (outputDef == null || outputDef.length == 0) {
                            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.outputDefinitionError", new Object[]{deployName}));
                            continue;
                        }
                        ((DeployedRoot)newRoot).outputs[n2] = outputName = this.getCell(row, columnOffset);
                        ++columnOffset;
                        if ((outputDef = newWorksheet.outputDefs.get(++n2)) == null || outputDef.length == 0) {
                            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.targetSlotHintsError", new Object[]{deployName}));
                            continue;
                        }
                        String outputSlotName = this.getCell(row, columnOffset);
                        if (outputSlotName == null || outputSlotName.length() == 0) {
                            outputSlotName = outputDef[3];
                        }
                        log.log(IMPORT_LOG_LEVEL, "Output name " + outputName + " slot " + outputSlotName);
                        ((DeployedRoot)newRoot).outputs[n2] = outputSlotName;
                        ++columnOffset;
                    }
                }
                if (configCounts[2] > 0) {
                    DeployedRoot.access$1002(newRoot, new String[configCounts[2]]);
                    ++columnOffset;
                    for (n2 = 0; n2 < configCounts[2]; ++n2) {
                        String[] relationDef = newWorksheet.relationDefs.get(n2);
                        if (relationDef == null || relationDef.length == 0) {
                            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.relationDefinitionError", new Object[]{deployName}));
                            continue;
                        }
                        String relationName = this.getCell(row, columnOffset);
                        log.log(IMPORT_LOG_LEVEL, "Relation name " + relationName);
                        ((DeployedRoot)newRoot).relations[n2] = relationName;
                        ++columnOffset;
                    }
                }
                if (configCounts[3] > 0) {
                    DeployedRoot.access$1102(newRoot, new String[configCounts[3]]);
                    ++columnOffset;
                    for (n2 = 0; n2 < configCounts[3]; ++n2) {
                        boolean stringType = false;
                        String[] configDef = newWorksheet.configDefs.get(n2);
                        if (configDef == null || configDef.length == 0) {
                            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.configDefinitionError", new Object[]{deployName}));
                            continue;
                        }
                        if (configDef.length >= 2) {
                            stringType = BulkDeployUtil.isStringType(configDef[2]);
                        }
                        ((DeployedRoot)newRoot).configs[n2] = configValue = this.getCellOrNull(row, columnOffset, stringType);
                        ++columnOffset;
                    }
                }
                if (configCounts[4] > 0) {
                    DeployedRoot.access$1202(newRoot, new String[configCounts[4]]);
                    ++columnOffset;
                    for (n2 = 0; n2 < configCounts[4]; ++n2) {
                        String[] optionalDef = newWorksheet.optionalDefs.get(n2);
                        if (optionalDef == null || optionalDef.length == 0) {
                            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.optionalsDefinitionError", new Object[]{deployName}));
                            continue;
                        }
                        String optionalName = this.getCellOrNull(row, columnOffset, true);
                        log.log(IMPORT_LOG_LEVEL, "Optional value " + optionalName);
                        ((DeployedRoot)newRoot).optionals[n2] = optionalName;
                        ++columnOffset;
                    }
                }
                if (configCounts[5] > 0) {
                    DeployedRoot.access$1302(newRoot, new String[configCounts[5]]);
                    ++columnOffset;
                    for (n2 = 0; n2 < configCounts[5]; ++n2) {
                        String optionalConfigValue;
                        boolean stringType = false;
                        String[] optionalConfigDef = newWorksheet.optionalConfigDefs.get(n2);
                        if (optionalConfigDef == null || optionalConfigDef.length == 0) {
                            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.optionalsConfigDefinitionError", new Object[]{deployName}));
                            continue;
                        }
                        if (optionalConfigDef.length >= 2) {
                            Type t = Sys.getType((String)optionalConfigDef[2]);
                            stringType = t.is(BString.TYPE) || t.is(BStatusString.TYPE) || t.is(BEnum.TYPE) || t.is(BStatusEnum.TYPE) || t.is(BFrozenEnum.TYPE);
                        }
                        ((DeployedRoot)newRoot).optionalConfigs[n2] = optionalConfigValue = this.getCellOrNull(row, columnOffset, stringType);
                        ++columnOffset;
                    }
                }
                if (configCounts[6] > 0) {
                    DeployedRoot.access$1402(newRoot, new String[configCounts[6]]);
                    ++columnOffset;
                    for (n2 = 0; n2 < configCounts[6]; ++n2) {
                        String[] tagDef = newWorksheet.tagDefs.get(n2);
                        if (tagDef == null || tagDef.length == 0) {
                            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.tagDefinitionError", new Object[]{deployName}));
                            continue;
                        }
                        boolean stringType = true;
                        ((DeployedRoot)newRoot).tags[n2] = configValue = this.getCellOrNull(row, columnOffset, stringType);
                        ++columnOffset;
                    }
                }
                log.log(IMPORT_LOG_LEVEL, () -> String.format("Root = %s, Deploy Name = %s, Device Target = %s, Enable Histories = %s", newRoot.parentComponentSlotPath, newRoot.deployName, newRoot.deviceTarget, newRoot.enableHistories));
                newWorksheet.deployedRoots.add(newRoot);
            }
            deployedWorksheets.add(newWorksheet);
        }
        return deployedWorksheets;
    }

    private static boolean isStringType(String valueType) {
        Type t = Sys.getType((String)valueType);
        return t.is(BString.TYPE) || t.is(BStatusString.TYPE) || t.is(BEnum.TYPE) || t.is(BStatusEnum.TYPE) || t.is(BFrozenEnum.TYPE);
    }

    private void setTemplateExportVersion(Workbook workbook) {
        this.addWorkbookConstant(workbook, TEMPLATE_EXPORT_VERSION_NAME, TEMPLATE_EXPORT_VERSION);
    }

    private void setKeepPrivateFlag(Workbook workbook) {
        this.addWorkbookConstant(workbook, KEEP_PRIVATE_NAME, Boolean.TRUE.toString());
    }

    private void setTemplateFile(Sheet sheet, String templateFile) {
        this.addSheetConstant(sheet, TEMPLATE_FILE_NAME, templateFile);
    }

    private void setTemplateVendor(Sheet sheet, String templateVendor) {
        this.addSheetConstant(sheet, TEMPLATE_VENDOR_NAME, templateVendor);
    }

    private void setTemplateTitle(Sheet sheet, String templateTitle) {
        this.addSheetConstant(sheet, TEMPLATE_TITLE_NAME, templateTitle);
    }

    private void setTemplateVersion(Sheet sheet, String templateVersion) {
        this.addSheetConstant(sheet, TEMPLATE_VERSION_NAME, templateVersion);
    }

    private void setTemplateUID(Sheet sheet, String templateUID) throws IOException {
        this.addSheetConstant(sheet, TEMPLATE_UID_NAME, templateUID);
    }

    private void setTemplateTypeName(Sheet sheet, String templateTypeName) {
        this.addSheetConstant(sheet, TEMPLATE_TYPE_NAME, templateTypeName);
    }

    private void setTemplateSheetInfoColumns(Sheet sheet, int infoColumns) {
        this.addSheetConstant(sheet, TEMPLATE_SHEET_INFO_COLUMNS_NAME, Integer.toString(infoColumns));
    }

    private void setInputsCount(Sheet sheet, int count) {
        this.addSheetConstant(sheet, TEMPLATE_INPUTS_COUNT_NAME, Integer.toString(count));
    }

    private void setOutputsCount(Sheet sheet, int count) {
        this.addSheetConstant(sheet, TEMPLATE_OUTPUTS_COUNT_NAME, Integer.toString(count));
    }

    private void setRelationsCount(Sheet sheet, int count) {
        this.addSheetConstant(sheet, TEMPLATE_RELATIONS_COUNT_NAME, Integer.toString(count));
    }

    private void setConfigsCount(Sheet sheet, int count) {
        this.addSheetConstant(sheet, TEMPLATE_CONFIGS_COUNT_NAME, Integer.toString(count));
    }

    private void setOptionalCount(Sheet sheet, int count) {
        this.addSheetConstant(sheet, TEMPLATE_OPTIONALS_COUNT_NAME, Integer.toString(count));
    }

    private void setOptionalConfigurationCount(Sheet sheet, int count) {
        this.addSheetConstant(sheet, TEMPLATE_OPTIONAL_CONFIGS_COUNT_NAME, Integer.toString(count));
    }

    private void setTagCount(Sheet sheet, int count) {
        this.addSheetConstant(sheet, TEMPLATE_TAG_COUNT_NAME, Integer.toString(count));
    }

    private String buildTemplateTypeName(TemplateManifest manifest) {
        if (manifest.isApplication) {
            return TEMPLATE_TYPE_APPLICATION;
        }
        TemplateManager tm = TemplateManager.INSTANCE;
        TemplateManager.TemplateInfo templateInfo = tm.getTemplate(manifest.uID, manifest.vendor);
        if (templateInfo.getRootType().is(BDevice.TYPE)) {
            return TEMPLATE_TYPE_DEVICE;
        }
        return TEMPLATE_TYPE_COMPONENT;
    }

    private void addWorkbookConstant(Workbook workbook, String constantName, String constantValue) {
        this.addSheetOrWorkbookConstant(workbook, -1, constantName, constantValue);
    }

    private void addSheetConstant(Sheet sheet, String constantName, String constantValue) {
        Workbook workbook = sheet.getWorkbook();
        int sheetIndex = workbook.getSheetIndex(sheet.getSheetName());
        this.addSheetOrWorkbookConstant(workbook, sheetIndex, constantName, constantValue);
    }

    private void addSheetOrWorkbookConstant(Workbook workbook, int sheetIndex, String constantName, String constantValue) {
        Name name = workbook.createName();
        name.setSheetIndex(sheetIndex);
        name.setNameName(constantName);
        name.setRefersToFormula("\"" + constantValue + "\"");
    }

    private String getTemplateExportVersion(Workbook workbook) {
        return this.getWorkbookConstant(workbook, TEMPLATE_EXPORT_VERSION_NAME);
    }

    private String getTemplateFile(Sheet sheet) {
        return this.getSheetConstant(sheet, TEMPLATE_FILE_NAME);
    }

    private String getTemplateVendor(Sheet sheet) {
        return this.getSheetConstant(sheet, TEMPLATE_VENDOR_NAME);
    }

    private String getTemplateTitle(Sheet sheet) {
        return this.getSheetConstant(sheet, TEMPLATE_TITLE_NAME);
    }

    private String getTemplateVersion(Sheet sheet) {
        return this.getSheetConstant(sheet, TEMPLATE_VERSION_NAME);
    }

    private String getTemplateUID(Sheet sheet) {
        return this.getSheetConstant(sheet, TEMPLATE_UID_NAME);
    }

    private String getTemplateTypeName(Sheet sheet) {
        return this.getSheetConstant(sheet, TEMPLATE_TYPE_NAME);
    }

    private int getTemplateSheetInfoColumns(Sheet sheet) {
        String result = this.getSheetConstant(sheet, TEMPLATE_SHEET_INFO_COLUMNS_NAME);
        if (result == null) {
            return 5;
        }
        return Integer.parseInt(result);
    }

    private void loadConfigItemCounts(Sheet sheet, int excelInstanceInfoColumns, int[] configCounts) {
        String inputsCount = this.getSheetConstant(sheet, TEMPLATE_INPUTS_COUNT_NAME);
        String outputsCount = this.getSheetConstant(sheet, TEMPLATE_OUTPUTS_COUNT_NAME);
        String relationsCount = this.getSheetConstant(sheet, TEMPLATE_RELATIONS_COUNT_NAME);
        String configsCount = this.getSheetConstant(sheet, TEMPLATE_CONFIGS_COUNT_NAME);
        String optionalsCount = this.getSheetConstant(sheet, TEMPLATE_OPTIONALS_COUNT_NAME);
        String optionalConfigsCount = this.getSheetConstant(sheet, TEMPLATE_OPTIONAL_CONFIGS_COUNT_NAME);
        String tagCount = this.getSheetConstant(sheet, TEMPLATE_TAG_COUNT_NAME);
        if (inputsCount != null) {
            configCounts[0] = Integer.parseInt(inputsCount);
        }
        if (outputsCount != null) {
            configCounts[1] = Integer.parseInt(outputsCount);
        }
        if (relationsCount != null) {
            configCounts[2] = Integer.parseInt(relationsCount);
        }
        if (configsCount != null) {
            configCounts[3] = Integer.parseInt(configsCount);
        }
        if (optionalsCount != null) {
            configCounts[4] = Integer.parseInt(optionalsCount);
        }
        if (optionalConfigsCount != null) {
            configCounts[5] = Integer.parseInt(optionalConfigsCount);
        }
        if (tagCount != null) {
            configCounts[6] = Integer.parseInt(tagCount);
        }
    }

    private String getWorkbookConstant(Workbook workbook, String name) {
        return this.getSheetOrWorkbookConstant(workbook, -1, name);
    }

    private String getSheetConstant(Sheet sheet, String name) {
        Workbook workbook = sheet.getWorkbook();
        int sheetIndex = workbook.getSheetIndex(sheet.getSheetName());
        return this.getSheetOrWorkbookConstant(workbook, sheetIndex, name);
    }

    private String getSheetOrWorkbookConstant(Workbook workbook, int sheetIndex, String name) {
        String formula;
        String value = null;
        Name constantName = this.getNamedRange(workbook, sheetIndex, name);
        if (constantName != null && (formula = constantName.getRefersToFormula()).startsWith("\"") && formula.endsWith("\"") && formula.length() >= 2) {
            value = formula.substring(1, formula.length() - 1);
        }
        return value;
    }

    private Name getNamedRange(Workbook workbook, int sheetIndex, String nameName) {
        List names = workbook.getNames(nameName);
        Name foundName = null;
        for (Name name : names) {
            if (name.getSheetIndex() != sheetIndex) continue;
            foundName = name;
            break;
        }
        return foundName;
    }

    protected BComponent resolveDeployComponent(DeployedRoot deployedRoot, BComponent root) {
        String escapedParentComponentSlotPath = this.escapeSlotPathNames(deployedRoot.parentComponentSlotPath);
        BOrd deployRootOrd = BOrd.make((String)(root.getSlotPathOrd() + escapedParentComponentSlotPath));
        log.log(IMPORT_LOG_LEVEL, "deployRootOrd = " + deployRootOrd);
        try {
            OrdTarget ordTarget = deployRootOrd.resolve((BObject)root);
        }
        catch (UnresolvedException e) {
            SlotPath deployRootSlotPath = new SlotPath("slot", escapedParentComponentSlotPath);
            String[] slotPathElements = deployRootSlotPath.getNames();
            BComponent nextComponent = root;
            for (String element : slotPathElements) {
                if ((nextComponent = this.getNextChild(nextComponent, element)) != null) continue;
                log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.rootTargetError", new Object[]{deployedRoot.parentComponentSlotPath}));
                return null;
            }
        }
        BComponent deployRootComponent = deployRootOrd.resolve((BObject)root).getComponent();
        if (deployRootComponent == null) {
            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.rootTargetError", new Object[]{deployedRoot.parentComponentSlotPath}));
            return null;
        }
        if (!deployRootComponent.isMounted()) {
            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.notMountedError", new Object[]{deployedRoot.parentComponentSlotPath}));
            return null;
        }
        return deployRootComponent;
    }

    protected BComponent getNextChild(BComponent parentComponent, String childName) {
        BValue childValue = parentComponent.get(childName);
        if (childValue == null) {
            log.log(Level.FINE, "Creating missing slot path node " + childName);
            Type newFolderType = BFolder.TYPE;
            if (parentComponent instanceof BIPointFolder) {
                newFolderType = ((BIPointFolder)parentComponent).getPointFolderType();
            } else if (parentComponent instanceof BIDeviceFolder) {
                newFolderType = ((BIDeviceFolder)parentComponent).getDeviceFolderType();
            } else if (parentComponent instanceof BIArchiveFolder) {
                newFolderType = ((BIArchiveFolder)parentComponent).getArchiveFolderType();
            }
            BComponent nextChild = newFolderType.getInstance().asComponent();
            parentComponent.add(childName, (BValue)nextChild);
            BComponent createdChild = parentComponent.get(childName).asComponent();
            return createdChild;
        }
        return childValue.asComponent();
    }

    private BWbDeployableNtplFile getTemplFileFromWorksheet(DeployedWorksheet worksheet) {
        TemplateManager tmInstance = new TemplateManager();
        tmInstance.initTemplateMap();
        log.log(IMPORT_LOG_LEVEL, "Locate template file for UID" + worksheet.uid + " and vendor " + worksheet.vendor);
        TemplateManager.TemplateInfo deployTemplateInfo = tmInstance.getTemplate(worksheet.uid, worksheet.vendor);
        if (deployTemplateInfo == null) {
            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.templateFileNotFound", new Object[]{worksheet.title}));
            return null;
        }
        BNtplFile ntplFile = deployTemplateInfo.getNtplFile();
        if (ntplFile instanceof BWbDeployableNtplFile) {
            return (BWbDeployableNtplFile)ntplFile;
        }
        return BWbDeployableNtplFile.make(ntplFile);
    }

    protected BNtplFile copyTemplateToStation(DeployedWorksheet worksheet, BComponent deployRootComponent) {
        BWbDeployableNtplFile deployableNtplFile = this.getTemplFileFromWorksheet(worksheet);
        if (UpdateUtil.updateNtplFile(deployableNtplFile, deployRootComponent)) {
            return deployableNtplFile;
        }
        return null;
    }

    protected boolean updateNtplFile(BWbDeployableNtplFile ntplFile, BComponent target) {
        return UpdateUtil.updateNtplFile(ntplFile, target);
    }

    protected BComponent installTemplateToStation(DeployedWorksheet worksheet, DeployedRoot deployedRoot, BComponent deployRootComponent, BNtplFile ntplFile, Map<String, BFormat> componentDisplayNames) {
        try {
            if (!(ntplFile instanceof BWbDeployableNtplFile)) {
                log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.templateFileNotFound", new Object[]{worksheet.title}));
                return null;
            }
            String escapedName = SlotPath.escape((String)deployedRoot.deployName);
            BComponent params = new BComponent();
            params.add("exact", (BValue)BBoolean.TRUE);
            Mark mark = new Mark((BObject)ntplFile, escapedName);
            mark.copyTo((BObject)deployRootComponent, params, DeployToComp.NoPostLink);
            BComponent deployedTemplateComponent = deployRootComponent.get(escapedName).asComponent();
            if (deployedTemplateComponent == null) {
                log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.deploymentError", new Object[]{worksheet.title, deployedRoot.deployName}));
                return null;
            }
            BulkDeployUtil.setComponentPosition(deployedTemplateComponent, deployedRoot.position);
            if (deployedRoot.enableHistories) {
                BHistoryExt[] unconfigurableHistories;
                for (BHistoryExt historyExt : unconfigurableHistories = this.unconfigurableHistoryExtensions(deployedTemplateComponent)) {
                    historyExt.setEnabled(true);
                }
            }
            if (deployedRoot.displayName != null && !deployedRoot.displayName.isEmpty()) {
                try {
                    componentDisplayNames.put(deployRootComponent.getProperty(escapedName).getName(), BFormat.make((String)deployedRoot.displayName));
                }
                catch (Exception e) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.displayNameError", new Object[]{deployedRoot.displayName, deployedRoot.deployName}), e);
                }
            }
            return deployedTemplateComponent;
        }
        catch (Exception e) {
            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.postDeployError", new Object[]{worksheet.title, deployedRoot.deployName}), e);
            return null;
        }
    }

    public void applyConfigurations(DeployedWorksheet deployedWorksheet, DeployedRoot deployedRoot) {
        this.setConfigurationsFromWorksheet(deployedWorksheet, deployedRoot, false);
    }

    public void updateConfigurations(DeployedWorksheet deployedWorksheet, DeployedRoot deployedRoot) {
        this.setConfigurationsFromWorksheet(deployedWorksheet, deployedRoot, true);
    }

    private void setConfigurationsFromWorksheet(DeployedWorksheet deployedWorksheet, DeployedRoot deployedRoot, boolean whenNoValueKeepCurrent) {
        int n;
        if (deployedWorksheet == null || deployedRoot == null) {
            return;
        }
        log.log(IMPORT_LOG_LEVEL, "Bulk deploy inputs/outputs/relations/configs");
        BComponent deployedTemplateComponent = deployedRoot.deployedTemplate;
        if (deployedTemplateComponent == null) {
            return;
        }
        BTemplateConfig templateConfig = BTemplateConfig.getConfigForRoot((BComponent)deployedTemplateComponent);
        if (templateConfig == null) {
            log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.invalidTemplateError", new Object[]{deployedTemplateComponent.getName()}));
            return;
        }
        if (deployedRoot.inputs != null) {
            int inputColumnIncrement = this.supportInputSlot(deployedWorksheet) ? 2 : 1;
            for (int n2 = 0; n2 < deployedRoot.inputs.length; n2 += inputColumnIncrement) {
                Object[] choices;
                int nName = n2;
                int nSlot = n2 + 1;
                String[] inputDef = deployedWorksheet.inputDefs.get(nName);
                if (inputDef == null || inputDef.length == 0) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.inputDefinitionError", new Object[]{deployedTemplateComponent.getName()}));
                    continue;
                }
                String slotName = inputDef[0];
                String label = inputDef[1];
                String bindHints = inputDef[2];
                log.log(IMPORT_LOG_LEVEL, "Input slot name = " + slotName + ", bind hints = " + bindHints);
                Slot inputSlot = deployedTemplateComponent.getSlot(slotName);
                if (inputSlot == null) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.missingInputSlotError", new Object[]{deployedTemplateComponent.getName(), slotName}));
                    continue;
                }
                try {
                    choices = TmplUtil.findMatchingObjects(bindHints, this.getSearchService(deployedTemplateComponent), this.getTemplateService(deployedTemplateComponent), (BComponent)templateConfig, lex);
                }
                catch (Exception ignored) {
                    choices = null;
                }
                if (choices == null || choices.length == 0) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.inputBindingError", new Object[]{deployedTemplateComponent.getName(), slotName}));
                    continue;
                }
                String sourceName = deployedRoot.inputs[nName];
                String sourceSlotName = DEFAULT_SOURCE_SLOT;
                if (inputColumnIncrement == 2) {
                    sourceSlotName = deployedRoot.inputs[nSlot];
                }
                log.log(IMPORT_LOG_LEVEL, "Input name " + sourceName + " slot " + sourceSlotName);
                BComponent sourceComponent = this.getNamedComponentFromChoices(choices, this.escapeSlotPathNames(sourceName), this.getEscapedNameFromSlotPath(sourceName));
                if (sourceComponent == null) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.inputSourceError", new Object[]{sourceName, deployedTemplateComponent.getName()}));
                    continue;
                }
                Property sourceProp = sourceComponent.getProperty(sourceSlotName);
                if (sourceProp == null) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.sourceSlotError", new Object[]{sourceComponent.getName(), deployedTemplateComponent.getName()}));
                    continue;
                }
                LinkCheck linkCheck = deployedTemplateComponent.checkLink(sourceComponent, (Slot)sourceProp, inputSlot, null);
                if (!linkCheck.isValid()) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.inputLinkError", new Object[]{sourceComponent.getName(), deployedTemplateComponent.getName(), linkCheck.getInvalidReason()}));
                    continue;
                }
                BLink link = deployedTemplateComponent.makeLink(sourceComponent, (Slot)sourceProp, inputSlot, null);
                deployedTemplateComponent.add(null, (BValue)link);
            }
        }
        if (deployedRoot.outputs != null) {
            for (n = 0; n < deployedRoot.outputs.length; n += 2) {
                Object[] choices;
                int nName = n;
                int nSlot = n + 1;
                String[] outputDef = deployedWorksheet.outputDefs.get(nName);
                if (outputDef == null || outputDef.length == 0) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.outputDefinitionError", new Object[]{deployedTemplateComponent.getName()}));
                    continue;
                }
                String slotName = outputDef[0];
                String label = outputDef[1];
                String bindHints = outputDef[2];
                log.log(IMPORT_LOG_LEVEL, "Output slot name = " + slotName + ", bind hints = " + bindHints);
                try {
                    choices = TmplUtil.findMatchingObjects(bindHints, this.getSearchService(deployedTemplateComponent), this.getTemplateService(deployedTemplateComponent), (BComponent)templateConfig, lex);
                }
                catch (Exception ignored) {
                    choices = null;
                }
                if (choices == null || choices.length == 0) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.outputBindingError", new Object[]{deployedTemplateComponent.getName(), slotName}));
                    continue;
                }
                String outputName = deployedRoot.outputs[nName];
                outputDef = deployedWorksheet.outputDefs.get(nSlot);
                if (outputDef == null || outputDef.length == 0) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.targetSlotHintsError", new Object[]{deployedTemplateComponent.getName()}));
                    continue;
                }
                String targetSlotHints = outputDef[3];
                String outputSlotName = deployedRoot.outputs[nSlot];
                log.log(IMPORT_LOG_LEVEL, "Output name " + outputName + " slot " + outputSlotName);
                BComponent targetComponent = this.getNamedComponentFromChoices(choices, this.escapeSlotPathNames(outputName), this.getEscapedNameFromSlotPath(outputName));
                if (targetComponent == null) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.outputTargetError", new Object[]{outputName, deployedTemplateComponent.getName()}));
                    continue;
                }
                Slot targetSlot = targetComponent.getSlot(outputSlotName);
                if (targetSlot == null) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.targetSlotError", new Object[]{targetComponent.getName(), deployedTemplateComponent.getName()}));
                    continue;
                }
                BLink link = new BLink(deployedTemplateComponent.getHandleOrd(), slotName, outputSlotName, true);
                targetComponent.add(null, (BValue)link);
                targetComponent.lease(1);
            }
        }
        if (deployedRoot.relations != null) {
            for (n = 0; n < deployedRoot.relations.length; ++n) {
                Object[] choices;
                String[] relationDef = deployedWorksheet.relationDefs.get(n);
                if (relationDef == null || relationDef.length == 0) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.relationDefinitionError", new Object[]{deployedTemplateComponent.getName()}));
                    continue;
                }
                String label = relationDef[0];
                String relationId = relationDef[1];
                String relateHints = relationDef[2];
                String direction = relationDef[3];
                log.log(IMPORT_LOG_LEVEL, "Relation name = " + label + ", bind hints = " + relateHints + ", direction = " + direction);
                try {
                    choices = TmplUtil.findMatchingObjects(relateHints, this.getSearchService(deployedTemplateComponent), this.getTemplateService(deployedTemplateComponent), (BComponent)templateConfig, lex);
                }
                catch (Exception ignored) {
                    choices = null;
                }
                if (choices == null || choices.length == 0) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.relationBindingError", new Object[]{deployedTemplateComponent.getName(), label}));
                    continue;
                }
                String relationName = deployedRoot.relations[n];
                log.log(IMPORT_LOG_LEVEL, "Relation name " + relationName);
                BComponent externalComponent = this.getNamedComponentFromChoices(choices, this.escapeSlotPathNames(relationName), this.getEscapedNameFromSlotPath(relationName));
                if (externalComponent == null) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.relationComponentError", new Object[]{deployedTemplateComponent.getName(), relationName}));
                    continue;
                }
                Id id = Id.newId((String)relationId);
                BOrd endPointOrd = direction.equals(lex.getText("templateRelationEditor.out")) ? externalComponent.getHandleOrd() : deployedTemplateComponent.getHandleOrd();
                BComponent relationOwner = direction.equals(lex.getText("templateRelationEditor.out")) ? deployedTemplateComponent : externalComponent;
                BRelation newRelation = new BRelation(id, endPointOrd);
                relationOwner.relations().add((Relation)newRelation);
                relationOwner.lease();
            }
        }
        templateConfig.subscribed();
        if (deployedRoot.configs != null) {
            this.setConfigsFromWorksheet(deployedWorksheet, deployedRoot, deployedTemplateComponent, templateConfig, whenNoValueKeepCurrent);
        }
        if (deployedRoot.optionalConfigs != null) {
            this.setOptionalConfigsFromWorksheet(deployedWorksheet, deployedRoot, deployedTemplateComponent, templateConfig, whenNoValueKeepCurrent);
        }
        if (deployedRoot.tags != null) {
            this.setTagsFromWorksheet(deployedWorksheet, deployedRoot, deployedTemplateComponent);
        }
    }

    public void setConfigsFromWorksheet(DeployedWorksheet deployedWorksheet, DeployedRoot deployedRoot, BComponent deployedTemplateComponent, BTemplateConfig templateConfig, boolean whenNoValueKeepCurrent) {
        this.setTemplateConfigProperty(deployedRoot.configs, deployedWorksheet.configDefs, deployedTemplateComponent, templateConfig, whenNoValueKeepCurrent);
    }

    public void setOptionalConfigsFromWorksheet(DeployedWorksheet deployedWorksheet, DeployedRoot deployedRoot, BComponent deployedTemplateComponent, BTemplateConfig templateConfig, boolean whenNoValueKeepCurrent) {
        this.setTemplateConfigProperty(deployedRoot.optionalConfigs, deployedWorksheet.optionalConfigDefs, deployedTemplateComponent, templateConfig, whenNoValueKeepCurrent);
    }

    private void setTemplateConfigProperty(String[] rootConfigDefs, List<String[]> deployedConfigDefs, BComponent deployedTemplateComponent, BTemplateConfig templateConfig, boolean whenNoValueKeepCurrent) {
        BStruct newInstance = null;
        String previousSlotName = "";
        for (int n = 0; n < rootConfigDefs.length; ++n) {
            String[] configDef = deployedConfigDefs.get(n);
            if (configDef == null || configDef.length == 0) {
                log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.configDefinitionError", new Object[]{deployedTemplateComponent.getName()}));
                continue;
            }
            String slotName = SlotPath.escape((String)configDef[0]);
            String userTip = configDef[1];
            String slotType = configDef[2];
            String defaultValue = configDef[3];
            log.log(IMPORT_LOG_LEVEL, "Configuration name = " + slotName + ", slot type = " + slotType);
            String[] propertyNames = null;
            Property configProp = templateConfig.getProperty(slotName);
            if (configProp == null) {
                propertyNames = BulkDeployUtil.getPropertyNamesForConfigSlot(slotName);
                Property property = configProp = propertyNames.length > 0 ? templateConfig.getProperty(propertyNames[0]) : null;
            }
            if (configProp == null) {
                log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.configComponentError", new Object[]{deployedTemplateComponent.getName(), SlotPath.unescape((String)slotName)}));
                continue;
            }
            try {
                log.log(IMPORT_LOG_LEVEL, "  Template Config Property = " + configProp.getName());
                String configValue = rootConfigDefs[n];
                if (configValue == null) {
                    configValue = defaultValue;
                }
                if (configProp.getType().is(BStruct.TYPE) && !configProp.getType().is(BStatusValue.TYPE)) {
                    Property structProp;
                    TypeInfo slotTypeInfo = configProp.getType().getTypeInfo();
                    log.log(IMPORT_LOG_LEVEL, "Slot type info = " + slotTypeInfo);
                    if (!previousSlotName.contentEquals(configProp.getName())) {
                        log.log(IMPORT_LOG_LEVEL, "  Create new BStruct instance of " + slotTypeInfo.getTypeName());
                        previousSlotName = configProp.getName();
                        newInstance = (BStruct)slotTypeInfo.getInstance();
                    }
                    if (propertyNames.length > 1 && (structProp = ((BStruct)configProp.getDefaultValue()).getProperty(propertyNames[1])) != null) {
                        BValue configPropertyValue = null;
                        if (configValue != null) {
                            configPropertyValue = this.setConfigValue(structProp, configValue, slotType);
                        }
                        if (configPropertyValue == null && !whenNoValueKeepCurrent) {
                            configPropertyValue = structProp.getDefaultValue().newCopy();
                        }
                        if (configPropertyValue != null) {
                            newInstance.set(structProp.getName(), configPropertyValue);
                        }
                    }
                    templateConfig.set(configProp.getName(), newInstance);
                    continue;
                }
                BValue configPropertyValue = null;
                if (configValue != null) {
                    configPropertyValue = this.setConfigValue(configProp, configValue, slotType);
                }
                if (configPropertyValue == null && !whenNoValueKeepCurrent) {
                    configPropertyValue = configProp.getDefaultValue().newCopy();
                }
                if (configPropertyValue == null) continue;
                templateConfig.set(configProp.getName(), configPropertyValue);
                continue;
            }
            catch (Exception e) {
                log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.configComponentError", new Object[]{deployedTemplateComponent.getName(), slotName}), e);
            }
        }
    }

    protected static String[] getPropertyNamesForConfigSlot(String configSlotName) {
        String[] names = SlotPath.unescape((String)configSlotName).split(SLOT_NAME_SEPARATOR_REGEX);
        for (int i = 0; i < names.length; ++i) {
            names[i] = SlotPath.escape((String)names[i]);
        }
        return names;
    }

    public void setTagsFromWorksheet(DeployedWorksheet deployedWorksheet, DeployedRoot deployedRoot, BComponent deployedTemplateComponent) {
        for (int n = 0; n < deployedRoot.tags.length; ++n) {
            String[] tagDef = deployedWorksheet.tagDefs.get(n);
            if (tagDef == null || tagDef.length == 0) {
                log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.tagDefinitionError", new Object[]{deployedTemplateComponent.getName()}));
                continue;
            }
            String tagId = tagDef[0];
            String slotType = tagDef[1];
            String defaultValue = tagDef[2];
            log.log(IMPORT_LOG_LEVEL, "TagId = " + tagId + ", slot type = " + slotType + ", default = " + defaultValue);
            String configValue = deployedRoot.tags[n];
            if (configValue == null) {
                configValue = defaultValue;
            }
            log.log(IMPORT_LOG_LEVEL, "Applying value = " + configValue);
            Tag newTag = Tag.newTag((String)tagId, (String)configValue);
            if (deployedWorksheet.templateType.equals(TEMPLATE_TYPE_APPLICATION)) {
                Object[] choices;
                BTemplateConfig templateConfig = BTemplateConfig.getConfigForRoot((BComponent)deployedTemplateComponent);
                if (templateConfig == null) {
                    log.log(Level.WARNING, lex.getText("bulkDeploy.excelImport.invalidTemplateError", new Object[]{deployedTemplateComponent.getName()}));
                    return;
                }
                templateConfig.lease();
                try {
                    choices = TmplUtil.findMatchingObjects(tagId, this.getSearchService(deployedTemplateComponent), this.getTemplateService(deployedTemplateComponent), (BComponent)templateConfig, lex);
                }
                catch (Exception ignored) {
                    log.log(IMPORT_LOG_LEVEL, " No components found with tag = " + tagId);
                    choices = null;
                }
                for (Object choice : choices) {
                    if (!(choice instanceof BComponent)) continue;
                    BComponent component = (BComponent)choice;
                    component.lease();
                    log.log(IMPORT_LOG_LEVEL, " TO Entity component at = " + component.getSlotPath());
                    component.tags().set(newTag);
                }
                continue;
            }
            ComponentTreeIterator iterator = new ComponentTreeIterator(deployedTemplateComponent);
            while (iterator.hasNext()) {
                Entity entity = iterator.next();
                BComponent component = (BComponent)entity;
                if (!entity.tags().contains(newTag.getId())) continue;
                component.lease();
                log.log(IMPORT_LOG_LEVEL, " TO Entity component at = " + component.getSlotPath());
                entity.tags().set(newTag);
            }
        }
    }

    public boolean templatesHaveConfigPasswords(BWbDeployableNtplFile[] files) {
        boolean hasConfigPasswords = false;
        for (BWbDeployableNtplFile file : files) {
            if (this.templateHasConfigPasswords(file)) {
                hasConfigPasswords = true;
            }
            file.closeIfOpen();
        }
        return hasConfigPasswords;
    }

    public boolean templateHasConfigPasswords(BWbDeployableNtplFile file) {
        BComponent templateBase = file.getBaseComponent();
        if (templateBase == null) {
            return false;
        }
        BTemplateConfig templateConfig = BTemplateConfig.getConfigForRoot((BComponent)templateBase);
        if (templateConfig == null) {
            return false;
        }
        BConfigBinding[] configBindings = templateConfig.getConfigBindings();
        if (configBindings == null) {
            return false;
        }
        for (BConfigBinding configBinding : configBindings) {
            String slotName = configBinding.getSourceSlot();
            Property configProperty = templateConfig.getProperty(slotName);
            if (configProperty == null) continue;
            if (configProperty.getType().is(BPassword.TYPE)) {
                return true;
            }
            if (!configProperty.getType().is(BStruct.TYPE) || configProperty.getType().is(BStatusValue.TYPE)) continue;
            for (Property property : ((BStruct)configProperty.getDefaultValue()).getPropertiesArray()) {
                if (!property.getType().is(BPassword.TYPE)) continue;
                return true;
            }
        }
        return false;
    }

    public static void setComponentPosition(BComponent component, String positionStr) {
        BWsAnnotation position = BulkDeployUtil.buildWsPosition(positionStr);
        if (position == null) {
            return;
        }
        Slot wsAnnotation = component.getSlot("wsAnnotation");
        if (wsAnnotation == null) {
            component.add("wsAnnotation", (BValue)position);
        } else if (wsAnnotation.isProperty()) {
            component.set((Property)wsAnnotation, (BValue)position);
        }
    }

    private static BWsAnnotation buildWsPosition(String positionStr) {
        if (positionStr == null || positionStr.isEmpty()) {
            return null;
        }
        BWsAnnotation position = null;
        StringTokenizer st = new StringTokenizer(positionStr, ",");
        if (st.hasMoreTokens()) {
            try {
                int p = Integer.parseInt(st.nextToken().trim());
                if (st.hasMoreTokens()) {
                    int q = Integer.parseInt(st.nextToken().trim());
                    if (st.hasMoreTokens()) {
                        int wixelWidth = Integer.parseInt(st.nextToken().trim());
                        position = BWsAnnotation.make((int)p, (int)q, (int)wixelWidth);
                    } else {
                        position = BWsAnnotation.make((int)p, (int)q);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return position;
    }

    private BValue setConfigValue(Property configProp, String configValue, String slotType) throws IOException {
        TypeInfo slotTypeInfo = Sys.getRegistry().getType(slotType);
        log.log(IMPORT_LOG_LEVEL, "Slot type info = " + slotTypeInfo);
        BObject slotInstance = slotTypeInfo.getInstance();
        BValue configPropertyValue = null;
        if (configProp.getType().is(BStatusValue.TYPE)) {
            configPropertyValue = (BValue)slotTypeInfo.getInstance();
            if (configProp.getType().is(BStatusNumeric.TYPE)) {
                ((BStatusNumeric)configPropertyValue).setValue(Double.parseDouble(configValue));
            } else if (configProp.getType().is(BStatusBoolean.TYPE)) {
                ((BStatusBoolean)configPropertyValue).setValue(Boolean.parseBoolean(configValue.toLowerCase()));
            } else if (configProp.getType().is(BStatusString.TYPE)) {
                ((BStatusString)configPropertyValue).setValue(configValue);
            } else if (configProp.getType().is(BStatusEnum.TYPE)) {
                BValue defaultValue = configProp.getDefaultValue();
                BEnumRange range = ((BStatusEnum)defaultValue).getEnum().getRange();
                if (range.isNull()) {
                    ((BStatusEnum)configPropertyValue).setValue(BDynamicEnum.make((int)Double.valueOf(configValue).intValue()));
                } else {
                    BEnum selectedValue = range.get(configValue);
                    log.log(IMPORT_LOG_LEVEL, "BStatusEnum value = " + selectedValue.getTag());
                    if (selectedValue != null) {
                        ((BStatusEnum)configPropertyValue).setValue(selectedValue);
                    }
                }
            }
        } else if (configProp.getType().is(BSimple.TYPE)) {
            if (configProp.getType().is(BInteger.TYPE)) {
                String converted = Integer.toString(Double.valueOf(configValue).intValue());
                configPropertyValue = BInteger.make((String)converted);
            } else if (configProp.getType().is(BLong.TYPE)) {
                String converted = Long.toString(Double.valueOf(configValue).longValue());
                configPropertyValue = BLong.make((String)converted);
            } else if (configProp.getType().is(BBoolean.TYPE)) {
                configPropertyValue = BBoolean.make((boolean)Boolean.parseBoolean(configValue.toLowerCase()));
            } else if (configProp.getType().is(BFrozenEnum.TYPE)) {
                BEnum selectedValue = ((BFrozenEnum)slotInstance).getEnum().getRange().get(configValue);
                log.log(IMPORT_LOG_LEVEL, "BFrozenEnum value = " + selectedValue.getTag());
                configPropertyValue = (BValue)((BFrozenEnum)slotInstance).decodeFromString(configValue);
            } else if (configProp.getType().is(BDynamicEnum.TYPE)) {
                BValue defaultValue = configProp.getDefaultValue();
                BEnumRange range = ((BDynamicEnum)defaultValue).getEnum().getRange();
                BEnum selectedValue = range.get(configValue);
                log.log(IMPORT_LOG_LEVEL, "BDynamicEnum value = " + selectedValue.getTag());
                int selectedOrdinal = selectedValue.getOrdinal();
                configPropertyValue = BDynamicEnum.make((int)selectedOrdinal, (BEnumRange)range);
            } else {
                configPropertyValue = (BValue)((BSimple)slotInstance).decodeFromString(configValue);
            }
        }
        return configPropertyValue;
    }

    protected BSearchService getSearchService(BComponent base) {
        if (this.searchService != null) {
            return this.searchService;
        }
        BIService service = this.getService(BSearchService.TYPE, base);
        if (service == null) {
            return null;
        }
        this.searchService = (BSearchService)service;
        return this.searchService;
    }

    protected BTemplateService getTemplateService(BComponent base) {
        if (this.templateService != null) {
            return this.templateService;
        }
        BIService service = this.getService(BTemplateService.TYPE, base);
        if (service == null) {
            return null;
        }
        this.templateService = (BTemplateService)service;
        return this.templateService;
    }

    private BIService getService(Type serviceType, BComponent base) {
        BComponentSpace space = base.getComponentSpace();
        if (space == null) {
            return null;
        }
        BComponent root = space.getRootComponent();
        BServiceContainer[] serviceContainer = (BServiceContainer[])root.getChildren(BServiceContainer.class);
        if (serviceContainer == null || serviceContainer.length == 0) {
            return null;
        }
        BIService[] services = (BIService[])serviceContainer[0].getChildren(serviceType.getTypeClass());
        if (services == null || services.length == 0) {
            return null;
        }
        return services[0];
    }

    private String getCell(Row row, int cellnum) {
        String result = this.getCellOrNull(row, cellnum, false);
        if (result == null) {
            return "";
        }
        return result;
    }

    private String getCellOrNull(Row row, int cellnum, boolean forceString) {
        Cell cell = row.getCell(cellnum);
        if (cell == null || cell.getCellType() == CellType.BLANK) {
            return null;
        }
        if (forceString && cell.getCellType() != CellType.STRING) {
            DataFormatter formatter = ExcelUtils.makeDataFormatter();
            return formatter.formatCellValue(cell);
        }
        return cell.toString();
    }

    private boolean getCellAsBoolean(Row row, int cellnum) {
        Cell cell = row.getCell(cellnum);
        if (cell == null) {
            return false;
        }
        switch (cell.getCellType()) {
            case BOOLEAN: 
            case BLANK: {
                return cell.getBooleanCellValue();
            }
            case NUMERIC: {
                return cell.getNumericCellValue() != 0.0;
            }
        }
        return Boolean.parseBoolean(cell.toString());
    }

    private String getEscapedNameFromSlotPath(String name) {
        if (name == null || name.length() == 0) {
            return "";
        }
        String[] names = name.split("/");
        return SlotPath.escape((String)names[names.length - 1]);
    }

    private String escapeSlotPathNames(String name) {
        String[] names = name.split("/");
        StringJoiner sj = new StringJoiner("/");
        for (String node : names) {
            sj.add(SlotPath.escape((String)node));
        }
        return sj.toString();
    }

    private BComponent getNamedComponentFromChoices(Object[] choices, String path, String name) {
        for (Object choice : choices) {
            BComponent component;
            if (!(choice instanceof BComponent) || !(component = (BComponent)choice).getSlotPath().toString().contains(path) || !component.getName().equals(name)) continue;
            return component;
        }
        return null;
    }

    public BOrdList getSelectedOptionalsFromWorkbook(BWbDeployableNtplFile applicationTemplateFile, DeployedWorksheet deployedWorksheet, DeployedRoot deployedRoot) {
        Array optionalComponentOrds = applicationTemplateFile.getTemplateManifest().optional;
        if (optionalComponentOrds.isEmpty()) {
            return BOrdList.DEFAULT;
        }
        ArrayList<BOrd> optionalOrdList = new ArrayList<BOrd>();
        String[] rootOptionals = deployedRoot.getOptionals();
        block0: for (int i = 0; i < rootOptionals.length; ++i) {
            String optionalInstallValue = rootOptionals[i];
            String[] optionalColumnInfo = deployedWorksheet.optionalDefs.get(i);
            if (optionalInstallValue == null) {
                optionalInstallValue = optionalColumnInfo[2];
            }
            String optionalSlotPath = optionalColumnInfo[0];
            for (BOrd optionalComponentOrd : optionalComponentOrds) {
                OrdQuery[] queries = optionalComponentOrd.parse();
                SlotPath path = (SlotPath)queries[queries.length - 1];
                if (!path.getBody().contains(optionalSlotPath)) continue;
                if (Boolean.parseBoolean(optionalInstallValue.toLowerCase())) continue block0;
                String[] names = path.getNames();
                StringBuilder friendlyName = new StringBuilder(names[1]);
                for (int j = 2; j < names.length; ++j) {
                    friendlyName.append('/').append(names[j]);
                }
                optionalOrdList.add(BOrd.make((OrdQuery)new SlotPath(friendlyName.toString())));
                continue block0;
            }
        }
        return BOrdList.make((BOrd[])optionalOrdList.toArray(new BOrd[0]));
    }

    private static enum TemplateType {
        COMPONENT,
        DEVICE,
        APPLICATION;

    }

    private static class StyleVault {
        private Font boldFont = null;
        private CellStyle infoCellStyle = null;
        private CellStyle instanceCellStyle = null;
        private CellStyle optionalCellStyle = null;
        private CellStyle inputCellStyle = null;
        private CellStyle outputCellStyle = null;
        private CellStyle relationCellStyle = null;
        private CellStyle configCellStyle = null;
        private CellStyle optionalConfigCellStyle = null;
        private CellStyle highlightCellStyle = null;
        private CellStyle tagCellStyle = null;
        private CellStyle dataCellStyle = null;
        private CellStyle dataCellStyleRO = null;
        private CellStyle stringCellStyle = null;
        private CellStyle stringCellStyleRO = null;
        private CellStyle passwordCellStyle = null;
        private CellStyle passwordCellStyleRO = null;
        private CellStyle emptyCellStyle = null;
        Color lightGray;
        private final Workbook workbook;

        StyleVault(Workbook workbook) {
            this.workbook = workbook;
            byte[] colorBytes = new byte[]{-24, -24, -24};
            this.lightGray = !ExcelUtils.isXmlFormat((ExcelFileObject)workbook) ? null : ExcelUtils.makeXmlFormatColor((byte[])colorBytes);
        }

        CellStyle getInfoCellStyle() {
            if (this.infoCellStyle == null) {
                Font infoFont = this.workbook.createFont();
                infoFont.setBold(true);
                infoFont.setColor(ExcelUtils.getColorIndex((IndexedColors)IndexedColors.DARK_BLUE));
                this.infoCellStyle = this.workbook.createCellStyle();
                this.infoCellStyle.setFont(infoFont);
                this.infoCellStyle.setLocked(false);
            }
            return this.infoCellStyle;
        }

        CellStyle getInstanceCellStyle() {
            if (this.instanceCellStyle == null) {
                this.instanceCellStyle = this.generateHeaderCellStyle(this.getBoldFont(), ExcelUtils.getColorIndex((IndexedColors)IndexedColors.GREY_25_PERCENT));
            }
            return this.instanceCellStyle;
        }

        CellStyle getOptionalCellStyle() {
            if (this.optionalCellStyle == null) {
                this.optionalCellStyle = this.generateHeaderCellStyle(this.getBoldFont(), ExcelUtils.getColorIndex((IndexedColors)IndexedColors.GREY_40_PERCENT));
            }
            return this.optionalCellStyle;
        }

        CellStyle getInputCellStyle() {
            if (this.inputCellStyle == null) {
                this.inputCellStyle = this.generateHeaderCellStyle(this.getBoldFont(), ExcelUtils.getColorIndex((IndexedColors)IndexedColors.PALE_BLUE));
            }
            return this.inputCellStyle;
        }

        CellStyle getOutputCellStyle() {
            if (this.outputCellStyle == null) {
                this.outputCellStyle = this.generateHeaderCellStyle(this.getBoldFont(), ExcelUtils.getColorIndex((IndexedColors)IndexedColors.SKY_BLUE));
            }
            return this.outputCellStyle;
        }

        CellStyle getRelationCellStyle() {
            if (this.relationCellStyle == null) {
                this.relationCellStyle = this.generateHeaderCellStyle(this.getBoldFont(), ExcelUtils.getColorIndex((IndexedColors)IndexedColors.LIGHT_GREEN));
            }
            return this.relationCellStyle;
        }

        CellStyle getConfigCellStyle() {
            if (this.configCellStyle == null) {
                this.configCellStyle = this.generateHeaderCellStyle(this.getBoldFont(), ExcelUtils.getColorIndex((IndexedColors)IndexedColors.LIGHT_YELLOW));
            }
            return this.configCellStyle;
        }

        CellStyle getOptionalConfigCellStyle() {
            if (this.optionalConfigCellStyle == null) {
                this.optionalConfigCellStyle = this.generateHeaderCellStyle(this.getBoldFont(), ExcelUtils.getColorIndex((IndexedColors)IndexedColors.GOLD));
            }
            return this.optionalConfigCellStyle;
        }

        CellStyle getHighlightCellStyle() {
            if (this.highlightCellStyle == null && this.lightGray != null) {
                this.highlightCellStyle = this.generateColorCellStyle(this.lightGray);
            }
            return this.highlightCellStyle;
        }

        CellStyle getTagCellStyle() {
            if (this.tagCellStyle == null) {
                this.tagCellStyle = this.generateHeaderCellStyle(this.getBoldFont(), ExcelUtils.getColorIndex((IndexedColors)IndexedColors.LEMON_CHIFFON));
            }
            return this.tagCellStyle;
        }

        CellStyle getDataCellStyle() {
            if (this.dataCellStyle == null) {
                this.dataCellStyle = this.generateDataCellStyle();
            }
            return this.dataCellStyle;
        }

        CellStyle getStringCellStyle() {
            if (this.stringCellStyle == null) {
                this.stringCellStyle = this.generateDataCellStyle();
                this.stringCellStyle.setQuotePrefixed(true);
                this.stringCellStyle.setDataFormat(ExcelUtils.getBuiltinFormat((String)"TEXT"));
            }
            return this.stringCellStyle;
        }

        CellStyle getPasswordCellStyle() {
            if (this.passwordCellStyle == null) {
                this.passwordCellStyle = this.generateDataCellStyle();
                this.passwordCellStyle.setHidden(true);
                this.passwordCellStyle.setQuotePrefixed(true);
                CreationHelper creationHelper = this.workbook.getCreationHelper();
                short formatIndex = creationHelper.createDataFormat().getFormat(";;;**");
                this.passwordCellStyle.setDataFormat(formatIndex);
            }
            return this.passwordCellStyle;
        }

        CellStyle getEmptyCellStyle() {
            if (this.emptyCellStyle == null) {
                this.emptyCellStyle = this.generateCellStyle(null, (short)0, false);
            }
            return this.emptyCellStyle;
        }

        private CellStyle generateDataCellStyle() {
            return this.generateCellStyle(null, (short)0, false);
        }

        private CellStyle generateHeaderCellStyle(Font font, short color) {
            return this.generateCellStyle(font, color, true);
        }

        private CellStyle generateCellStyle(Font font, short color, boolean header) {
            CellStyle newStyle = this.workbook.createCellStyle();
            if (font != null) {
                newStyle.setFont(font);
            }
            newStyle.setHidden(false);
            newStyle.setLocked(header);
            newStyle.setQuotePrefixed(header);
            if (color != 0) {
                newStyle.setFillForegroundColor(color);
                newStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
            return newStyle;
        }

        private CellStyle generateColorCellStyle(Color color) {
            CellStyle newStyle = this.workbook.createCellStyle();
            newStyle.setFillForegroundColor(color);
            newStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            return newStyle;
        }

        private Font getBoldFont() {
            if (this.boldFont == null) {
                this.boldFont = this.workbook.createFont();
                this.boldFont.setBold(true);
            }
            return this.boldFont;
        }
    }

    class BindingProperty {
        Property property;
        BValue value;
        String name;

        BindingProperty(Property property, BValue value, String name) {
            this.property = property;
            this.value = value;
            this.name = name;
        }
    }

    class BindingProperties {
        BConfigBinding configBinding;
        List<BindingProperty> properties;

        BindingProperties(BConfigBinding binding, BTemplateConfig templateConfig) {
            this.configBinding = binding;
            this.properties = new ArrayList<BindingProperty>();
            String slotName = this.configBinding.getSourceSlot();
            Property configProperty = templateConfig.getProperty(slotName);
            BValue configPropertyValue = templateConfig.get(slotName);
            if (configPropertyValue != null) {
                if (configProperty.getType().is(BStruct.TYPE) && !configProperty.getType().is(BStatusValue.TYPE)) {
                    Property[] structProperties;
                    for (Property structProperty : structProperties = ((BStruct)configPropertyValue).getPropertiesArray()) {
                        this.properties.add(new BindingProperty(structProperty, ((BStruct)configPropertyValue).get(structProperty), slotName + BulkDeployUtil.SLOT_NAME_SEPARATOR + structProperty.getName()));
                    }
                } else {
                    this.properties.add(new BindingProperty(configProperty, configPropertyValue, slotName));
                }
            }
        }
    }

    class OptionalBindingProperties
    extends BindingProperties {
        BComponent parentComponent;
        String relativeSlotPath;

        OptionalBindingProperties(BConfigBinding binding, List<BOrd> optionalComponents, BComponent templateBase, BTemplateConfig templateConfig) {
            super(binding, templateConfig);
            this.relativeSlotPath = "";
            Optional parentComponent = BulkDeployUtil.this.getComponentForOptionalConfig(binding, optionalComponents, templateBase);
            if (parentComponent.isPresent()) {
                this.parentComponent = (BComponent)parentComponent.get();
                this.relativeSlotPath = BulkDeployUtil.this.getRelativeSlotPathForOptionalComponent((BComponent)parentComponent.get(), templateBase);
            }
        }
    }

    public static class DeployedWorksheet {
        public String title;
        public String vendor;
        public String version;
        public BUuid uid;
        public String templateType;
        public String templateFile;
        public String templateExportVersion;
        public List<DeployedRoot> deployedRoots = new ArrayList<DeployedRoot>();
        public List<String[]> inputDefs = new ArrayList<String[]>();
        public List<String[]> outputDefs = new ArrayList<String[]>();
        public List<String[]> relationDefs = new ArrayList<String[]>();
        public List<String[]> configDefs = new ArrayList<String[]>();
        public List<String[]> optionalDefs = new ArrayList<String[]>();
        public List<String[]> optionalConfigDefs = new ArrayList<String[]>();
        public List<String[]> tagDefs = new ArrayList<String[]>();
    }

    public static class DeployedRoot {
        private String parentComponentSlotPath;
        private String deployName;
        private String displayName;
        private String position;
        private String deviceTarget;
        private boolean enableHistories;
        private String[] inputs;
        private String[] outputs;
        private String[] relations;
        private String[] configs;
        private String[] optionals;
        private String[] optionalConfigs;
        private String[] tags;
        private BComponent deployedTemplate;

        public void setDeployedTemplate(BComponent deployedTemplate) {
            this.deployedTemplate = deployedTemplate;
        }

        public String getParentComponentSlotPath() {
            return this.parentComponentSlotPath;
        }

        public String getDeployName() {
            return this.deployName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getPosition() {
            return this.position;
        }

        public String getDeviceTarget() {
            return this.deviceTarget;
        }

        public boolean isEnableHistories() {
            return this.enableHistories;
        }

        public String[] getInputs() {
            return this.inputs;
        }

        public String[] getOutputs() {
            return this.outputs;
        }

        public String[] getRelations() {
            return this.relations;
        }

        public String[] getConfigs() {
            return this.configs;
        }

        public String[] getOptionals() {
            return this.optionals;
        }

        public String[] getOptionalConfigs() {
            return this.optionalConfigs;
        }

        public String[] getTags() {
            return this.tags;
        }

        public BComponent getDeployedTemplate() {
            return this.deployedTemplate;
        }

        static /* synthetic */ String[] access$802(DeployedRoot x0, String[] x1) {
            x0.inputs = x1;
            return x1;
        }

        static /* synthetic */ String[] access$902(DeployedRoot x0, String[] x1) {
            x0.outputs = x1;
            return x1;
        }

        static /* synthetic */ String[] access$1002(DeployedRoot x0, String[] x1) {
            x0.relations = x1;
            return x1;
        }

        static /* synthetic */ String[] access$1102(DeployedRoot x0, String[] x1) {
            x0.configs = x1;
            return x1;
        }

        static /* synthetic */ String[] access$1202(DeployedRoot x0, String[] x1) {
            x0.optionals = x1;
            return x1;
        }

        static /* synthetic */ String[] access$1302(DeployedRoot x0, String[] x1) {
            x0.optionalConfigs = x1;
            return x1;
        }

        static /* synthetic */ String[] access$1402(DeployedRoot x0, String[] x1) {
            x0.tags = x1;
            return x1;
        }
    }
}

