/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui;

import com.tridium.excel.ExcelUiUtils;
import com.tridium.template.BTemplateService;
import com.tridium.template.file.NtplUtil;
import com.tridium.template.ui.ApplicationTemplateInstallUtil;
import com.tridium.template.ui.BTemplateDeployProgressDialog;
import com.tridium.template.ui.BulkDeployUtil;
import com.tridium.template.ui.BulkDeployWorkbook;
import com.tridium.template.ui.TemplateDeployWorker;
import com.tridium.template.ui.file.BBulkDeployPasswordPrompt;
import com.tridium.template.ui.installapp.BackupUiHandler;
import com.tridium.template.ui.installapp.CompatibilityMessageUiHandler;
import com.tridium.template.ui.installapp.ConfirmInstallApplicationTemplateUiHandler;
import com.tridium.template.ui.installapp.InstallingApplicationWorker;
import com.tridium.ui.wizard.step.StepModel;
import com.tridium.ui.wizard.step.StepWizardModel;
import com.tridium.ui.wizard.step.WizardStep;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.IFileFilter;
import javax.baja.naming.BOrd;
import javax.baja.security.BPassword;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.BServiceContainer;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbComponentView;

public abstract class BulkDeploy
extends Command {
    protected BWidget owner;
    protected BulkDeployUtil deployUtil;
    protected Level IMPORT_LOG_LEVEL = Level.FINE;
    protected static final Lexicon LEX = Lexicon.make((String)"template");
    protected static final Logger LOG = Logger.getLogger("template");

    public BulkDeploy(BWidget owner, String label) {
        super(owner, label);
    }

    public BulkDeploy(BWidget owner, Lexicon lexicon, String keyBase) {
        super(owner, lexicon, keyBase);
    }

    public CommandArtifact doInvoke() throws Exception {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandArtifact doDeploy() throws Exception {
        if (ExcelUiUtils.informIfNoExcelSupportIsInstalledLocally((BWidget)this.getShell())) {
            return null;
        }
        LOG.log(this.IMPORT_LOG_LEVEL, "Bulk deploy");
        BComponent root = this.initBulkDeploy();
        if (root == null) {
            return null;
        }
        BFileChooser chooser = BFileChooser.makeOpen((BWidget)this.getShell());
        chooser.setCurrentDirectory(NtplUtil.getTemplateDirectoryOrd());
        chooser.addFilter((IFileFilter)new ExtFileFilter("Excel Files", new String[]{"xlsx", "xls"}));
        BOrd excelOrd = chooser.show();
        if (excelOrd == null) {
            return null;
        }
        BIFile excelFile = (BIFile)excelOrd.resolve().get();
        File importFile = BFileSystem.INSTANCE.pathToLocalFile(excelFile.getFilePath());
        try (BulkDeployWorkbook wb = null;){
            BPassword password2;
            wb = BulkDeployWorkbook.load(importFile);
            if (wb.isEncrypted()) {
                wb.close();
                password2 = BBulkDeployPasswordPrompt.getPassword(this.getOwner(), importFile);
                if (password2 == BBulkDeployPasswordPrompt.DLG_CANCELLED) {
                    CommandArtifact commandArtifact = null;
                    return commandArtifact;
                }
                wb = BulkDeployWorkbook.load(importFile, password2.getValue());
                if (!wb.isValid()) {
                    BDialog.message((BWidget)this.getOwner(), (Object)LEX.getText("bulkDeploy.excelImport.invalidPassword"));
                    CommandArtifact commandArtifact = null;
                    return commandArtifact;
                }
            } else if (!wb.isValid()) {
                BDialog.message((BWidget)this.getOwner(), (Object)LEX.getText("bulkDeploy.excelImport.invalidFile"));
                CommandArtifact password2 = null;
                return password2;
            }
            if (wb.hasPrivateData() && (wb.usesOldExcelFormat() || !wb.isEncrypted()) && 4 != BDialog.confirm((BWidget)this.getOwner(), (String)LEX.getText("bulkDeploy.excelImport.insecureFormat.title"), (Object)LEX.getText("bulkDeploy.excelImport.insecureFormat.message"))) {
                password2 = null;
                return password2;
            }
            if (wb.hasApplicationTemplate()) {
                if (!(root instanceof BStation)) {
                    BDialog.error((BWidget)this.getShell(), (String)LEX.getText("bulkDeploy.excelImport.applicationNotAllowedTitle"), (Object)LEX.getText("bulkDeploy.excelImport.applicationNotAllowed"));
                    password2 = null;
                    return password2;
                }
                try {
                    BWizard.open((BWidget)this.getOwner(), (WizardModel)this.makeWizardModel((BStation)root, excelFile, wb));
                }
                catch (Exception err) {
                    BDialog.error((BWidget)this.getOwner(), (String)this.getLabel(), (Object)LEX.get("installApplication.cannotInstall"), (Throwable)err);
                }
                CommandArtifact err = null;
                return err;
            }
            TemplateDeployWorker worker = new TemplateDeployWorker(wb, root, this.deployUtil);
            BTemplateDeployProgressDialog.open((BWidget)this.owner.getShell(), LEX.getText("bulkDeploy.progress.title"), worker);
        }
        return null;
    }

    protected BComponent initBulkDeploy() {
        this.owner = this.getOwner();
        if (!this.owner.getType().is(BWbComponentView.TYPE)) {
            LOG.log(Level.WARNING, "Bulk Deploy command owner should be a manager view");
            return null;
        }
        BObject ownerObject = ((BWbComponentView)this.owner).getCurrentValue();
        if (!ownerObject.getType().is(BComponent.TYPE)) {
            LOG.log(Level.WARNING, "Bulk Deploy command owner target should be a component");
            return null;
        }
        BComponent ownerComponent = (BComponent)ownerObject;
        this.deployUtil = new BulkDeployUtil();
        BTemplateService templateService = this.deployUtil.getTemplateService(ownerComponent);
        if (templateService == null) {
            return null;
        }
        BComponentSpace space = templateService.getComponentSpace();
        if (space == null) {
            return null;
        }
        BComponent root = space.getRootComponent();
        BServiceContainer[] serviceContainer = (BServiceContainer[])root.getChildren(BServiceContainer.class);
        if (serviceContainer == null || serviceContainer.length == 0) {
            return null;
        }
        return root;
    }

    protected BulkDeployWorkbook getDeployWorkbook() throws Exception {
        BFileChooser chooser = BFileChooser.makeOpen((BWidget)this.getShell());
        chooser.setCurrentDirectory(NtplUtil.getTemplateDirectoryOrd());
        chooser.addFilter((IFileFilter)new ExtFileFilter("Excel Files", new String[]{"xlsx", "xls"}));
        BOrd excelOrd = chooser.show();
        if (excelOrd == null) {
            return null;
        }
        BIFile excelFile = (BIFile)excelOrd.resolve().get();
        File importFile = BFileSystem.INSTANCE.pathToLocalFile(excelFile.getFilePath());
        BulkDeployWorkbook wb = BulkDeployWorkbook.load(importFile);
        if (wb.isEncrypted()) {
            wb.close();
            BPassword password = BBulkDeployPasswordPrompt.getPassword(this.getOwner(), importFile);
            if (password == BBulkDeployPasswordPrompt.DLG_CANCELLED) {
                return null;
            }
            wb = BulkDeployWorkbook.load(importFile, password.getValue());
            if (!wb.isValid()) {
                BDialog.message((BWidget)this.getOwner(), (Object)LEX.getText("bulkDeploy.excelImport.invalidPassword"));
                wb.close();
                return null;
            }
        } else if (!wb.isValid()) {
            BDialog.message((BWidget)this.getOwner(), (Object)LEX.getText("bulkDeploy.excelImport.invalidFile"));
            wb.close();
            return null;
        }
        if (wb.hasPrivateData() && (wb.usesOldExcelFormat() || !wb.isEncrypted()) && 4 != BDialog.confirm((BWidget)this.getOwner(), (String)LEX.getText("bulkDeploy.excelImport.insecureFormat.title"), (Object)LEX.getText("bulkDeploy.excelImport.insecureFormat.message"))) {
            wb.close();
            return null;
        }
        return wb;
    }

    private StepWizardModel makeWizardModel(BStation station, BIFile excelFile, BulkDeployWorkbook workbook) {
        ApplicationTemplateInstallUtil installInfo = new ApplicationTemplateInstallUtil(station, excelFile, workbook);
        installInfo.checkApplicationTemplateFileCompatibility();
        WizardStep firstStep = null;
        if (installInfo.hasCompatibilityMessage()) {
            firstStep = CompatibilityMessageUiHandler.makeWizardStep(installInfo);
        }
        WizardStep backupStep = BackupUiHandler.makeWizardStep(installInfo);
        WizardStep confirmStep = ConfirmInstallApplicationTemplateUiHandler.makeWizardStep(installInfo);
        WizardStep installingStep = InstallingApplicationWorker.makeWizardStep(installInfo);
        if (firstStep == null) {
            firstStep = backupStep;
        } else {
            firstStep.setNext(backupStep);
        }
        backupStep.setNext(backupStep).setNext(confirmStep).setNext(installingStep);
        StepModel stepModel = StepModel.make((WizardStep)firstStep);
        return new StepWizardModel(stepModel, LEX.get("installApplication.title"));
    }
}

