/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui;

import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.tagdictionary.util.TagDictionaryUtil;
import com.tridium.template.BPasswordBinding;
import com.tridium.template.BTemplateConfig;
import com.tridium.template.BTemplateState;
import com.tridium.template.TemplateConst;
import com.tridium.template.UpgradeUtil;
import com.tridium.template.application.ApplicationTemplateUtil;
import com.tridium.template.file.BNtplFile;
import com.tridium.template.file.DependencyUtil;
import com.tridium.template.file.NtplUtil;
import com.tridium.template.file.PxFileRef;
import com.tridium.template.manifest.TemplateManifest;
import com.tridium.template.ui.BDuplicateTemplateInfo;
import com.tridium.template.ui.BTemplateBogEditor;
import com.tridium.template.ui.BTemplateConfigEditor;
import com.tridium.template.ui.BTemplateIOEditor;
import com.tridium.template.ui.BTemplateManager;
import com.tridium.template.ui.BTemplateOptions;
import com.tridium.template.ui.BTemplatePxEditor;
import com.tridium.template.ui.BTemplateRelationEditor;
import com.tridium.template.ui.TemplateViewState;
import com.tridium.template.ui.file.BWbDeployableNtplFile;
import com.tridium.template.ui.file.TmplUtil;
import com.tridium.template.ui.sidebar.BTemplateSideBar;
import com.tridium.ui.BOptionDialog;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import com.tridium.util.CompUtil;
import com.tridium.util.ObjectUtil;
import com.tridium.workbench.console.BConsole;
import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import com.tridium.workbench.shell.BErrorPanel;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.tools.NewStationUtil;
import com.tridium.workbench.util.BEditTagDialog;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.BDevice;
import javax.baja.file.BDataFile;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.types.image.BImageFile;
import javax.baja.file.types.image.BPngFile;
import javax.baja.file.zip.BZipSpace;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BMarker;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.CopyHints;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.TagDictionaryService;
import javax.baja.tag.TagInfo;
import javax.baja.tagdictionary.BTagDictionaryService;
import javax.baja.tagdictionary.BTagGroupInfo;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.WidgetSubscriber;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.menu.BIMenuBar;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.util.Version;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.sidebar.BIWbSideBar;
import javax.baja.workbench.view.BWbComponentView;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"template:NtplFile"}, requiredPermissions="r", defaultAgent=AgentOn.Preference.NORMAL)})
@NiagaraActions(value={@NiagaraAction(name="templateModified"), @NiagaraAction(name="save"), @NiagaraAction(name="duplicate"), @NiagaraAction(name="cancel")})
public class BTemplateView
extends BWbComponentView
implements BConsole.HyperlinkInterceptor,
TemplateConst {
    public static final Action templateModified = BTemplateView.newAction((int)0, null);
    public static final Action save = BTemplateView.newAction((int)0, null);
    public static final Action duplicate = BTemplateView.newAction((int)0, null);
    public static final Action cancel = BTemplateView.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BTemplateView.class);
    BEdgePane iconPan;
    static BImage openIcon = BImage.make((String)"module://icons/x16/open.png");
    static ArrayList<BIMenu> menuList = new ArrayList();
    private static final String INVALID_TEMPLATE_NAME = "ivdName";
    private static final String INVALID_TEMPLATE_NAME_ICON = "ivdNameIcon";
    private static BImage infoIcon = BImage.make((String)"module://icons/x16/info.png");
    private static BImage errorIcon = BImage.make((String)"module://icons/x16/error.png");
    private static final String NO_ICON = "NO ICON SELECTED";
    private static final Lexicon lex = Lexicon.make((String)"template");
    private static final Logger log = Logger.getLogger("ntpl");
    private BWbDeployableNtplFile ntplFile;
    private BComponent templateComp;
    private Property tcfgProp;
    private BTemplateConfig templateConfig;
    private TemplateManifest manifest;
    private BDataFile[] stationFiles = null;
    private String templateName;
    private BLabel banner;
    private boolean newTemplate = false;
    private boolean initModified = false;
    private boolean checkIo = false;
    private HashSet<String> outOfDateSubtemplates = null;
    private ArrayList<String> dynamicPasswordDetected = new ArrayList();
    private boolean uuidAssigned = false;
    private boolean titleAssigned = false;
    boolean readOnly = true;
    BTabbedPane tp;
    TabbedPaneSubscriber tabbedPaneSubscriber;
    PropertyChangedSubscriber propertyChangedSubscriber;
    private BGridPane infoGridPane;
    private BGridPane nameGridPane;
    private BGridPane versionGridPane;
    private BGridPane titleGridPane;
    private BLabel invalidName;
    private BLabel invalidVersion;
    private BLabel titleRequired;
    private BTextField nameField;
    private BTextField titleField;
    private BTextField vendorField;
    private BFrozenEnumFE stateField;
    private BTextField versionField;
    private BTextField descriptionField;
    private BTextEditorPane infoField;
    private BPngFile pngFile = null;
    BOrd iconSrcOrd = null;
    BOrd imageOrd = null;
    private BLabel iconLabel;
    BTemplateBogEditor bogPane;
    BWidget infoPane;
    BTemplateConfigEditor settingsPane;
    BTemplateRelationEditor relationPane;
    BTemplateIOEditor ioPane;
    BWidget bindingsPane;
    BTemplatePxEditor graphicsPane;
    BTemplateManager templateMgr;
    private BButton btnSave;
    private BButton btnDuplicate;
    private BButton btnCancel;
    private BPane buttonPane;

    public void templateModified() {
        this.invoke(templateModified, null, null);
    }

    public void save() {
        this.invoke(save, null, null);
    }

    public void duplicate() {
        this.invoke(duplicate, null, null);
    }

    public void cancel() {
        this.invoke(cancel, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void deactivated() {
        if (this.ntplFile != null) {
            TemplateViewState.save(this);
            if (this.bogPane != null) {
                this.bogPane.deactivated();
            }
            BIMenuBar w = (BIMenuBar)this.getShell().getMenuBar();
            for (int i = 0; i < menuList.size(); ++i) {
                w.removeMenu(menuList.get(i));
            }
            menuList.clear();
            if (!this.readOnly && this.ntplFile.isOpen()) {
                this.ntplFile.close();
            }
        }
    }

    public void prime() {
        if (this.newTemplate || this.initModified) {
            this.doTemplateModified();
        }
    }

    public void doLoadValue(BObject value, Context cx) {
        try {
            Feature feature = Sys.getLicenseManager().getFeature("tridium", "template");
            feature.check();
            this.ntplFile = (BWbDeployableNtplFile)value;
            this.readOnly = this.ntplFile.getSpace() instanceof BZipSpace;
            this.setReadonly(this.readOnly);
            this.init();
            BEdgePane ep = new BEdgePane();
            this.banner = new BLabel(this.getBannerText(), BHalign.left);
            BFont fnt = Theme.label().getTextFont((IStylable)this.banner);
            this.banner.setFont(BFont.make((String)fnt.getName(), (double)(fnt.getSize() * 1.1), (int)1));
            BEdgePane bp = new BEdgePane();
            bp.setCenter((BWidget)this.banner);
            if (this.readOnly) {
                BLabel ro = new BLabel("ReadOnly", BFont.make((String)fnt.getName(), (double)(fnt.getSize() * 1.1), (int)1));
                ro.setForeground(BBrush.makeSolid((BColor)BColor.red));
                bp.setLeft((BWidget)new BBorderPane((BWidget)ro, 0.0, 10.0, 0.0, 0.0));
            }
            ep.setTop((BWidget)new BBorderPane((BWidget)bp, 5.0, 0.0, 7.0, 2.0));
            this.tp = new BTabbedPane();
            ep.setCenter((BWidget)new BBorderPane((BWidget)this.tp, 0.0, 0.0, 10.0, 0.0));
            this.buttonPane = this.buildButtonPane();
            ep.setBottom((BWidget)this.buttonPane);
            this.infoPane = this.buildInfoPane();
            this.tp.addPane(new BLabel(BImage.make((BIcon)BIcon.make((String)"module://icons/x16/files/ntpl.png")), lex.getText("template.infoPane.title")), (BWidget)new BBorderPane(this.infoPane, 4.0, 4.0, 4.0, 4.0));
            this.bogPane = new BTemplateBogEditor(this);
            this.tp.addPane(new BLabel(BImage.make((BIcon)BIcon.std((String)"compass.png")), lex.getText("template.bogPane.title")), (BWidget)new BBorderPane((BWidget)this.bogPane, 0.0, 0.0, 0.0, 0.0));
            this.settingsPane = new BTemplateConfigEditor(this, this.templateComp, this.templateConfig);
            this.tp.addPane(new BLabel(BImage.make((BIcon)BIcon.std((String)"propertySheet.png")), lex.getText("template.settingsPane.title")), (BWidget)new BBorderPane((BWidget)this.settingsPane, 2.0, 2.0, 2.0, 2.0));
            if (this.isStationTemplate() || this.isApplicationTemplate()) {
                this.stationFiles = this.ntplFile.getStationFiles();
            } else {
                this.relationPane = new BTemplateRelationEditor(this, this.templateConfig);
                this.tp.addPane(new BLabel(BImage.make((BIcon)BIcon.std((String)"match.png")), lex.getText("template.relatePane.title")), (BWidget)new BBorderPane((BWidget)this.relationPane, 4.0, 4.0, 4.0, 4.0));
                this.ioPane = new BTemplateIOEditor(this, this.templateComp);
                this.tp.addPane(new BLabel(BImage.make((BIcon)BIcon.std((String)"match.png")), lex.getText("template.ioPane.title")), (BWidget)new BBorderPane((BWidget)this.ioPane, 4.0, 4.0, 4.0, 4.0));
            }
            this.graphicsPane = new BTemplatePxEditor(this, this.templateComp, this.ntplFile.getPxFiles(), this.ntplFile.getPxImageFiles());
            this.tp.addPane(new BLabel(BImage.make((BIcon)BIcon.std((String)"view.png")), lex.getText("template.graphicsPane.title")), (BWidget)new BBorderPane((BWidget)this.graphicsPane, 2.0, 2.0, 2.0, 2.0));
            this.templateMgr = new BTemplateManager();
            BLabel templateMgrTabLabel = new BLabel(BImage.make((BIcon)BIcon.std((String)"files/ntpl.png")), lex.getText("template.templateMgr.title"));
            this.tp.addPane(templateMgrTabLabel, (BWidget)new BBorderPane((BWidget)this.templateMgr, 2.0, 2.0, 2.0, 2.0));
            this.setContent((BWidget)ep);
            this.tp.selectPane(this.infoPane.getParentWidget());
            if (!this.newTemplate && !this.initModified) {
                TemplateViewState.restore(this);
            }
            this.bogPane.doLoadValue(this.templateComp);
            this.templateMgr.setReadonly(this.readOnly);
            this.templateMgr.doLoadValue((BObject)this.getTemplateRoot(), cx);
            if (!this.readOnly) {
                this.outOfDateSubtemplates = this.templateMgr.hasOutOfDateTemplate();
                if (this.outOfDateSubtemplates != null && this.outOfDateSubtemplates.size() > 0) {
                    BTemplateManager.UpgradeAll upgradeAllCmd = this.templateMgr.upgradeAllCmd;
                    BTemplateManager.Commit commitCmd = this.templateMgr.commitCmd;
                    if (upgradeAllCmd != null && commitCmd != null) {
                        upgradeAllCmd.doInvoke();
                        commitCmd.doInvoke(true);
                        this.templateMgr.doLoadValue((BObject)this.getTemplateRoot(), cx);
                        BLabel info = new BLabel(lex.getText("template.infoPane.outOfDateSubtemplate.message"));
                        this.addToInfoPane(infoIcon, info, BColor.red);
                        templateMgrTabLabel.setForeground(BBrush.makeSolid((BColor)BColor.red));
                        this.setInitModified(true);
                        this.templateMgr.setUpdatedStatus(this.outOfDateSubtemplates);
                    }
                }
            }
            try {
                List tagGroupChoices = TagDictionaryUtil.listPotentialTagGroupsFromTags((BComponent)this.templateComp);
                if (!tagGroupChoices.isEmpty()) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(lex.get("template.infoPane.tagsToTagGroup"));
                    BComponent currentComp = null;
                    for (TagDictionaryUtil.ComponentTagGroupChoices choice : tagGroupChoices) {
                        BComponent comp = choice.getComponent();
                        if (currentComp != null && comp.equals(currentComp)) continue;
                        sb.append("\r     ");
                        sb.append(comp.toPathString());
                        currentComp = comp;
                    }
                    sb.append("\r");
                    sb.append(lex.get("template.infoPane.tagsToTagGroup.save"));
                    BLabel info = new BLabel(sb.toString());
                    this.addToInfoPane(infoIcon, info, BColor.blue);
                    this.infoGridPane.add(null, (BValue)new BLabel());
                    BButton chooseButton = new BButton(lex.getText("template.infoPane.tagsToTagGroup.choose"));
                    this.infoGridPane.add(null, (BValue)chooseButton);
                    this.linkTo((BComponent)chooseButton, (Slot)BButton.actionPerformed, (Slot)save);
                }
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.WARNING, "ListTagGroupChoices threw an exception: " + e, e);
                }
                log.warning("ListTagGroupChoices threw an exception: " + e);
            }
            BWidget content = this.tp.getSelectedLabelPane().getContent();
            this.swapActiveView(this.getWbView(content));
            this.tabbedPaneSubscriber = new TabbedPaneSubscriber();
            this.tabbedPaneSubscriber.subscribe((BComponent)this.tp);
            this.propertyChangedSubscriber = new PropertyChangedSubscriber();
            this.propertyChangedSubscriber.subscribe(this.templateComp, Integer.MAX_VALUE);
            this.btnSave.setEnabled(!this.readOnly && this.initModified);
        }
        catch (FeatureNotLicensedException e) {
            String errorMessage = lex.getText("templateView.featureNotLicensed");
            BErrorPanel ep = new BErrorPanel(this.getWbShell(), errorMessage, ((BNtplFile)value).getAbsoluteOrd(), (Throwable)e);
            this.setContent((BWidget)ep);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.WARNING, errorMessage, e);
            } else {
                log.warning(errorMessage);
            }
        }
        catch (Exception e) {
            String exceptionMessage = e.getCause() != null ? e.getCause().getLocalizedMessage() : e.getLocalizedMessage();
            String errorDisplayMessage = lex.getText("templateView.loadException", new Object[]{exceptionMessage});
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.WARNING, errorDisplayMessage, e);
            } else {
                log.warning(errorDisplayMessage);
            }
            BErrorPanel ep = new BErrorPanel(this.getWbShell(), errorDisplayMessage, ((BNtplFile)value).getNavOrd(), (Throwable)e);
            this.setContent((BWidget)ep);
        }
    }

    public void setInitModified(boolean value) {
        this.initModified = value;
    }

    public void doTemplateModified() {
        if (this.readOnly) {
            return;
        }
        this.setModified();
        this.invalidName.setVisible(!this.checkValidName());
        this.btnSave.setEnabled(this.checkValidName());
        this.banner.setText(this.getBannerText());
        if (this.titleField.getText().length() == 0) {
            this.titleRequired.setVisible(true);
        } else {
            this.titleRequired.setVisible(false);
        }
        this.checkChangeState();
    }

    private void checkChangeState() {
        try {
            if (this.manifest.state.equals((Object)BTemplateState.ready) && this.stateField.saveValue().equals((Object)BTemplateState.ready)) {
                this.stateField.loadValue((BObject)BTemplateState.draft);
                this.versionField.setEditable(false);
                this.invalidVersion.setVisible(false);
            } else if (this.stateField.saveValue().equals((Object)BTemplateState.ready)) {
                this.versionField.setEditable(true);
                this.invalidVersion.setVisible(true);
            } else {
                this.versionField.setEditable(false);
                this.invalidVersion.setVisible(false);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error checking template change state:" + e.getLocalizedMessage(), e);
        }
    }

    private String getBannerText() {
        if (this.isApplicationTemplate()) {
            return "Application Template: " + this.templateName + "   Vendor: " + this.manifest.vendor + "   Version: " + this.manifest.version;
        }
        if (this.isStationTemplate()) {
            return "Station Template: " + this.templateName + "   Vendor: " + this.manifest.vendor + "   Version: " + this.manifest.version;
        }
        return "Template: " + this.templateName + "   Vendor: " + this.manifest.vendor + "   Version: " + this.manifest.version;
    }

    private boolean isStationTemplate() {
        return this.templateComp.getType().is(BStation.TYPE) && this.templateConfig.getPropertyInParent().isDynamic();
    }

    public boolean isApplicationTemplate() {
        return this.templateComp.getType().is(BStation.TYPE) && this.templateConfig.getPropertyInParent().isFrozen();
    }

    public BComponent getTemplateRoot() {
        return this.templateComp;
    }

    private void init() throws Exception {
        this.templateComp = this.ntplFile.getBaseComponent();
        this.manifest = this.ntplFile.getTemplateManifest();
        this.newTemplate = this.manifest.newCreation;
        BImageFile image = this.ntplFile.getImageFile();
        if (image != null && image instanceof BPngFile) {
            this.pngFile = (BPngFile)image;
            this.imageOrd = image.getAbsoluteOrd();
        }
        this.templateConfig = BTemplateConfig.getOrCreateConfigForRoot((BComponent)this.templateComp, (boolean)this.manifest.isApplication);
        if (this.templateConfig != null) {
            this.tcfgProp = this.templateConfig.getPropertyInParent();
        }
        if (this.templateConfig == null || this.tcfgProp == null) {
            throw new Exception(lex.getText("templateView.cannotFindTemplateConfig"));
        }
        if (this.newTemplate) {
            BPasswordBinding[] passwordBindings;
            String templateNameCandidate = SlotPath.unescape((String)this.templateComp.getPropertyInParent().getName());
            BDirectory templates = NtplUtil.getTemplateDirectory();
            this.manifest.title = this.templateName = this.getUniqueName(templateNameCandidate, templates);
            int count = this.templateComp.getLinks().length;
            this.checkIo = (count += this.templateComp.getKnobCount()) > 0;
            for (BPasswordBinding binding : passwordBindings = this.templateConfig.getPasswordBindings()) {
                if (!binding.getIsDynamic()) continue;
                String s = " * " + binding.getPswOrd().toString();
                this.dynamicPasswordDetected.add(s + '.' + binding.getPswSlot());
                this.templateConfig.remove((BComplex)binding);
            }
            this.manifest.state = BTemplateState.DEFAULT;
            this.manifest.uID = BUuid.make();
        } else {
            this.templateName = this.templateConfig.getTemplateName();
            if (this.manifest.title.isEmpty()) {
                this.manifest.title = this.templateName;
                this.titleAssigned = true;
            }
            if (this.templateConfig.getUID().equals((Object)BUuid.DEFAULT)) {
                this.templateConfig.setUID(BUuid.make());
                this.manifest.uID = this.templateConfig.getUID();
                this.setInitModified(true);
                this.uuidAssigned = true;
            }
        }
        if (!this.templateConfig.getUID().equals((Object)this.manifest.uID)) {
            this.manifest.uID = this.templateConfig.getUID();
        }
    }

    public void handleComponentEvent(BComponentEvent e) {
        super.handleComponentEvent(e);
        switch (e.getId()) {
            case 5: {
                return;
            }
        }
        this.bogPane.handleComponentEvent(e);
        this.doTemplateModified();
    }

    private BPane buildButtonPane() {
        BFlowPane pane = new BFlowPane();
        pane.setAlign(BHalign.center);
        pane.add(null, (BValue)this.makeSaveButton());
        pane.add(null, (BValue)this.makeDuplicateButton());
        if (this.newTemplate) {
            pane.add(null, (BValue)this.makeCancelButton());
        }
        return pane;
    }

    private BPane buildInfoPane() {
        BLabel info;
        this.infoGridPane = new BGridPane(2);
        this.nameGridPane = new BGridPane(2);
        this.titleGridPane = new BGridPane(2);
        this.versionGridPane = new BGridPane(3);
        this.infoGridPane.setColumnGap(10.0);
        this.infoGridPane.setRowGap(6.0);
        this.infoGridPane.setHalign(BHalign.left);
        this.invalidName = new BLabel(lex.getText("templateView.invalidTemplateName"));
        this.invalidName.setForeground(BBrush.makeSolid((BColor)BColor.red));
        this.invalidName.setVisible(false);
        this.invalidVersion = new BLabel(lex.getText("templateView.versionChangeRequired", new Object[]{this.manifest.version}));
        this.invalidVersion.setForeground(BBrush.makeSolid((BColor)BColor.red));
        this.invalidVersion.setVisible(false);
        this.titleRequired = new BLabel(lex.getText("templateView.titleRequired"));
        this.titleRequired.setForeground(BBrush.makeSolid((BColor)BColor.red));
        this.titleRequired.setVisible(false);
        this.nameField = new BTextField(this.templateName, 25, this.newTemplate);
        this.nameGridPane.add(null, (BValue)this.nameField);
        this.nameGridPane.add(null, (BValue)this.invalidName);
        LabelUtil.addLabelWidgetPair((BPane)this.infoGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"templateView.templateName"), (BWidget)this.nameGridPane);
        this.titleField = new BTextField(this.manifest.title, 25, !this.readOnly);
        this.titleGridPane.add(null, (BValue)this.titleField);
        this.titleGridPane.add(null, (BValue)this.titleRequired);
        LabelUtil.addLabelWidgetPair((BPane)this.infoGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"templateView.templateTitle"), (BWidget)this.titleGridPane);
        this.vendorField = new BTextField(this.manifest.vendor, 25, !this.readOnly);
        LabelUtil.addLabelWidgetPair((BPane)this.infoGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"templateView.vendor"), (BWidget)this.vendorField);
        this.versionField = new BTextField(this.manifest.version, 25, false);
        this.versionGridPane.add(null, (BValue)this.versionField);
        this.versionGridPane.add(null, (BValue)this.invalidVersion);
        LabelUtil.addLabelWidgetPair((BPane)this.infoGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"templateView.version"), (BWidget)this.versionGridPane);
        this.stateField = new BFrozenEnumFE();
        this.stateField.loadValue((BObject)this.manifest.state);
        this.stateField.setReadonly(this.readOnly);
        LabelUtil.addLabelWidgetPair((BPane)this.infoGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"templateView.state"), (BWidget)this.stateField);
        this.descriptionField = new BTextField(this.manifest.description, 25, !this.readOnly);
        LabelUtil.addLabelWidgetPair((BPane)this.infoGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"templateView.description"), (BWidget)this.descriptionField);
        this.infoField = new BTextEditorPane(this.manifest.info, 5, 60, !this.readOnly);
        LabelUtil.addLabelWidgetPair((BPane)this.infoGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"templateView.info"), (BWidget)this.infoField);
        TemplateManifest.Resource res = this.manifest.getResource("image.png", "png");
        String s = NO_ICON;
        if (res != null) {
            s = res.sourceOrd;
            this.iconSrcOrd = BOrd.make((String)s);
        } else {
            this.iconSrcOrd = null;
        }
        BTextField iconField = new BTextField(s, 40, false);
        if (this.getShell() != null) {
            BButton iconSel = new BButton((Command)new BrowseIcons((BWidget)this.getShell(), iconField));
            iconSel.setButtonStyle(BButtonStyle.toolBar);
            iconSel.setVisible(!this.readOnly);
            this.iconLabel = new BLabel();
            this.iconPan = new BEdgePane();
            this.iconPan.setCenter((BWidget)iconField);
            this.iconPan.setRight((BWidget)iconSel);
            if (this.pngFile != null) {
                this.setIcon();
            }
            LabelUtil.addLabelWidgetPair((BPane)this.infoGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"templateView.icon"), (BWidget)this.iconPan);
        }
        this.invalidName.setVisible(!this.checkValidName());
        if (this.readOnly) {
            info = new BLabel(lex.getText("template.infoPane.readonly.message"));
            this.addToInfoPane(infoIcon, info, BColor.red);
            if (this.uuidAssigned) {
                BLabel info1 = new BLabel(lex.getText("template.infoPane.uuidAssigned.readonly.message"));
                this.addToInfoPane(infoIcon, info1, BColor.red);
                this.uuidAssigned = false;
            }
        } else {
            Object info2;
            if (this.newTemplate && this.templateComp instanceof BDevice) {
                info = new BLabel(lex.getText("template.infoPane.newDeviceTemplate.message"));
                this.addToInfoPane(infoIcon, info, BColor.red);
            }
            try {
                this.templateConfig.checkForValidTemplate();
            }
            catch (Exception e) {
                info2 = new BLabel(e.getLocalizedMessage());
                this.addToInfoPane(errorIcon, (BLabel)info2, BColor.red);
            }
            if (this.uuidAssigned) {
                info = new BLabel(lex.getText("template.infoPane.uuidAssigned.message"));
                this.addToInfoPane(infoIcon, info, BColor.red);
                this.uuidAssigned = false;
            }
            if (this.titleAssigned) {
                info = new BLabel(lex.getText("template.infoPane.titleAssigned.message"));
                this.addToInfoPane(infoIcon, info, BColor.red);
                this.titleAssigned = false;
            }
            if (this.checkIo) {
                info = new BLabel(lex.getText("template.infoPane.checkIO.message"));
                this.addToInfoPane(infoIcon, info, BColor.red);
                this.checkIo = false;
            }
            if (this.outOfDateSubtemplates != null && this.outOfDateSubtemplates.size() > 0) {
                info = new BLabel(lex.getText("template.infoPane.outOfDateSubtemplate.message"));
                this.addToInfoPane(infoIcon, info, BColor.red);
            }
            if (this.templateConfig.getPasswordBindings().length > 0) {
                info = new BLabel(lex.getText("template.infoPane.checkConfig.message"));
                this.addToInfoPane(infoIcon, info, BColor.black);
            }
            if (!this.dynamicPasswordDetected.isEmpty()) {
                StringBuffer list = new StringBuffer();
                for (String s1 : this.dynamicPasswordDetected) {
                    list.append("\n").append(s1);
                }
                info2 = new BLabel(lex.getText("template.infoPane.dynamicPsw.message") + list.toString());
                this.addToInfoPane(infoIcon, (BLabel)info2, BColor.red);
                this.dynamicPasswordDetected.clear();
            }
        }
        BEdgePane ip = new BEdgePane();
        ip.setTop((BWidget)new BBorderPane((BWidget)this.infoGridPane, 10.0, 10.0, 10.0, 10.0));
        this.linkTo((BComponent)this.nameField, (Slot)BTextField.textModified, (Slot)templateModified);
        this.linkTo((BComponent)this.vendorField, (Slot)BTextField.textModified, (Slot)templateModified);
        this.linkTo((BComponent)this.titleField, (Slot)BTextField.textModified, (Slot)templateModified);
        this.linkTo((BComponent)this.versionField, (Slot)BTextField.textModified, (Slot)templateModified);
        this.linkTo((BComponent)this.descriptionField, (Slot)BTextField.textModified, (Slot)templateModified);
        this.linkTo((BComponent)this.infoField.getEditor(), (Slot)BTextEditor.textModified, (Slot)templateModified);
        this.linkTo((BComponent)this.stateField, (Slot)BFrozenEnumFE.pluginModified, (Slot)templateModified);
        return ip;
    }

    private boolean checkValidName() {
        return BTemplateView.isValidFileName(this.nameField.getText());
    }

    private void setIcon() {
        if (this.imageOrd != null) {
            BImage iconImage = BImage.make((BOrd)this.imageOrd);
            this.iconLabel.setImage(iconImage);
            this.banner.setImage(iconImage);
            this.iconPan.setLeft((BWidget)this.iconLabel);
        } else {
            this.iconLabel.setImage(BImage.NULL);
            this.banner.setImage(BImage.NULL);
            this.iconPan.setLeft((BWidget)new BNullWidget());
        }
    }

    public void addToInfoPane(BWidget widget) {
        this.infoGridPane.add(null, (BValue)new BLabel(errorIcon));
        this.infoGridPane.add(null, (BValue)widget);
    }

    public void addToInfoPane(BImage icon, BLabel label, BColor color) {
        this.infoGridPane.add(null, (BValue)new BLabel(icon));
        label.setWordWrapEnabled(true);
        label.setHalign(BHalign.left);
        label.setForeground(BBrush.makeSolid((BColor)color));
        this.infoGridPane.add(null, (BValue)label);
    }

    public boolean consoleHyperlink(File file, int line1, int col1, int line2, int col2) {
        return this.bogPane.consoleHyperlink(file, line1, col1, line2, col2);
    }

    public void doSave() {
        int proceed;
        FilePath outFilePath;
        File targetFile;
        String tname = this.nameField.getText();
        if (!this.isValidFilename(tname)) {
            log.fine("doSave: invalid template name " + tname);
            return;
        }
        if (this.newTemplate && (targetFile = BFileSystem.INSTANCE.pathToLocalFile(outFilePath = NtplUtil.buildTemplateFilePath((String)tname, (this.manifest.isStation || this.manifest.isApplication ? 1 : 0) != 0, (boolean)this.manifest.isApplication))).exists() && (proceed = BDialog.confirm((BWidget)this.getWbShell(), (String)lex.getText("commands.duplicate.dup.title"), (Object)(lex.getText("commands.duplicate.dup.message") + "\n\n" + outFilePath.getBody()))) != 4) {
            return;
        }
        log.fine("doSave: template name=" + tname);
        if (this.titleField.getText().length() > 0 && this.verifyVersionChange()) {
            if (this.prepForSave()) {
                this.implSave(tname, this.titleField.getText(), this.versionField.getText(), this.templateComp, this.ntplFile, this.manifest.isApplication, this.newTemplate);
                if (this.newTemplate) {
                    String msg = this.getSaveConfirmationMessage(this.templateComp.getType().is(BStation.TYPE), this.templateConfig.getPropertyInParent().isFrozen(), this.templateConfig.getTemplateName());
                    BDialog.message((BWidget)this.getWbShell(), (String)lex.getText("templateCreated.title"), (Object)msg);
                }
                if (!this.readOnly && this.ntplFile.isOpen()) {
                    this.ntplFile.close();
                }
                this.clearModified();
                this.refreshTemplateSidebar();
                if (this.newTemplate) {
                    this.getWbShell().getBackCommand().invoke();
                } else {
                    this.getWbShell().getRefreshCommand().invoke();
                }
            }
            this.invalidVersion.setVisible(false);
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) throws CannotSaveException, Exception {
        this.doSave();
        return value;
    }

    public void doDuplicate() {
        BDuplicateTemplateInfo dupInfo = this.promptForDuplicateInfo(new BDuplicateTemplateInfo(this.nameField.getText() + "Dup", this.titleField.getText() + "Dup", this.versionField.getText()));
        if (dupInfo != null) {
            boolean wasModified = this.isModified();
            if (this.prepForSave()) {
                boolean isStation = this.templateComp.getType().is(BStation.TYPE);
                boolean isApplication = isStation && this.templateConfig.getPropertyInParent().isFrozen();
                String templateName = dupInfo.getFileName();
                CopyHints hints = new CopyHints();
                hints.defaultOnClone = false;
                hints.swizzleHandles = false;
                hints.keepHandles = true;
                BComponent spaceRoot = this.templateComp.getParent().newCopy(hints).asComponent();
                BComponentSpace dupSpace = new BComponentSpace("dup", this.templateComp.getSpace().getLexiconText(), BOrd.make((String)"dup:"));
                dupSpace.setRootComponent(spaceRoot);
                BComponent saveComponent = spaceRoot.getChildComponents()[0];
                this.implSave(templateName, dupInfo.getTitle(), dupInfo.getVersion(), saveComponent, this.ntplFile, isApplication, true);
                this.refreshTemplateSidebar();
                BDialog.message((BWidget)this.getWbShell(), (String)lex.getText("templateCreated.title"), (Object)this.getSaveConfirmationMessage(isStation, isApplication, templateName));
                this.clearModified();
                this.templateConfig.clearCacheValues();
                if (this.newTemplate) {
                    this.getWbShell().getBackCommand().invoke();
                } else {
                    this.getWbShell().getRefreshCommand().invoke();
                    if (!wasModified) {
                        this.clearModified();
                        this.btnSave.setEnabled(false);
                    }
                }
            } else if (!wasModified) {
                this.clearModified();
                this.btnSave.setEnabled(false);
            }
        }
    }

    private String getSaveConfirmationMessage(boolean isStation, boolean isApplication, String templateName) {
        String msg = null;
        msg = isStation ? (isApplication ? MessageFormat.format(lex.getText("applicationTemplateCreated.message"), templateName) : MessageFormat.format(lex.getText("stationTemplateCreated.message"), templateName)) : MessageFormat.format(lex.getText("templateCreated.message"), templateName);
        return msg;
    }

    private BDuplicateTemplateInfo promptForDuplicateInfo(BDuplicateTemplateInfo editComp) {
        BWbFieldEditor editor = BWbFieldEditor.makeFor((BObject)editComp);
        editor.loadValue((BObject)editComp);
        BGridPane gridPane = new BGridPane(1);
        gridPane.add(null, (BValue)editor);
        BOptionDialog dlg = new BOptionDialog((BWidget)this.getWbShell(), lex.getText("commands.duplicate.prompt.label"), (BWidget)gridPane, 3, null, null);
        dlg.computePreferredSize();
        dlg.setBoundsCenteredOnOwner();
        boolean validEntry = false;
        while (!validEntry) {
            block7: {
                dlg.open();
                if (dlg.getResult() != 1) {
                    return null;
                }
                try {
                    editComp = (BDuplicateTemplateInfo)editor.saveValue();
                    if (!this.isValidFilename(editComp.getFileName())) {
                        editor.loadValue((BObject)editComp);
                        continue;
                    }
                    if (this.isDuplicateFilename(editComp.getFileName())) {
                        BDialog.error((BWidget)this.getWbShell(), (String)lex.getText("commands.duplicate.dup.title"), (Object)(lex.getText("commands.duplicate.dup.title") + " " + lex.getText("commands.duplicate.dup.newFilename")));
                        editor.loadValue((BObject)editComp);
                        continue;
                    }
                    if (!this.isValidVersion(editComp.getVersion())) {
                        BDialog.error((BWidget)this.getWbShell(), (String)lex.getText("commands.duplicate.version.invalid.title"), (Object)lex.getText("commands.duplicate.version.invalid.message", new Object[]{editComp.getVersion()}));
                        editor.loadValue((BObject)editComp);
                    }
                    break block7;
                }
                catch (Exception e) {
                    BDialog.error((BWidget)this.getWbShell(), (Object)("Exception: " + e.getLocalizedMessage()));
                }
                continue;
            }
            validEntry = true;
        }
        return editComp;
    }

    public void doCancel() {
        if (this.newTemplate) {
            BLabel ruSure = new BLabel(lex.getText("commands.cancel.confirm"));
            double fontSize = BFont.DEFAULT.getSize() + 2.0;
            ruSure.setFont(BFont.make((BFont)BFont.DEFAULT, (double)fontSize));
            int proceed = BDialog.confirm((BWidget)this.getWbShell(), (String)lex.getText("commands.cancel.label"), (Object)ruSure);
            if (proceed != 4) {
                return;
            }
            this.clearModified();
            this.getWbShell().getBackCommand().invoke();
        }
    }

    private boolean prepForSave() {
        int proceed;
        BTagDictionaryService tdService = (BTagDictionaryService)this.templateComp.getTagDictionaryService();
        List entities = TagDictionaryUtil.getComponents((BComponent)this.templateComp);
        List tagGroups = TagDictionaryUtil.getTagGroups((BTagDictionaryService)tdService);
        ArrayList<TagDictionaryUtil.ComponentTagGroupChoices> ctgChoices = new ArrayList<TagDictionaryUtil.ComponentTagGroupChoices>();
        TagDictionaryUtil.listPotentialTagGroupsFromTags((List)entities, (List)tagGroups, ctgChoices);
        int results = TmplUtil.selectTagGroupChoices((BWidget)this, ctgChoices, lex);
        if (results == 1) {
            ArrayList<String> keepTags = new ArrayList<String>();
            ArrayList<BTagGroupInfo> addTagGroup = new ArrayList<BTagGroupInfo>();
            ArrayList<BTagGroupInfo> dontAddTagGroup = new ArrayList<BTagGroupInfo>();
            for (int i = 0; i < ctgChoices.size(); ++i) {
                String removeName;
                String qName;
                boolean isComplete;
                TagDictionaryUtil.ComponentTagGroupChoices ctgChoice = ctgChoices.get(i);
                TagDictionaryUtil.ComponentTagGroupChoices nextCtgChoice = null;
                if (i + 1 < ctgChoices.size()) {
                    nextCtgChoice = ctgChoices.get(i + 1);
                }
                BComponent thisComp = ctgChoice.getComponent();
                boolean bl = isComplete = i + 1 == ctgChoices.size() || nextCtgChoice != null && !thisComp.equals((Object)nextCtgChoice.getComponent());
                if (ctgChoice.isSelected()) {
                    addTagGroup.add(ctgChoice.getTagGroupInfo());
                } else {
                    dontAddTagGroup.add(ctgChoice.getTagGroupInfo());
                    if (!ctgChoice.isRemoveTags()) {
                        for (TagInfo tagInfo : ctgChoice.getTagGroupInfo().getTagList()) {
                            keepTags.add(tagInfo.getTagId().getQName());
                        }
                    }
                }
                if (!isComplete) continue;
                BComponent currentComp = thisComp;
                for (BTagGroupInfo tagGroupInfo : addTagGroup) {
                    Optional ord;
                    if (tagGroupInfo instanceof Entity && (ord = tagGroupInfo.getOrdToEntity()).isPresent()) {
                        BOrd slotPathOrd = ((BOrd)ord.get()).get((BObject)thisComp).asComponent().getSlotPathOrd();
                        String addName = SlotPath.escape((String)tagGroupInfo.getGroupId().getQName());
                        if (thisComp.get(addName) == null) {
                            Property tgProp = thisComp.add(addName, (BValue)slotPathOrd, BEditTagDialog.TAG_GROUP_FLAGS);
                            thisComp.setFacets((Slot)tgProp, BEditTagDialog.TAG_GROUP_FACETS);
                        }
                    }
                    for (TagInfo tagInfo : tagGroupInfo.getTagList()) {
                        BValue tagValue;
                        qName = tagInfo.getTagId().getQName();
                        if (keepTags.contains(qName) || (tagValue = currentComp.get(removeName = SlotPath.escape((String)qName))) == null) continue;
                        if (tagValue.equivalent((Object)tagInfo.getDefaultValue())) {
                            currentComp.remove(removeName);
                            continue;
                        }
                        keepTags.add(removeName);
                    }
                }
                for (BTagGroupInfo tagGroupInfo : dontAddTagGroup) {
                    for (TagInfo tagInfo : tagGroupInfo.getTagList()) {
                        qName = tagInfo.getTagId().getQName();
                        if (keepTags.contains(qName) || currentComp.get(removeName = SlotPath.escape((String)qName)) == null) continue;
                        currentComp.remove(removeName);
                    }
                }
                keepTags = new ArrayList();
                addTagGroup = new ArrayList();
                dontAddTagGroup = new ArrayList();
            }
        }
        boolean needsRelationHints = this.relationPane != null && !this.relationPane.hasValidHints();
        boolean needBindHints = this.ioPane != null && !this.ioPane.hasValidHints();
        this.outOfDateSubtemplates = this.templateMgr.hasOutOfDateTemplate();
        if ((needsRelationHints || needBindHints) && (proceed = BDialog.confirm((BWidget)this.getWbShell(), (String)lex.getText("commands.save.needsHints.title"), (Object)lex.getText("commands.save.needsHints.message"))) != 4) {
            return false;
        }
        this.settingsPane.save();
        this.bogPane.save();
        if (this.relationPane != null) {
            this.relationPane.save();
        }
        if (this.ioPane != null) {
            this.ioPane.save();
        }
        this.graphicsPane.save();
        this.templateConfig.updatePxEditBindings(this.graphicsPane.pxEditTargets);
        boolean isStationTemplate = this.templateComp.getParent().asComponent().getChildComponents()[0].getType().is(BStation.TYPE);
        if (!isStationTemplate) {
            TmplUtil.convertTagGroupRelationsToTags(this.templateComp);
        }
        TmplUtil.markComponentTags(this.templateComp);
        TagDictionaryService tagDictionaryService = this.templateComp.getTagDictionaryService();
        if (tagDictionaryService instanceof BTagDictionaryService) {
            Property tdsProp = ((BTagDictionaryService)tagDictionaryService).getPropertyInParent();
            BComponent tmplRoot = ((BTagDictionaryService)tagDictionaryService).getParent().asComponent();
            tmplRoot.setFlags((Slot)tdsProp, tmplRoot.getFlags((Slot)tdsProp) | 2);
        }
        return true;
    }

    private void implSave(String saveName, String saveTitle, String saveVersion, BComponent saveRoot, BWbDeployableNtplFile sourceNtpl, boolean isApplication, boolean creatingNew) {
        BTemplateConfig saveConfig = BTemplateConfig.getOrCreateConfigForRoot((BComponent)saveRoot, (boolean)isApplication);
        TemplateManifest sourceManifest = sourceNtpl.getTemplateManifest();
        BFacets f = saveRoot.getSlotFacets((Slot)this.tcfgProp);
        saveRoot.setFacets((Slot)this.tcfgProp, BFacets.makeRemove((BFacets)f, (String)"ntplCreation"));
        saveConfig.setTemplateName(saveName);
        BVersion version = new BVersion(this.vendorField.getText(), saveVersion);
        version.setBajaVersionString(Sys.getBajaVersion().toString());
        saveConfig.setVersion(version);
        saveConfig.setVersionDate(BAbsTime.now());
        TemplateManifest locManifest = saveConfig.getManifest();
        locManifest.vendor = this.vendorField.getText();
        locManifest.title = saveTitle;
        locManifest.version = saveVersion;
        locManifest.description = this.descriptionField.getText();
        locManifest.info = this.infoField.getText();
        if (creatingNew) {
            locManifest.uID = BUuid.make();
            saveConfig.setUID(locManifest.uID);
        } else {
            locManifest.uID = sourceManifest.uID;
        }
        locManifest.buildVersion = Sys.getModuleForClass(BTemplateView.class).getVendorVersion(RuntimeProfile.rt).toString();
        CompUtil.setOrAdd((BComponent)saveRoot, (String)ROOT_TAG_NAME, (BValue)BMarker.MARKER, (int)16389, null, null);
        CompUtil.setOrAdd((BComponent)saveRoot, (String)NTPL_FILE_TAG_NAME, (BValue)BString.make((String)NtplUtil.buildTemplateFileName((String)saveName, (boolean)isApplication)), (int)16389, null, null);
        CompUtil.setOrAdd((BComponent)saveRoot, (String)VENDOR_TAG_NAME, (BValue)BString.make((String)locManifest.vendor), (int)16389, null, null);
        CompUtil.setOrAdd((BComponent)saveRoot, (String)TITLE_TAG_NAME, (BValue)BString.make((String)locManifest.title), (int)16389, null, null);
        CompUtil.setOrAdd((BComponent)saveRoot, (String)VERSION_TAG_NAME, (BValue)BString.make((String)locManifest.version), (int)16389, null, null);
        CompUtil.setOrAdd((BComponent)saveRoot, (String)INFO_TAG_NAME, (BValue)BString.make((String)locManifest.description), (int)16389, null, null);
        CompUtil.setOrAdd((BComponent)saveRoot, (String)UID_TAG_NAME, (BValue)BString.make((String)locManifest.uID.toString()), (int)16389, null, null);
        if (this.iconSrcOrd != null && !this.iconSrcOrd.equals((Object)NO_ICON)) {
            CompUtil.setOrAdd((BComponent)saveRoot, (String)ICON_TAG_NAME, (BValue)this.iconSrcOrd, (int)16389, null, null);
        } else if (saveRoot.get(ICON_TAG_NAME) != null) {
            saveRoot.remove(ICON_TAG_NAME);
        }
        long signature = UpgradeUtil.getTemplateSignature((BComponent)saveRoot);
        locManifest.bogSignature = Long.toHexString(signature);
        try {
            locManifest.state = BTemplateState.make((String)this.stateField.saveValue().toString().toLowerCase());
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error setting template edit state:" + e.getLocalizedMessage(), e);
        }
        locManifest.resources = sourceManifest.resources;
        Hashtable hashtable = new Hashtable();
        for (BComponent root : this.findAllTemplateRoots(saveRoot, isApplication)) {
            DependencyUtil.getBogComponentDependencies((BComponent)root, hashtable, (boolean)BTemplateOptions.get().getUseMinorVersionOnDeployment());
        }
        DependencyUtil.getTemplatePxDependencies((PxFileRef[])this.graphicsPane.getPxRefs(), hashtable, (boolean)BTemplateOptions.get().getUseMinorVersionOnDeployment());
        BDependency[] dependencies = new BDependency[hashtable.size()];
        locManifest.addDependencies(hashtable.values().toArray(dependencies));
        for (TmplUtil.SubtemplateInfo stInfo : TmplUtil.listSubtemplates(saveRoot)) {
            locManifest.addSubtemplate(stInfo.getDeployName(), stInfo.getVendor(), stInfo.getVersion(), stInfo.getDeployOrd().toString(), stInfo.getNtplFileOrd().toString());
        }
        locManifest.optional = sourceManifest.optional.copy();
        NtplUtil.makeNtpl((String)saveConfig.getTemplateName(), (BComponent)saveRoot.getParent().asComponent(), (BTemplateConfig)saveConfig, (PxFileRef[])this.graphicsPane.getPxRefs(), (BImageFile)this.pngFile, (BNtplFile)sourceNtpl, (boolean)creatingNew);
    }

    private void refreshTemplateSidebar() {
        BWbShell wbShell = this.getWbShell();
        if (wbShell instanceof BNiagaraWbShell) {
            BIWbSideBar[] bars;
            for (BIWbSideBar bar : bars = ((BNiagaraWbShell)wbShell).pane.getSideBar().list()) {
                if (!(bar instanceof BTemplateSideBar)) continue;
                ((BTemplateSideBar)bar).updateTree();
            }
        }
    }

    private BComponent[] findAllTemplateRoots(BComponent templateComp, boolean isApplicationTemplate) {
        if (isApplicationTemplate) {
            return ApplicationTemplateUtil.findApplicationRoots((BStation)((BStation)templateComp));
        }
        return new BComponent[]{templateComp};
    }

    private boolean isValidVersion(String version) {
        String regex = "^\\d+(\\.?\\d+)*$";
        return version.matches(regex);
    }

    private boolean verifyVersionChange() {
        Version versionOld = new Version(this.manifest.version);
        Version versionNew = null;
        if (!this.isValidVersion(this.versionField.getText())) {
            BDialog.error((BWidget)this.getWbShell(), (String)lex.getText("templateView.invalidVersionTitle"), (Object)lex.getText("templateView.invalidVersion", new Object[]{this.versionField.getText()}));
            return false;
        }
        versionNew = new Version(this.versionField.getText());
        int result = versionNew.compareTo(versionOld);
        if (result == 0) {
            try {
                if (this.stateField.saveValue().equals((Object)BTemplateState.draft)) {
                    return true;
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error detecting template edit state:" + e.getLocalizedMessage(), e);
            }
            this.invalidVersion.setText(lex.getText("templateView.versionChangeRequired", new Object[]{this.manifest.version}));
            return false;
        }
        if (result < 0) {
            this.invalidVersion.setText(lex.getText("templateView.versionChangeRequired", new Object[]{this.manifest.version}));
            return false;
        }
        this.invalidVersion.setVisible(false);
        return true;
    }

    private boolean isDuplicateFilename(String name) {
        String proposedName = NtplUtil.buildTemplateFileName((String)name, (boolean)this.isApplicationTemplate());
        BDirectory directory = this.isStationTemplate() ? NewStationUtil.getUserNewStationDirectory() : (this.isApplicationTemplate() ? NtplUtil.getApplicationDirectory() : NtplUtil.getTemplateDirectory());
        return directory != null && directory.getNavChild(proposedName) != null;
    }

    private boolean isValidFilename(String name) {
        if (null == name || name.isEmpty()) {
            BDialog.error((BWidget)this.getWbShell(), (String)lex.getText("templateName.invalidNameTitle"), (Object)lex.getText("templateName.zeroLengthMessage"));
            return false;
        }
        if (!BTemplateView.isValidFileName(name)) {
            BDialog.error((BWidget)this.getWbShell(), (String)lex.getText("templateName.invalidNameTitle"), (Object)lex.getText("templateName.invalidCharacterMessage.filename", new Object[]{name}));
            return false;
        }
        return true;
    }

    static boolean isValidFileName(String name) {
        try {
            int len = name.length();
            if (len == 0) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                char c = name.charAt(i);
                if (!(i == 0 ? !(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') : !(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '-'))) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected BButton makeCancelButton() {
        this.btnCancel = new BButton(new Command((BWidget)this, lex, "commands.cancel"));
        this.linkTo((BComponent)this.btnCancel, (Slot)BButton.actionPerformed, (Slot)cancel);
        return this.btnCancel;
    }

    protected BButton makeSaveButton() {
        this.btnSave = new BButton(new Command((BWidget)this, lex, "commands.save"));
        this.linkTo((BComponent)this.btnSave, (Slot)BButton.actionPerformed, (Slot)save);
        this.btnSave.setEnabled(false);
        return this.btnSave;
    }

    protected BButton makeDuplicateButton() {
        this.btnDuplicate = new BButton(new Command((BWidget)this, lex, "commands.duplicate"));
        this.linkTo((BComponent)this.btnDuplicate, (Slot)BButton.actionPerformed, (Slot)duplicate);
        this.btnDuplicate.setEnabled(true);
        return this.btnDuplicate;
    }

    private String getUniqueName(String templateName, BDirectory dir) {
        return ObjectUtil.generateUniqueName((String)templateName, (ObjectUtil.NameContainer)new NameContainerImpl(dir));
    }

    public TemplateManifest getManifest() {
        return this.manifest;
    }

    void swapActiveView(BWbView wbView) {
        if (this.getShell() == null) {
            return;
        }
        BTransferWidget trans = wbView != null ? wbView.getTransferWidget() : null;
        this.setTransferWidget(trans);
        BIMenuBar w = (BIMenuBar)this.getShell().getMenuBar();
        for (int i = 0; i < menuList.size(); ++i) {
            w.removeMenu(menuList.get(i));
        }
        menuList.clear();
        if (wbView == null) {
            return;
        }
        BIMenu[] menus = wbView.getViewMenus();
        if (menus == null) {
            return;
        }
        for (int i = 0; i < menus.length; ++i) {
            w.addMenu("template" + i, menus[i]);
            menuList.add(menus[i]);
        }
    }

    private BWbView getWbView(BWidget content) {
        if (content instanceof BWbView) {
            return (BWbView)content;
        }
        BWbView[] a = (BWbView[])CompUtil.getDescendants((BComponent)content, BWbView.class);
        if (a.length > 0) {
            return a[0];
        }
        return null;
    }

    private class TabbedPaneSubscriber
    extends WidgetSubscriber {
        private TabbedPaneSubscriber() {
        }

        public void modified(BWidgetEvent e) {
            if (e.getWidget().equals((Object)BTemplateView.this.tp)) {
                BWidget content = BTemplateView.this.tp.getSelectedLabelPane().getContent();
                BTemplateView.this.swapActiveView(BTemplateView.this.getWbView(content));
            }
        }
    }

    private class PropertyChangedSubscriber
    extends Subscriber {
        private PropertyChangedSubscriber() {
        }

        public void event(BComponentEvent event) {
            BTemplateView.this.doTemplateModified();
        }
    }

    private class NameContainerImpl
    implements ObjectUtil.NameContainer {
        BDirectory dir;

        NameContainerImpl(BDirectory dir) {
            this.dir = dir;
        }

        public boolean contains(String name) {
            for (BIFile f : this.dir.listFiles()) {
                String fnWithExt;
                int dot = (fnWithExt = f.getFileName()).lastIndexOf(46);
                String fn = fnWithExt.substring(0, dot > 0 ? dot : fnWithExt.length());
                if (!fn.equals(name)) continue;
                return true;
            }
            return false;
        }
    }

    public class BrowseIcons
    extends Command {
        BTextField txt;

        BrowseIcons(BWidget owner, BTextField t) {
            super(owner, "");
            this.txt = t;
        }

        public String getText() {
            return null;
        }

        public BImage getIcon() {
            return openIcon;
        }

        public CommandArtifact doInvoke() {
            BOrd ord = null;
            BTemplateView.this.imageOrd = null;
            BTemplateView.this.pngFile = null;
            try {
                ord = this.getOrd();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (ord != null) {
                this.txt.setText(ord.encodeToString());
                this.txt.repaint();
                BObject o = ord.resolve().get();
                if (o instanceof BPngFile) {
                    BTemplateView.this.pngFile = (BPngFile)o;
                    BTemplateView.this.imageOrd = ord;
                    TemplateManifest.Resource res = BTemplateView.this.manifest.getResource("image.png", "png");
                    BTemplateView.this.iconSrcOrd = BTemplateView.this.imageOrd.relativizeToSession();
                    String iconOrd = BTemplateView.this.iconSrcOrd.toString(null);
                    if (res == null) {
                        BTemplateView.this.manifest.addResource("image.png", "png", iconOrd);
                    } else {
                        res.sourceOrd = iconOrd;
                    }
                }
            } else {
                BTemplateView.this.manifest.removeResource("image.png");
                this.txt.setText("");
            }
            BTemplateView.this.setIcon();
            BTemplateView.this.templateModified();
            return null;
        }

        BOrd getOrd() {
            BFileChooser c = BFileChooser.makeOpen((BWidget)this.getShell());
            String t = this.txt.getText();
            if (t.indexOf(".") > 0) {
                t = t.substring(0, t.lastIndexOf("/"));
                c.setCurrentDirectory(BOrd.make((String)t));
            } else {
                c.setCurrentDirectory(BOrd.make((String)"module://icons/x16/file.png"));
            }
            return c.show();
        }
    }
}

