/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui;

import com.tridium.template.ui.file.TmplUtil;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(ordScheme="template")
@NiagaraSingleton
public class BTemplateOrdScheme
extends BOrdScheme {
    public static final BTemplateOrdScheme INSTANCE = new BTemplateOrdScheme();
    public static final Type TYPE = Sys.loadType(BTemplateOrdScheme.class);

    public Type getType() {
        return TYPE;
    }

    private BTemplateOrdScheme() {
        super("template");
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        String queryBody = query.getBody();
        BComponent c = base.getComponent();
        BComponentSpace sp = c.getComponentSpace();
        if (sp != null) {
            sp.update(c, Integer.MAX_VALUE);
        }
        OrdTarget result = null;
        if ("create".equals(queryBody)) {
            try {
                result = new OrdTarget(base, (BObject)TmplUtil.createInMemoryNtpl(c));
            }
            catch (Exception e) {
                throw new UnresolvedException("Unable to create in memory template", (Throwable)e);
            }
        }
        if ("createApp".equals(queryBody)) {
            try {
                result = new OrdTarget(base, (BObject)TmplUtil.createInMemoryApp(c));
            }
            catch (Exception e) {
                throw new UnresolvedException("Unable to create in memory template", (Throwable)e);
            }
        }
        return result;
    }
}

