/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui;

import com.tridium.sys.tag.ComponentTags;
import com.tridium.tagdictionary.BNiagaraTagDictionary;
import com.tridium.template.BConfigBinding;
import com.tridium.template.BTemplateConfig;
import com.tridium.template.TemplateConst;
import com.tridium.template.ui.BTemplateConfigEditor;
import com.tridium.template.ui.BTemplateView;
import com.tridium.template.ui.tag.TagSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Optional;
import javax.baja.agent.BPxView;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.status.BStatusValue;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BMarker;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Tag;
import javax.baja.tag.Taggable;
import javax.baja.tag.Tags;
import javax.baja.tag.util.BasicEntity;
import javax.baja.tagdictionary.BTagDictionary;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.WidgetSubscriber;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableHeaderRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeSelection;
import javax.baja.util.BCompositeAction;
import javax.baja.util.BCompositeTopic;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public class BTemplateIOEditor
extends BEdgePane
implements TemplateConst {
    public static final Type TYPE = Sys.loadType(BTemplateIOEditor.class);
    private static Lexicon lex = Lexicon.make((String)"template");
    private static BModule module = Sys.getModuleForClass(BTemplateIOEditor.class);
    private static BImage inIcon = BImage.make((String)"module://icons/x16/arrowLeft.png");
    private static BImage outIcon = BImage.make((String)"module://icons/x16/arrowRight.png");
    private static BImage filterIcon = BImage.make((String)"module://icons/x16/filter.png");
    private static BBrush colorProperty = BColor.make((int)13816554).toBrush();
    private static BBrush colorAction = BColor.make((int)0xB8F8B8).toBrush();
    private static BBrush colorTopic = BColor.make((int)14934976).toBrush();
    private static String TAG_FILTER_ALL = lex.getText("controlAppIOEditor.tagFilter.showAll");
    private static String TAG_FILTER_MARKERS = lex.getText("controlAppIOEditor.tagFilter.markersOnly");
    private static String TAG_FILTER_DICTIONARY = lex.getText("controlAppIOEditor.tagFilter.dictionaryOnly");
    private static Tag NIAGARA_BIND_HINTS_TAG = new Tag(BNiagaraTagDictionary.BIND_HINTS, (BIDataValue)BString.make((String)""));
    private static Tag NIAGARA_TARGET_SLOT_HINT_TAG = new Tag(BNiagaraTagDictionary.TARGET_SLOT_HINT, (BIDataValue)BString.make((String)""));
    private static Tag NIAGARA_TEMPLATE_INPUT = new Tag(BNiagaraTagDictionary.INPUT, (BIDataValue)BMarker.MARKER);
    private static Tag NIAGARA_TEMPLATE_OUTPUT = new Tag(BNiagaraTagDictionary.OUTPUT, (BIDataValue)BMarker.MARKER);
    private static Tag NIAGARA_USER_TIP = new Tag(BNiagaraTagDictionary.USER_TIP, (BIDataValue)BString.make((String)""));
    private static int IN_EXIST = 1;
    private static int OUT_EXIST = 2;
    private static int BOTH_EXIST = 3;
    private static int NONE_EXIST = 0;
    BTemplateView view;
    BSplitPane sp;
    private BComponent root;
    private BTree tree;
    private BTable table;
    private BTable sourceTagTable;
    private BTable ioTagTable;
    private ArrayList<CompositeSlot> removed = new ArrayList();
    private IoWidgetSubscriber tableSubscriber;
    private BListDropDown tagFilterSelect;
    private BListDropDown dictionarySelect;
    private BEdgePane sourceTagPane;
    private BEdgePane ioTagPane;
    private BGridPane addButtonPane;
    private BGridPane delButtonPane;
    private BTagDictionary dictionary;
    private BTextField tagEntry;
    private String tagFilter;
    private Add add;
    private Reverse reverse;
    private Rename rename;
    private Remove remove;
    private MoveUp moveUp;
    private MoveDown moveDown;
    private AddTag addTag;
    private DeleteTag deleteTag;
    private DeleteAllTag deleteAllTag;
    private HashMap<String, Object> dictionaryHash = new HashMap();

    public Type getType() {
        return TYPE;
    }

    public BTemplateIOEditor() {
        throw new IllegalStateException();
    }

    public BTemplateIOEditor(BTemplateView view, BComponent root) {
        Knob[] knobs;
        ComponentTags tags;
        BComponent taggable;
        String sourceSlotName;
        BLink[] links;
        this.view = view;
        this.root = root;
        this.tree = new BTree((TreeModel)new Model(root));
        this.tree.setMultipleSelection(true);
        this.tree.setController((TreeController)new Controller());
        this.tree.setSelection((TreeSelection)new Selection());
        this.tree.setExpanded(this.tree.getModel().getRoot(0), true);
        this.tree.getModel().updateTree();
        CompositeModel model = new CompositeModel();
        this.table = new BTable((TableModel)model);
        this.table.setController((TableController)new CompositeController());
        this.table.setSelection((TableSelection)new CompositeSelection());
        this.table.setCellRenderer((TableCellRenderer)new CompositeRenderer());
        this.table.setHeaderRenderer((TableHeaderRenderer)new CompositeHeaderRenderer());
        this.tableSubscriber = new IoWidgetSubscriber();
        this.tableSubscriber.subscribe((BComponent)this.table);
        String rootPathPrefix = root.getSlotPath().toString() + '/';
        for (BLink link : links = root.getLinks()) {
            boolean readonly;
            String linkSourcePath;
            if (link.getTargetSlot().isFrozen()) continue;
            BComponent source = null;
            try {
                source = (BComponent)link.getSourceOrd().resolve((BObject)root).get();
            }
            catch (Exception e) {
                root.remove((BComplex)link);
            }
            if (source == null || source.getType().is(BTemplateConfig.TYPE) || !(linkSourcePath = source.getSlotPath().toString()).startsWith(rootPathPrefix)) continue;
            String targetSlotName = link.getTargetSlotName();
            sourceSlotName = link.getSourceSlotName();
            source.lease();
            Slot sourceSlot = source.getSlot(sourceSlotName);
            boolean bl = readonly = sourceSlot.isTopic() || Flags.isReadonly((BComplex)source, (Slot)sourceSlot);
            if (root.getProperty(targetSlotName) == null) {
                root.remove(link.getName());
                continue;
            }
            Tags existingTags = link.tags();
            if (existingTags.isEmpty()) {
                taggable = new BComponent();
                taggable.tags().set(NIAGARA_BIND_HINTS_TAG);
                taggable.tags().set(NIAGARA_TARGET_SLOT_HINT_TAG);
                taggable.tags().set(NIAGARA_TEMPLATE_OUTPUT);
                taggable.tags().set(NIAGARA_USER_TIP);
                existingTags = taggable.tags();
                tags = new ComponentTags(source);
                existingTags.merge(tags.getAll());
            }
            if (!existingTags.contains(NIAGARA_BIND_HINTS_TAG.getId())) {
                existingTags.set(NIAGARA_BIND_HINTS_TAG);
            }
            if (!existingTags.contains(NIAGARA_TARGET_SLOT_HINT_TAG.getId())) {
                existingTags.set(NIAGARA_TARGET_SLOT_HINT_TAG);
            }
            if (!existingTags.contains(NIAGARA_TEMPLATE_OUTPUT.getId())) {
                existingTags.set(NIAGARA_TEMPLATE_OUTPUT);
            }
            if (!existingTags.contains(NIAGARA_USER_TIP.getId())) {
                existingTags.set(NIAGARA_USER_TIP);
            }
            Property targetProperty = root.getProperty(targetSlotName);
            model.add(1, targetSlotName, linkSourcePath, sourceSlotName, targetProperty.getType(), readonly, true, root.getFlags((Slot)targetProperty), existingTags);
        }
        for (Knob knob : knobs = root.getKnobs()) {
            if (knob.getSourceSlot().isFrozen()) continue;
            BComponent target = (BComponent)knob.getTargetOrd().resolve((BObject)root).get();
            target.lease();
            String targetPath = target.getSlotPath().toString();
            if (!targetPath.startsWith(rootPathPrefix)) continue;
            sourceSlotName = knob.getSourceSlotName();
            String targetSlotName = knob.getTargetSlotName();
            if (root.getProperty(sourceSlotName) == null) {
                target.remove(knob.getLink().getName());
                continue;
            }
            Slot targetSlot = target.getSlot(targetSlotName);
            Tags linkTags = knob.getLink().tags();
            if (linkTags.isEmpty()) {
                taggable = new BComponent();
                taggable.tags().set(NIAGARA_BIND_HINTS_TAG);
                taggable.tags().set(NIAGARA_TARGET_SLOT_HINT_TAG);
                taggable.tags().set(NIAGARA_TEMPLATE_INPUT);
                taggable.tags().set(NIAGARA_USER_TIP);
                linkTags = taggable.tags();
                tags = new ComponentTags(target);
                linkTags.merge(tags.getAll());
            }
            if (!linkTags.contains(NIAGARA_BIND_HINTS_TAG.getId())) {
                linkTags.set(NIAGARA_BIND_HINTS_TAG);
            }
            if (!linkTags.contains(NIAGARA_TARGET_SLOT_HINT_TAG.getId())) {
                linkTags.set(NIAGARA_TARGET_SLOT_HINT_TAG);
            }
            if (!linkTags.contains(NIAGARA_TEMPLATE_INPUT.getId())) {
                linkTags.set(NIAGARA_TEMPLATE_INPUT);
            }
            if (!linkTags.contains(NIAGARA_USER_TIP.getId())) {
                linkTags.set(NIAGARA_USER_TIP);
            }
            Property sourceProperty = root.getProperty(sourceSlotName);
            model.add(0, sourceSlotName, targetPath, targetSlotName, sourceProperty.getType(), false, true, target.getFlags(targetSlot), linkTags);
        }
        Property[] props = root.getPropertiesArray();
        int offset = 0;
        for (Property prop : props) {
            for (int j = 0; j < model.getRowCount(); ++j) {
                if (!prop.getName().equals(model.get((int)j).name)) continue;
                model.move(j, offset++);
            }
        }
        BSplitPane split = new BSplitPane();
        split.setDividerPosition(15.0);
        split.setWidget1(this.buildLeftPane());
        split.setWidget2(this.buildRightPane());
        this.setCenter((BWidget)split);
        this.updateTagPanes();
    }

    private BWidget buildLeftPane() {
        this.add = new Add((BWidget)this);
        this.add.setEnabled(false);
        BButton a = new BButton((Command)this.add);
        a.setButtonStyle(BButtonStyle.toolBar);
        BGridPane top = new BGridPane(1);
        top.setHalign(BHalign.left);
        top.add(null, (BValue)a);
        BEdgePane pane = new BEdgePane();
        pane.setTop((BWidget)new BBorderPane((BWidget)top, 5.0, 0.0, 5.0, 0.0));
        pane.setCenter((BWidget)new BBorderPane((BWidget)new BTreePane(this.tree), BBorder.none, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        return pane;
    }

    private BWidget buildRightPane() {
        this.reverse = new Reverse((BWidget)this);
        this.rename = new Rename((BWidget)this);
        this.remove = new Remove((BWidget)this);
        this.moveUp = new MoveUp((BWidget)this);
        this.moveDown = new MoveDown((BWidget)this);
        this.addTag = new AddTag((BWidget)this);
        this.deleteTag = new DeleteTag((BWidget)this);
        this.deleteAllTag = new DeleteAllTag((BWidget)this);
        this.reverse.setEnabled(false);
        this.rename.setEnabled(false);
        this.remove.setEnabled(false);
        this.moveUp.setEnabled(false);
        this.moveDown.setEnabled(false);
        this.addTag.setEnabled(false);
        this.deleteTag.setEnabled(false);
        this.deleteAllTag.setEnabled(false);
        BButton a = new BButton((Command)this.reverse);
        BButton b = new BButton((Command)this.rename);
        BButton c = new BButton((Command)this.remove);
        BButton d = new BButton((Command)this.moveUp);
        BButton e = new BButton((Command)this.moveDown);
        a.setButtonStyle(BButtonStyle.toolBar);
        b.setButtonStyle(BButtonStyle.toolBar);
        c.setButtonStyle(BButtonStyle.toolBar);
        d.setButtonStyle(BButtonStyle.toolBar);
        e.setButtonStyle(BButtonStyle.toolBar);
        BButton addTagB = new BButton((Command)this.addTag);
        BButton deleteTagB = new BButton((Command)this.deleteTag);
        BButton deleteAllTagB = new BButton((Command)this.deleteAllTag);
        addTagB.setButtonStyle(BButtonStyle.toolBar);
        deleteTagB.setButtonStyle(BButtonStyle.toolBar);
        deleteAllTagB.setButtonStyle(BButtonStyle.toolBar);
        BGridPane topLeft = new BGridPane(3);
        topLeft.add(null, (BValue)a);
        topLeft.add(null, (BValue)b);
        topLeft.add(null, (BValue)c);
        BGridPane topRight = new BGridPane(2);
        topRight.add(null, (BValue)d);
        topRight.add(null, (BValue)e);
        BEdgePane top = new BEdgePane();
        top.setLeft((BWidget)topLeft);
        top.setRight((BWidget)topRight);
        this.addButtonPane = new BGridPane(2);
        this.addButtonPane.add(null, (BValue)addTagB);
        this.delButtonPane = new BGridPane(2);
        this.delButtonPane.add(null, (BValue)deleteTagB);
        this.delButtonPane.add(null, (BValue)deleteAllTagB);
        this.sp = new BSplitPane();
        BEdgePane pane = new BEdgePane();
        pane.setTop((BWidget)new BBorderPane((BWidget)top, 5.0, 0.0, 5.0, 0.0));
        pane.setCenter((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        this.sp.setWidget1((BWidget)pane);
        this.sp.setOrientation(BOrientation.vertical);
        this.sp.setWidget2(this.buildTagPane());
        return this.sp;
    }

    public boolean hasValidHints() {
        CompositeModel model = (CompositeModel)this.table.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            CompositeSlot slot = model.get(i);
            if (slot.hasValidBindHints()) continue;
            return false;
        }
        return true;
    }

    public void save() {
        this.root = this.createComposite();
    }

    private BWidget buildTagPane() {
        this.dictionarySelect = TagSupport.makeDictionarySelect(this.dictionaryHash);
        this.sourceTagTable = new BTable();
        this.sourceTagTable.setModel((TableModel)new TagTableModel());
        this.sourceTagTable.setSelection((TableSelection)new TagTableSelection());
        this.sourceTagTable.setController((TableController)new TagTableController());
        this.tagEntry = new BTextField("");
        this.ioTagTable = new BTable();
        this.ioTagTable.setModel((TableModel)new TagTableModel());
        this.ioTagTable.setSelection((TableSelection)new TagTableSelection());
        this.ioTagTable.setController((TableController)new TagTableController());
        this.tagFilterSelect = this.makeFilterSelect();
        this.tableSubscriber.subscribe((BComponent)this.tagEntry);
        this.tableSubscriber.subscribe((BComponent)this.dictionarySelect);
        this.tableSubscriber.subscribe((BComponent)this.tagFilterSelect);
        this.initDictionary();
        BEdgePane tagPane = new BEdgePane();
        BSplitPane tagSplitPane = new BSplitPane();
        tagSplitPane.setOrientation(BOrientation.horizontal);
        tagPane.setTop((BWidget)this.buildTagPaneHeader());
        tagPane.setCenter((BWidget)tagSplitPane);
        this.sourceTagPane = this.buildTagSubPane(lex.getText("controlAppIOEditor.tags"));
        this.ioTagPane = this.buildTagSubPane(lex.getText("controlAppIOEditor.ioTags"));
        tagSplitPane.setWidget1((BWidget)this.sourceTagPane);
        tagSplitPane.setWidget2((BWidget)this.ioTagPane);
        BGridPane tpSelect = new BGridPane(6);
        return tagPane;
    }

    private BBorderPane buildTagPaneHeader() {
        BBorderPane dictnPane = new BBorderPane((BWidget)new BNullWidget(), BInsets.make((double)1.0, (double)0.0, (double)1.0, (double)1.0));
        BGridPane dictnSelPane = new BGridPane();
        dictnSelPane.setColumnCount(8);
        dictnSelPane.setHalign(BHalign.left);
        dictnSelPane.add(null, (BValue)new BLabel(lex.getText("tag.dictionary.select")));
        dictnSelPane.add(null, (BValue)this.dictionarySelect);
        dictnSelPane.add(null, (BValue)new BLabel(filterIcon, ""));
        dictnSelPane.add(null, (BValue)this.tagEntry);
        dictnSelPane.add(null, (BValue)new BLabel(lex.getText("controlAppIOEditor.tagFilter.label")));
        dictnSelPane.add(null, (BValue)this.tagFilterSelect);
        dictnPane.setContent((BWidget)dictnSelPane);
        return dictnPane;
    }

    private BEdgePane buildTagSubPane(String title) {
        BEdgePane tagPane = new BEdgePane();
        BGridPane titlePane = new BGridPane(1);
        titlePane.setHalign(BHalign.left);
        titlePane.add(null, (BValue)new BLabel(title));
        tagPane.setTop((BWidget)titlePane);
        return tagPane;
    }

    private void updateTagPanes() {
        TagSupport.updateTagDictionaryTable(this.sourceTagTable, this.dictionary, this.tagFilterSelect.getSelectedItem().equals(TAG_FILTER_MARKERS), this.tagFilter);
        this.sourceTagPane.setCenter((BWidget)this.sourceTagTable);
        this.sourceTagPane.setBottom((BWidget)this.addButtonPane);
        this.updateButtons(this.sourceTagTable, true);
        ((TagTableController)this.sourceTagTable.getController()).resizeColumns(this.sourceTagTable);
        this.updateIoTagPane(this.getIoTaggable(), this.ioTagPane, this.ioTagTable, this.delButtonPane);
    }

    private void updateIoTagPane(Taggable taggable, BEdgePane tagPane, BTable tagTable, BGridPane buttons) {
        this.updateTagPane(taggable, tagPane, tagTable, "", buttons);
        this.updateIoTags(taggable);
    }

    private void updateIoTags(Taggable taggable) {
        if (taggable == null) {
            return;
        }
        TagTableModel ttModel = (TagTableModel)this.ioTagTable.getModel();
        int rows = this.ioTagTable.getModel().getRowCount();
        ArrayList<Tag> list = new ArrayList<Tag>();
        for (int i = 0; i < rows; ++i) {
            list.add(ttModel.get(i));
        }
        taggable.tags().merge(list);
    }

    private void updateTagPane(Taggable taggable, BEdgePane tagPane, BTable tagTable, String tagFilter, BGridPane buttons) {
        TagTableModel model = (TagTableModel)tagTable.getModel();
        if (taggable == null) {
            BLabel noIOSelected = new BLabel(lex.getText("controlAppIOEditor.noIOSelected"));
            BFont font = BFont.DEFAULT;
            noIOSelected.setFont(BFont.make((BFont)font, (double)(font.getSize() * 2.0)));
            tagPane.setCenter((BWidget)new BBorderPane((BWidget)noIOSelected, 2.0, 2.0, 2.0, 2.0));
        } else {
            Iterator it = null;
            Tags tags = taggable.tags();
            it = this.tagFilterSelect.getSelectedItem().equals(TAG_FILTER_MARKERS) ? tags.filter(t -> t.getValue() instanceof BMarker).iterator() : (this.tagFilterSelect.getSelectedItem().equals(TAG_FILTER_DICTIONARY) ? tags.filter(t -> !t.getId().getDictionary().equals("")).iterator() : tags.iterator());
            model.removeAll();
            while (it.hasNext()) {
                Tag tag = (Tag)it.next();
                if (tagFilter == null || tagFilter.length() == 0) {
                    model.add(tag);
                    continue;
                }
                if (tag.getId().getName().equalsIgnoreCase(tagFilter)) {
                    model.add(tag);
                    break;
                }
                if (!tag.getId().getName().toLowerCase().startsWith(tagFilter.toLowerCase())) continue;
                model.add(tag);
            }
            tagPane.setCenter((BWidget)tagTable);
        }
        if (buttons != null) {
            tagPane.setBottom((BWidget)buttons);
        }
        this.updateButtons(tagTable, taggable != null);
        model.sortByColumn(0, true);
        tagTable.repaint();
    }

    private void updateButtons(BTable tagTable, boolean enable) {
        if (tagTable.equals((Object)this.sourceTagTable)) {
            TagTableModel model = (TagTableModel)this.sourceTagTable.getModel();
            int tagCount = this.sourceTagTable.getModel().getRowCount();
            if (tagCount == 1) {
                this.sourceTagTable.getSelection().select(0);
            }
            int[] rows = this.sourceTagTable.getSelection().getRows();
            boolean isIoSelected = this.table.getSelection().getRows().length > 0;
            this.addTag.setEnabled(enable && isIoSelected && (rows.length > 0 || tagCount == 1));
        } else if (tagTable.equals((Object)this.ioTagTable)) {
            TagTableModel model = (TagTableModel)this.ioTagTable.getModel();
            int[] rows = this.ioTagTable.getSelection().getRows();
            this.deleteTag.setEnabled(enable && rows.length > 0);
            this.deleteAllTag.setEnabled(enable && model.getRowCount() > 0);
        }
    }

    public BComponent createComposite() {
        CompositeSlot slot;
        int i;
        Context tx = Transaction.start((BComponent)this.root, null);
        CompositeModel model = (CompositeModel)this.table.getModel();
        for (i = 0; i < model.getRowCount(); ++i) {
            slot = model.get(i);
            slot.name = SlotPath.escape((String)slot.name);
            if (slot.backup == null) {
                this.addCompositeSlot(tx, slot);
                continue;
            }
            slot.backup.backup = slot.backup;
            this.removeCompositeSlot(tx, slot.backup);
            this.addCompositeSlot(tx, slot);
        }
        for (i = 0; i < this.removed.size(); ++i) {
            slot = this.removed.get(i);
            this.removeCompositeSlot(tx, slot);
        }
        try {
            Transaction.end((BComponent)this.root, (Context)tx);
        }
        catch (Exception e) {
            BDialog.error((BWidget)this.getShell(), (String)"Error", (Object)"createTemplateConfig failed.", (Throwable)e);
        }
        this.reorderCompositeSlots();
        return this.root;
    }

    private void addCompositeSlot(Context tx, CompositeSlot slot) {
        BCompositeAction value;
        BComponent child = (BComponent)BOrd.make((String)slot.ord).resolve((BObject)this.root).get();
        Slot childSlot = child.getSlot(slot.slot);
        slot.childFlags = child.getFlags(childSlot);
        BFacets facets = child.getSlotFacets(childSlot);
        if (facets == null) {
            facets = BFacets.NULL;
        }
        if (childSlot.isAction() || childSlot.isTopic()) {
            value = slot.dir == 0 ? new BCompositeAction() : new BCompositeTopic();
        } else {
            value = (BValue)slot.type.getInstance();
            value = child.get(slot.slot).newCopy();
        }
        int flags = slot.dir == 1 ? 4097 : 4096;
        this.root.add(slot.name, (BValue)value, flags, facets, tx);
        if (slot.dir == 1) {
            BLink link = new BLink(child.getHandleOrd(), slot.slot, slot.name, true);
            link.tags().merge(slot.taggable.tags().getAll());
            this.root.add(null, (BValue)link, 4096, BFacets.NULL, tx);
        } else {
            BLink link = new BLink(this.root.getHandleOrd(), slot.name, slot.slot, true);
            link.tags().merge(slot.taggable.tags().getAll());
            child.add(null, (BValue)link, 4096, BFacets.NULL, tx);
        }
    }

    private void renameCompositeSlot(Context tx, CompositeSlot slot) {
        if (slot.backup.name.equals(slot.name)) {
            return;
        }
        BComponent c = this.root;
        Property prop = c.getProperty(slot.backup.name);
        BString newName = BString.make((String)slot.name);
        c.rename(prop, slot.name, tx);
        BLink[] links = c.getLinks((Slot)prop);
        for (int i = 0; i < links.length; ++i) {
            BLink link = links[i];
            link.set(BLink.targetSlotName, (BValue)newName, tx);
        }
        Knob[] knobs = c.getKnobs((Slot)prop);
        block1: for (int i = 0; i < knobs.length; ++i) {
            Knob knob = knobs[i];
            BComponent target = (BComponent)knob.getTargetOrd().get((BObject)c);
            target.lease();
            Property targetProp = target.getProperty(knob.getTargetSlotName());
            BLink[] targetLinks = target.getLinks((Slot)targetProp);
            for (int j = 0; j < targetLinks.length; ++j) {
                BLink link = targetLinks[j];
                if (!this.isMatch(knob, link)) continue;
                link.set(BLink.sourceSlotName, (BValue)newName, tx);
                continue block1;
            }
        }
    }

    private boolean isMatch(Knob knob, BLink link) {
        return link.getSourceOrd().equals((Object)knob.getSourceOrd()) && link.getSourceSlotName().equals(knob.getSourceSlotName());
    }

    private void removeCompositeSlot(Context tx, CompositeSlot slot) {
        if (slot.dir == 1) {
            BLink[] links = this.root.getLinks();
            for (int i = 0; i < links.length; ++i) {
                if (!links[i].getTargetSlotName().equals(slot.backup.name)) continue;
                this.root.remove(links[i].getPropertyInParent(), tx);
                this.root.remove(this.root.getProperty(slot.backup.name), tx);
                return;
            }
        } else {
            BComponent child = (BComponent)BOrd.make((String)slot.ord).resolve((BObject)this.root).get();
            child.lease();
            BLink[] links = child.getLinks();
            for (int i = 0; i < links.length; ++i) {
                if (!links[i].getSourceSlotName().equals(slot.backup.name)) continue;
                child.remove(links[i].getPropertyInParent(), tx);
                this.root.remove(this.root.getProperty(slot.backup.name), tx);
                return;
            }
        }
        throw new RuntimeException("Could not find link for " + slot.backup.name);
    }

    public void reorderCompositeSlots() {
        this.root.lease();
        CompositeModel model = (CompositeModel)this.table.getModel();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < model.getRowCount(); ++i) {
            list.add(model.get((int)i).name);
        }
        this.root.loadSlots();
        SlotCursor c = this.root.getProperties();
        while (c.next()) {
            Property p = c.property();
            if (p.isFrozen() || list.contains(p.getName())) continue;
            list.add(p.getName());
        }
        Property[] newProps = new Property[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            newProps[i] = this.root.getProperty((String)list.get(i));
        }
        this.root.reorder(newProps);
    }

    private String getUniqueName(String name) {
        CompositeModel model = (CompositeModel)this.table.getModel();
        this.root.loadSlots();
        Slot[] s = this.root.getSlotsArray();
        int count = 1;
        String tempName = name;
        for (int i = 0; i < s.length; ++i) {
            if (s[i].getName().equals(tempName)) {
                tempName = name + count;
                ++count;
                i = -1;
                continue;
            }
            for (int j = 0; j < model.getRowCount(); ++j) {
                CompositeSlot cs = model.get(j);
                if (!cs.name.equals(tempName)) continue;
                tempName = name + count;
                ++count;
                j = model.getRowCount();
                i = -1;
            }
        }
        return tempName;
    }

    private Tags getIOTags(Taggable comp) {
        return comp.tags();
    }

    private void copySoruceTagsToIoTags() {
        this.getIoTaggable().tags().merge(this.getSourceTags().getAll());
    }

    private Taggable getSourceTaggable() {
        try {
            CompositeSlot slot = this.getIoCompositeSlot();
            if (slot == null) {
                return null;
            }
            return (Taggable)BOrd.make((String)slot.ord).resolve((BObject)this.root).get();
        }
        catch (Exception e) {
            return null;
        }
    }

    private Tags getSourceTags() {
        return this.getSourceTaggable().tags();
    }

    private Taggable getIoTaggable() {
        CompositeSlot slot = this.getIoCompositeSlot();
        if (slot == null) {
            return null;
        }
        return this.getIoCompositeSlot().taggable;
    }

    private CompositeSlot getIoCompositeSlot() {
        CompositeModel model = (CompositeModel)this.table.getModel();
        int[] rows = this.table.getSelection().getRows();
        if (rows == null || rows.length == 0) {
            return null;
        }
        return model.get(rows[0]);
    }

    private void initDictionary() {
        String dictn;
        Object object;
        this.dictionary = this.dictionarySelect.getSelectedIndex() >= 0 && this.dictionarySelect.getSelectedItem() instanceof String ? ((object = this.dictionaryHash.get(dictn = (String)this.dictionarySelect.getSelectedItem())) instanceof BTagDictionary ? (BTagDictionary)object : null) : null;
    }

    private BListDropDown makeFilterSelect() {
        BListDropDown filterSel = new BListDropDown();
        BList list = filterSel.getList();
        list.addItem((Object)TAG_FILTER_ALL);
        list.addItem((Object)TAG_FILTER_MARKERS);
        list.addItem((Object)TAG_FILTER_DICTIONARY);
        list.setSelectedItem((Object)TAG_FILTER_ALL);
        return filterSel;
    }

    class Selection
    extends TreeSelection {
        Selection() {
        }

        public void updateTree() {
            super.updateTree();
            TreeNode[] nodes = this.getNodes();
            boolean b = false;
            if (nodes != null) {
                for (int i = 0; i < nodes.length; ++i) {
                    BComplex obj = ((Node)nodes[i]).object;
                    b = obj instanceof BControlPoint || !(obj instanceof BComponent);
                }
            }
            BTemplateIOEditor.this.add.setEnabled(b);
        }
    }

    class Controller
    extends TreeController {
        Controller() {
        }

        protected void doSelectAction(TreeNode target, double x, double y) {
            if (BTemplateIOEditor.this.add.isEnabled()) {
                BTemplateIOEditor.this.add.invoke();
            }
        }

        public void setFocus(TreeNode node) {
            super.setFocus(node);
            if (node != null) {
                BTemplateIOEditor.this.add.setEnabled(((Node)node).canAdd());
            }
        }
    }

    class Node
    extends TreeNode {
        BComplex object;
        String name;
        Node[] kids;

        public Node(TreeModel model, BComplex object) {
            super(model);
            this.name = object.getName();
            this.object = object;
        }

        public Node(TreeNode parent, BComplex object) {
            super(parent);
            this.name = object.getName();
            this.object = object;
        }

        public String getText() {
            return this.object.getDisplayName(null);
        }

        public BImage getIcon() {
            BImage icon = BImage.make((BIcon)this.object.getIcon());
            return this.canAdd() ? icon : icon.getDisabledImage();
        }

        public boolean hasChildren() {
            if (this.kids == null) {
                return true;
            }
            return this.kids.length > 0;
        }

        public int getChildCount() {
            if (this.kids == null) {
                this.getChild(-1);
            }
            return this.kids.length;
        }

        public TreeNode getChild(int index) {
            if (this.kids == null) {
                this.load();
            }
            return index == -1 ? null : this.kids[index];
        }

        public TreeNode getChild(String name) {
            if (this.kids == null) {
                this.load();
            }
            for (int i = 0; i < this.kids.length; ++i) {
                if (!this.kids[i].name.equals(name)) continue;
                return this.kids[i];
            }
            return null;
        }

        private void load() {
            this.load(false);
        }

        private void load(boolean clear) {
            if (clear) {
                this.kids = null;
            }
            if (this.kids == null) {
                this.loadRefChildren(this.object);
            }
            ArrayList<Node> list = new ArrayList<Node>();
            for (Node kid : this.kids) {
                if (kid.getChildCount() <= 0) continue;
                list.add(kid);
            }
            Node[] kidNodes = new Node[list.size()];
            this.kids = list.toArray(kidNodes);
        }

        boolean loadRefChildren(BComplex parent) {
            ArrayList<Node> al = new ArrayList<Node>();
            boolean descendantComp = false;
            boolean isSubtemplate = false;
            if (parent instanceof BComponent && parent.getParent().getParent() != null) {
                isSubtemplate = parent.asComponent().tags().get(TemplateConst.TEMPLATE_ROOT_TAG_ID).isPresent();
            }
            SlotCursor c = parent.getProperties();
            while (c.next()) {
                Slot slot = c.slot();
                if (!this.accept(parent, slot, isSubtemplate)) continue;
                BComplex v = parent.get(slot.asProperty()).asComplex();
                Node rf = new Node(this, v);
                if (v instanceof BStatusValue) {
                    al.add(rf);
                }
                if (!(v instanceof BComplex)) continue;
                boolean isComponent = v instanceof BComponent;
                boolean containsComp = rf.loadRefChildren(v);
                if (!isComponent && !containsComp) continue;
                al.add(rf);
                descendantComp = true;
            }
            Node[] kidNodes = new Node[al.size()];
            this.kids = al.toArray(kidNodes);
            return descendantComp;
        }

        boolean canAdd() {
            CompositeModel model = (CompositeModel)BTemplateIOEditor.this.table.getModel();
            if (this.getParent() == null) {
                return false;
            }
            BComponent parent = (BComponent)((Node)this.getParent()).object;
            Slot slot = parent.getSlot(this.name);
            BValue childValue = parent.get(slot.asProperty());
            if (childValue instanceof BControlPoint) {
                parent = childValue.asComponent();
                slot = parent.getSlot("out");
            } else if (childValue instanceof BComponent) {
                return false;
            }
            int existing = model.canAddToModel(parent, slot);
            return existing != BOTH_EXIST;
        }

        boolean accept(BComplex parent, Slot slot, boolean isTemplateRoot) {
            if (slot == null || parent == null || !slot.isProperty() || Flags.isHidden((BComplex)parent, (Slot)slot)) {
                return false;
            }
            Type slotType = parent.asComplex().get(slot.asProperty()).getType();
            if (isTemplateRoot) {
                int flags = parent.getFlags(slot);
                return (flags & 0x1000) != 0;
            }
            if (slotType.is(BTemplateConfig.TYPE) || slotType.is(BWsAnnotation.TYPE) || slotType.is(BPxView.TYPE) || slotType.is(BMarker.TYPE) || slotType.is(BRelation.TYPE) || slotType.is(BConfigBinding.TYPE)) {
                return false;
            }
            return slotType.is(BComplex.TYPE);
        }
    }

    class Model
    extends TreeModel {
        Node root;

        public Model(BComponent rootNode) {
            this.root = new Node(this, (BComplex)rootNode);
        }

        public int getRootCount() {
            return 1;
        }

        public TreeNode getRoot(int index) {
            return this.root;
        }
    }

    class IoWidgetSubscriber
    extends WidgetSubscriber {
        IoWidgetSubscriber() {
        }

        public void actionPerformed(BWidgetEvent e) {
            BWidget widget = e.getWidget();
            if (widget.equals((Object)BTemplateIOEditor.this.tagEntry)) {
                TableSelection selection = BTemplateIOEditor.this.sourceTagTable.getSelection();
                TagTableModel model = (TagTableModel)BTemplateIOEditor.this.sourceTagTable.getModel();
                if (model.getRowCount() == 1) {
                    selection.selectAll();
                    BTemplateIOEditor.this.addTag.doInvoke();
                }
                BTemplateIOEditor.this.tagFilter = "";
                BTemplateIOEditor.this.tagEntry.setText("");
                BTemplateIOEditor.this.updateTagPanes();
            }
        }

        public void keyTyped(BKeyEvent event) {
            if (event.getWidget().equals((Object)BTemplateIOEditor.this.tagEntry)) {
                TableSelection selection = BTemplateIOEditor.this.sourceTagTable.getSelection();
                selection.deselectAll();
                BTemplateIOEditor.this.tagFilter = BTemplateIOEditor.this.tagEntry.getText();
                if (BTemplateIOEditor.this.tagFilter.endsWith(":")) {
                    String dctnFilter = BTemplateIOEditor.this.tagFilter.substring(0, BTemplateIOEditor.this.tagFilter.length() - 1);
                    BList list = BTemplateIOEditor.this.dictionarySelect.getList();
                    for (int i = 0; i < list.getItemCount(); ++i) {
                        if (!(list.getItem(i) instanceof TypeInfo) || !((TypeInfo)list.getItem(i)).getTypeName().toLowerCase().startsWith(dctnFilter.toLowerCase())) continue;
                        list.setSelectedIndex(i);
                        BTemplateIOEditor.this.initDictionary();
                        break;
                    }
                    BTemplateIOEditor.this.tagFilter = "";
                    BTemplateIOEditor.this.tagEntry.setText("");
                }
                BTemplateIOEditor.this.updateTagPanes();
            }
        }

        public void modified(BWidgetEvent e) {
            BWidget widget = e.getWidget();
            if (widget.equals((Object)BTemplateIOEditor.this.table) || widget.equals((Object)BTemplateIOEditor.this.tagFilterSelect)) {
                BTemplateIOEditor.this.updateTagPanes();
            } else if (widget.equals((Object)BTemplateIOEditor.this.dictionarySelect)) {
                BTemplateIOEditor.this.initDictionary();
                BTemplateIOEditor.this.updateTagPanes();
            }
        }
    }

    public class AddFromDictionary
    extends Command {
        public AddFromDictionary(BWidget owner) {
            super(owner, module, "controlAppConfigEditor.addFromDictionary");
        }

        public CommandArtifact doInvoke() {
            TagTableModel model = (TagTableModel)BTemplateIOEditor.this.ioTagTable.getModel();
            model.getSelection().selectAll();
            return BTemplateIOEditor.this.deleteTag.doInvoke();
        }
    }

    public class DeleteAllTag
    extends Command {
        public DeleteAllTag(BWidget owner) {
            super(owner, module, "controlAppConfigEditor.deleteAllTags");
        }

        public CommandArtifact doInvoke() {
            TagTableModel model = (TagTableModel)BTemplateIOEditor.this.ioTagTable.getModel();
            model.getSelection().selectAll();
            return BTemplateIOEditor.this.deleteTag.doInvoke();
        }
    }

    public class DeleteTag
    extends Command {
        public DeleteTag(BWidget owner) {
            super(owner, module, "controlAppConfigEditor.deleteTag");
        }

        public CommandArtifact doInvoke() {
            TagTableModel model = (TagTableModel)BTemplateIOEditor.this.ioTagTable.getModel();
            int[] rows = model.getSelection().getRows();
            model.remove(rows);
            model.getSelection().deselectAll();
            BTemplateIOEditor.this.ioTagTable.repaint();
            BTemplateIOEditor.this.view.templateModified();
            return null;
        }
    }

    public class AddTag
    extends Command {
        public AddTag(BWidget owner) {
            super(owner, module, "controlAppConfigEditor.addTag");
        }

        public CommandArtifact doInvoke() {
            return this.doInvoke(true);
        }

        public CommandArtifact doInvoke(boolean update) {
            TagTableModel model = (TagTableModel)BTemplateIOEditor.this.sourceTagTable.getModel();
            int[] rows = model.getSelection().getRows();
            for (int i = 0; i < rows.length; ++i) {
                Tag tag = model.get(rows[i]);
                ((TagTableModel)BTemplateIOEditor.this.ioTagTable.getModel()).add(tag);
            }
            BTemplateIOEditor.this.ioTagTable.repaint();
            ((TagTableController)BTemplateIOEditor.this.ioTagTable.getController()).resizeColumns(BTemplateIOEditor.this.ioTagTable);
            BTemplateIOEditor.this.updateButtons(BTemplateIOEditor.this.ioTagTable, true);
            BTemplateIOEditor.this.view.templateModified();
            if (update) {
                BTemplateIOEditor.this.updateIoTags(BTemplateIOEditor.this.getIoTaggable());
            }
            return null;
        }
    }

    class TagTableController
    extends TableController {
        TagTableController() {
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            if (event.getWidget().equals((Object)BTemplateIOEditor.this.sourceTagTable)) {
                BTemplateIOEditor.this.addTag.doInvoke();
                BTemplateIOEditor.this.ioTagTable.repaint();
            } else if (event.getWidget().equals((Object)BTemplateIOEditor.this.ioTagTable) && column == 3) {
                TagTableModel tagModel = (TagTableModel)BTemplateIOEditor.this.ioTagTable.getModel();
                Tag tag = tagModel.get(row);
                if (tag.getValue() instanceof BMarker) {
                    return;
                }
                BWbFieldEditor editor = BWbFieldEditor.makeFor((BObject)tag.getValue().asObject());
                editor.loadValue(tag.getValue().asObject());
                BGridPane grid = new BGridPane(1);
                grid.add(null, (BValue)new BLabel(tag.getId().toString()));
                grid.add(null, (BValue)editor);
                BBorderPane pane = new BBorderPane((BWidget)grid, 10.0, 10.0, 10.0, 10.0);
                if (1 != BDialog.open((BWidget)BTemplateIOEditor.this.view, (String)lex.getText("controlAppConfigEditor.setValue.label"), (Object)pane, (int)3)) {
                    return;
                }
                BValue newValue = null;
                try {
                    newValue = editor.saveValue().asValue();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (newValue == null) {
                    return;
                }
                if (tag.getValue().equals(newValue)) {
                    return;
                }
                Tag updateTag = new Tag(tag.getId(), (BIDataValue)newValue);
                tagModel.updateRow(row, updateTag);
                Taggable ioTaggable = BTemplateIOEditor.this.getIoTaggable();
                ioTaggable.tags().set(updateTag);
                BTemplateIOEditor.this.table.relayout();
                BTemplateIOEditor.this.view.templateModified();
            }
        }

        public void resizeColumns(BTable table) {
            new TableController.ResizeColumnsCommand((TableController)this, table).doInvoke();
        }
    }

    public class TagTableModel
    extends TableModel {
        Array<Tag> tags = new Array(Tag.class);

        public int getRowCount() {
            return this.tags.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "NameSpace";
                }
                case 1: {
                    return "TagName";
                }
                case 2: {
                    return "Type";
                }
                case 3: {
                    return "value";
                }
            }
            return "";
        }

        public boolean isColumnSortable(int col) {
            return col <= 2;
        }

        public synchronized void sortByColumn(int col, boolean ascending) {
            Object[] keys = this.getColumnValues(col);
            Tag[] current = (Tag[])this.tags.trim();
            Object[] temp = new Tag[current.length];
            System.arraycopy(current, 0, temp, 0, keys.length);
            SortUtil.sort((Object[])keys, (Object[])temp, (boolean)ascending);
            this.tags.clear();
            this.tags.addAll(temp);
        }

        public Object getValueAt(int row, int col) {
            Tag tag = (Tag)this.tags.get(row);
            switch (col) {
                case 0: {
                    return tag.getId().getDictionary();
                }
                case 1: {
                    return tag.getId().getName();
                }
                case 2: {
                    return tag.getValue().getType().getTypeName();
                }
                case 3: {
                    return tag.getValue().toString();
                }
            }
            return "";
        }

        public Object getSubject(int row) {
            return this.tags.get(row);
        }

        public void add(Tag tag) {
            if (this.tags.contains((Object)tag)) {
                return;
            }
            this.tags.add((Object)tag);
        }

        public void removeAll() {
            this.tags = new Array(Tag.class);
        }

        public void remove(Tag tag) {
            if (this.tags.contains((Object)tag)) {
                this.tags.remove(this.tags.indexOf((Object)tag));
            }
        }

        public void remove(int[] rows) {
            int i;
            Tag[] remTags = new Tag[rows.length];
            for (i = 0; i < rows.length; ++i) {
                remTags[i] = this.get(rows[i]);
            }
            for (i = 0; i < remTags.length; ++i) {
                this.remove(remTags[i]);
                BTemplateIOEditor.this.getIoTaggable().tags().remove(remTags[i]);
            }
        }

        public void remove(int row) {
            this.tags.remove(row);
        }

        public Tag get(int row) {
            if (row > this.tags.size()) {
                return null;
            }
            return (Tag)this.tags.get(row);
        }

        public void updateRow(int row, Tag newTag) {
            this.tags.set(row, (Object)newTag);
        }

        public int getTagIndex(String startsWith) {
            ListIterator listIterator = this.tags.list().listIterator();
            while (listIterator.hasNext()) {
                int index = listIterator.nextIndex();
                Tag tag = (Tag)listIterator.next();
                String thisName = tag.getId().getName();
                if (!tag.getId().getName().startsWith(startsWith)) continue;
                return index;
            }
            return -1;
        }
    }

    class CompositeRenderer
    extends TableCellRenderer {
        CompositeRenderer() {
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            if (cell.column == 3) {
                return BBrush.makeSolid((BColor)BColor.red);
            }
            return super.getForeground(cell);
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            CompositeModel model = (CompositeModel)this.getTable().getModel();
            CompositeSlot slot = model.get(cell.row);
            if (slot.type.is(BCompositeAction.TYPE)) {
                return colorAction;
            }
            if (slot.type.is(BCompositeTopic.TYPE)) {
                return colorTopic;
            }
            return colorProperty;
        }

        public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
            if (cell.column == 0) {
                return this.getForeground(cell);
            }
            return super.getSelectionForeground(cell);
        }

        public BBrush getSelectionBackground(TableCellRenderer.Cell cell) {
            if (cell.column == 0) {
                return this.getBackground(cell);
            }
            return super.getSelectionBackground(cell);
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            double width = super.getPreferredCellWidth(cell);
            if (cell.column == 1 && width < BTemplateConfigEditor.COL0_MIN_WIDTH) {
                return BTemplateConfigEditor.COL0_MIN_WIDTH;
            }
            return width;
        }
    }

    class CompositeHeaderRenderer
    extends TableHeaderRenderer {
        CompositeHeaderRenderer() {
        }

        public double getPreferredHeaderWidth(TableHeaderRenderer.Header header) {
            double width = super.getPreferredHeaderWidth(header);
            if (header.column == 1 && width < BTemplateConfigEditor.COL0_MIN_WIDTH) {
                return BTemplateConfigEditor.COL0_MIN_WIDTH;
            }
            return width;
        }
    }

    class CompositeSelection
    extends TableSelection {
        CompositeSelection() {
        }

        public void updateTable() {
            super.updateTable();
            CompositeModel model = (CompositeModel)this.getTable().getModel();
            int[] rows = this.getRows();
            BTemplateIOEditor.this.rename.setEnabled(rows.length > 0);
            BTemplateIOEditor.this.remove.setEnabled(rows.length > 0);
            BTemplateIOEditor.this.moveUp.setEnabled(rows.length > 0);
            BTemplateIOEditor.this.moveDown.setEnabled(rows.length > 0);
            for (int i = 0; i < rows.length; ++i) {
                CompositeSlot slot = ((CompositeModel)BTemplateIOEditor.this.table.getModel()).get(rows[i]);
                if (slot.readonly) {
                    BTemplateIOEditor.this.reverse.setEnabled(false);
                    return;
                }
                for (int j = 0; j < model.getRowCount(); ++j) {
                    CompositeSlot temp = model.get(j);
                    if (!(temp.ord + temp.slot).equals(slot.ord + slot.slot) || temp.name.equals(slot.name)) continue;
                    BTemplateIOEditor.this.reverse.setEnabled(false);
                    return;
                }
            }
            BTemplateIOEditor.this.reverse.setEnabled(rows.length > 0);
        }
    }

    class TagTableSelection
    extends TableSelection {
        TagTableSelection() {
        }

        public void updateTable() {
            super.updateTable();
            TagTableModel model = (TagTableModel)this.getTable().getModel();
            int[] rows = this.getRows();
            if (this.getTable().equals((Object)BTemplateIOEditor.this.sourceTagTable)) {
                BTemplateIOEditor.this.addTag.setEnabled(rows.length > 0);
            } else if (this.getTable().equals((Object)BTemplateIOEditor.this.ioTagTable)) {
                BTemplateIOEditor.this.deleteTag.setEnabled(rows.length > 0);
                BTemplateIOEditor.this.deleteAllTag.setEnabled(model.getRowCount() > 0);
            }
        }
    }

    class CompositeController
    extends TableController {
        CompositeController() {
        }

        public void keyPressed(BKeyEvent event) {
            super.keyPressed(event);
            if (event.getKeyCode() == 127 && BTemplateIOEditor.this.remove.isEnabled()) {
                BTemplateIOEditor.this.remove.invoke();
            }
        }

        protected void handleEnter(BKeyEvent event) {
            event.consume();
            if (BTemplateIOEditor.this.rename.isEnabled()) {
                BTemplateIOEditor.this.rename.invoke();
            }
            BTemplateIOEditor.this.table.repaint();
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            if (column == 0) {
                if (BTemplateIOEditor.this.reverse.isEnabled()) {
                    BTemplateIOEditor.this.reverse.invoke();
                }
            } else if (BTemplateIOEditor.this.rename.isEnabled()) {
                BTemplateIOEditor.this.rename.invoke();
            }
            BTemplateIOEditor.this.table.repaint();
        }

        protected void checkSelection(BMouseEvent event, int row) {
            super.checkSelection(event, row);
            TableSelection cacSel = BTemplateIOEditor.this.table.getSelection();
            int selRow = cacSel.getRow();
            if (selRow >= 0) {
                CompositeSlot slot = ((CompositeModel)BTemplateIOEditor.this.table.getModel()).get(cacSel.getRow());
                BComponent child = (BComponent)BOrd.make((String)slot.ord).resolve((BObject)BTemplateIOEditor.this.root).get();
                TreeModel model = BTemplateIOEditor.this.tree.getModel();
                SlotPath initialPath = child.getSlotPath();
                SlotPath rootPath = BTemplateIOEditor.this.root.getSlotPath();
                if (initialPath != null) {
                    Node temp;
                    String[] names = initialPath.getNames();
                    String[] rootNames = rootPath.getNames();
                    Node node = (Node)model.getRoot(0);
                    for (int i = rootNames.length; i < names.length && (temp = (Node)node.getChild(names[i])) != null; ++i) {
                        node = temp;
                    }
                    Node temp2 = (Node)node.getChild(slot.slot);
                    if (temp2 != null) {
                        node = temp2;
                    }
                    TreeNode[] path = node.getPathFromRoot();
                    BTemplateIOEditor.this.tree.scrollPathToVisible(path);
                    TreeNode n = path[path.length - 1];
                    BTemplateIOEditor.this.tree.getSelection().deselectAll();
                    BTemplateIOEditor.this.tree.getSelection().select(n);
                    BTemplateIOEditor.this.tree.getController().setFocus(BTemplateIOEditor.this.tree.getSelection().getNode());
                    n.setExpanded(true);
                } else {
                    model.getRoot(0).setExpanded(true);
                }
                model.updateTree();
            }
            BTemplateIOEditor.this.updateTagPanes();
        }
    }

    class CompositeSlot {
        public String name;
        public String ord;
        public String slot;
        public Object handle;
        public Type type;
        public int dir;
        public boolean readonly = false;
        public Taggable taggable = new BasicEntity();
        public static final int IN = 0;
        public static final int OUT = 1;
        public CompositeSlot backup = null;
        public int flags = 0;
        public int childFlags = 0;

        CompositeSlot() {
        }

        private boolean hasValidBindHints() {
            boolean validHints = false;
            Optional optBindHints = this.taggable.tags().get(NIAGARA_BIND_HINTS_TAG.getId());
            if (optBindHints.isPresent()) {
                String predicateStatus = TagSupport.isNeqlPredicateValid(((BIDataValue)optBindHints.get()).toString(), "BindHints");
                validHints = predicateStatus.equals("");
            }
            return validHints;
        }
    }

    public class CompositeModel
    extends TableModel {
        ArrayList<CompositeSlot> kids = new ArrayList();

        public int getRowCount() {
            return this.kids.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return lex.getText("controlAppConfigEditor.dir");
                }
                case 1: {
                    return lex.getText("controlAppConfigEditor.slot");
                }
                case 2: {
                    return lex.getText("controlAppConfigEditor.ord");
                }
            }
            return "";
        }

        public int canAddToModel(BComponent parent, Slot slot) {
            boolean isReadOnly;
            int retValue = NONE_EXIST;
            String ordStr = parent.getSlotPath().toString();
            boolean bl = isReadOnly = (parent.getFlags(slot) & 1) != 0;
            if (isReadOnly) {
                retValue = IN_EXIST;
            }
            for (int j = 0; j < this.getRowCount(); ++j) {
                CompositeSlot temp = this.get(j);
                if ((temp.ord + temp.slot).equals(ordStr + slot.getName())) {
                    if (temp.dir == 1) {
                        retValue |= OUT_EXIST;
                    }
                    if (temp.dir == 0) {
                        retValue |= IN_EXIST;
                    }
                }
                if (retValue == BOTH_EXIST) break;
            }
            return retValue;
        }

        public Object getValueAt(int row, int col) {
            CompositeSlot slot = this.kids.get(row);
            switch (col) {
                case 0: {
                    return slot.dir == 0 ? lex.getText("controlAppConfigEditor.in") : lex.getText("controlAppConfigEditor.out");
                }
                case 1: {
                    return slot.name;
                }
                case 2: {
                    String a = BTemplateIOEditor.this.root.getSlotPath().toString();
                    String b = slot.ord + "/" + slot.slot;
                    return b.substring(a.length());
                }
                case 3: {
                    String neqlStatus = "";
                    String bindHints = "";
                    Optional optBindHints = slot.taggable.tags().get(NIAGARA_BIND_HINTS_TAG.getId());
                    if (optBindHints.isPresent()) {
                        bindHints = ((BIDataValue)optBindHints.get()).toString();
                    }
                    return TagSupport.isNeqlPredicateValid(bindHints, "BindHints");
                }
            }
            return "";
        }

        public Object getSubject(int row) {
            return this.kids.get(row);
        }

        public BImage getRowIcon(int row) {
            CompositeSlot slot = this.kids.get(row);
            return slot.dir == 0 ? inIcon : outIcon;
        }

        public void add(int dir, String name, String ord, String slotName, Type type, boolean readonly, boolean backup, int flags) {
            this.add(dir, name, ord, slotName, type, readonly, backup, flags, null);
        }

        public void add(int dir, String name, String ord, String slotName, Type type, boolean readonly, boolean backup, int flags, Tags tags) {
            CompositeSlot slot = new CompositeSlot();
            slot.name = SlotPath.unescape((String)name);
            slot.ord = ord;
            slot.slot = slotName;
            slot.dir = dir;
            slot.type = type;
            slot.readonly = readonly;
            slot.flags = flags;
            if (tags != null) {
                slot.taggable.tags().merge(tags.getAll());
            }
            if (backup) {
                slot.backup = new CompositeSlot();
                slot.backup.name = name;
                slot.backup.ord = ord;
                slot.backup.slot = slotName;
                slot.backup.dir = dir;
                slot.backup.type = type;
                slot.backup.readonly = readonly;
                slot.backup.flags = flags;
                if (tags != null) {
                    slot.backup.taggable.tags().merge(tags.getAll());
                }
            }
            this.kids.add(slot);
        }

        public void remove(int row) {
            this.kids.remove(row);
        }

        public CompositeSlot get(int row) {
            if (row > this.kids.size()) {
                return null;
            }
            return this.kids.get(row);
        }

        public void move(int row, int newRow) {
            CompositeSlot obj = this.kids.remove(row);
            this.kids.add(newRow, obj);
        }
    }

    public class MoveDown
    extends Command {
        public MoveDown(BWidget owner) {
            super(owner, module, "controlAppConfigEditor.moveDown");
        }

        public CommandArtifact doInvoke() {
            CompositeModel model = (CompositeModel)BTemplateIOEditor.this.table.getModel();
            int[] rows = model.getSelection().getRows();
            if (rows.length == 0 || rows[rows.length - 1] == model.getRowCount() - 1) {
                return null;
            }
            for (int i = rows.length - 1; i >= 0; --i) {
                model.getSelection().deselect(rows[i]);
                model.move(rows[i], rows[i] + 1);
                model.getSelection().select(rows[i] + 1);
            }
            BTemplateIOEditor.this.table.relayout();
            BTemplateIOEditor.this.view.templateModified();
            return null;
        }
    }

    public class MoveUp
    extends Command {
        public MoveUp(BWidget owner) {
            super(owner, module, "controlAppConfigEditor.moveUp");
        }

        public CommandArtifact doInvoke() {
            CompositeModel model = (CompositeModel)BTemplateIOEditor.this.table.getModel();
            int[] rows = model.getSelection().getRows();
            if (rows.length == 0 || rows[0] == 0) {
                return null;
            }
            for (int i = 0; i < rows.length; ++i) {
                model.getSelection().deselect(rows[i]);
                model.move(rows[i], rows[i] - 1);
                model.getSelection().select(rows[i] - 1);
            }
            BTemplateIOEditor.this.table.relayout();
            BTemplateIOEditor.this.view.templateModified();
            return null;
        }
    }

    public class Remove
    extends Command {
        public Remove(BWidget owner) {
            super(owner, module, "controlAppConfigEditor.remove");
        }

        public CommandArtifact doInvoke() {
            CompositeModel model = (CompositeModel)BTemplateIOEditor.this.table.getModel();
            int[] rows = model.getSelection().getRows();
            for (int i = 0; i < rows.length; ++i) {
                CompositeSlot slot = model.get(rows[i] - i);
                if (slot.backup != null) {
                    BTemplateIOEditor.this.removed.add(slot);
                }
                model.remove(rows[i] - i);
            }
            BTemplateIOEditor.this.table.getSelection().deselectAll();
            BTemplateIOEditor.this.table.relayout();
            Model treeModel = (Model)BTemplateIOEditor.this.tree.getModel();
            ((Node)treeModel.getRoot(0)).load(true);
            treeModel.updateTree();
            BTemplateIOEditor.this.view.templateModified();
            return null;
        }
    }

    public class Rename
    extends Command {
        public Rename(BWidget owner) {
            super(owner, module, "controlAppConfigEditor.rename");
        }

        public CommandArtifact doInvoke() {
            int[] rows = BTemplateIOEditor.this.table.getSelection().getRows();
            for (int i = 0; i < rows.length; ++i) {
                int j;
                CompositeSlot slot = ((CompositeModel)BTemplateIOEditor.this.table.getModel()).get(rows[i]);
                BTextField field = new BTextField(slot.name, 25);
                BGridPane grid = new BGridPane(1);
                grid.add(null, (BValue)field);
                BBorderPane pane = new BBorderPane((BWidget)grid, 10.0, 10.0, 10.0, 10.0);
                if (1 != BDialog.open((BWidget)this.getOwner(), (String)lex.getText("controlAppConfigEditor.rename.label"), (Object)pane, (int)3)) break;
                if (slot.name.equals(field.getText())) continue;
                BTemplateIOEditor.this.root.loadSlots();
                Slot[] s = BTemplateIOEditor.this.root.getSlotsArray();
                for (j = 0; j < s.length; ++j) {
                    if (!s[j].getName().equals(field.getText())) continue;
                    BDialog.error((BWidget)this.getOwner(), (String)lex.getText("controlAppConfigEditor.rename.label"), (Object)lex.getText("controlAppConfigEditor.rename.exists"));
                    return null;
                }
                for (j = 0; j < BTemplateIOEditor.this.table.getModel().getRowCount(); ++j) {
                    CompositeSlot cs = ((CompositeModel)BTemplateIOEditor.this.table.getModel()).get(j);
                    if (!cs.name.equals(field.getText())) continue;
                    BDialog.error((BWidget)this.getOwner(), (String)lex.getText("controlAppConfigEditor.rename.label"), (Object)lex.getText("controlAppConfigEditor.rename.exists"));
                    return null;
                }
                slot.name = field.getText();
                BTemplateIOEditor.this.table.repaint();
            }
            BTemplateIOEditor.this.view.templateModified();
            return null;
        }
    }

    public class Reverse
    extends Command {
        public Reverse(BWidget owner) {
            super(owner, module, "controlAppConfigEditor.reverse");
        }

        public CommandArtifact doInvoke() {
            CompositeModel model = (CompositeModel)BTemplateIOEditor.this.table.getModel();
            int[] rows = BTemplateIOEditor.this.table.getSelection().getRows();
            for (int i = 0; i < rows.length; ++i) {
                CompositeSlot slot = model.get(rows[i]);
                if (slot.readonly) continue;
                int n = slot.dir = slot.dir == 0 ? 1 : 0;
                if (slot.type.is(BCompositeAction.TYPE)) {
                    slot.type = BCompositeTopic.TYPE;
                    continue;
                }
                if (slot.readonly || !slot.type.is(BCompositeTopic.TYPE)) continue;
                slot.type = BCompositeAction.TYPE;
            }
            BTemplateIOEditor.this.table.repaint();
            BTemplateIOEditor.this.view.templateModified();
            return null;
        }
    }

    public class Add
    extends Command {
        public Add(BWidget owner) {
            super(owner, module, "controlAppConfigEditor.add");
        }

        public CommandArtifact doInvoke() {
            int i;
            CompositeModel model = (CompositeModel)BTemplateIOEditor.this.table.getModel();
            TreeNode[] nodes = BTemplateIOEditor.this.tree.getSelection().getNodes();
            ArrayList<Integer> newRows = new ArrayList<Integer>();
            for (i = 0; i < nodes.length; ++i) {
                int dir;
                boolean readonly;
                Slot slot;
                int existing;
                Node outNode;
                Node n = (Node)nodes[i];
                if (n.object instanceof BControlPoint && (outNode = (Node)n.getChild("out")) != null) {
                    n = outNode;
                }
                if (n.object instanceof BComponent) continue;
                BComponent parent = (BComponent)((Node)n.getParent()).object;
                String name = n.name;
                if (parent.getType().is(BControlPoint.TYPE)) {
                    name = parent.getName() + '_' + name;
                }
                if ((existing = model.canAddToModel(parent, slot = parent.getSlot(n.name))) == BOTH_EXIST) continue;
                boolean inExists = existing >= IN_EXIST;
                boolean outExists = existing >= OUT_EXIST;
                boolean bl = readonly = slot.isTopic() || Flags.isReadonly((BComplex)parent, (Slot)slot);
                if (outExists && readonly) continue;
                int n2 = dir = readonly ? 1 : 0;
                if (outExists) {
                    dir = 0;
                } else if (inExists) {
                    dir = 1;
                }
                Type type = slot.isTopic() ? BCompositeTopic.TYPE : (slot.isAction() ? (dir == 0 ? BCompositeAction.TYPE : BCompositeTopic.TYPE) : n.object.getType());
                BComponent taggable = new BComponent();
                taggable.tags().set(NIAGARA_BIND_HINTS_TAG);
                taggable.tags().set(NIAGARA_USER_TIP);
                if (dir == 0) {
                    taggable.tags().set(NIAGARA_TEMPLATE_INPUT);
                    taggable.tags().set(NIAGARA_TARGET_SLOT_HINT_TAG);
                } else {
                    taggable.tags().set(NIAGARA_TEMPLATE_OUTPUT);
                    taggable.tags().set(NIAGARA_TARGET_SLOT_HINT_TAG);
                }
                Tags tags = taggable.tags();
                if (parent instanceof BComponent) {
                    ComponentTags parentTags = new ComponentTags(parent);
                    tags.merge(parentTags.getAll());
                }
                String ord = parent.getSlotPath().toString();
                model.add(dir, BTemplateIOEditor.this.getUniqueName(name), ord, n.name, type, readonly, false, 4096, tags);
                newRows.add(new Integer(model.getRowCount() - 1));
            }
            BTemplateIOEditor.this.table.relayout();
            if (newRows.size() > 0) {
                BTemplateIOEditor.this.table.requestFocus();
                BTemplateIOEditor.this.table.getSelection().deselectAll();
                for (i = 0; i < newRows.size(); ++i) {
                    BTemplateIOEditor.this.table.getSelection().select(((Integer)newRows.get(i)).intValue());
                }
            }
            BTemplateIOEditor.this.view.templateModified();
            return null;
        }
    }
}

