/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui;

import com.tridium.platform.BIPlatformConnection;
import com.tridium.template.BConfigBinding;
import com.tridium.template.BTemplateConfig;
import com.tridium.template.application.ApplicationTemplateUtil;
import com.tridium.template.application.NameTree;
import com.tridium.template.manifest.TemplateManifest;
import com.tridium.template.ui.BTemplateView;
import com.tridium.template.ui.file.TmplUtil;
import com.tridium.workbench.ord.RefFilter;
import com.tridium.workbench.ord.RefNode;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.baja.agent.BPxView;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceFolder;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BClientCredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sync.Transaction;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BMarker;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelation;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BExpandablePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableHeaderRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public class BTemplateConfigEditor
extends BEdgePane {
    public static final Type TYPE = Sys.loadType(BTemplateConfigEditor.class);
    public static final RefFilter configProps = new RefFilter(){

        public boolean accept(BObject parent, Slot slot) {
            if (slot == null || parent == null || !slot.isProperty() || !(parent instanceof BComponent)) {
                return false;
            }
            BValue childValue = parent.asComponent().get(slot.asProperty());
            if (childValue instanceof BUsernameAndPassword && (parent instanceof BClientCredentials || parent instanceof BIPlatformConnection)) {
                return true;
            }
            Type slotType = childValue.getType();
            if (slotType.is(BTemplateConfig.TYPE) || slotType.is(BWsAnnotation.TYPE) || slotType.is(BPxView.TYPE) || slotType.is(BMarker.TYPE) || slotType.is(BRelation.TYPE) || slotType.is(BConfigBinding.TYPE) || slotType.is(BPassword.TYPE)) {
                return false;
            }
            if (childValue instanceof BComponent && childValue.asComponent().getSlotCount() == 0) {
                return false;
            }
            int slotFlags = parent.asComplex().getFlags(slot);
            if ((slotFlags & 0x9007) != 0) {
                return false;
            }
            return !slotType.is(BStruct.TYPE) || !TmplUtil.hasPasswordProp((BComplex)childValue.asStruct());
        }
    };
    public static double COL0_MIN_WIDTH = 175.0;
    private static final int COL_NAME = 0;
    private static final int COL_ORD = 1;
    private static final int COL_VALUE = 2;
    private static final int COL_USERTIP = 3;
    private static final int COL_COUNT = 4;
    private static final String USE_NEQL = "useNeql";
    private static final Lexicon lex = Lexicon.make((String)"template");
    private static final Lexicon uiLex = Lexicon.make((String)"bajaui");
    private static final BModule module = Sys.getModuleForClass(BTemplateConfigEditor.class);
    private static final BImage inIcon = BImage.make((String)"module://icons/x16/arrowLeft.png");
    private static final BImage outIcon = BImage.make((String)"module://icons/x16/arrowRight.png");
    private static final BBrush colorProperty = BColor.make((int)13816554).toBrush();
    private static final BBrush colorAction = BColor.make((int)0xB8F8B8).toBrush();
    private static final BBrush colorTopic = BColor.make((int)14934976).toBrush();
    private static final BIcon ADD_BADGE_ICON = BIcon.std((String)"badges/add.png");
    private static final BIcon REMOVE_BADGE_ICON = BIcon.std((String)"badges/remove.png");
    private static final BIcon OPTIONAL_BADGE_ICON = BIcon.std((String)"badges/ellipsis.png");
    private BTemplateConfig templateConfig;
    private final BComponent templateRoot;
    private final BTree tree;
    private final BBindingTable table;
    private final ArrayList<BindingSlot> removed = new ArrayList();
    private final BWidget owner;
    BTemplateView view;
    private Add add;
    private SetValue setValue;
    private SetUserTip setUserTip;
    private Rename rename;
    private Remove remove;
    private MoveUp moveUp;
    private MoveDown moveDown;

    public Type getType() {
        return TYPE;
    }

    public BTemplateConfigEditor() {
        throw new IllegalStateException();
    }

    public BTemplateConfigEditor(BTemplateView view, BComponent templateRoot, BTemplateConfig templateConfig) {
        BConfigBinding[] bindings;
        boolean modified;
        this.owner = view.getShell();
        this.view = view;
        this.templateConfig = templateConfig;
        this.templateRoot = templateRoot;
        this.tree = new BTree((TreeModel)new Model(this.templateRoot, view.isApplicationTemplate(), view.getManifest()));
        this.tree.setMultipleSelection(true);
        this.tree.setController((TreeController)new Controller());
        this.tree.setExpanded(this.tree.getModel().getRoot(0), true);
        this.tree.getModel().updateTree();
        BindingModel model = new BindingModel();
        this.table = new BBindingTable(model);
        this.table.setController(new BindingController());
        this.table.setSelection(new BindingSelection());
        this.table.setCellRenderer(new BindingRenderer());
        this.table.setHeaderRenderer(new BindingHeaderRenderer());
        Knob[] knobs = templateConfig.getKnobs();
        boolean bl = modified = knobs.length > 0;
        if (modified) {
            BDialog.info((BWidget)this.owner, (Object)"Converting Template Configuration property Composite Links to BConfigBindings.  Must click Save to complete.");
            view.setInitModified(modified);
        }
        templateConfig.convertToBindings();
        for (BConfigBinding binding : bindings = templateConfig.getConfigBindings()) {
            String rootSlotPath;
            String targetSlotPath;
            BComponent targetComponent;
            Property sourceProperty;
            String source;
            block6: {
                source = binding.getSourceSlot();
                sourceProperty = templateConfig.getProperty(source);
                targetComponent = null;
                try {
                    targetComponent = (BComponent)binding.getTargetOrd().resolve((BObject)templateConfig).get();
                }
                catch (Exception ignored) {
                    templateConfig.remove((BComplex)binding);
                    if (sourceProperty == null) break block6;
                    templateConfig.remove(sourceProperty);
                }
            }
            if (targetComponent == null || !(targetSlotPath = targetComponent.getSlotPath().toString()).startsWith(rootSlotPath = this.templateRoot.getSlotPath().toString())) continue;
            String target = binding.getTargetSlot();
            String userTip = binding.getUserTip();
            if (sourceProperty == null) continue;
            model.add(0, source, targetSlotPath, (BComplex)targetComponent, target, templateConfig.get(sourceProperty), templateConfig.getSlotFacets((Slot)sourceProperty), sourceProperty.getType(), false, true, templateConfig.getFlags((Slot)sourceProperty), userTip);
        }
        Property[] props = templateConfig.getPropertiesArray();
        int offset = 0;
        for (Property prop : props) {
            for (int j = 0; j < model.getRowCount(); ++j) {
                if (!prop.getName().equals(model.get((int)j).name)) continue;
                model.move(j, offset++);
            }
        }
        BSplitPane split = new BSplitPane();
        split.setDividerPosition(30.0);
        split.setWidget1(this.buildLeftPane());
        split.setWidget2(this.buildRightPane());
        this.setCenter((BWidget)split);
    }

    private BWidget buildLeftPane() {
        this.add = new Add((BWidget)this);
        this.add.setEnabled(false);
        BButton a = new BButton((Command)this.add);
        a.setButtonStyle(BButtonStyle.toolBar);
        BGridPane top = new BGridPane(1);
        top.setHalign(BHalign.left);
        top.add(null, (BValue)a);
        BEdgePane pane = new BEdgePane();
        pane.setTop((BWidget)new BBorderPane((BWidget)top, 5.0, 0.0, 5.0, 0.0));
        pane.setCenter((BWidget)new BBorderPane((BWidget)new BTreePane(this.tree), BBorder.none, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        return pane;
    }

    private BWidget buildRightPane() {
        this.setValue = new SetValue((BWidget)this);
        this.setUserTip = new SetUserTip((BWidget)this);
        this.rename = new Rename((BWidget)this);
        this.remove = new Remove((BWidget)this);
        this.moveUp = new MoveUp((BWidget)this);
        this.moveDown = new MoveDown((BWidget)this);
        this.setValue.setEnabled(false);
        this.setUserTip.setEnabled(false);
        this.rename.setEnabled(false);
        this.remove.setEnabled(false);
        this.moveUp.setEnabled(false);
        this.moveDown.setEnabled(false);
        BButton b = new BButton((Command)this.rename);
        BButton c = new BButton((Command)this.remove);
        BButton d = new BButton((Command)this.moveUp);
        BButton e = new BButton((Command)this.moveDown);
        BButton f = new BButton((Command)this.setValue);
        b.setButtonStyle(BButtonStyle.toolBar);
        c.setButtonStyle(BButtonStyle.toolBar);
        d.setButtonStyle(BButtonStyle.toolBar);
        e.setButtonStyle(BButtonStyle.toolBar);
        f.setButtonStyle(BButtonStyle.toolBar);
        BGridPane topLeft = new BGridPane(3);
        topLeft.add(null, (BValue)b);
        topLeft.add(null, (BValue)c);
        topLeft.add(null, (BValue)f);
        BGridPane topRight = new BGridPane(2);
        topRight.add(null, (BValue)d);
        topRight.add(null, (BValue)e);
        BEdgePane top = new BEdgePane();
        top.setLeft((BWidget)topLeft);
        top.setRight((BWidget)topRight);
        BEdgePane pane = new BEdgePane();
        pane.setTop((BWidget)new BBorderPane((BWidget)top, 5.0, 0.0, 5.0, 0.0));
        pane.setCenter((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        return pane;
    }

    public void save() {
        this.templateConfig = this.createTemplateConfig();
    }

    public BTemplateConfig createTemplateConfig() {
        Context tx = Transaction.start((BComponent)this.templateConfig, null);
        BindingModel model = (BindingModel)this.table.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            BindingSlot slot = model.get(i);
            if (slot.backup == null) {
                this.addConfigSlot(tx, slot);
                continue;
            }
            if (slot.dir == slot.backup.dir) {
                this.renameConfigSlot(tx, slot);
                continue;
            }
            slot.backup.backup = slot.backup;
            this.removeConfigSlot(tx, slot.backup);
            this.addConfigSlot(tx, slot);
        }
        for (BindingSlot slot : this.removed) {
            this.removeConfigSlot(tx, slot);
        }
        try {
            Transaction.end((BComponent)this.templateConfig, (Context)tx);
        }
        catch (Exception e) {
            BDialog.error((BWidget)this.getShell(), (String)"Error", (Object)"createTemplateConfig failed.", (Throwable)e);
        }
        this.reorderConfigSlots();
        this.setConfigSlotsValues();
        return this.templateConfig;
    }

    private void addConfigSlot(Context tx, BindingSlot bindingSlot) {
        BComponent targetComp = (BComponent)BOrd.make((String)bindingSlot.ord).resolve((BObject)this.templateConfig).get();
        BString value = null;
        int flags = 0;
        BFacets facets = BFacets.NULL;
        if (bindingSlot.slotOrAttribute.startsWith("#")) {
            value = BString.DEFAULT;
        } else {
            Slot targetSlot = targetComp.getSlot(bindingSlot.slotOrAttribute);
            if (targetSlot.isProperty()) {
                value = targetComp.get(bindingSlot.slotOrAttribute).newCopy();
                BFacets targetFacets = targetComp.getSlotFacets(targetSlot);
                if (targetFacets != null) {
                    facets = targetFacets;
                }
                bindingSlot.childFlags = targetComp.getFlags(targetSlot);
                flags = bindingSlot.flags;
            }
        }
        if (value != null) {
            this.templateConfig.add(bindingSlot.name, (BValue)value, flags, facets, tx);
            BConfigBinding binding = new BConfigBinding(targetComp.getHandleOrd(), bindingSlot.name, bindingSlot.slotOrAttribute, bindingSlot.userTip);
            this.templateConfig.add(null, (BValue)binding, 4, BFacets.NULL, tx);
        }
    }

    private void renameConfigSlot(Context tx, BindingSlot slot) {
        BConfigBinding[] bindings;
        if (slot.backup.name.equals(slot.name)) {
            return;
        }
        Property prop = this.templateConfig.getProperty(slot.backup.name);
        BString newName = BString.make((String)slot.name);
        this.templateConfig.rename(prop, slot.name, tx);
        for (BConfigBinding binding : bindings = this.templateConfig.getConfigBindings()) {
            String targetOrdString;
            Optional optional = binding.getTarget();
            if (!optional.isPresent() || !(targetOrdString = ((BComplex)optional.get()).asComponent().getSlotPathOrd().toString()).equals(slot.backup.ord) || !binding.getSourceSlot().equals(slot.backup.name)) continue;
            binding.set(BConfigBinding.sourceSlot, (BValue)newName, tx);
            break;
        }
    }

    private void removeConfigSlot(Context tx, BindingSlot slot) {
        BConfigBinding[] bindings;
        for (BConfigBinding binding : bindings = this.templateConfig.getConfigBindings()) {
            BComponent target = binding.getTargetOrd().resolve((BObject)this.templateConfig).get().asComponent();
            if (!target.getSlotPathOrd().toString().equals(slot.backup.ord) || !binding.getSourceSlot().equals(slot.backup.name)) continue;
            this.templateConfig.remove(binding.getPropertyInParent(), tx);
            this.templateConfig.remove(this.templateConfig.getProperty(slot.backup.name), tx);
            return;
        }
        throw new RuntimeException("Could not find config binding for " + slot.backup.name);
    }

    public void reorderConfigSlots() {
        BindingModel model = (BindingModel)this.table.getModel();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < model.getRowCount(); ++i) {
            list.add(model.get((int)i).name);
        }
        this.templateConfig.loadSlots();
        SlotCursor c = this.templateConfig.getProperties();
        while (c.next()) {
            Property p = c.property();
            if (p.isFrozen() || list.contains(p.getName())) continue;
            list.add(p.getName());
        }
        Property[] newProps = new Property[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            newProps[i] = this.templateConfig.getProperty((String)list.get(i));
        }
        if (!list.isEmpty()) {
            this.templateConfig.reorder(newProps);
        }
    }

    public void setConfigSlotsValues() {
        BindingModel model = (BindingModel)this.table.getModel();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < model.getRowCount(); ++i) {
            list.add(model.get((int)i).name);
        }
        SlotCursor c = this.templateConfig.getProperties();
        while (c.next()) {
            int nameIndex;
            Property p = c.property();
            if (p.isFrozen()) continue;
            if (p.getType().is(BConfigBinding.TYPE)) {
                nameIndex = list.indexOf(((BConfigBinding)this.templateConfig.get(p)).getSourceSlot());
                if (nameIndex < 0) continue;
                String userTip = model.get((int)nameIndex).userTip;
                ((BConfigBinding)this.templateConfig.get(p)).setUserTip(userTip);
                continue;
            }
            nameIndex = list.indexOf(p.getName());
            if (nameIndex < 0) continue;
            boolean facetAdded = false;
            BFacets facets = model.get((int)nameIndex).facets;
            if (facets != null) {
                facetAdded = !this.templateConfig.getSlotFacets((Slot)p).equals((Object)facets);
            }
            BValue value = model.get((int)nameIndex).value;
            if (this.templateConfig.get(p).equals((Object)value) && !facetAdded) continue;
            this.templateConfig.set(p, value.newCopy(true));
            if (facets == null) continue;
            this.templateConfig.setFacets((Slot)p, facets);
        }
    }

    private String getUniqueName(String name) {
        BindingModel model = (BindingModel)this.table.getModel();
        this.templateConfig.loadSlots();
        Slot[] s = this.templateConfig.getSlotsArray();
        int count = 1;
        String unescapedTempName = SlotPath.unescape((String)name);
        if (unescapedTempName.chars().filter(ch -> ch == 58).count() == 1L) {
            name = SlotPath.escape((String)unescapedTempName.replace(':', '_'));
        }
        String tempName = name;
        for (int i = 0; i < s.length + model.getRowCount(); ++i) {
            if (i < s.length) {
                if (!s[i].getName().equals(tempName)) continue;
                tempName = name + count;
                ++count;
                i = -1;
                continue;
            }
            BindingSlot cs = model.get(i - s.length);
            if (!cs.name.equals(tempName)) continue;
            tempName = name + count;
            ++count;
            i = -1;
        }
        return tempName;
    }

    public static BComplex getParentOfType(Type parentType, BComplex base) {
        for (BComplex parent = base.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.getType().is(parentType)) continue;
            return parent;
        }
        return null;
    }

    class Controller
    extends TreeController {
        Controller() {
        }

        protected void doSelectAction(TreeNode target, double x, double y) {
            if (BTemplateConfigEditor.this.add.isEnabled()) {
                BTemplateConfigEditor.this.add.invoke();
            }
        }

        public void setFocus(TreeNode node) {
            super.setFocus(node);
            if (node instanceof Node && !(((Node)node).ref.object instanceof BComponent)) {
                BTemplateConfigEditor.this.add.setEnabled(!((Node)node).isExisting());
            } else if (node instanceof AttributeNode) {
                BTemplateConfigEditor.this.add.setEnabled(!((AttributeNode)node).isExisting());
            }
        }
    }

    class AppOptionalDescendantNode
    extends Node {
        AppOptionalDescendantNode(TreeNode parent, RefNode ref) {
            super(parent, ref);
        }

        @Override
        Node makeChildNode(RefNode childRef) {
            if (!(childRef.object instanceof BINavNode)) {
                return super.makeChildNode(childRef);
            }
            return new AppOptionalDescendantNode(this, childRef);
        }

        @Override
        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.make((BIcon)this.ref.object.getIcon(), (BIcon)OPTIONAL_BADGE_ICON));
        }
    }

    class AppOptionalComponentNode
    extends Node {
        AppOptionalComponentNode(TreeNode parent, RefNode ref) {
            super(parent, ref);
        }

        @Override
        Node makeChildNode(RefNode childRef) {
            if (!(childRef.object instanceof BINavNode)) {
                return super.makeChildNode(childRef);
            }
            return new AppOptionalDescendantNode(this, childRef);
        }

        @Override
        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.make((BIcon)this.ref.object.getIcon(), (BIcon)OPTIONAL_BADGE_ICON));
        }
    }

    class AppExcludedDescendantNode
    extends Node {
        AppExcludedDescendantNode(TreeNode parent, RefNode ref) {
            super(parent, ref);
        }

        @Override
        Node makeChildNode(RefNode childRef) {
            if (!(childRef.object instanceof BINavNode)) {
                return super.makeChildNode(childRef);
            }
            return new AppExcludedDescendantNode(this, childRef);
        }

        @Override
        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.make((BIcon)this.ref.object.getIcon(), (BIcon)REMOVE_BADGE_ICON));
        }
    }

    class AppExcludedComponentNode
    extends Node {
        AppExcludedComponentNode(TreeNode parent, RefNode ref) {
            super(parent, ref);
        }

        @Override
        Node makeChildNode(RefNode childRef) {
            if (!(childRef.object instanceof BINavNode)) {
                return super.makeChildNode(childRef);
            }
            return new AppExcludedDescendantNode(this, childRef);
        }

        @Override
        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.make((BIcon)this.ref.object.getIcon(), (BIcon)REMOVE_BADGE_ICON));
        }
    }

    class AppIncludedDescendantNode
    extends Node {
        AppIncludedDescendantNode(TreeNode parent, RefNode ref) {
            super(parent, ref);
        }

        @Override
        Node makeChildNode(RefNode childRef) {
            if (!(childRef.object instanceof BINavNode)) {
                return super.makeChildNode(childRef);
            }
            if (this.getTree().getModel() instanceof Model && ((Model)this.getTree().getModel()).isOptionalNode((BINavNode)childRef.object)) {
                return new AppOptionalDescendantNode(this, childRef);
            }
            return new AppIncludedDescendantNode(this, childRef);
        }

        @Override
        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.make((BIcon)this.ref.object.getIcon(), (BIcon)ADD_BADGE_ICON));
        }
    }

    class AppIncludedComponentNode
    extends Node {
        AppIncludedComponentNode(TreeNode parent, RefNode ref) {
            super(parent, ref);
        }

        @Override
        Node makeChildNode(RefNode childRef) {
            if (!(childRef.object instanceof BINavNode)) {
                return super.makeChildNode(childRef);
            }
            if (this.getTree().getModel() instanceof Model && ((Model)this.getTree().getModel()).isOptionalNode((BINavNode)childRef.object)) {
                return new AppOptionalDescendantNode(this, childRef);
            }
            return new AppIncludedDescendantNode(this, childRef);
        }

        @Override
        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.make((BIcon)this.ref.object.getIcon(), (BIcon)ADD_BADGE_ICON));
        }
    }

    class AppMergedContainerNode
    extends Node {
        final NameTree exclusions;

        AppMergedContainerNode(TreeModel model, RefNode ref, NameTree exclusions) {
            super(model, ref);
            assert (exclusions != null);
            this.exclusions = exclusions;
        }

        AppMergedContainerNode(TreeNode parent, RefNode ref, NameTree exclusions) {
            super(parent, ref);
            assert (exclusions != null);
            this.exclusions = exclusions;
        }

        @Override
        Node makeChildNode(RefNode childRef) {
            if (!(childRef.object instanceof BINavNode)) {
                return super.makeChildNode(childRef);
            }
            if (this.getTree().getModel() instanceof Model && ((Model)this.getTree().getModel()).isOptionalNode((BINavNode)childRef.object)) {
                return new AppOptionalComponentNode(this, childRef);
            }
            if (!this.exclusions.has(childRef.name)) {
                return new AppIncludedComponentNode(this, childRef);
            }
            NameTree childExclusions = this.exclusions.fetch(childRef.name);
            if (childExclusions == null) {
                return new AppExcludedComponentNode(this, childRef);
            }
            return new AppMergedContainerNode(this, childRef, childExclusions);
        }
    }

    static class NodeGroup
    extends TreeNode {
        private final String groupName;
        private final ArrayList<TreeNode> kids = new ArrayList();

        public NodeGroup(TreeNode parent, String groupName) {
            super(parent);
            this.groupName = groupName;
        }

        public String getText() {
            return this.groupName;
        }

        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.std((String)"folder.png"));
        }

        public int getChildCount() {
            return this.kids.size();
        }

        public TreeNode getChild(int index) {
            return this.kids.get(index);
        }

        public void addChild(TreeNode child) {
            this.kids.add(child);
        }
    }

    class DisplayNameNode
    extends AttributeNode {
        DisplayNameNode(TreeNode parent) {
            super(parent);
        }

        public String getText() {
            return lex.get("configEditorTree.displayNameAttribute.label");
        }

        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.std((String)"rename.png"));
        }

        @Override
        public String id() {
            return "#DisplayName";
        }

        @Override
        public String defaultSlotName(String parentName) {
            return lex.getText("controlAppConfigEditor.displayNameAttribute.default", new Object[]{parentName});
        }

        @Override
        public BValue defaultValue(String parentName) {
            return BString.DEFAULT;
        }

        @Override
        public Type configType() {
            return BString.TYPE;
        }
    }

    class NameNode
    extends AttributeNode {
        NameNode(TreeNode parent) {
            super(parent);
        }

        public String getText() {
            return lex.get("configEditorTree.nameAttribute.label");
        }

        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.std((String)"rename.png"));
        }

        @Override
        public String id() {
            return "#Name";
        }

        @Override
        public String defaultSlotName(String parentName) {
            return lex.getText("controlAppConfigEditor.nameAttribute.default", new Object[]{parentName});
        }

        @Override
        public BValue defaultValue(String parentName) {
            return BString.make((String)parentName);
        }

        @Override
        public Type configType() {
            return BString.TYPE;
        }
    }

    abstract class AttributeNode
    extends TreeNode {
        AttributeNode(TreeNode parent) {
            super(parent);
        }

        public int getChildCount() {
            return 0;
        }

        public TreeNode getChild(int index) {
            return null;
        }

        boolean isExisting() {
            BindingModel model = (BindingModel)BTemplateConfigEditor.this.table.getModel();
            TreeNode parent = this.getParent();
            if (parent instanceof NodeGroup) {
                parent = parent.getParent();
            }
            if (!(parent instanceof Node)) {
                return false;
            }
            BObject refParent = ((Node)parent).ref.object;
            if (!refParent.isComponent()) {
                return false;
            }
            return model.isExisting(refParent.asComponent(), this.id());
        }

        public abstract String id();

        public abstract String defaultSlotName(String var1);

        public abstract BValue defaultValue(String var1);

        public abstract Type configType();
    }

    class Node
    extends TreeNode {
        RefNode ref;
        TreeNode[] kids;

        public Node(TreeModel model, RefNode ref) {
            super(model);
            this.ref = ref;
        }

        public Node(TreeNode parent, RefNode ref) {
            super(parent);
            this.ref = ref;
        }

        public Object getSubject() {
            return this.ref;
        }

        public String getText() {
            return this.ref.text;
        }

        public BImage getIcon() {
            BImage icon = this.ref.icon;
            return this.isExisting() ? icon.getDisabledImage() : icon;
        }

        public boolean hasChildren() {
            if (!(this.ref.object instanceof BComponent)) {
                return false;
            }
            if (this.kids == null) {
                return true;
            }
            return this.kids.length > 0;
        }

        public int getChildCount() {
            if (this.kids == null) {
                this.getChild(-1);
            }
            return this.kids.length;
        }

        public TreeNode getChild(int index) {
            if (this.kids == null) {
                this.load();
            }
            return index == -1 ? null : this.kids[index];
        }

        public TreeNode getChild(String name) {
            if (this.kids == null) {
                this.load();
            }
            for (TreeNode kid : this.kids) {
                if (!(kid instanceof Node) || !((Node)kid).ref.name.equals(name)) continue;
                return kid;
            }
            return null;
        }

        private void load() {
            this.load(false);
        }

        private void load(boolean clear) {
            if (clear) {
                this.kids = null;
            }
            if (this.kids == null) {
                RefNode[] refs;
                ArrayList<TreeNode> list = new ArrayList<TreeNode>();
                if (this.ref.object != null && this.ref.object.isComponent()) {
                    Property p;
                    NodeGroup attributesNode = this.makeNodeGroup(lex.get("configEditorTree.attributesGroup.label"));
                    if (BTemplateConfigEditor.this.view.isApplicationTemplate() && (this.ref.object instanceof BDevice || this.ref.object instanceof BDeviceFolder) && (p = this.ref.object.asComponent().getPropertyInParent()) != null && p.isDynamic()) {
                        this.makeNameNode(attributesNode);
                    }
                    this.makeDisplayNameNode(attributesNode);
                    list.add(attributesNode);
                }
                for (RefNode childRef : refs = this.ref.getChildren(configProps)) {
                    list.add(this.makeChildNode(childRef));
                }
                this.kids = new TreeNode[list.size()];
                list.toArray(this.kids);
            }
        }

        boolean isExisting() {
            BindingModel model = (BindingModel)BTemplateConfigEditor.this.table.getModel();
            BObject refObject = this.ref.object;
            if (refObject == null || this.ref.parent == null || !(this.ref.parent instanceof BComponent)) {
                return false;
            }
            return model.isExisting(this.ref.parent.asComponent(), this.ref.slot);
        }

        Node makeChildNode(RefNode childRef) {
            return new Node(this, childRef);
        }

        NodeGroup makeNodeGroup(String name) {
            return new NodeGroup(this, name);
        }

        TreeNode makeNameNode(NodeGroup group) {
            NameNode node = new NameNode(group == null ? this : group);
            if (group != null) {
                group.addChild(node);
            }
            return node;
        }

        TreeNode makeDisplayNameNode(NodeGroup group) {
            DisplayNameNode node = new DisplayNameNode(group == null ? this : group);
            if (group != null) {
                group.addChild(node);
            }
            return node;
        }
    }

    class Model
    extends TreeModel {
        final Node root;
        private final TemplateManifest manifest;

        public Model(BComponent rootNode, boolean isApplicationTemplate, TemplateManifest manifest) {
            this.root = isApplicationTemplate ? new AppMergedContainerNode(this, new RefNode((BComplex)rootNode), ApplicationTemplateUtil.describeDefaultStation(null)) : new Node(this, new RefNode((BComplex)rootNode));
            this.manifest = manifest;
        }

        public int getRootCount() {
            return 1;
        }

        public TreeNode getRoot(int index) {
            return this.root;
        }

        boolean isOptionalNode(BINavNode navNode) {
            OrdQuery[] queries;
            for (OrdQuery query : queries = navNode.getNavOrd().parse()) {
                if (!(query instanceof SlotPath) || query == null || !this.manifest.optional.contains((Object)BOrd.make((OrdQuery)query))) continue;
                return true;
            }
            return false;
        }
    }

    public class BindingRenderer
    extends TableCellRenderer {
        public BBrush getBackground(TableCellRenderer.Cell cell) {
            if (cell.column == 2) {
                return BColor.white.toBrush();
            }
            return colorProperty;
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            double width = super.getPreferredCellWidth(cell);
            if (cell.column == 0 && width < COL0_MIN_WIDTH) {
                return COL0_MIN_WIDTH;
            }
            return width;
        }
    }

    static class BindingHeaderRenderer
    extends TableHeaderRenderer {
        BindingHeaderRenderer() {
        }

        public double getPreferredHeaderWidth(TableHeaderRenderer.Header header) {
            double width = super.getPreferredHeaderWidth(header);
            if (header.column == 0 && width < COL0_MIN_WIDTH) {
                return COL0_MIN_WIDTH;
            }
            return width;
        }
    }

    public static class BBindingTable
    extends BTable {
        public BBindingTable(TableModel model) {
            super(model);
        }

        public double getCellWidth(int col) {
            return super.getCellWidth(col);
        }
    }

    class BindingSelection
    extends TableSelection {
        BindingSelection() {
        }

        public void updateTable() {
            super.updateTable();
            int[] rows = this.getRows();
            BTemplateConfigEditor.this.rename.setEnabled(rows.length > 0);
            BTemplateConfigEditor.this.remove.setEnabled(rows.length > 0);
            BTemplateConfigEditor.this.moveUp.setEnabled(rows.length > 0);
            BTemplateConfigEditor.this.moveDown.setEnabled(rows.length > 0);
            BTemplateConfigEditor.this.setValue.setEnabled(rows.length > 0);
            BTemplateConfigEditor.this.setUserTip.setEnabled(rows.length > 0);
        }
    }

    class BindingController
    extends TableController {
        BindingController() {
        }

        public void keyPressed(BKeyEvent event) {
            super.keyPressed(event);
            if (event.getKeyCode() == 127 && BTemplateConfigEditor.this.remove.isEnabled()) {
                BTemplateConfigEditor.this.remove.invoke();
            }
        }

        protected void handleEnter(BKeyEvent event) {
            event.consume();
            if (BTemplateConfigEditor.this.rename.isEnabled()) {
                BTemplateConfigEditor.this.rename.invoke();
            }
            BTemplateConfigEditor.this.table.repaint();
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            if (column == 2) {
                BTemplateConfigEditor.this.setValue.invoke();
            } else if (column == 3) {
                BTemplateConfigEditor.this.setUserTip.invoke();
            } else if (BTemplateConfigEditor.this.rename.isEnabled()) {
                BTemplateConfigEditor.this.rename.invoke();
            }
            BTemplateConfigEditor.this.table.repaint();
        }

        protected void checkSelection(BMouseEvent event, int row) {
            super.checkSelection(event, row);
            this.syncTree();
        }

        protected void syncTree() {
            TableSelection cacSel = BTemplateConfigEditor.this.table.getSelection();
            int selRow = cacSel.getRow();
            if (selRow >= 0) {
                BindingSlot slot = ((BindingModel)BTemplateConfigEditor.this.table.getModel()).get(selRow);
                BComponent child = (BComponent)BOrd.make((String)slot.ord).resolve((BObject)BTemplateConfigEditor.this.templateConfig).get();
                TreeModel model = BTemplateConfigEditor.this.tree.getModel();
                SlotPath initialPath = child.getSlotPath();
                SlotPath rootPath = BTemplateConfigEditor.this.templateRoot.getSlotPath();
                if (initialPath != null) {
                    Node temp;
                    String[] names = initialPath.getNames();
                    String[] rootNames = rootPath.getNames();
                    Node node = (Node)model.getRoot(0);
                    for (int i = rootNames.length; i < names.length && (temp = (Node)node.getChild(names[i])) != null; ++i) {
                        node = temp;
                    }
                    TreeNode selectNode = node;
                    if (slot.slotOrAttribute.startsWith("#")) {
                        AttributeNode attributeNode = this.FindChildAttributeNode(node, slot.slotOrAttribute);
                        if (attributeNode != null) {
                            selectNode = attributeNode;
                        }
                    } else {
                        temp = (Node)node.getChild(slot.slotOrAttribute);
                        if (temp != null) {
                            selectNode = temp;
                        }
                    }
                    TreeNode[] path = selectNode.getPathFromRoot();
                    BTemplateConfigEditor.this.tree.scrollPathToVisible(path);
                    TreeNode n = path[path.length - 1];
                    BTemplateConfigEditor.this.tree.getSelection().deselectAll();
                    BTemplateConfigEditor.this.tree.getSelection().select(n);
                    BTemplateConfigEditor.this.tree.getController().setFocus(BTemplateConfigEditor.this.tree.getSelection().getNode());
                    n.setExpanded(true);
                } else {
                    model.getRoot(0).setExpanded(true);
                }
                model.updateTree();
            }
        }

        private AttributeNode FindChildAttributeNode(TreeNode node, String attributeId) {
            AttributeNode childAttributeNode = null;
            for (int i = 0; childAttributeNode == null && i < node.getChildCount(); ++i) {
                AttributeNode possible;
                TreeNode childNode = node.getChild(i);
                if (childNode instanceof NodeGroup) {
                    childAttributeNode = this.FindChildAttributeNode(childNode, attributeId);
                    continue;
                }
                if (!(childNode instanceof AttributeNode) || !attributeId.equals((possible = (AttributeNode)childNode).id())) continue;
                childAttributeNode = possible;
            }
            return childAttributeNode;
        }
    }

    public static class BindingSlot {
        public String name;
        public String ord;
        public String slotOrAttribute;
        public BValue value;
        public BFacets facets;
        public BComplex parent;
        public Type type;
        public int dir;
        public boolean readonly = false;
        public String userTip;
        public static final int IN = 0;
        public static final int OUT = 1;
        public BindingSlot backup = null;
        public int flags = 0;
        public int childFlags = 0;
    }

    public class BindingModel
    extends TableModel {
        ArrayList<BindingSlot> kids = new ArrayList();

        public int getRowCount() {
            return this.kids.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return lex.getText("controlAppConfigEditor.slot");
                }
                case 1: {
                    return lex.getText("controlAppConfigEditor.ord");
                }
                case 2: {
                    return lex.getText("controlAppConfigEditor.value");
                }
                case 3: {
                    return lex.getText("controlAppConfigEditor.userTip");
                }
            }
            return "";
        }

        public Object getValueAt(int row, int col) {
            BindingSlot slot = this.kids.get(row);
            switch (col) {
                case 0: {
                    return SlotPath.unescape((String)slot.name);
                }
                case 1: {
                    String a = BTemplateConfigEditor.this.templateRoot.getSlotPath().toString();
                    String b = slot.ord + "/" + slot.slotOrAttribute;
                    return b.substring(a.length());
                }
                case 2: {
                    if (slot.value instanceof BPassword) {
                        return "";
                    }
                    if (slot.value instanceof BUsernameAndPassword) {
                        return ((BUsernameAndPassword)slot.value).getUsername();
                    }
                    return slot.value.toString((Context)slot.facets);
                }
                case 3: {
                    return slot.userTip;
                }
            }
            return "";
        }

        public Object getSubject(int row) {
            return this.kids.get(row);
        }

        public void add(int dir, String name, String ord, BComplex parent, String slotOrAttribute, BValue value, BFacets facets, Type type, boolean readonly, boolean backup, int flags, String userTip) {
            BindingSlot slot = new BindingSlot();
            slot.name = name;
            slot.ord = ord;
            slot.parent = parent;
            slot.slotOrAttribute = slotOrAttribute;
            slot.dir = dir;
            slot.value = value;
            slot.facets = facets;
            slot.type = type;
            slot.readonly = readonly;
            slot.flags = flags;
            slot.userTip = userTip;
            if (backup) {
                slot.backup = new BindingSlot();
                slot.backup.name = name;
                slot.backup.ord = ord;
                slot.backup.parent = parent;
                slot.backup.slotOrAttribute = slotOrAttribute;
                slot.backup.dir = dir;
                slot.backup.value = value;
                slot.backup.type = type;
                slot.backup.readonly = readonly;
                slot.backup.flags = flags;
                slot.backup.userTip = userTip;
            }
            this.kids.add(slot);
        }

        public void remove(int row) {
            this.kids.remove(row);
        }

        public BindingSlot get(int row) {
            if (row > this.kids.size()) {
                return null;
            }
            return this.kids.get(row);
        }

        public void move(int row, int newRow) {
            BindingSlot obj = this.kids.remove(row);
            this.kids.add(newRow, obj);
        }

        boolean isExisting(BComponent parent, Slot slot) {
            String slotName = slot == null ? null : slot.getName();
            return this.isExisting(parent, slotName);
        }

        boolean isExisting(BComponent parent, String slotOrAttribute) {
            String parentOrd = parent.getSlotPath().toString();
            for (BindingSlot kid : this.kids) {
                if (!kid.ord.equals(parentOrd) || !Objects.equals(slotOrAttribute, kid.slotOrAttribute)) continue;
                return true;
            }
            return false;
        }
    }

    public class MoveDown
    extends Command {
        public MoveDown(BWidget owner) {
            super(owner, module, "controlAppConfigEditor.moveDown");
        }

        public CommandArtifact doInvoke() {
            BindingModel model = (BindingModel)BTemplateConfigEditor.this.table.getModel();
            int[] rows = model.getSelection().getRows();
            if (rows.length == 0 || rows[rows.length - 1] == model.getRowCount() - 1) {
                return null;
            }
            for (int i = rows.length - 1; i >= 0; --i) {
                model.getSelection().deselect(rows[i]);
                model.move(rows[i], rows[i] + 1);
                model.getSelection().select(rows[i] + 1);
            }
            BTemplateConfigEditor.this.table.relayout();
            BTemplateConfigEditor.this.view.templateModified();
            return null;
        }
    }

    public class MoveUp
    extends Command {
        public MoveUp(BWidget owner) {
            super(owner, module, "controlAppConfigEditor.moveUp");
        }

        public CommandArtifact doInvoke() {
            BindingModel model = (BindingModel)BTemplateConfigEditor.this.table.getModel();
            int[] rows = model.getSelection().getRows();
            if (rows.length == 0 || rows[0] == 0) {
                return null;
            }
            for (int row : rows) {
                model.getSelection().deselect(row);
                model.move(row, row - 1);
                model.getSelection().select(row - 1);
            }
            BTemplateConfigEditor.this.table.relayout();
            BTemplateConfigEditor.this.view.templateModified();
            return null;
        }
    }

    public class Remove
    extends Command {
        public Remove(BWidget owner) {
            super(owner, module, "controlAppConfigEditor.remove");
        }

        public CommandArtifact doInvoke() {
            BindingModel model = (BindingModel)BTemplateConfigEditor.this.table.getModel();
            int[] rows = model.getSelection().getRows();
            for (int i = 0; i < rows.length; ++i) {
                BindingSlot cSlot = model.get(rows[i] - i);
                if (cSlot.backup != null) {
                    BTemplateConfigEditor.this.removed.add(cSlot);
                }
                model.remove(rows[i] - i);
            }
            BTemplateConfigEditor.this.table.getSelection().deselectAll();
            BTemplateConfigEditor.this.table.relayout();
            Model treeModel = (Model)BTemplateConfigEditor.this.tree.getModel();
            ((Node)treeModel.getRoot(0)).load(true);
            treeModel.updateTree();
            BTemplateConfigEditor.this.view.templateModified();
            return null;
        }
    }

    public class SetUserTip
    extends Command {
        public SetUserTip(BWidget owner) {
            super(owner, module, "controlAppConfigEditor.setUserTip");
        }

        public CommandArtifact doInvoke() {
            int[] rows;
            for (int row : rows = BTemplateConfigEditor.this.table.getSelection().getRows()) {
                String newString;
                BindingSlot slot = ((BindingModel)BTemplateConfigEditor.this.table.getModel()).get(row);
                BString valueAt = BString.make((String)slot.userTip);
                BWbFieldEditor editor = BWbFieldEditor.makeFor((BObject)valueAt);
                editor.loadValue((BObject)valueAt);
                BGridPane grid = new BGridPane(1);
                grid.add(null, (BValue)new BLabel(SlotPath.unescape((String)slot.name)));
                grid.add(null, (BValue)editor);
                BBorderPane pane = new BBorderPane((BWidget)grid, 10.0, 10.0, 10.0, 10.0);
                if (1 != BDialog.open((BWidget)BTemplateConfigEditor.this.view, (String)lex.getText("controlAppConfigEditor.setUserTip.label"), (Object)pane, (int)3)) break;
                BValue newValue = null;
                try {
                    newValue = editor.saveValue().asValue();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (newValue == null || slot.userTip.contentEquals(newString = newValue.toString())) continue;
                slot.userTip = newString;
                BTemplateConfigEditor.this.table.repaint();
            }
            BTemplateConfigEditor.this.view.templateModified();
            return null;
        }
    }

    public class SetValue
    extends Command {
        public SetValue(BWidget owner) {
            super(owner, module, "controlAppConfigEditor.setValue");
        }

        public CommandArtifact doInvoke() {
            int[] rows;
            for (int row : rows = BTemplateConfigEditor.this.table.getSelection().getRows()) {
                BindingSlot slot = ((BindingModel)BTemplateConfigEditor.this.table.getModel()).get(row);
                BValue editingValue = slot.value;
                if (editingValue instanceof BPassword) continue;
                BFacets editorFacets = slot.facets;
                String editorName = slot.name;
                if (editingValue instanceof BUsernameAndPassword) {
                    BUsernameAndPassword usernameAndPassword = (BUsernameAndPassword)editingValue;
                    Property username = usernameAndPassword.getProperty("username");
                    editingValue = usernameAndPassword.get(username);
                    editorFacets = username.getFacets();
                    editorName = username.getName();
                }
                boolean isNiagaraProxyExt = false;
                BComplex parent = slot.parent;
                BCheckBox useNeqlCheckbox = new BCheckBox(lex.getText("controlAppConfigEditor.setValue.useNeql"));
                if ("NiagaraProxyExt".equals(parent.getType().getTypeName())) {
                    isNiagaraProxyExt = true;
                }
                BWbFieldEditor editor = BWbFieldEditor.makeFor((BObject)editingValue);
                editor.loadValue((BObject)editingValue, (Context)editorFacets);
                BWidget content = editor.getContent();
                if (content instanceof BExpandablePane) {
                    ((BExpandablePane)content).setExpanded(true);
                }
                BGridPane grid = new BGridPane(1);
                grid.add(null, (BValue)new BLabel(editorName));
                grid.add(null, (BValue)editor);
                BBoolean isUseNeqlSelected = (BBoolean)editorFacets.get(BTemplateConfigEditor.USE_NEQL, (BObject)BBoolean.FALSE);
                if (isNiagaraProxyExt) {
                    useNeqlCheckbox.setSelected(isUseNeqlSelected.getBoolean());
                    grid.add(BTemplateConfigEditor.USE_NEQL, (BValue)useNeqlCheckbox);
                }
                BConstrainedPane pane = new BConstrainedPane((BWidget)grid);
                boolean validEntry = false;
                BValue newValue = null;
                while (!validEntry && 1 == BDialog.open((BWidget)this.getOwner(), (String)lex.getText("controlAppConfigEditor.setValue.label"), (Object)pane, (int)3)) {
                    try {
                        newValue = editor.saveValue().asValue();
                    }
                    catch (Exception e) {
                        BDialog.error((BWidget)BTemplateConfigEditor.this.owner, (Object)(uiLex.getText("plugin.saveProp.error", new Object[]{SlotPath.unescape((String)slot.name)}) + " " + e.getLocalizedMessage()));
                        continue;
                    }
                    validEntry = true;
                }
                if (newValue == null || editingValue.equals(newValue) && isUseNeqlSelected.getBoolean() == useNeqlCheckbox.isSelected()) continue;
                if (slot.value instanceof BUsernameAndPassword) {
                    BUsernameAndPassword usernameAndPassword = (BUsernameAndPassword)slot.value;
                    usernameAndPassword.setUsername(newValue.toString());
                } else {
                    slot.value = newValue;
                    slot.facets = useNeqlCheckbox.isSelected() ? BFacets.make((BFacets)editorFacets, (String)BTemplateConfigEditor.USE_NEQL, (BIDataValue)BBoolean.TRUE) : BFacets.makeRemove((BFacets)editorFacets, (String)BTemplateConfigEditor.USE_NEQL);
                }
                BTemplateConfigEditor.this.table.repaint();
                BTemplateConfigEditor.this.view.templateModified();
            }
            return null;
        }
    }

    public class Rename
    extends Command {
        public Rename(BWidget owner) {
            super(owner, module, "controlAppConfigEditor.rename");
        }

        public CommandArtifact doInvoke() {
            int[] rows;
            for (int row : rows = BTemplateConfigEditor.this.table.getSelection().getRows()) {
                Slot[] s;
                BindingSlot slot = ((BindingModel)BTemplateConfigEditor.this.table.getModel()).get(row);
                BTextField field = new BTextField(SlotPath.unescape((String)slot.name), 25);
                BGridPane grid = new BGridPane(1);
                grid.add(null, (BValue)field);
                BBorderPane pane = new BBorderPane((BWidget)grid, 10.0, 10.0, 10.0, 10.0);
                if (1 != BDialog.open((BWidget)this.getOwner(), (String)lex.getText("controlAppConfigEditor.rename.label"), (Object)pane, (int)3)) break;
                if (slot.name.equals(SlotPath.escape((String)field.getText()))) continue;
                BTemplateConfigEditor.this.templateConfig.loadSlots();
                for (Slot value : s = BTemplateConfigEditor.this.templateConfig.getSlotsArray()) {
                    if (!value.getName().equals(SlotPath.escape((String)field.getText()))) continue;
                    BDialog.error((BWidget)this.getOwner(), (String)lex.getText("controlAppConfigEditor.rename.label"), (Object)lex.getText("controlAppConfigEditor.rename.exists"));
                    return null;
                }
                for (int i = 0; i < BTemplateConfigEditor.this.table.getModel().getRowCount(); ++i) {
                    BindingSlot cs = ((BindingModel)BTemplateConfigEditor.this.table.getModel()).get(i);
                    if (!cs.name.equals(SlotPath.escape((String)field.getText()))) continue;
                    BDialog.error((BWidget)this.getOwner(), (String)lex.getText("controlAppConfigEditor.rename.label"), (Object)lex.getText("controlAppConfigEditor.rename.exists"));
                    return null;
                }
                slot.name = SlotPath.escape((String)field.getText());
                BTemplateConfigEditor.this.table.repaint();
            }
            BTemplateConfigEditor.this.view.templateModified();
            return null;
        }
    }

    public class Add
    extends Command {
        public Add(BWidget owner) {
            super(owner, module, "controlAppConfigEditor.add");
        }

        public CommandArtifact doInvoke() {
            BindingModel model = (BindingModel)BTemplateConfigEditor.this.table.getModel();
            TreeNode[] nodes = BTemplateConfigEditor.this.tree.getSelection().getNodes();
            ArrayList<Integer> newRows = new ArrayList<Integer>();
            for (TreeNode node : nodes) {
                int dir;
                boolean readonly;
                String ord;
                if (node instanceof AttributeNode) {
                    AttributeNode attributeNode = (AttributeNode)node;
                    TreeNode parentNode = attributeNode.getParent();
                    if (parentNode instanceof NodeGroup) {
                        parentNode = parentNode.getParent();
                    }
                    BComponent parent = ((Node)parentNode).ref.object.asComponent();
                    ord = parent.getSlotPath().toString();
                    boolean hasEntry = false;
                    for (int j = 0; j < model.getRowCount(); ++j) {
                        BindingSlot temp = model.get(j);
                        if (!temp.slotOrAttribute.equals(attributeNode.id()) || !temp.ord.equals(ord)) continue;
                        hasEntry = true;
                        break;
                    }
                    if (hasEntry) continue;
                    String parentName = parent.getName();
                    String configName = attributeNode.defaultSlotName(parentName);
                    BValue defaultValue = attributeNode.defaultValue(parentName);
                    Type configType = attributeNode.configType();
                    model.add(0, BTemplateConfigEditor.this.getUniqueName(configName), ord, (BComplex)parent, attributeNode.id(), defaultValue, BFacets.NULL, configType, false, false, 0, "");
                    newRows.add(model.getRowCount() - 1);
                    continue;
                }
                if (!(node instanceof Node)) continue;
                Node n = (Node)node;
                if (n.ref.object instanceof BComponent || !(((Node)n.getParent()).ref.object instanceof BComponent)) continue;
                BComponent parent = (BComponent)((Node)n.getParent()).ref.object;
                String name = n.ref.name;
                if (parent instanceof BControlPoint) {
                    name = parent.getName() + '_' + name;
                } else {
                    BControlPoint parentPoint = (BControlPoint)BTemplateConfigEditor.getParentOfType(BControlPoint.TYPE, (BComplex)parent);
                    if (parentPoint != null) {
                        name = parentPoint.getName() + '_' + name;
                    }
                }
                ord = parent.getSlotPath().toString();
                Slot slot = parent.getSlot(n.ref.name);
                boolean inExists = false;
                boolean outExists = false;
                for (int j = 0; j < model.getRowCount(); ++j) {
                    BindingSlot temp = model.get(j);
                    if (!(temp.ord + temp.slotOrAttribute).equals(ord + slot.getName())) continue;
                    if (temp.dir == 1) {
                        outExists = true;
                    }
                    if (temp.dir != 0) continue;
                    inExists = true;
                }
                if (inExists && outExists) continue;
                boolean bl = readonly = slot.isTopic() || Flags.isReadonly((BComplex)parent, (Slot)slot);
                if (outExists && readonly) continue;
                int n2 = dir = readonly ? 1 : 0;
                if (outExists) {
                    dir = 0;
                } else if (inExists) {
                    dir = 1;
                }
                Type type = n.ref.object.getType();
                if (slot.isTopic() || slot.isAction()) continue;
                BFacets facets = parent.getSlotFacets(slot);
                model.add(dir, BTemplateConfigEditor.this.getUniqueName(name), ord, (BComplex)parent, n.ref.name, (BValue)n.ref.object, facets, type, readonly, false, parent.getFlags(slot), "");
                newRows.add(model.getRowCount() - 1);
            }
            if (newRows.size() > 0) {
                BTemplateConfigEditor.this.table.requestFocus();
                BTemplateConfigEditor.this.table.getSelection().deselectAll();
                for (Integer newRow : newRows) {
                    BTemplateConfigEditor.this.table.getSelection().select(newRow.intValue());
                }
                BTemplateConfigEditor.this.table.computePreferredSize();
                BTemplateConfigEditor.this.table.relayout();
                Model treeModel = (Model)BTemplateConfigEditor.this.tree.getModel();
                ((Node)treeModel.getRoot(0)).load(true);
                treeModel.updateTree();
                ((BindingController)BTemplateConfigEditor.this.table.getController()).syncTree();
                BTemplateConfigEditor.this.view.templateModified();
            }
            return null;
        }
    }
}

