/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.template.application.ApplicationTemplateUtil;
import com.tridium.template.file.BNtplFile;
import com.tridium.template.manifest.TemplateManifest;
import com.tridium.template.ui.ApplicationNavTreeModel;
import com.tridium.template.ui.BTemplateBogEditor;
import com.tridium.template.ui.ExcludedComponentNavTreeNode;
import com.tridium.template.ui.ExcludedDescendantNavTreeNode;
import com.tridium.template.ui.IncludedComponentNavTreeNode;
import com.tridium.template.ui.OptionalComponentNavTreeNode;
import com.tridium.template.ui.file.BWbDeployableNtplFile;
import com.tridium.template.ui.file.ExportApplicationCommand;
import com.tridium.template.ui.installapp.InstallApplicationCommand;
import com.tridium.template.ui.makeapp.MakeApplicationCommand;
import com.tridium.template.ui.makeapp.MakeStationTemplateCommand;
import com.tridium.template.ui.upgradeapp.UpgradeApplicationCommand;
import com.tridium.workbench.nav.BComponentMenuAgent;
import com.tridium.workbench.nav.BIComponentMenuDecorator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceFolder;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BSingleton;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BMenuItem;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.util.UiLexicon;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.nav.tree.BNavTree;
import javax.baja.workbench.nav.tree.NavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeNode;

@NiagaraType(agent={@AgentOn(types={"workbench:ComponentMenuAgent"})})
@NiagaraSingleton
public final class BTemplateComponentMenuDecorator
extends BSingleton
implements BIComponentMenuDecorator {
    public static final BTemplateComponentMenuDecorator INSTANCE = new BTemplateComponentMenuDecorator();
    public static final Type TYPE = Sys.loadType(BTemplateComponentMenuDecorator.class);

    private BTemplateComponentMenuDecorator() {
    }

    public Type getType() {
        return TYPE;
    }

    public void decorateMenu(BComponentMenuAgent menuAgent, BMenu menu, BWidget owner, BComponent target, Context cx) {
        if (!BTemplateComponentMenuDecorator.isLicensed()) {
            return;
        }
        if (!BTemplateComponentMenuDecorator.isChildTemplateConfigAllowed(target)) {
            return;
        }
        ArrayList<Property> properties = new ArrayList<Property>(Arrays.asList(menu.getDynamicPropertiesArray()));
        int addIndex = BTemplateComponentMenuDecorator.findStartIndexForTemplateCommands(properties, menu);
        ++addIndex;
        if (target instanceof BStation) {
            BMenu templatesMenu = new BMenu(UiLexicon.bajaui().get("commands.templates.label"));
            BStation station = (BStation)target;
            templatesMenu.add(null, (Command)new MakeStationTemplateCommand(owner, station, MakeTemplateCommand.makeStationTemplateCommand(owner, (BComponent)station)));
            templatesMenu.add(null, (Command)new MakeApplicationCommand(owner, station, MakeTemplateCommand.makeApplicationTemplateCommand(owner, (BComponent)station)));
            if (BTemplateComponentMenuDecorator.isSuperUser((BComponent)station)) {
                templatesMenu.add(null, (Command)new InstallApplicationCommand(owner, station));
                BNtplFile upgradeFile = ApplicationTemplateUtil.getApplicationUpgrade((BStation)station);
                if (upgradeFile instanceof BWbDeployableNtplFile) {
                    templatesMenu.add(null, (Command)new UpgradeApplicationCommand(owner, station, upgradeFile.getAbsoluteOrd()));
                }
            }
            if (!ApplicationTemplateUtil.getStationApplicationId((BStation)station).isNull()) {
                templatesMenu.add(null, (Command)new ExportApplicationCommand(owner, station));
            }
            BTemplateComponentMenuDecorator.addPropertyToList(properties, ++addIndex, menu.add(null, (BValue)new BSubMenuItem((BIMenu)templatesMenu)));
        } else if (this.isApplicationTemplate(owner) && this.canBeAnOptionalComponent(target, owner)) {
            BMenu templatesMenu = new BMenu(UiLexicon.bajaui().get("commands.templates.label"));
            templatesMenu.add(null, (Command)new MarkAsOptionalCommand(owner, target, this.getManifest(owner)));
            templatesMenu.add(null, (Command)MakeTemplateCommand.makeTemplateCommand(owner, target));
            BTemplateComponentMenuDecorator.addPropertyToList(properties, ++addIndex, menu.add(null, (BValue)new BSubMenuItem((BIMenu)templatesMenu)));
        } else {
            Property property = menu.add(null, (Command)MakeTemplateCommand.makeTemplateCommand(owner, target)).getPropertyInParent();
            BTemplateComponentMenuDecorator.addPropertyToList(properties, ++addIndex, property);
        }
        BTemplateComponentMenuDecorator.addPropertyToList(properties, ++addIndex, menu.add(null, (BValue)new BSeparator()));
        menu.reorder(properties.toArray(new Property[properties.size()]));
    }

    private TemplateManifest getManifest(BWidget owner) {
        for (BWidget container = owner.getParentWidget(); container != null; container = container.getParentWidget()) {
            if (!container.getType().is(BTemplateBogEditor.TYPE)) continue;
            BTemplateBogEditor bogEditor = (BTemplateBogEditor)container;
            return bogEditor.getManifest();
        }
        return null;
    }

    private boolean isApplicationTemplate(BWidget owner) {
        if (!owner.getType().is(BNavTree.TYPE)) {
            return false;
        }
        for (BWidget container = owner.getParentWidget(); container != null; container = container.getParentWidget()) {
            if (!container.getType().is(BTemplateBogEditor.TYPE)) continue;
            BTemplateBogEditor bogEditor = (BTemplateBogEditor)container;
            return bogEditor.isApplicationTemplate();
        }
        return false;
    }

    private boolean canBeAnOptionalComponent(BComponent component, BWidget owner) {
        Property propertyInParent = component.getPropertyInParent();
        if (propertyInParent == null || propertyInParent.isFrozen()) {
            return false;
        }
        for (BComplex parent = component.getParent(); parent != null; parent = parent.getParent()) {
            OrdQuery[] queries;
            for (OrdQuery query : queries = ((BComponent)parent).getNavOrd().parse()) {
                if (!(query instanceof SlotPath) || query == null) continue;
                TemplateManifest manifest = this.getManifest(owner);
                if (!manifest.optional.contains((Object)BOrd.make((OrdQuery)query))) continue;
                return false;
            }
        }
        return component.getType().is(BDevice.TYPE) || component.getType().is(BDeviceFolder.TYPE);
    }

    private static void addPropertyToList(List<Property> properties, int index, Property newProperty) {
        if (index >= properties.size()) {
            properties.add(newProperty);
        } else {
            properties.add(index, newProperty);
        }
    }

    private static boolean isSuperUser(BComponent target) {
        BISession session = target.getSession();
        BUser user = null;
        if (session instanceof BFoxSession) {
            BFoxSession foxSession = (BFoxSession)session;
            try {
                String userName = foxSession.getUsername();
                BUserService userService = (BUserService)BOrd.make((String)"service:baja:UserService").get((BObject)target);
                userService.lease();
                user = userService.getUser(userName);
                user.lease();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return user != null && user.getPermissions().isSuperUser();
    }

    private static boolean isLicensed() {
        try {
            Feature feature = Sys.getLicenseManager().getFeature("tridium", "template");
            feature.check();
            return true;
        }
        catch (FeatureNotLicensedException e) {
            return false;
        }
    }

    private static boolean isChildTemplateConfigAllowed(BComponent comp) {
        try {
            BComponent templateConfig = (BComponent)BTypeSpec.make((String)"template", (String)"TemplateConfig").getInstance();
            return comp.isChildLegal(templateConfig);
        }
        catch (Exception err) {
            return false;
        }
    }

    private static int findStartIndexForTemplateCommands(List<Property> properties, BMenu menu) {
        int addIndex = properties.size() - 1;
        for (int i = 0; i < properties.size(); ++i) {
            BMenuItem menuItem;
            BValue value = menu.get(properties.get(i));
            if (!(value instanceof BMenuItem) || !((menuItem = (BMenuItem)value).getCommand() instanceof BComponentMenuAgent.EditTagsCommand)) continue;
            addIndex = i;
            break;
        }
        return addIndex;
    }

    private static void hyperlink(BWidget owner, BOrd ord) {
        BWbShell shell = BWbShell.getWbShell((BWidget)owner);
        if (shell != null) {
            shell.hyperlink(ord);
        }
    }

    private static final class MarkAsOptionalCommand
    extends Command {
        private BComponent target;
        private TemplateManifest manifest;

        private MarkAsOptionalCommand(BWidget owner, BComponent c, TemplateManifest manifest) {
            super(owner, (Lexicon)UiLexicon.bajaui(), "commands.markAsOptional");
            this.target = c;
            this.manifest = manifest;
        }

        public CommandArtifact doInvoke() {
            if (this.getOwner().getType().is(BNavTree.TYPE)) {
                BNavTree tree = (BNavTree)this.getOwner();
                ApplicationNavTreeModel model = (ApplicationNavTreeModel)tree.getModel();
                NavTreeNode thisNode = (NavTreeNode)model.getSelection().getNode();
                if (thisNode instanceof ExcludedComponentNavTreeNode || thisNode instanceof ExcludedDescendantNavTreeNode) {
                    return null;
                }
                NavTreeNode parentNode = (NavTreeNode)thisNode.getParent();
                BOrd optionalOrd = this.target.getSlotPathOrd();
                if (this.manifest.optional.contains((Object)optionalOrd)) {
                    this.manifest.optional.remove((Object)optionalOrd);
                    parentNode.replaceChild(thisNode, (NavTreeNode)new IncludedComponentNavTreeNode((NavTreeModel)model, parentNode, thisNode.getNavNode()));
                } else {
                    this.manifest.optional.add((Object)optionalOrd);
                    parentNode.replaceChild(thisNode, (NavTreeNode)new OptionalComponentNavTreeNode((NavTreeModel)model, parentNode, thisNode.getNavNode()));
                }
            }
            return null;
        }
    }

    private static final class MakeTemplateCommand
    extends Command {
        private String ordChild;
        private BComponent target;

        private MakeTemplateCommand(BWidget owner, BComponent c, String keyBase, String ordChild) {
            super(owner, (Lexicon)UiLexicon.bajaui(), keyBase);
            this.target = c;
            this.ordChild = ordChild;
        }

        private static MakeTemplateCommand makeStationTemplateCommand(BWidget owner, BComponent comp) {
            return new MakeTemplateCommand(owner, comp, "commands.makeStationTemplate", "template:create");
        }

        private static MakeTemplateCommand makeTemplateCommand(BWidget owner, BComponent comp) {
            return new MakeTemplateCommand(owner, comp, "commands.makeTemplate", "template:create");
        }

        private static MakeTemplateCommand makeApplicationTemplateCommand(BWidget owner, BComponent comp) {
            return new MakeTemplateCommand(owner, comp, "commands.makeApplicationTemplate", "template:createApp");
        }

        public CommandArtifact doInvoke() {
            BTemplateComponentMenuDecorator.hyperlink(this.getOwner(), BOrd.make((BOrd)this.target.getAbsoluteOrd(), (String)this.ordChild));
            return null;
        }
    }
}

