/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui;

import com.tridium.template.application.ApplicationTemplateUtil;
import com.tridium.template.manifest.TemplateManifest;
import com.tridium.template.ui.ApplicationNavTreeModel;
import com.tridium.template.ui.BTemplateView;
import com.tridium.template.ui.TemplateWsState;
import com.tridium.template.ui.file.TmplUtil;
import com.tridium.template.ui.tag.TagSupport;
import com.tridium.util.CompUtil;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.WsController;
import com.tridium.wiresheet.WsState;
import com.tridium.wiresheet.states.NormalState;
import com.tridium.workbench.console.BConsole;
import com.tridium.workbench.propsheet.BPropertyEntry;
import com.tridium.workbench.propsheet.BPropertySheet;
import com.tridium.workbench.shell.WbCommands;
import com.tridium.workbench.slotsheet.BSlotSheet;
import java.io.File;
import java.util.ArrayList;
import java.util.Objects;
import javax.baja.driver.BDevice;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.menu.BIMenuItem;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeNode;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.wiresheet.BWireSheet;
import javax.baja.workbench.nav.tree.BNavTree;
import javax.baja.workbench.nav.tree.DefaultNavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeController;
import javax.baja.workbench.nav.tree.NavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeSubject;
import javax.baja.workbench.view.BWbComponentView;
import javax.baja.workbench.view.BWbView;

public class BTemplateBogEditor
extends BEdgePane
implements BWbComponentView.Attachable {
    public static final Type TYPE = Sys.loadType(BTemplateBogEditor.class);
    private static final Lexicon lex = Lexicon.make((String)"template");
    private static BTypeSpec PROGRAM_TYPE = BTypeSpec.make((String)"program:Program");
    private static final BIcon TEMPLATE_BADGE_ICON = BIcon.std((String)"badges/nodeLibrary.png");
    private final BWidget owner;
    private BTemplateView view;
    private BComponent root;
    BNavTree tree;
    private BTreePane treePane;
    private BSplitPane split;
    private BPropertySheet propSheet;
    private BWireSheet wireSheet;
    private BSlotSheet slotSheet;
    private BWbComponentView programEditor;
    public ArrayList<ProgramObjInfo> programObjInfos;
    boolean attached = false;
    BObject selObj;
    private ProgramEditorSubscriber subscriber;
    private static final int PROP = 1;
    private static final int WIRE = 2;
    private static final int SLOT = 3;
    private static final int PROGRAM = 4;
    int selPane = 1;
    BOrd bogSelOrd = null;
    int programSelIndex = 0;

    public Type getType() {
        return TYPE;
    }

    public BTemplateBogEditor(BTemplateView view) {
        this.view = view;
        this.owner = view.getShell();
    }

    void doLoadValue(BComponent root) {
        BComponentSpace space = Objects.requireNonNull(root.getComponentSpace());
        if (space.getRootComponent() == null) {
            space.setRootComponent(this.view.getTemplateRoot());
        }
        TmplUtil.setTagDictionaryServiceForTemplateComponentSpace(root);
        TmplUtil.convertTagsToTagGroupRelations(root);
        this.root = root;
        TagSupport.convertMultiTags(root);
        BValue bValue = root.get("icon");
        if (bValue == null) {
            BIcon rootIcon = root.getIcon();
            BIcon tmplIcon = BIcon.make((BIcon)rootIcon, (BIcon)TEMPLATE_BADGE_ICON);
            root.add("icon", (BValue)tmplIcon, 5);
        }
        this.selObj = root;
        if (root instanceof BDevice) {
            ((BDevice)root).setEnabled(false);
        }
        ApplicationNavTreeModel model = this.view.isApplicationTemplate() ? new ApplicationNavTreeModel((BINavNode)root, ApplicationTemplateUtil.describeDefaultStation(null), this.view.getManifest()) : new DefaultNavTreeModel((BINavNode)root);
        this.tree = new BNavTree((NavTreeModel)model);
        model.setRootVisible(true);
        this.tree.setMultipleSelection(true);
        this.tree.setController((javax.baja.ui.tree.TreeController)new TreeController());
        this.tree.setExpanded(model.getRoot(0), true);
        this.treePane = new BTreePane((BTree)this.tree);
        this.propSheet = new BPropertySheet();
        this.wireSheet = new BWireSheet();
        BWireSheetPane wsPane = this.wireSheet.getWireSheetPane();
        TemplateWsController wsc = new TemplateWsController(wsPane);
        wsPane.setController((WsController)wsc);
        this.slotSheet = new BSlotSheet();
        this.subscriber = new ProgramEditorSubscriber();
        this.programObjInfos = this.initProgramEditors();
        this.split = new BSplitPane();
        this.split.setDividerPosition(30.0);
        this.split.setWidget1((BWidget)this.treePane);
        this.setCenter((BWidget)this.split);
        try {
            if (this.bogSelOrd != null) {
                this.selObj = this.bogSelOrd.resolve((BObject)root).getComponent();
            }
        }
        catch (Throwable e) {
            this.selPane = 1;
            e.printStackTrace();
        }
        switch (this.selPane) {
            case 2: {
                this.split.setWidget2((BWidget)this.wireSheet);
                this.wireSheet.loadValue(this.selObj);
                break;
            }
            case 3: {
                this.split.setWidget2((BWidget)this.slotSheet);
                this.slotSheet.loadValue(this.selObj);
                break;
            }
            case 4: {
                if (this.programObjInfos.size() > 0) {
                    if (this.programSelIndex >= this.programObjInfos.size()) {
                        this.programSelIndex = 0;
                    }
                    this.programEditor = this.programObjInfos.get(this.programSelIndex).getProgramEditor();
                    this.split.setWidget2((BWidget)this.programEditor);
                    this.selObj = this.programObjInfos.get(this.programSelIndex).getProgObjOrd().resolve((BObject)root).getComponent();
                    this.doSyncTree();
                    break;
                }
            }
            default: {
                this.selPane = 1;
                this.split.setWidget2((BWidget)this.propSheet);
                this.propSheet.loadValue(this.selObj);
            }
        }
        this.disablePropSheetHyperlink();
        this.hideButtons();
        if (this.programObjInfos != null) {
            for (ProgramObjInfo programObjInfo : this.programObjInfos) {
                if (!programObjInfo.getOutOfDate()) continue;
                BGridPane gridPane = new BGridPane(2);
                BLabel info = programObjInfo.getProgObjStatus();
                String s = programObjInfo.getProgObjOrd().toString();
                BTextField ordFe = new BTextField(s, 45, false);
                gridPane.add(null, (BValue)info);
                gridPane.add(null, (BValue)ordFe);
                this.view.addToInfoPane((BWidget)gridPane);
            }
        }
        this.view.linkTo((BComponent)this.propSheet, (Slot)BPropertySheet.pluginModified, (Slot)BTemplateView.templateModified);
        this.view.linkTo((BComponent)this.wireSheet, (Slot)BWireSheet.pluginModified, (Slot)BTemplateView.templateModified);
        this.view.linkTo((BComponent)this.slotSheet, (Slot)BSlotSheet.pluginModified, (Slot)BTemplateView.templateModified);
        this.view.linkTo((BComponent)this.tree, (Slot)BNavTree.treeModified, (Slot)BTemplateView.templateModified);
        this.view.attach(this);
    }

    public void deactivated() {
        if (this.propSheet != null && this.propSheet.getWbShell() != null) {
            this.propSheet.deactivated();
        }
        if (this.slotSheet != null) {
            this.slotSheet.deactivated();
        }
        if (this.wireSheet != null) {
            this.wireSheet.deactivated();
        }
        if (this.root != null) {
            TmplUtil.convertTagGroupRelationsToTags(this.root);
        }
    }

    private ArrayList<ProgramObjInfo> initProgramEditors() {
        BObject[] progObjs = (BObject[])CompUtil.getDescendants((BComponent)this.root, PROGRAM_TYPE.getInstance().getClass());
        ArrayList<ProgramObjInfo> programObjInfos = new ArrayList<ProgramObjInfo>();
        for (int i = 0; i < progObjs.length; ++i) {
            BWbComponentView instance = (BWbComponentView)BTypeSpec.make((String)"program:ProgramEditor").getInstance();
            instance.loadValue(progObjs[i]);
            ProgramObjInfo programObjInfo = new ProgramObjInfo(instance, progObjs[i].asComponent().getSlotPathOrd());
            this.updateProgramObjStatus(programObjInfo);
            programObjInfos.add(programObjInfo);
            this.subscriber.subscribe((BComponent)instance);
            this.subscriber.subscribe(progObjs[i].asComponent());
        }
        return programObjInfos;
    }

    public CommandArtifact toPropertysheet() {
        this.selObj = this.tree.getSelectedObject();
        this.propSheet.loadValue(this.selObj);
        this.disablePropSheetHyperlink();
        this.split.setWidget2((BWidget)this.propSheet);
        this.selPane = 1;
        this.view.swapActiveView(null);
        return null;
    }

    public CommandArtifact toWiresheet() {
        this.selObj = this.tree.getSelectedObject();
        this.wireSheet.loadValue(this.selObj, null);
        this.split.setWidget2((BWidget)this.wireSheet);
        this.selPane = 2;
        BWireSheetPane wireSheetPane = this.wireSheet.getWireSheetPane();
        if (this.selObj.isComponent()) {
            if (TagSupport.isSubtemplate((BComplex)this.selObj.asComponent())) {
                wireSheetPane.controller.transition((WsState)new TemplateWsState(wireSheetPane));
            } else {
                wireSheetPane.controller.transition((WsState)new NormalState(wireSheetPane));
            }
        }
        this.view.swapActiveView((BWbView)this.wireSheet);
        return null;
    }

    public CommandArtifact toSlotsheet() {
        this.selObj = this.tree.getSelectedObject();
        this.slotSheet.loadValue(this.selObj, null);
        this.split.setWidget2((BWidget)this.slotSheet);
        this.selPane = 3;
        if (this.selObj.isComponent() && TagSupport.hasTemplateAncestor((BComplex)this.selObj.asComponent())) {
            this.slotSheet.setReadonly(true);
        }
        this.view.swapActiveView(null);
        return null;
    }

    public CommandArtifact toProgramEditor() {
        this.selObj = this.tree.getSelectedObject();
        BOrd programSelOrd = this.selObj.asComponent().getSlotPathOrd();
        this.programSelIndex = this.getProgramObjectIndex(programSelOrd);
        if (this.programSelIndex >= 0) {
            this.programEditor = this.programObjInfos.get(this.programSelIndex).getProgramEditor();
        } else {
            System.out.println("programObject not found: rebuilding ");
            this.programObjInfos = this.initProgramEditors();
            this.programSelIndex = this.getProgramObjectIndex(programSelOrd);
            if (this.programSelIndex >= 0) {
                this.programEditor = this.programObjInfos.get(this.programSelIndex).getProgramEditor();
            } else {
                System.out.println("**** programObject not found ****");
                return null;
            }
        }
        this.split.setWidget2((BWidget)this.programEditor);
        this.selPane = 4;
        this.view.swapActiveView((BWbView)this.programEditor);
        return null;
    }

    private int getProgramObjectIndex(BOrd progObjOrd) {
        for (int i = 0; i < this.programObjInfos.size(); ++i) {
            if (!this.programObjInfos.get(i).getProgObjOrd().equals((Object)progObjOrd)) continue;
            return i;
        }
        return -1;
    }

    public CommandArtifact doSyncTree() {
        if (this.selObj == null) {
            return null;
        }
        this.selObj.asComponent().getSlotPathOrd();
        try {
            this.tree.expandToNavNode((BINavNode)this.selObj);
        }
        catch (Exception e) {
            this.selObj = this.root;
            try {
                this.selPane = 1;
                this.doLoadValue(this.root);
                this.tree.expandToNavNode((BINavNode)this.selObj);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return null;
    }

    public void save() {
        try {
            if (this.root.get("wsAnnotation") != null) {
                this.root.remove("wsAnnotation");
            }
            this.propSheet.saveValue(this.propSheet.getCurrentValue(), null);
            for (ProgramObjInfo poi : this.programObjInfos) {
                this.updateProgramObjStatus(poi);
                if (poi.getModified()) {
                    poi.getProgramEditor().saveValue();
                }
                poi.setModified(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isApplicationTemplate() {
        return this.view.isApplicationTemplate();
    }

    public TemplateManifest getManifest() {
        return this.view.getManifest();
    }

    private void updateProgramObjectStatus() {
        for (ProgramObjInfo poi : this.programObjInfos) {
            this.updateProgramObjStatus(poi);
        }
    }

    private void updateProgramObjStatus(ProgramObjInfo poi) {
        BWidget top;
        BWidget status;
        BWbComponentView programEditor = poi.getProgramEditor();
        BWidget content = programEditor.getContent();
        if (content instanceof BEdgePane && (status = ((BBorderPane)(top = ((BEdgePane)content).getTop())).getContent()) instanceof BLabel) {
            poi.setProgObjStatus(new BLabel(((BLabel)status).getText()));
            BImage statusImage = ((BLabel)status).getImage();
            poi.setOutOfDate(statusImage.toString().contains("circleGold.png"));
        }
    }

    private void disablePropSheetHyperlink() {
        BPropertyEntry[] a = (BPropertyEntry[])CompUtil.getDescendants((BComponent)this.propSheet, BPropertyEntry.class);
        for (int i = 0; i < a.length; ++i) {
            a[i].disableHyperlink(true);
        }
    }

    private void hideButtons() {
        BButton[] a = (BButton[])CompUtil.getDescendants((BComponent)this.propSheet, BButton.class);
        for (int i = 0; i < a.length; ++i) {
            Command command = a[i].getCommand();
            if (command == null || !command.getClass().equals(WbCommands.SaveCommand.class) && !command.getClass().equals(WbCommands.RefreshCommand.class)) continue;
            a[i].setVisible(false);
        }
    }

    public boolean consoleHyperlink(File file, int line1, int col1, int line2, int col2) {
        if (this.selPane == 4 && this.programEditor instanceof BConsole.HyperlinkInterceptor) {
            BConsole.HyperlinkInterceptor interceptor = (BConsole.HyperlinkInterceptor)this.programEditor;
            return interceptor.consoleHyperlink(file, line1, col1, line2, col2);
        }
        return false;
    }

    public void attached(BWbComponentView editor) {
        this.attached = true;
    }

    public void detached(BWbComponentView editor) {
        this.attached = false;
    }

    public void handleComponentEvent(BComponentEvent event) {
        if (!this.attached) {
            return;
        }
        if (event.getId() == 3) {
            return;
        }
        switch (this.selPane) {
            case 1: {
                this.propSheet.handleComponentEvent(event);
                break;
            }
            case 2: {
                this.wireSheet.handleComponentEvent(event);
                break;
            }
            case 3: {
                this.slotSheet.handleComponentEvent(event);
                break;
            }
            case 4: {
                this.programEditor.handleComponentEvent(event);
            }
        }
    }

    public class TemplateWsController
    extends WsController {
        public TemplateWsController(BWireSheetPane ws) {
            super(ws);
        }

        public void mousePressed(BMouseEvent event) {
            if (event.getClickCount() > 1) {
                return;
            }
            super.mousePressed(event);
        }
    }

    class SyncTree
    extends Command {
        SyncTree() {
            super(BTemplateBogEditor.this.owner, "SyncTree");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BTemplateBogEditor.this.doSyncTree();
        }

        public BImage getIcon() {
            return BImage.make((String)"module://icons/x16/sync.png");
        }
    }

    class ProgramEditor
    extends Command {
        ProgramEditor() {
            super(BTemplateBogEditor.this.owner, lex, "programEditor");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BTemplateBogEditor.this.toProgramEditor();
        }
    }

    class SlotSheet
    extends Command {
        SlotSheet() {
            super(BTemplateBogEditor.this.owner, lex, "slotSheet");
        }

        SlotSheet(boolean enable) {
            super(BTemplateBogEditor.this.owner, lex, "slotSheet");
            this.setEnabled(enable);
        }

        public CommandArtifact doInvoke() throws Exception {
            return BTemplateBogEditor.this.toSlotsheet();
        }
    }

    class WireSheet
    extends Command {
        WireSheet() {
            super(BTemplateBogEditor.this.owner, lex, "wireSheet");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BTemplateBogEditor.this.toWiresheet();
        }
    }

    class PropertySheet
    extends Command {
        PropertySheet() {
            super(BTemplateBogEditor.this.owner, lex, "propSheet");
        }

        PropertySheet(boolean enable) {
            super(BTemplateBogEditor.this.owner, lex, "propSheet");
            this.setEnabled(enable);
        }

        public CommandArtifact doInvoke() throws Exception {
            return BTemplateBogEditor.this.toPropertysheet();
        }
    }

    class TreeController
    extends NavTreeController {
        protected BMenu makePopup(NavTreeSubject subject) {
            BMenu menu = super.makePopup(subject);
            if (menu == null) {
                menu = new BMenu();
                menu.add("st", (Command)new SyncTree());
            } else {
                BComponent component;
                menu.addSeparatorToFront();
                Object[] objects = subject.get();
                boolean hasTemplateAncestor = false;
                if (objects.length > 0 && objects[0] instanceof BComponent && (component = (BComponent)objects[0]).getType().is(PROGRAM_TYPE.getResolvedType())) {
                    menu.addItemToFront("pe", (BIMenuItem)new BActionMenuItem((Command)new ProgramEditor()));
                }
                menu.addItemToFront("sl", (BIMenuItem)new BActionMenuItem((Command)new SlotSheet(!hasTemplateAncestor)));
                menu.addItemToFront("ws", (BIMenuItem)new BActionMenuItem((Command)new WireSheet()));
                menu.addItemToFront("ps", (BIMenuItem)new BActionMenuItem((Command)new PropertySheet(!hasTemplateAncestor)));
            }
            return menu;
        }

        public void nodeDoubleClicked(BMouseEvent event, TreeNode node) {
            Object subject = node.getSubject();
            BTemplateBogEditor.this.toPropertysheet();
        }
    }

    class ProgramObjInfo {
        boolean isModified = false;
        boolean outOfDate = false;
        BLabel progObjStatus;
        BOrd progObjOrd;
        BWbComponentView programEditor;

        ProgramObjInfo(BWbComponentView programEditor, BOrd progObjOrd) {
            this.programEditor = programEditor;
            this.progObjOrd = progObjOrd;
        }

        boolean getModified() {
            return this.isModified;
        }

        void setModified(boolean isModified) {
            this.isModified = isModified;
        }

        boolean getOutOfDate() {
            return this.outOfDate;
        }

        void setOutOfDate(boolean outOfDate) {
            this.outOfDate = outOfDate;
        }

        BLabel getProgObjStatus() {
            return this.progObjStatus;
        }

        void setProgObjStatus(BLabel progObjStatus) {
            this.progObjStatus = progObjStatus;
        }

        BWbComponentView getProgramEditor() {
            return this.programEditor;
        }

        void setProgramEditor(BWbComponentView programEditor) {
            this.programEditor = programEditor;
        }

        BOrd getProgObjOrd() {
            return this.progObjOrd;
        }

        void setProgObjOrd(BOrd progObjOrd) {
            this.progObjOrd = progObjOrd;
        }

        int getProgramObjIndex(BOrd progObjOrd) {
            for (int i = 0; i < BTemplateBogEditor.this.programObjInfos.size(); ++i) {
                if (!BTemplateBogEditor.this.programObjInfos.get(i).getProgObjOrd().equals((Object)progObjOrd)) continue;
                return i;
            }
            return -1;
        }
    }

    class ProgramEditorSubscriber
    extends Subscriber {
        ProgramEditorSubscriber() {
        }

        public void event(BComponentEvent event) {
            if (BTemplateBogEditor.this.programEditor == null) {
                BTemplateBogEditor.this.programEditor = BTemplateBogEditor.this.programObjInfos.get(BTemplateBogEditor.this.programSelIndex).getProgramEditor();
            }
            BTemplateBogEditor.this.programEditor.handleComponentEvent(event);
            switch (event.getId()) {
                case 5: {
                    if (!event.getSlotName().equals("pluginModified")) break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    BTemplateBogEditor.this.view.doTemplateModified();
                    ProgramObjInfo programObjInfo = BTemplateBogEditor.this.programObjInfos.get(BTemplateBogEditor.this.programSelIndex);
                    BTemplateBogEditor.this.updateProgramObjStatus(programObjInfo);
                    programObjInfo.setModified(true);
                    break;
                }
            }
        }
    }
}

