/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossWebhook.auth;

import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import solutions.onesight.ossWebhook.auth.BAuthCreds;
import solutions.onesight.ossWebhook.service.BOssWebhookService;

@NiagaraType
public final class BAuthSelectionFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BAuthSelectionFE.class);
    private final BTextDropDown selectionDropDown = new BTextDropDown("", 20, true);
    private AuthSelection[] selectionList;
    public static final int SERVICE_SEARCH_DEPTH = 5;
    public static final BImage NO_AUTH_ICON = BImage.make((BIcon)BIcon.std((String)"securityLow.png"));

    public Type getType() {
        return TYPE;
    }

    public BAuthSelectionFE() {
        this.setContent((BWidget)this.selectionDropDown);
        this.linkTo("linkModified", (BComponent)this.selectionDropDown, (Slot)BTextDropDown.valueModified, (Slot)setModified);
        this.linkTo("linkAction", (BComponent)this.selectionDropDown, (Slot)BTextDropDown.actionPerformed, (Slot)actionPerformed);
    }

    protected void doLoadValue(BObject value, Context cx) {
        this.loadIdent(value.toString());
    }

    public void loadIdent(String ident) {
        if (ident.isEmpty()) {
            ident = "No Auth";
        }
        this.selectionDropDown.setText(ident);
        this.selectionDropDown.getList().removeAllItems();
        this.selectionDropDown.getList().addItem(NO_AUTH_ICON, (Object)"No Auth");
        this.selectionList = null;
        try {
            BAuthCreds[] authCredsList = this.getAuthCredsList();
            if (authCredsList == null) {
                return;
            }
            this.selectionList = new AuthSelection[authCredsList.length];
            AuthSelection match = null;
            for (int listIndex = 0; listIndex < this.selectionList.length; ++listIndex) {
                this.selectionList[listIndex] = new AuthSelection(authCredsList[listIndex]);
                AuthSelection item = this.selectionList[listIndex];
                if (item.ident.equals(ident)) {
                    match = item;
                }
                this.selectionDropDown.getList().addItem(item.icon, (Object)item);
            }
            if (match != null) {
                this.selectionDropDown.setText(match.displayName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        return BString.make((String)this.saveIdent());
    }

    public String saveIdent() {
        String ident = this.selectionDropDown.getText();
        if (this.selectionList != null) {
            for (int listIndex = 0; listIndex < this.selectionList.length; ++listIndex) {
                if (!this.selectionList[listIndex].displayName.equals(ident)) continue;
                ident = this.selectionList[listIndex].ident;
                break;
            }
        }
        return ident;
    }

    public BAuthCreds[] getAuthCredsList() {
        BAuthCreds[] credsList = null;
        BOssWebhookService service = this.findService();
        if (service != null) {
            service.lease(2);
            credsList = (BAuthCreds[])service.getAuthentication().getChildren(BAuthCreds.class);
        }
        return credsList;
    }

    public BOssWebhookService findService() {
        BOssWebhookService foundService;
        block4: {
            foundService = null;
            try {
                BOrd agentOrd = this.getWbShell().getActiveOrd();
                BObject agentObject = agentOrd.get();
                if (!(agentObject instanceof BComponent)) break block4;
                BComponent searchNode = (BComponent)agentObject;
                for (int searchCount = 0; searchCount < 5; ++searchCount) {
                    if (searchNode instanceof BOssWebhookService) {
                        foundService = (BOssWebhookService)searchNode;
                        break;
                    }
                    searchNode = (BComponent)searchNode.getParent();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return foundService;
    }

    static class AuthSelection {
        private final String ident;
        private final String displayName;
        private final BImage icon;

        public AuthSelection(BAuthCreds creds) {
            this.ident = creds.getName();
            this.displayName = creds.getDisplayName(null);
            this.icon = BImage.make((BIcon)creds.getIcon());
        }

        public String toString() {
            return this.displayName;
        }
    }
}

