/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossWebhook.auth;

import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;
import javax.baja.workbench.mgr.folder.FolderModel;
import solutions.onesight.ossWebhook.auth.BAuthCreds;
import solutions.onesight.ossWebhook.auth.BAuthCredsFolder;

@NiagaraType(agent={@AgentOn(types={"ossWebhook:AuthCredsFolder", "ossWebhook:AuthGroup"})})
public class BAuthManager
extends BFolderManager {
    public static final Type TYPE = Sys.loadType(BAuthManager.class);
    private final MgrColumn[] cols = new MgrColumn[]{new MgrColumn.Name(1), new CredTypeColumn(), new ExpiryColumn()};

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    private static class ExpiryColumn
    extends AuthColumn {
        ExpiryColumn() {
            super("Expiry");
        }

        @Override
        public String getCellContents(BAuthCreds credsInstance) {
            return credsInstance.expirySummary();
        }
    }

    private static class CredTypeColumn
    extends AuthColumn {
        CredTypeColumn() {
            super("Type");
        }

        @Override
        public String getCellContents(BAuthCreds credsInstance) {
            return credsInstance.getType().getTypeName();
        }
    }

    private static abstract class AuthColumn
    extends MgrColumn {
        AuthColumn(String columnName) {
            super(columnName, 4);
        }

        public Object get(Object row) {
            return this.getCellContents(row);
        }

        public String toDisplayString(Object row, Object value, Context cxt) {
            return this.getCellContents(row);
        }

        public String getCellContents(Object row) {
            String cellContents = "";
            if (row instanceof BAuthCreds) {
                cellContents = this.getCellContents((BAuthCreds)row);
            }
            return cellContents;
        }

        abstract String getCellContents(BAuthCreds var1);
    }

    static class Controller
    extends FolderController {
        private final BAuthManager manager;

        Controller(BFolderManager localManager) {
            super(localManager);
            this.manager = (BAuthManager)localManager;
            this.newFolder.setFlags(0);
            this.newFolder.setEnabled(false);
            this.edit.setFlags(7);
            this.edit.setEnabled(true);
            this.newCommand.setFlags(7);
            this.newCommand.setEnabled(true);
            this.match.setFlags(0);
            this.match.setEnabled(false);
            this.tagIt.setFlags(0);
            this.tagIt.setEnabled(false);
        }

        public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int rowIndex, int colIndex) {
            BComponent endpointNode = table.getComponentAt(rowIndex);
            if (endpointNode instanceof BAuthCreds) {
                this.manager.getWbShell().hyperlink(new HyperlinkInfo(endpointNode.getNavOrd(), (BInputEvent)event));
            }
        }
    }

    class Model
    extends FolderModel {
        Model(BFolderManager manager) {
            super(manager);
        }

        protected MgrColumn[] makeColumns() {
            return BAuthManager.this.cols;
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BAuthCreds.TYPE};
        }

        public Type getFolderType() {
            return BAuthCredsFolder.TYPE;
        }

        public MgrTypeInfo[] getNewTypes() {
            return MgrTypeInfo.makeArray((Type)BAuthCreds.TYPE);
        }
    }
}

